/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.control;

import java.awt.Component;
import java.util.ArrayList;
import javax.media.Controls;
import javax.media.Format;
import javax.media.control.FormatControl;

public abstract class AbstractFormatControl
implements FormatControl {
    private boolean enabled;

    public Component getControlComponent() {
        return null;
    }

    public static FormatControl[] getFormatControls(Controls controlsImpl) {
        ArrayList<FormatControl> formatControls = new ArrayList<FormatControl>();
        for (Object control : controlsImpl.getControls()) {
            if (!(control instanceof FormatControl)) continue;
            formatControls.add((FormatControl)control);
        }
        return formatControls.toArray(new FormatControl[formatControls.size()]);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Format setFormat(Format format) {
        return AbstractFormatControl.setFormat(this, format);
    }

    public static Format setFormat(FormatControl formatControl, Format format) {
        boolean formatIsSupported = false;
        if (format != null) {
            for (Format supportedFormat : formatControl.getSupportedFormats()) {
                if (!supportedFormat.matches(format)) continue;
                formatIsSupported = true;
                break;
            }
        }
        return formatIsSupported ? formatControl.getFormat() : null;
    }
}

