/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.slick.protocol.generic;

import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import net.java.sip.communicator.service.protocol.event.MessageDeliveredEvent;
import net.java.sip.communicator.service.protocol.event.MessageDeliveryFailedEvent;
import net.java.sip.communicator.service.protocol.event.MessageListener;
import net.java.sip.communicator.service.protocol.event.MessageReceivedEvent;
import net.java.sip.communicator.util.Logger;

public class ImEventCollector
implements MessageListener {
    private static final Logger logger = Logger.getLogger(ImEventCollector.class);
    public List<EventObject> collectedEvents = new LinkedList<EventObject>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(MessageReceivedEvent evt) {
        logger.debug((Object)("Received a MessageReceivedEvent: " + evt));
        ImEventCollector imEventCollector = this;
        synchronized (imEventCollector) {
            this.collectedEvents.add((EventObject)evt);
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageDeliveryFailed(MessageDeliveryFailedEvent evt) {
        logger.debug((Object)("Received a MessageDeliveryFailedEvent: " + evt));
        ImEventCollector imEventCollector = this;
        synchronized (imEventCollector) {
            this.collectedEvents.add((EventObject)evt);
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageDelivered(MessageDeliveredEvent evt) {
        logger.debug((Object)("Received a MessageDeliveredEvent: " + evt));
        ImEventCollector imEventCollector = this;
        synchronized (imEventCollector) {
            this.collectedEvents.add((EventObject)evt);
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForEvent(long waitFor) {
        ImEventCollector imEventCollector = this;
        synchronized (imEventCollector) {
            if (this.collectedEvents.size() > 0) {
                return;
            }
            try {
                this.wait(waitFor);
            }
            catch (InterruptedException ex) {
                logger.debug((Object)"Interrupted while waiting for a message evt", (Throwable)ex);
            }
        }
    }
}

