/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.contactlist;

import java.awt.Frame;
import java.util.Iterator;
import net.java.sip.communicator.impl.gui.GuiActivator;
import net.java.sip.communicator.impl.gui.utils.Constants;
import net.java.sip.communicator.plugin.desktoputil.ErrorDialog;
import net.java.sip.communicator.plugin.desktoputil.MessageDialog;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.contactlist.MetaContactGroup;
import net.java.sip.communicator.service.contactlist.MetaContactListException;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.util.ConfigurationUtils;

public class MetaContactListManager {
    public static void moveContactToMetaContact(Contact srcContact, MetaContact destMetaContact) {
        new MoveContactToMetaContactThread(srcContact, destMetaContact).start();
    }

    public static void moveMetaContactToMetaContact(MetaContact srcMetaContact, MetaContact destMetaContact) {
        new MoveMetaContactToMetaContactThread(srcMetaContact, destMetaContact).start();
    }

    public static void moveContactToGroup(Contact srcContact, MetaContactGroup destGroup) {
        new MoveContactToGroupThread(srcContact, destGroup).start();
    }

    public static void moveMetaContactToGroup(MetaContact srcContact, MetaContactGroup group) {
        new MoveMetaContactThread(srcContact, group).start();
    }

    public static void moveMetaContactToGroup(MetaContact srcContact, String groupID) {
        new MoveMetaContactThread(srcContact, MetaContactListManager.getGroupByID(groupID)).start();
    }

    public static void removeContact(Contact contact) {
        new RemoveContactThread(contact).start();
    }

    public static void removeMetaContact(MetaContact metaContact) {
        new RemoveMetaContactThread(metaContact).start();
    }

    public static void removeMetaContactGroup(MetaContactGroup group) {
        new RemoveGroupThread(group).start();
    }

    private static MetaContactGroup getGroupByID(String metaUID) {
        return GuiActivator.getContactListService().findMetaContactGroupByMetaUID(metaUID);
    }

    private static class RemoveGroupThread
    extends Thread {
        private MetaContactGroup group;

        public RemoveGroupThread(MetaContactGroup group) {
            this.group = group;
        }

        @Override
        public void run() {
            try {
                if (Constants.REMOVE_CONTACT_ASK) {
                    String message = GuiActivator.getResources().getI18NString("service.gui.REMOVE_CONTACT_TEXT", new String[]{this.group.getGroupName()});
                    MessageDialog dialog = new MessageDialog(null, GuiActivator.getResources().getI18NString("service.gui.REMOVE_GROUP"), message, GuiActivator.getResources().getI18NString("service.gui.REMOVE"));
                    int returnCode = dialog.showDialog();
                    if (returnCode == 0) {
                        GuiActivator.getContactListService().removeMetaContactGroup(this.group);
                    } else if (returnCode == 2) {
                        GuiActivator.getContactListService().removeMetaContactGroup(this.group);
                        Constants.REMOVE_CONTACT_ASK = false;
                    }
                } else {
                    GuiActivator.getContactListService().removeMetaContactGroup(this.group);
                }
            }
            catch (Exception ex) {
                new ErrorDialog(null, GuiActivator.getResources().getI18NString("service.gui.REMOVE_GROUP"), ex.getMessage(), (Throwable)ex).showDialog();
            }
        }
    }

    private static class RemoveMetaContactThread
    extends Thread {
        private MetaContact metaContact;

        public RemoveMetaContactThread(MetaContact contact) {
            this.metaContact = contact;
        }

        @Override
        public void run() {
            if (Constants.REMOVE_CONTACT_ASK) {
                String message = GuiActivator.getResources().getI18NString("service.gui.REMOVE_CONTACT_TEXT", new String[]{this.metaContact.getDisplayName()});
                MessageDialog dialog = new MessageDialog(null, GuiActivator.getResources().getI18NString("service.gui.REMOVE_CONTACT"), message, GuiActivator.getResources().getI18NString("service.gui.REMOVE"));
                int returnCode = dialog.showDialog();
                if (returnCode == 0) {
                    GuiActivator.getContactListService().removeMetaContact(this.metaContact);
                } else if (returnCode == 2) {
                    GuiActivator.getContactListService().removeMetaContact(this.metaContact);
                    Constants.REMOVE_CONTACT_ASK = false;
                }
            } else {
                GuiActivator.getContactListService().removeMetaContact(this.metaContact);
            }
        }
    }

    private static class RemoveContactThread
    extends Thread {
        private Contact contact;

        public RemoveContactThread(Contact contact) {
            this.contact = contact;
        }

        @Override
        public void run() {
            if (!this.contact.getProtocolProvider().isRegistered()) {
                new ErrorDialog((Frame)((Object)GuiActivator.getUIService().getMainFrame()), GuiActivator.getResources().getI18NString("service.gui.ADD_CONTACT_ERROR_TITLE"), GuiActivator.getResources().getI18NString("service.gui.REMOVE_CONTACT_NOT_CONNECTED"), 1).showDialog();
                return;
            }
            try {
                if (Constants.REMOVE_CONTACT_ASK) {
                    String message = GuiActivator.getResources().getI18NString("service.gui.REMOVE_CONTACT_TEXT", new String[]{this.contact.getDisplayName()});
                    MessageDialog dialog = new MessageDialog(null, GuiActivator.getResources().getI18NString("service.gui.REMOVE_CONTACT"), message, GuiActivator.getResources().getI18NString("service.gui.REMOVE"));
                    int returnCode = dialog.showDialog();
                    if (returnCode == 0) {
                        GuiActivator.getContactListService().removeContact(this.contact);
                    } else if (returnCode == 2) {
                        GuiActivator.getContactListService().removeContact(this.contact);
                        Constants.REMOVE_CONTACT_ASK = false;
                    }
                } else {
                    GuiActivator.getContactListService().removeContact(this.contact);
                }
            }
            catch (Exception ex) {
                new ErrorDialog(null, GuiActivator.getResources().getI18NString("service.gui.REMOVE_CONTACT"), ex.getMessage(), (Throwable)ex).showDialog();
            }
        }
    }

    private static class MoveMetaContactThread
    extends Thread {
        private final MetaContact srcContact;
        private final MetaContactGroup destGroup;

        public MoveMetaContactThread(MetaContact srcContact, MetaContactGroup destGroup) {
            this.srcContact = srcContact;
            this.destGroup = destGroup;
        }

        @Override
        public void run() {
            if (!ConfigurationUtils.isMoveContactConfirmationRequested()) {
                try {
                    GuiActivator.getContactListService().moveMetaContact(this.srcContact, this.destGroup);
                }
                catch (MetaContactListException metaContactListException) {
                    // empty catch block
                }
                return;
            }
            String message = GuiActivator.getResources().getI18NString("service.gui.MOVE_SUBCONTACT_QUESTION", new String[]{this.srcContact.getDisplayName(), this.destGroup.getGroupName()});
            MessageDialog dialog = new MessageDialog(null, GuiActivator.getResources().getI18NString("service.gui.MOVE_CONTACT"), message, GuiActivator.getResources().getI18NString("service.gui.MOVE"));
            switch (dialog.showDialog()) {
                case 2: {
                    ConfigurationUtils.setMoveContactConfirmationRequested((boolean)false);
                }
                case 0: {
                    GuiActivator.getContactListService().moveMetaContact(this.srcContact, this.destGroup);
                }
            }
        }
    }

    private static class MoveContactToGroupThread
    extends Thread {
        private final Contact srcContact;
        private final MetaContactGroup destGroup;

        public MoveContactToGroupThread(Contact srcContact, MetaContactGroup destGroup) {
            this.srcContact = srcContact;
            this.destGroup = destGroup;
        }

        @Override
        public void run() {
            if (!ConfigurationUtils.isMoveContactConfirmationRequested()) {
                GuiActivator.getContactListService().moveContact(this.srcContact, this.destGroup);
                return;
            }
            String message = GuiActivator.getResources().getI18NString("service.gui.MOVE_SUBCONTACT_QUESTION", new String[]{this.srcContact.getDisplayName(), this.destGroup.getGroupName()});
            MessageDialog dialog = new MessageDialog(null, GuiActivator.getResources().getI18NString("service.gui.MOVE_CONTACT"), message, GuiActivator.getResources().getI18NString("service.gui.MOVE"));
            switch (dialog.showDialog()) {
                case 2: {
                    ConfigurationUtils.setMoveContactConfirmationRequested((boolean)false);
                }
                case 0: {
                    GuiActivator.getContactListService().moveContact(this.srcContact, this.destGroup);
                }
            }
        }
    }

    private static class MoveMetaContactToMetaContactThread
    extends Thread {
        private final MetaContact srcMetaContact;
        private final MetaContact destMetaContact;

        public MoveMetaContactToMetaContactThread(MetaContact srcContact, MetaContact destMetaContact) {
            this.srcMetaContact = srcContact;
            this.destMetaContact = destMetaContact;
        }

        @Override
        public void run() {
            if (!ConfigurationUtils.isMoveContactConfirmationRequested()) {
                this.moveAllSubcontacts();
                return;
            }
            String message = GuiActivator.getResources().getI18NString("service.gui.MOVE_SUBCONTACT_QUESTION", new String[]{this.srcMetaContact.getDisplayName(), this.destMetaContact.getDisplayName()});
            MessageDialog dialog = new MessageDialog(null, GuiActivator.getResources().getI18NString("service.gui.MOVE_CONTACT"), message, GuiActivator.getResources().getI18NString("service.gui.MOVE"));
            switch (dialog.showDialog()) {
                case 2: {
                    ConfigurationUtils.setMoveContactConfirmationRequested((boolean)false);
                }
                case 0: {
                    this.moveAllSubcontacts();
                }
            }
        }

        private void moveAllSubcontacts() {
            Iterator contacts = this.srcMetaContact.getContacts();
            while (contacts.hasNext()) {
                GuiActivator.getContactListService().moveContact((Contact)contacts.next(), this.destMetaContact);
            }
        }
    }

    private static class MoveContactToMetaContactThread
    extends Thread {
        private final Contact srcContact;
        private final MetaContact destMetaContact;

        public MoveContactToMetaContactThread(Contact srcContact, MetaContact destMetaContact) {
            this.srcContact = srcContact;
            this.destMetaContact = destMetaContact;
        }

        @Override
        public void run() {
            if (!ConfigurationUtils.isMoveContactConfirmationRequested()) {
                GuiActivator.getContactListService().moveContact(this.srcContact, this.destMetaContact);
                return;
            }
            String message = GuiActivator.getResources().getI18NString("service.gui.MOVE_SUBCONTACT_QUESTION", new String[]{this.srcContact.getDisplayName(), this.destMetaContact.getDisplayName()});
            MessageDialog dialog = new MessageDialog(null, GuiActivator.getResources().getI18NString("service.gui.MOVE_CONTACT"), message, GuiActivator.getResources().getI18NString("service.gui.MOVE"));
            switch (dialog.showDialog()) {
                case 2: {
                    ConfigurationUtils.setMoveContactConfirmationRequested((boolean)false);
                }
                case 0: {
                    GuiActivator.getContactListService().moveContact(this.srcContact, this.destMetaContact);
                }
            }
        }
    }
}

