/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.chat.filetransfer;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import net.java.sip.communicator.impl.gui.main.chat.ChatPanel;
import net.java.sip.communicator.impl.gui.main.chat.filetransfer.FileTransferConversationComponent;
import net.java.sip.communicator.service.protocol.FileTransfer;
import net.java.sip.communicator.service.protocol.event.FileTransferStatusChangeEvent;
import net.java.sip.communicator.service.protocol.event.FileTransferStatusListener;

public class SendFileConversationComponent
extends FileTransferConversationComponent
implements FileTransferStatusListener {
    private final String toContactName;
    private final ChatPanel parentChatPanel;
    private final Date date;
    private final String dateString;
    private final File file;

    public SendFileConversationComponent(ChatPanel chatPanel, String toContactName, final File file) {
        this.parentChatPanel = chatPanel;
        this.toContactName = toContactName;
        this.file = file;
        this.date = new Date();
        this.dateString = this.getDateString(this.date);
        this.setCompletedDownloadFile(file);
        this.titleLabel.setText(this.dateString + resources.getI18NString("service.gui.FILE_WAITING_TO_ACCEPT", new String[]{toContactName}));
        this.fileLabel.setText(this.getFileLabel(file));
        this.progressBar.setMaximum((int)file.length());
        this.cancelButton.setVisible(true);
        this.retryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JButton sourceButton = (JButton)e.getSource();
                if (sourceButton.equals(SendFileConversationComponent.this.retryButton)) {
                    SendFileConversationComponent.this.setWarningStyle(false);
                    SendFileConversationComponent.this.parentChatPanel.sendFile(file, SendFileConversationComponent.this);
                }
            }
        });
    }

    public void setProtocolFileTransfer(FileTransfer fileTransfer) {
        this.setFileTransfer(fileTransfer, this.file.length());
        fileTransfer.addStatusListener((FileTransferStatusListener)this);
    }

    public void statusChanged(final FileTransferStatusChangeEvent event) {
        FileTransfer fileTransfer = event.getFileTransfer();
        int status = event.getNewStatus();
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SendFileConversationComponent.this.statusChanged(event);
                }
            });
            return;
        }
        if (status == 0 || status == 1 || status == 2 || status == 3) {
            this.parentChatPanel.removeActiveFileTransfer(fileTransfer.getID());
            fileTransfer.removeStatusListener((FileTransferStatusListener)this);
        }
        if (status == 6) {
            this.hideProgressRelatedComponents();
            this.titleLabel.setText(this.dateString + resources.getI18NString("service.gui.FILE_TRANSFER_PREPARING", new String[]{this.toContactName}));
            this.cancelButton.setVisible(true);
            this.retryButton.setVisible(false);
        } else if (status == 2) {
            this.setFailed();
            this.retryButton.setVisible(true);
        } else if (status == 4) {
            this.titleLabel.setText(this.dateString + resources.getI18NString("service.gui.FILE_SENDING_TO", new String[]{this.toContactName}));
            this.setWarningStyle(false);
            if (!this.progressBar.isVisible()) {
                this.progressBar.setVisible(true);
            }
            this.cancelButton.setVisible(true);
            this.retryButton.setVisible(false);
        } else if (status == 0) {
            this.hideProgressRelatedComponents();
            this.titleLabel.setText(this.dateString + resources.getI18NString("service.gui.FILE_SEND_COMPLETED", new String[]{this.toContactName}));
            this.cancelButton.setVisible(false);
            this.retryButton.setVisible(false);
            this.openFileButton.setVisible(true);
            this.openFolderButton.setVisible(true);
        } else if (status == 1) {
            this.hideProgressRelatedComponents();
            this.titleLabel.setText(this.dateString + resources.getI18NString("service.gui.FILE_TRANSFER_CANCELED"));
            this.cancelButton.setVisible(false);
            this.retryButton.setVisible(true);
            this.setWarningStyle(true);
        } else if (status == 3) {
            this.hideProgressRelatedComponents();
            this.titleLabel.setText(this.dateString + resources.getI18NString("service.gui.FILE_SEND_REFUSED", new String[]{this.toContactName}));
            this.cancelButton.setVisible(false);
            this.retryButton.setVisible(true);
            this.setWarningStyle(true);
        }
    }

    public void setFailed() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SendFileConversationComponent.this.setFailed();
                }
            });
            return;
        }
        this.hideProgressRelatedComponents();
        this.titleLabel.setText(this.dateString + resources.getI18NString("service.gui.FILE_UNABLE_TO_SEND", new String[]{this.toContactName}));
        this.cancelButton.setVisible(false);
        this.setWarningStyle(true);
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    protected String getProgressLabel(String bytesString) {
        return bytesString + " " + resources.getI18NString("service.gui.SENT");
    }
}

