/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.main.call.conference;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import net.java.sip.communicator.impl.gui.main.call.CallPanel;
import net.java.sip.communicator.impl.gui.main.call.CallTitlePanel;
import net.java.sip.communicator.impl.gui.main.call.SecurityStatusLabel;
import net.java.sip.communicator.impl.gui.main.call.SwingCallRenderer;
import net.java.sip.communicator.impl.gui.utils.ImageLoader;
import net.java.sip.communicator.plugin.desktoputil.AntialiasingManager;
import net.java.sip.communicator.plugin.desktoputil.ImageUtils;
import net.java.sip.communicator.plugin.desktoputil.SoundLevelIndicator;
import net.java.sip.communicator.plugin.desktoputil.TransparentPanel;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.event.CallPeerSecurityOffEvent;
import net.java.sip.communicator.service.protocol.event.CallPeerSecurityOnEvent;
import net.java.sip.communicator.service.resources.ImageID;
import net.java.sip.communicator.util.skin.Skinnable;
import org.jitsi.service.neomedia.SrtpControl;
import org.jitsi.service.neomedia.ZrtpControl;

public abstract class BasicConferenceParticipantPanel<T>
extends TransparentPanel
implements Skinnable {
    private static final int AVATAR_HEIGHT = 50;
    private static final int AVATAR_WIDTH = 50;
    private static final Color bgColor = new Color(110, 110, 110);
    private static final long serialVersionUID = 0L;
    private final SwingCallRenderer callRenderer;
    private final JLabel callStatusLabel = new JLabel();
    private final GridBagConstraints constraints = new GridBagConstraints();
    private JTextComponent errorMessageComponent;
    private boolean iconChanged = false;
    private final JLabel imageLabel = new JLabel();
    private final boolean isVideo;
    private final JPanel nameBar = new TransparentPanel((LayoutManager)new GridBagLayout());
    private final GridBagConstraints nameBarConstraints = new GridBagConstraints();
    private final JLabel nameLabel = new JLabel();
    protected final T participant;
    private final TransparentPanel peerDetailsPanel = new TransparentPanel();
    private final TransparentPanel rightDetailsPanel = new TransparentPanel((LayoutManager)new GridLayout(0, 1));
    private ImageID securityImageID = ImageLoader.SECURE_OFF_CONF_CALL;
    protected SecurityStatusLabel securityStatusLabel = null;
    private SoundLevelIndicator soundIndicator;
    private final JPanel statusBar = new TransparentPanel((LayoutManager)new GridBagLayout());
    private final GridBagConstraints statusBarConstraints = new GridBagConstraints();
    private final JPanel titleBar = new CallTitlePanel(new GridBagLayout());
    private boolean isVideoIndicatorEnabled = false;
    private Image participantImage;

    public BasicConferenceParticipantPanel(SwingCallRenderer callRenderer, T participant, boolean isVideo) {
        this.callRenderer = callRenderer;
        this.participant = participant;
        this.isVideo = isVideo;
        this.constraints.anchor = 10;
        if (isVideo) {
            this.initVideoConferencePanel();
        } else {
            this.initAudioConferencePanel();
        }
    }

    public void addToCenter(Component component) {
        this.rightDetailsPanel.add(component);
    }

    public void addToNameBar(Component component) {
        ++this.nameBarConstraints.gridx;
        this.nameBarConstraints.weightx = 0.0;
        this.nameBarConstraints.insets = new Insets(0, 5, 0, 0);
        this.nameBar.add(component, this.nameBarConstraints);
    }

    public void addToStatusBar(Component component) {
        ++this.statusBarConstraints.gridx;
        this.statusBarConstraints.weightx = 0.0;
        this.statusBarConstraints.insets = new Insets(0, 5, 0, 5);
        this.statusBar.add(component, this.statusBarConstraints);
    }

    public CallPanel getCallPanel() {
        return this.getCallRenderer().getCallContainer();
    }

    public SwingCallRenderer getCallRenderer() {
        return this.callRenderer;
    }

    public T getParticipant() {
        return this.participant;
    }

    public String getParticipantName() {
        return this.nameLabel.getText();
    }

    private void initAudioConferencePanel() {
        this.soundIndicator = new SoundLevelIndicator(0, 127);
        this.soundIndicator.setPreferredSize(new Dimension(80, 30));
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.initTitleBar();
        this.constraints.fill = 2;
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.0;
        this.constraints.insets = new Insets(0, 0, 0, 0);
        this.add(this.titleBar, this.constraints);
        this.initPeerDetailsPanel();
        this.constraints.fill = 2;
        this.constraints.gridx = 0;
        this.constraints.gridy = 1;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.0;
        this.constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.peerDetailsPanel, this.constraints);
    }

    private void initPeerDetailsPanel() {
        this.peerDetailsPanel.setLayout((LayoutManager)new GridBagLayout());
        this.peerDetailsPanel.setBackground(new Color(255, 255, 255));
        this.setParticipantIcon(null, false);
        this.constraints.fill = 0;
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.weightx = 0.0;
        this.constraints.weighty = 0.0;
        this.constraints.insets = new Insets(5, 8, 5, 0);
        this.peerDetailsPanel.add((Component)this.imageLabel, (Object)this.constraints);
        this.constraints.fill = 1;
        this.constraints.gridx = 1;
        this.constraints.gridy = 0;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.0;
        this.constraints.insets = new Insets(5, 10, 5, 10);
        this.rightDetailsPanel.add((Component)this.soundIndicator);
        this.peerDetailsPanel.add((Component)this.rightDetailsPanel, (Object)this.constraints);
    }

    public void initSecurityStatusLabel() {
        this.securityStatusLabel = new SecurityStatusLabel();
        this.securityStatusLabel.setSecurityOff();
        this.addToStatusBar(this.securityStatusLabel);
    }

    private void initTitleBar() {
        this.titleBar.setBorder(BorderFactory.createEmptyBorder(2, 8, 2, 8));
        this.nameLabel.setForeground(Color.WHITE);
        this.nameBar.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        this.nameBarConstraints.gridx = 0;
        this.nameBarConstraints.gridy = 0;
        this.nameBarConstraints.weightx = 1.0;
        this.nameBar.add((Component)this.nameLabel, this.nameBarConstraints);
        this.statusBar.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        this.callStatusLabel.setForeground(Color.WHITE);
        this.statusBarConstraints.gridx = 0;
        this.statusBarConstraints.gridy = 0;
        this.statusBarConstraints.weightx = 1.0;
        this.statusBar.add((Component)this.callStatusLabel, this.statusBarConstraints);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 17;
        this.titleBar.add((Component)this.nameBar, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 13;
        this.titleBar.add((Component)this.statusBar, constraints);
    }

    private void initVideoConferencePanel() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(7, 7, 7, 7));
        this.initTitleBar();
        this.constraints.fill = 2;
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.0;
        this.constraints.insets = new Insets(0, 0, 0, 0);
        this.add(this.titleBar, this.constraints);
    }

    public void loadSkin() {
        if (!this.iconChanged) {
            this.setParticipantIcon(null, false);
        }
        if (this.securityStatusLabel != null) {
            this.securityStatusLabel.setIcon(new ImageIcon(ImageLoader.getImage(this.securityImageID)));
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.isVideo) {
            return;
        }
        g = g.create();
        try {
            AntialiasingManager.activateAntialiasing((Graphics)g);
            g.setColor(bgColor);
            g.fillRoundRect(5, 5, this.getWidth() - 10, this.getHeight() - 10, 10, 10);
        }
        finally {
            g.dispose();
        }
    }

    public void securityOff(CallPeerSecurityOffEvent evt) {
        if (this.securityStatusLabel == null) {
            return;
        }
        if (evt.getSessionType() == 1) {
            this.securityStatusLabel.setText("");
            this.securityStatusLabel.setSecurityOff();
            if (this.securityStatusLabel.getBorder() == null) {
                this.securityStatusLabel.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 3));
            }
        }
    }

    public void securityOn(CallPeerSecurityOnEvent evt) {
        if (this.securityStatusLabel == null) {
            return;
        }
        if (evt == null) {
            this.securityStatusLabel.setSecurityOn();
            return;
        }
        SrtpControl srtpControl = evt.getSecurityController();
        if (!srtpControl.requiresSecureSignalingTransport() || ((Call)this.getCallRenderer().getCallContainer().getCallConference().getCalls().get(0)).getProtocolProvider().isSignalingTransportSecure()) {
            if (srtpControl instanceof ZrtpControl) {
                this.securityStatusLabel.setText("zrtp");
                if (!((ZrtpControl)srtpControl).isSecurityVerified()) {
                    this.securityStatusLabel.setSecurityPending();
                } else {
                    this.securityStatusLabel.setSecurityOn();
                }
            } else {
                this.securityStatusLabel.setSecurityOn();
            }
        }
    }

    public void securityPending() {
        this.securityStatusLabel.setSecurityPending();
    }

    protected void setErrorReason(final String reason) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BasicConferenceParticipantPanel.this.setErrorReason(reason);
                }
            });
            return;
        }
        if (this.errorMessageComponent == null) {
            this.errorMessageComponent = new JTextPane();
            JTextPane textPane = (JTextPane)this.errorMessageComponent;
            textPane.setEditable(false);
            textPane.setOpaque(false);
            StyledDocument doc = textPane.getStyledDocument();
            SimpleAttributeSet standard = new SimpleAttributeSet();
            StyleConstants.setFontFamily(standard, textPane.getFont().getFamily());
            StyleConstants.setFontSize(standard, 12);
            doc.setParagraphAttributes(0, 0, standard, true);
            this.addToCenter(this.errorMessageComponent);
            this.revalidate();
        }
        this.errorMessageComponent.setText(reason);
        if (this.isVisible()) {
            Window parentWindow = SwingUtilities.getWindowAncestor(this.errorMessageComponent);
            if (parentWindow != null) {
                parentWindow.pack();
            }
            this.errorMessageComponent.repaint();
        }
    }

    public void setParticipantImage(byte[] image) {
        this.setParticipantIcon(image, true);
    }

    public void setParticipantName(String participantName) {
        this.nameLabel.setText(participantName);
    }

    public void setParticipantState(final String participantState) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BasicConferenceParticipantPanel.this.setParticipantState(participantState);
                }
            });
            return;
        }
        this.callStatusLabel.setText(participantState.toLowerCase());
    }

    protected void setTitleBackground(Color color) {
        this.titleBar.setBackground(color);
    }

    public void updateSoundBar(int soundLevel) {
        if (this.soundIndicator != null) {
            this.soundIndicator.updateSoundLevel(soundLevel);
        }
    }

    public void enableVideoIndicator(boolean enable) {
        this.isVideoIndicatorEnabled = enable;
        this.setParticipantIcon(null, true);
    }

    private void setParticipantIcon(byte[] image, boolean changed) {
        if (image != null && image.length > 0) {
            this.participantImage = ImageUtils.getScaledRoundedIcon((byte[])image, (int)50, (int)50).getImage();
        } else if (this.participantImage == null) {
            this.participantImage = ImageLoader.getImage(ImageLoader.DEFAULT_USER_PHOTO).getScaledInstance(50, 50, 4);
        }
        BufferedImage videoIndicatorImage = null;
        if (this.isVideoIndicatorEnabled) {
            videoIndicatorImage = ImageLoader.getImage(ImageLoader.CONFERENCE_VIDEO_INDICATOR);
        }
        ImageIcon avatarIcon = null;
        if (videoIndicatorImage != null && this.participantImage != null) {
            avatarIcon = new ImageIcon(ImageLoader.getImage(this.participantImage, videoIndicatorImage, this.participantImage.getWidth(null) - ((Image)videoIndicatorImage).getWidth(null) + 5, this.participantImage.getHeight(null) - ((Image)videoIndicatorImage).getHeight(null) + 5));
        } else if (this.participantImage != null) {
            avatarIcon = new ImageIcon(this.participantImage);
        }
        if (avatarIcon != null) {
            this.imageLabel.setIcon(avatarIcon);
            if (changed) {
                this.iconChanged = true;
            }
        }
    }
}

