/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.plugin.desktoputil;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.java.sip.communicator.plugin.desktoputil.DesktopUtilActivator;
import net.java.sip.communicator.plugin.desktoputil.UIContactDetailImpl;
import net.java.sip.communicator.service.contactlist.MetaContact;
import net.java.sip.communicator.service.gui.UIContactDetail;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationSetServerStoredContactInfo;
import net.java.sip.communicator.service.protocol.PresenceStatus;
import net.java.sip.communicator.service.protocol.ServerStoredDetails;
import net.java.sip.communicator.util.call.MetaContactPhoneUtil;

public class UIPhoneUtil
extends MetaContactPhoneUtil {
    protected UIPhoneUtil(MetaContact metaContact) {
        super(metaContact);
    }

    public static UIPhoneUtil getPhoneUtil(MetaContact metaContact) {
        return new UIPhoneUtil(metaContact);
    }

    public List<UIContactDetail> getAdditionalMobileNumbers() {
        return this.getAdditionalNumbers(true);
    }

    public List<UIContactDetail> getAdditionalNumbers() {
        return this.getAdditionalNumbers(false);
    }

    private List<UIContactDetail> getAdditionalNumbers(boolean onlyMobile) {
        ArrayList<UIContactDetail> telephonyContacts = new ArrayList<UIContactDetail>();
        Iterator contacts = this.getMetaContact().getContacts();
        while (contacts.hasNext()) {
            Contact contact = (Contact)contacts.next();
            OperationSetServerStoredContactInfo infoOpSet = (OperationSetServerStoredContactInfo)contact.getProtocolProvider().getOperationSet(OperationSetServerStoredContactInfo.class);
            ArrayList<String> phones = new ArrayList<String>();
            if (infoOpSet == null) continue;
            Iterator details = infoOpSet.getAllDetailsForContact(contact);
            while (details.hasNext()) {
                ServerStoredDetails.PhoneNumberDetail pnd;
                ServerStoredDetails.GenericDetail d = (ServerStoredDetails.GenericDetail)details.next();
                boolean process = false;
                if (onlyMobile) {
                    if (d instanceof ServerStoredDetails.MobilePhoneDetail) {
                        process = true;
                    }
                } else if (d instanceof ServerStoredDetails.PhoneNumberDetail && !(d instanceof ServerStoredDetails.PagerDetail) && !(d instanceof ServerStoredDetails.FaxDetail)) {
                    process = true;
                }
                if (!process || (pnd = (ServerStoredDetails.PhoneNumberDetail)d).getNumber() == null || pnd.getNumber().length() <= 0 || phones.contains(pnd.getNumber())) continue;
                phones.add(pnd.getNumber());
                UIContactDetailImpl cd = new UIContactDetailImpl(pnd.getNumber(), pnd.getNumber() + " (" + this.getLocalizedPhoneNumber(d) + ")", null, new ArrayList(), DesktopUtilActivator.getResources().getImage("service.gui.icons.EXTERNAL_PHONE"), null, null, pnd){

                    @Override
                    public PresenceStatus getPresenceStatus() {
                        return null;
                    }
                };
                telephonyContacts.add(cd);
            }
        }
        return telephonyContacts;
    }
}

