/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.ssiitem;

import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.snaccmd.ExtraInfoData;
import net.kano.joscar.snaccmd.ssi.SsiItem;
import net.kano.joscar.ssiitem.AbstractItemObj;
import net.kano.joscar.ssiitem.SsiItemObjectWithId;
import net.kano.joscar.tlv.ImmutableTlvChain;
import net.kano.joscar.tlv.MutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvChain;
import net.kano.joscar.tlv.TlvTools;

public class IconItem
extends AbstractItemObj
implements SsiItemObjectWithId {
    public static final String NAME_DEFAULT = "1";
    public static final String ALIAS_DEFAULT = "";
    private static final int GROUPID_DEFAULT = 0;
    private static final int TYPE_ICON_HASH = 213;
    private static final int TYPE_ALIAS = 305;
    private final String name;
    private final int id;
    private ExtraInfoData iconInfo;
    private String alias;

    public IconItem(SsiItem item) {
        DefensiveTools.checkNull(item, "item");
        this.name = item.getName();
        this.id = item.getId();
        ImmutableTlvChain chain = TlvTools.readChain(item.getData());
        Tlv iconTlv = chain.getLastTlv(213);
        if (iconTlv != null) {
            ByteBlock block = iconTlv.getData();
            this.iconInfo = ExtraInfoData.readExtraInfoData(block);
        } else {
            this.iconInfo = null;
        }
        this.alias = chain.getString(305);
        MutableTlvChain extraTlvs = TlvTools.getMutableCopy(chain);
        extraTlvs.removeTlvs(213, 305);
        this.addExtraTlvs(extraTlvs);
    }

    public IconItem(IconItem other) {
        this(other.name, other.id, other.iconInfo, other.alias, other.copyExtraTlvs());
    }

    public IconItem(String name, int id, ExtraInfoData iconInfo) {
        this(name, id, iconInfo, ALIAS_DEFAULT, null);
    }

    public IconItem(String name, int id, ExtraInfoData iconInfo, String alias, TlvChain extraTlvs) {
        super(extraTlvs);
        DefensiveTools.checkNull(name, "name");
        DefensiveTools.checkRange(id, "id", 0);
        this.name = name;
        this.id = id;
        this.iconInfo = iconInfo;
        this.alias = alias;
    }

    public final String getName() {
        return this.name;
    }

    public final int getId() {
        return this.id;
    }

    public final synchronized ExtraInfoData getIconInfo() {
        return this.iconInfo;
    }

    public final synchronized String getAlias() {
        return this.alias;
    }

    public final synchronized void setIconInfo(ExtraInfoData iconInfo) {
        this.iconInfo = iconInfo;
    }

    public final synchronized void setAlias(String alias) {
        this.alias = alias;
    }

    public synchronized SsiItem toSsiItem() {
        MutableTlvChain chain = TlvTools.createMutableChain();
        if (this.iconInfo != null) {
            ByteBlock iconData = ByteBlock.createByteBlock(this.iconInfo);
            chain.addTlv(new Tlv(213, iconData));
        }
        if (this.alias != null) {
            chain.addTlv(Tlv.getStringInstance(305, this.alias));
        }
        return this.generateItem(this.name, 0, this.id, 20, chain);
    }

    public synchronized String toString() {
        return "IconItem: name=" + this.name + ", id=0x" + Integer.toHexString(this.id) + ", alias='" + this.alias + "', iconinfo=" + this.iconInfo;
    }
}

