/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.search;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.search.InterestInfo;
import net.kano.joscar.snaccmd.search.SearchCommand;

public class InterestListCmd
extends SearchCommand {
    public static final int CODE_SUCCESS = 1;
    public static final int CODE_UNAVAILABLE = 11;
    private final int code;
    private final InterestInfo[] interests;

    protected InterestListCmd(SnacPacket packet) {
        super(5);
        DefensiveTools.checkNull(packet, "packet");
        ByteBlock snacData = packet.getData();
        this.code = BinaryTools.getUShort(snacData, 0);
        int interestCount = BinaryTools.getUShort(snacData, 2);
        if (snacData.getLength() > 4) {
            InterestInfo interest;
            ByteBlock block = snacData.subBlock(4);
            ArrayList<InterestInfo> interestList = new ArrayList<InterestInfo>();
            for (int i = 0; i < interestCount && (interest = InterestInfo.readInterestInfo(block)) != null; ++i) {
                interestList.add(interest);
                block = block.subBlock(interest.getTotalSize());
            }
            this.interests = interestList.toArray(new InterestInfo[interestList.size()]);
        } else {
            this.interests = null;
        }
    }

    public InterestListCmd(int code) {
        this(code, null);
    }

    public InterestListCmd(InterestInfo[] interests) {
        this(interests != null ? 1 : 11, interests);
    }

    public InterestListCmd(int code, InterestInfo[] interests) {
        super(5);
        DefensiveTools.checkRange(code, "code", 0);
        this.code = code;
        this.interests = interests == null ? null : (InterestInfo[])interests.clone();
    }

    public int getResultCode() {
        return this.code;
    }

    public final InterestInfo[] getInterests() {
        return this.interests == null ? null : (InterestInfo[])this.interests.clone();
    }

    public void writeData(OutputStream out) throws IOException {
        BinaryTools.writeUShort(out, this.code);
        if (this.interests != null) {
            BinaryTools.writeUShort(out, this.interests.length);
            for (InterestInfo interest : this.interests) {
                interest.write(out);
            }
        }
    }

    public String toString() {
        return "InterestListCmd: code=" + this.code + ", " + (this.interests == null ? -1 : this.interests.length) + " interests";
    }
}

