/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.introspection;

import com.google.gdata.client.CoreErrorDomain;
import com.google.gdata.client.Service;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.ExtensionVisitor;
import com.google.gdata.data.PlainTextConstruct;
import com.google.gdata.data.TextConstruct;
import com.google.gdata.data.introspection.Collection;
import com.google.gdata.data.introspection.IWorkspace;
import com.google.gdata.util.Namespaces;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.Version;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.xml.XmlNamespace;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;

public class Workspace
extends ExtensionPoint
implements IWorkspace {
    private Version coreVersion = Service.getVersion();
    private XmlNamespace atomPubNs = Namespaces.getAtomPubNs();
    private TextConstruct title;
    private List<Collection> collectionList = new ArrayList<Collection>();

    public Workspace() {
    }

    public Workspace(TextConstruct title) {
        this.title = title;
    }

    public TextConstruct getTitle() {
        return this.title;
    }

    public void setTitle(TextConstruct v) {
        this.title = v;
    }

    public List<Collection> getCollections() {
        return this.collectionList;
    }

    public void addCollection(Collection coll) {
        this.collectionList.add(coll);
    }

    @Override
    public Collection addCollection(String collectionUri, String title, String ... acceptedTypes) {
        Collection collection = new Collection(collectionUri, new PlainTextConstruct(title), acceptedTypes);
        this.addCollection(collection);
        return collection;
    }

    @Override
    protected void visitChildren(ExtensionVisitor ev) throws ExtensionVisitor.StoppedException {
        for (Collection collection : this.collectionList) {
            this.visitChild(ev, collection);
        }
        super.visitChildren(ev);
    }

    @Override
    public void generate(XmlWriter w, ExtensionProfile extProfile) throws IOException {
        ArrayList<XmlWriter.Attribute> attrs = new ArrayList<XmlWriter.Attribute>();
        if (this.coreVersion.isCompatible(Service.Versions.V1)) {
            attrs.add(new XmlWriter.Attribute("title", this.title.getPlainText()));
        }
        w.startElement(this.atomPubNs, "workspace", attrs, null);
        if (!this.coreVersion.isCompatible(Service.Versions.V1)) {
            this.title.generateAtom(w, "title");
        }
        w.startRepeatingElement();
        for (Collection collection : this.collectionList) {
            collection.generate(w, extProfile);
        }
        w.endRepeatingElement();
        this.generateExtensions(w, extProfile);
        w.endElement(this.atomPubNs, "workspace");
    }

    @Override
    public void consumeAttributes(AttributeHelper attrHelper) throws ParseException {
        if (this.coreVersion.isCompatible(Service.Versions.V1)) {
            String titleAttr = attrHelper.consume("title", true);
            this.title = new PlainTextConstruct(titleAttr);
        }
    }

    @Override
    public XmlParser.ElementHandler getHandler(ExtensionProfile p, String namespace, String localName, Attributes attrs) {
        return new Handler(p, attrs);
    }

    public void processEndElement() throws ParseException {
        if (this.title == null) {
            throw new ParseException(CoreErrorDomain.ERR.workspaceTitleRequired);
        }
    }

    public class Handler
    extends ExtensionPoint.ExtensionHandler {
        public Handler(ExtensionProfile extProfile, Attributes attrs) {
            super(extProfile, Workspace.class, attrs);
        }

        @Override
        public XmlParser.ElementHandler getChildHandler(String namespace, String localName, Attributes attrs) throws ParseException, IOException {
            if (namespace.equals(Workspace.this.atomPubNs.getUri())) {
                if (localName.equals("collection")) {
                    Collection collection = new Collection();
                    Workspace.this.addCollection(collection);
                    Collection collection2 = collection;
                    collection2.getClass();
                    return collection2.new Collection.Handler(this.extProfile, attrs);
                }
            } else if (namespace.equals("http://www.w3.org/2005/Atom") && localName.equals("title") && !Workspace.this.coreVersion.isCompatible(Service.Versions.V1)) {
                if (Workspace.this.title != null) {
                    throw new ParseException(CoreErrorDomain.ERR.duplicateTitle);
                }
                TextConstruct.ChildHandlerInfo chi = TextConstruct.getChildHandler(attrs);
                Workspace.this.title = chi.textConstruct;
                return chi.handler;
            }
            return super.getChildHandler(namespace, localName, attrs);
        }
    }
}

