/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.ldap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import net.java.sip.communicator.impl.ldap.LdapActivator;
import net.java.sip.communicator.impl.ldap.LdapPendingSearch;
import net.java.sip.communicator.impl.ldap.LdapPersonFoundImpl;
import net.java.sip.communicator.impl.ldap.LdapSSLSocketFactoryDelegate;
import net.java.sip.communicator.impl.ldap.LdapSearchSettingsImpl;
import net.java.sip.communicator.service.ldap.LdapConstants;
import net.java.sip.communicator.service.ldap.LdapDirectory;
import net.java.sip.communicator.service.ldap.LdapDirectorySettings;
import net.java.sip.communicator.service.ldap.LdapPersonFound;
import net.java.sip.communicator.service.ldap.LdapQuery;
import net.java.sip.communicator.service.ldap.LdapSearchSettings;
import net.java.sip.communicator.service.ldap.event.DefaultLdapEventManager;
import net.java.sip.communicator.service.ldap.event.LdapEvent;
import net.java.sip.communicator.service.ldap.event.LdapListener;
import net.java.sip.communicator.util.Logger;

public class LdapDirectoryImpl
extends DefaultLdapEventManager
implements LdapDirectory,
LdapListener,
LdapConstants {
    private static final Logger logger = Logger.getLogger(LdapDirectoryImpl.class);
    private LdapDirectorySettings settings;
    private HashMap<LdapQuery, LdapPendingSearch> pendingSearches = new HashMap();
    private static final String[] PHOTO_ATTRIBUTES;
    private static final Set<String> searchableAttributes;
    private Map<String, List<String>> attributesMap = new HashMap<String, List<String>>();
    private List<String> searchableAttrs = new ArrayList<String>();
    private static final Set<String> retrievableAttributes;
    private final Hashtable<String, String> env = new Hashtable();
    private final List<String> phoneNumberAttributes = new ArrayList<String>();

    public LdapDirectoryImpl(LdapDirectorySettings settings) {
        if (!this.textHasContent(settings.getName())) {
            throw new IllegalArgumentException("name has no content.");
        }
        if (!this.textHasContent(settings.getHostname())) {
            throw new IllegalArgumentException("Hostname has no content.");
        }
        if (settings.getAuth() != LdapConstants.Auth.NONE && !this.textHasContent(settings.getBindDN())) {
            throw new IllegalArgumentException("Bind DN has no content.");
        }
        if (settings.getAuth() != LdapConstants.Auth.NONE && settings.getPassword() == null) {
            throw new IllegalArgumentException("password is null.");
        }
        if (settings.getPort() < 0 || settings.getPort() > 65535) {
            throw new IllegalArgumentException("Illegal port number.");
        }
        if (settings.getBaseDN() == null) {
            throw new IllegalArgumentException("Base DN has no content.");
        }
        this.settings = settings.clone();
        String portText = this.settings.getPort() == 0 ? ":" + this.settings.getEncryption().defaultPort() : ":" + this.settings.getPort();
        this.env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        this.env.put("com.sun.jndi.ldap.connect.timeout", "5000");
        this.env.put("com.sun.jndi.ldap.read.timeout", "60000");
        this.env.put("java.naming.provider.url", settings.getEncryption().protocolString() + settings.getHostname() + portText + "/");
        this.env.put("com.sun.jndi.ldap.connect.pool", "true");
        switch (this.settings.getEncryption()) {
            case CLEAR: {
                break;
            }
            case SSL: {
                this.env.put("java.naming.security.protocol", "ssl");
                this.env.put("java.naming.ldap.factory.socket", LdapSSLSocketFactoryDelegate.class.getName());
            }
        }
        switch (this.settings.getAuth()) {
            case NONE: {
                this.env.put("java.naming.security.authentication", "none");
                break;
            }
            case SIMPLE: {
                this.env.put("java.naming.security.authentication", "simple");
                this.env.put("java.naming.security.principal", this.settings.getBindDN());
                this.env.put("java.naming.security.credentials", this.settings.getPassword());
            }
        }
        List<String> workPhoneOverrides = settings.getWorkPhoneSearchFields();
        List<String> mobilePhoneOverrides = settings.getMobilePhoneSearchFields();
        List<String> homePhoneOverrides = settings.getHomePhoneSearchFields();
        this.phoneNumberAttributes.addAll(workPhoneOverrides);
        this.phoneNumberAttributes.addAll(mobilePhoneOverrides);
        this.phoneNumberAttributes.addAll(homePhoneOverrides);
        this.attributesMap.put("mail", settings.getMailSearchFields());
        this.attributesMap.put("workPhone", workPhoneOverrides);
        this.attributesMap.put("mobilePhone", mobilePhoneOverrides);
        this.attributesMap.put("homePhone", homePhoneOverrides);
        this.searchableAttrs.addAll(searchableAttributes);
        for (String s : settings.getMailSearchFields()) {
            this.searchableAttrs.add(s);
        }
        for (String s : workPhoneOverrides) {
            this.searchableAttrs.add(s);
        }
        for (String s : mobilePhoneOverrides) {
            this.searchableAttrs.add(s);
        }
        for (String s : homePhoneOverrides) {
            this.searchableAttrs.add(s);
        }
        if (settings.isPhotoInline()) {
            retrievableAttributes.add("jpegPhoto");
            retrievableAttributes.add("thumbnailPhoto");
        }
    }

    @Override
    public boolean isEnabled() {
        return this.settings.isEnabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.settings.setEnabled(enabled);
    }

    @Override
    public LdapDirectorySettings getSettings() {
        return this.settings.clone();
    }

    private InitialDirContext connect() throws NamingException {
        logger.trace((Object)("connecting to directory \"" + this + "\""));
        long time0 = System.currentTimeMillis();
        InitialDirContext dirContext = new InitialDirContext(this.env);
        long time1 = System.currentTimeMillis();
        logger.trace((Object)("connection to directory \"" + this + "\" took " + (time1 - time0) + " ms"));
        return dirContext;
    }

    private void disconnect(InitialDirContext dirContext) {
        if (dirContext == null) {
            throw new NullPointerException("dirContext is null");
        }
        try {
            dirContext.close();
        }
        catch (NamingException e) {
            logger.trace((Object)("disconnection from directory \"" + this + "\" failed!"));
        }
        logger.trace((Object)"disconnection achieved!");
    }

    @Override
    public void searchPerson(LdapQuery query, LdapListener caller, LdapSearchSettings searchSettings) {
        if (query == null) {
            throw new NullPointerException("query shouldn't be null!");
        }
        if (caller == null) {
            throw new NullPointerException("caller shouldn't be null!");
        }
        if (searchSettings == null) {
            searchSettings = new LdapSearchSettingsImpl();
        }
        String[] intermediateQueryStrings = this.buildIntermediateQueryStrings(query.toString());
        ArrayList<LdapDirectory> serversList = new ArrayList<LdapDirectory>();
        for (int i = 0; i < intermediateQueryStrings.length; ++i) {
            serversList.add(this);
        }
        this.pendingSearches.put(query, new LdapPendingSearch(serversList, caller));
        for (String queryString : intermediateQueryStrings) {
            this.performSearch(query, queryString, searchSettings, this);
        }
    }

    private void performSearch(final LdapQuery query, final String realQueryString, final LdapSearchSettings searchSettings, final LdapListener caller) {
        Thread searchThread = new Thread(){
            int cancelState = 0;

            /*
             * Exception decompiling
             */
            @Override
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            private void checkCancel() throws LdapQueryCancelledException {
                if (query.getState() == LdapQuery.State.CANCELLED) {
                    throw new LdapQueryCancelledException();
                }
                ++this.cancelState;
            }
        };
        searchThread.setContextClassLoader(this.getClass().getClassLoader());
        searchThread.setDaemon(true);
        searchThread.start();
    }

    private boolean checkRetrievedAttributes(String queryString, Pattern searchPattern, Map<String, Set<Object>> retrievedAttributes) {
        for (Map.Entry<String, Set<Object>> en : retrievedAttributes.entrySet()) {
            if (!this.searchableAttrs.contains(en.getKey())) continue;
            boolean isPhoneNumber = this.phoneNumberAttributes.contains(en.getKey());
            for (Object o : en.getValue()) {
                if (!(o instanceof String) || !searchPattern.matcher((String)o).find() && (!isPhoneNumber || !LdapActivator.getPhoneNumberI18nService().phoneNumbersMatch(queryString, (String)o))) continue;
                return true;
            }
        }
        return false;
    }

    private String[] buildIntermediateQueryStrings(String initialQueryString) {
        if (!this.settings.isMangleQuery()) {
            return new String[]{initialQueryString};
        }
        String[] words = initialQueryString.split(" ");
        String[] intermediateQueryStrings = words.length == 2 ? new String[]{"*" + words[0] + " " + words[1] + "*", words[1] + "*" + words[0]} : new String[]{"*" + initialQueryString + "*"};
        return intermediateQueryStrings;
    }

    private Map<String, Set<Object>> retrieveAttributes(SearchResult searchResult) throws NamingException {
        Attributes attributes = searchResult.getAttributes();
        HashMap<String, Set<Object>> retrievedAttributes = new HashMap<String, Set<Object>>();
        NamingEnumeration<String> ids = attributes.getIDs();
        while (ids.hasMore()) {
            String id = ids.next();
            if (!retrievableAttributes.contains(id) && !this.containsAttribute(id)) continue;
            HashSet valuesSet = new HashSet();
            retrievedAttributes.put(id, valuesSet);
            Attribute attribute = attributes.get(id);
            NamingEnumeration<?> values = attribute.getAll();
            while (values.hasMore()) {
                valuesSet.add(values.next());
            }
        }
        return retrievedAttributes;
    }

    private LdapPersonFound buildPerson(LdapQuery query, String dn, Map<String, Set<Object>> retrievedAttributes) {
        byte[] photo;
        String department;
        String organization;
        String displayName;
        String surname;
        String firstName;
        LdapPersonFoundImpl person = new LdapPersonFoundImpl(this, dn, query);
        if (retrievedAttributes.get("givenname") != null) {
            firstName = (String)retrievedAttributes.get("givenname").iterator().next();
            person.setFirstName(firstName);
        } else if (retrievedAttributes.get("givenName") != null) {
            firstName = (String)retrievedAttributes.get("givenName").iterator().next();
            person.setFirstName(firstName);
        } else if (retrievedAttributes.get("gn") != null) {
            firstName = (String)retrievedAttributes.get("gn").iterator().next();
            person.setFirstName(firstName);
        }
        if (retrievedAttributes.get("sn") != null) {
            surname = (String)retrievedAttributes.get("sn").iterator().next();
            person.setSurname(surname);
        } else if (retrievedAttributes.get("surname") != null) {
            surname = (String)retrievedAttributes.get("surname").iterator().next();
            person.setSurname(surname);
        }
        if (retrievedAttributes.get("displayName") != null) {
            displayName = (String)retrievedAttributes.get("displayName").iterator().next();
            person.setDisplayName(displayName);
        } else if (retrievedAttributes.get("cn") != null) {
            displayName = (String)retrievedAttributes.get("cn").iterator().next();
            person.setDisplayName(displayName);
        } else if (retrievedAttributes.get("commonname") != null) {
            displayName = (String)retrievedAttributes.get("commonname").iterator().next();
            person.setDisplayName(displayName);
        }
        if (person.getDisplayName() == null) {
            person.setDisplayName("" + person.getFirstName() + person.getSurname());
        }
        if (person.getDisplayName() == null) {
            throw new RuntimeException("display name is null!");
        }
        if (retrievedAttributes.get("o") != null) {
            organization = (String)retrievedAttributes.get("o").iterator().next();
            person.setOrganization(organization);
        } else if (retrievedAttributes.get("organizationName") != null) {
            organization = (String)retrievedAttributes.get("organizationName").iterator().next();
            person.setOrganization(organization);
        } else if (retrievedAttributes.get("company") != null) {
            organization = (String)retrievedAttributes.get("company").iterator().next();
            person.setOrganization(organization);
        }
        if (retrievedAttributes.get("company") != null) {
            department = (String)retrievedAttributes.get("company").iterator().next();
            person.setDepartment(department);
        } else if (retrievedAttributes.get("ou") != null) {
            department = (String)retrievedAttributes.get("ou").iterator().next();
            person.setDepartment(department);
        } else if (retrievedAttributes.get("orgunit") != null) {
            department = (String)retrievedAttributes.get("orgunit").iterator().next();
            person.setDepartment(department);
        } else if (retrievedAttributes.get("organizationalUnitName") != null) {
            department = (String)retrievedAttributes.get("organizationalUnitName").iterator().next();
            person.setDepartment(department);
        } else if (retrievedAttributes.get("department") != null) {
            department = (String)retrievedAttributes.get("department").iterator().next();
            person.setDepartment(department);
        } else if (retrievedAttributes.get("departmentNumber") != null) {
            department = (String)retrievedAttributes.get("departmentNumber").iterator().next();
            person.setDepartment(department);
        }
        if (retrievedAttributes.get("jpegPhoto") != null) {
            photo = (byte[])retrievedAttributes.get("jpegPhoto").iterator().next();
            person.setPhoto(photo);
        } else if (retrievedAttributes.get("thumbnailPhoto") != null) {
            photo = (byte[])retrievedAttributes.get("thumbnailPhoto").iterator().next();
            person.setPhoto(photo);
        }
        List<String> attrs = this.attributesMap.get("mail");
        for (String attr : attrs) {
            if (retrievedAttributes.get(attr) == null) continue;
            for (Object o : retrievedAttributes.get(attr)) {
                String mail = o.toString();
                if (!mail.contains("@")) {
                    if (this.settings.getMailSuffix() == null) continue;
                    mail = mail + this.settings.getMailSuffix();
                }
                person.addMail(mail);
            }
        }
        attrs = this.attributesMap.get("workPhone");
        for (String attr : attrs) {
            if (retrievedAttributes.get(attr) == null) continue;
            String phone = (String)retrievedAttributes.get(attr).iterator().next();
            person.addWorkPhone(phone);
        }
        attrs = this.attributesMap.get("mobilePhone");
        for (String attr : attrs) {
            if (retrievedAttributes.get(attr) == null) continue;
            for (Object phone : retrievedAttributes.get(attr)) {
                person.addMobilePhone(phone.toString());
            }
        }
        attrs = this.attributesMap.get("homePhone");
        for (String attr : attrs) {
            if (retrievedAttributes.get(attr) == null) continue;
            for (Object phone : retrievedAttributes.get(attr)) {
                person.addHomePhone(phone.toString());
            }
        }
        return person;
    }

    public String toString() {
        return this.settings.getName();
    }

    @Override
    public int compareTo(LdapDirectory server) {
        return this.settings.getName().compareTo(server.getSettings().getName());
    }

    public boolean equals(Object anObject) {
        if (anObject instanceof LdapDirectory) {
            LdapDirectory anLdapDirectory = (LdapDirectory)anObject;
            return this.settings.getName().equals(anLdapDirectory.getSettings().getName());
        }
        return false;
    }

    public int hashCode() {
        return this.settings.getName().hashCode();
    }

    private boolean textHasContent(String aText) {
        String EMPTY_STRING = "";
        return aText != null && !aText.trim().equals(EMPTY_STRING);
    }

    private String buildSearchFilter(String query) {
        if ("custom".equals(this.settings.getQueryMode())) {
            return this.settings.getCustomQuery().replace("<query>", query);
        }
        StringBuilder searchFilter = new StringBuilder();
        searchFilter.append("(|");
        for (String attribute : this.searchableAttrs) {
            searchFilter.append("(");
            searchFilter.append(attribute);
            searchFilter.append("=");
            searchFilter.append(query);
            searchFilter.append(")");
        }
        searchFilter.append(")");
        return searchFilter.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> searchChildren(String dn) {
        Vector<String> nodes = new Vector<String>();
        InitialDirContext dirContext = null;
        if (dn.equals("")) {
            String[] returningAttributes = new String[]{"namingContexts"};
            SearchControls searchCtl = new SearchControls();
            searchCtl.setSearchScope(0);
            searchCtl.setReturningAttributes(returningAttributes);
            searchCtl.setTimeLimit(5000);
            logger.trace((Object)"starting search...");
            try {
                dirContext = this.connect();
                NamingEnumeration<SearchResult> result = dirContext.search(dn, "(objectClass=*)", searchCtl);
                while (result.hasMore()) {
                    SearchResult searchResult = result.next();
                    Attributes attributes = searchResult.getAttributes();
                    Attribute attribute = attributes.get("namingContexts");
                    NamingEnumeration<?> values = attribute.getAll();
                    while (values.hasMore()) {
                        nodes.add((String)values.next());
                    }
                }
            }
            catch (NamingException e) {
                logger.trace((Object)("error when performing ldap search query" + e));
            }
            finally {
                if (dirContext != null) {
                    this.disconnect(dirContext);
                }
            }
        } else {
            SearchControls searchCtl = new SearchControls();
            searchCtl.setSearchScope(1);
            logger.trace((Object)"starting search...");
            try {
                dirContext = this.connect();
                NamingEnumeration<SearchResult> result = dirContext.search(dn, "(objectClass=*)", searchCtl);
                while (result.hasMore()) {
                    SearchResult sr = result.next();
                    nodes.add(sr.getName());
                    logger.trace((Object)sr.getName());
                }
            }
            catch (NamingException e) {
                logger.trace((Object)("error when performing ldap search query" + e));
                e.printStackTrace();
            }
            finally {
                if (dirContext != null) {
                    this.disconnect(dirContext);
                }
            }
        }
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] fetchPhotoForPerson(String dn) {
        if (this.settings.isPhotoInline()) {
            return null;
        }
        byte[] photo = null;
        InitialDirContext dirContext = null;
        SearchControls searchCtl = new SearchControls();
        searchCtl.setSearchScope(0);
        searchCtl.setReturningAttributes(PHOTO_ATTRIBUTES);
        logger.trace((Object)"starting photo retrieval...");
        try {
            dirContext = this.connect();
            String newBaseDN = this.settings.getBaseDN().equals("") ? dn : dn + "," + this.settings.getBaseDN();
            NamingEnumeration<SearchResult> result = dirContext.search(newBaseDN, "(objectClass=*)", searchCtl);
            if (result.hasMore()) {
                SearchResult searchResult = result.next();
                Attributes attributes = searchResult.getAttributes();
                for (String a : PHOTO_ATTRIBUTES) {
                    NamingEnumeration<?> values;
                    Attribute attribute = attributes.get(a);
                    if (attribute == null || !(values = attribute.getAll()).hasMore()) continue;
                    photo = (byte[])values.next();
                }
            }
        }
        catch (NamingException e) {
            logger.trace((Object)("error when performing photo retrieval" + e));
            e.printStackTrace();
        }
        finally {
            if (dirContext != null) {
                this.disconnect(dirContext);
            }
        }
        return photo;
    }

    private SearchControls buildSearchControls(LdapSearchSettings searchSettings) {
        SearchControls searchControls = new SearchControls();
        if (searchSettings.isMaxResultsSet()) {
            searchControls.setCountLimit(searchSettings.getMaxResults());
        }
        if (searchSettings.isScopeSet()) {
            searchControls.setSearchScope(searchSettings.getScope().getConstant());
        } else {
            searchControls.setSearchScope(this.getSettings().getScope().getConstant());
        }
        ArrayList<String> retrievableAttrs = new ArrayList<String>();
        retrievableAttrs.addAll(retrievableAttributes);
        for (String key : this.attributesMap.keySet()) {
            List<String> attrs = this.attributesMap.get(key);
            for (String attr : attrs) {
                retrievableAttrs.add(attr);
            }
        }
        searchControls.setReturningAttributes(retrievableAttrs.toArray(new String[0]));
        return searchControls;
    }

    @Override
    public synchronized void ldapEventReceived(LdapEvent event) {
        switch (event.getCause()) {
            case NEW_SEARCH_RESULT: {
                LdapPersonFound result = (LdapPersonFound)event.getContent();
                LdapQuery query = result.getQuery();
                if (this.pendingSearches.get(query) == null) break;
                this.fireLdapEvent(event, this.pendingSearches.get(query).getCaller());
                logger.trace((Object)("result event for query \"" + result.getQuery().toString() + "\" forwaded"));
                break;
            }
            case SEARCH_ERROR: 
            case SEARCH_AUTH_ERROR: 
            case SEARCH_CANCELLED: 
            case SEARCH_ACHIEVED: {
                LdapQuery query = (LdapQuery)event.getContent();
                if (this.pendingSearches.get(query) == null) break;
                this.pendingSearches.get(query).getPendingServers().remove(event.getSource());
                int sizeLeft = this.pendingSearches.get(query).getPendingServers().size();
                logger.trace((Object)("end event received for initial query \"" + query.toString() + "\" on directory \"" + event.getSource() + "\"\nthere is " + sizeLeft + " search pending for this initial query on directory \"" + event.getSource() + "\""));
                if (sizeLeft != 0) break;
                this.fireLdapEvent(event, this.pendingSearches.get(query).getCaller());
                event = new LdapEvent(this, LdapEvent.LdapEventCause.SEARCH_ACHIEVED, query);
                this.pendingSearches.remove(query);
            }
        }
    }

    private boolean containsAttribute(String attribute) {
        for (String key : this.attributesMap.keySet()) {
            List<String> attrs = this.attributesMap.get(key);
            if (!attrs.contains(attribute)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void overrideAttributesSearch(String attribute, List<String> names) {
        this.attributesMap.put(attribute, names);
    }

    static /* synthetic */ String access$000(LdapDirectoryImpl x0, String x1) {
        return x0.buildSearchFilter(x1);
    }

    static /* synthetic */ Logger access$100() {
        return logger;
    }

    static /* synthetic */ SearchControls access$200(LdapDirectoryImpl x0, LdapSearchSettings x1) {
        return x0.buildSearchControls(x1);
    }

    static /* synthetic */ InitialDirContext access$300(LdapDirectoryImpl x0) throws NamingException {
        return x0.connect();
    }

    static /* synthetic */ LdapDirectorySettings access$400(LdapDirectoryImpl x0) {
        return x0.settings;
    }

    static /* synthetic */ Map access$500(LdapDirectoryImpl x0, SearchResult x1) throws NamingException {
        return x0.retrieveAttributes(x1);
    }

    static /* synthetic */ boolean access$600(LdapDirectoryImpl x0, String x1, Pattern x2, Map x3) {
        return x0.checkRetrievedAttributes(x1, x2, x3);
    }

    static /* synthetic */ LdapPersonFound access$700(LdapDirectoryImpl x0, LdapQuery x1, String x2, Map x3) {
        return x0.buildPerson(x1, x2, x3);
    }

    static /* synthetic */ void access$800(LdapDirectoryImpl x0, InitialDirContext x1) {
        x0.disconnect(x1);
    }

    static {
        logger.setLevelTrace();
        PHOTO_ATTRIBUTES = new String[]{"jpegPhoto", "thumbnailPhoto"};
        searchableAttributes = new HashSet<String>();
        searchableAttributes.add("displayName");
        searchableAttributes.add("cn");
        searchableAttributes.add("commonname");
        searchableAttributes.add("sn");
        searchableAttributes.add("surname");
        searchableAttributes.add("gn");
        searchableAttributes.add("givenname");
        searchableAttributes.add("uid");
        retrievableAttributes = new HashSet<String>();
        retrievableAttributes.add("displayName");
        retrievableAttributes.add("cn");
        retrievableAttributes.add("commonname");
        retrievableAttributes.add("sn");
        retrievableAttributes.add("surname");
        retrievableAttributes.add("givenName");
        retrievableAttributes.add("givenname");
        retrievableAttributes.add("gn");
        retrievableAttributes.add("o");
        retrievableAttributes.add("organizationName");
        retrievableAttributes.add("company");
        retrievableAttributes.add("ou");
        retrievableAttributes.add("orgunit");
        retrievableAttributes.add("organizationalUnitName");
        retrievableAttributes.add("department");
        retrievableAttributes.add("departmentNumber");
    }

    public class LdapQueryCancelledException
    extends Exception {
        private static final long serialVersionUID = 0L;
    }
}

