/*
 * Decompiled with CFR 0.152.
 */
package com.github.zafarkhaja.semver;

class NormalVersion
implements Comparable<NormalVersion> {
    private final int major;
    private final int minor;
    private final int patch;

    NormalVersion(int n, int n2, int n3) {
        if (n < 0 || n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException("Major, minor and patch versions MUST be non-negative integers.");
        }
        this.major = n;
        this.minor = n2;
        this.patch = n3;
    }

    int getMajor() {
        return this.major;
    }

    int getMinor() {
        return this.minor;
    }

    int getPatch() {
        return this.patch;
    }

    NormalVersion incrementMajor() {
        return new NormalVersion(this.major + 1, 0, 0);
    }

    NormalVersion incrementMinor() {
        return new NormalVersion(this.major, this.minor + 1, 0);
    }

    NormalVersion incrementPatch() {
        return new NormalVersion(this.major, this.minor, this.patch + 1);
    }

    @Override
    public int compareTo(NormalVersion normalVersion) {
        int n = this.major - normalVersion.major;
        if (n == 0 && (n = this.minor - normalVersion.minor) == 0) {
            n = this.patch - normalVersion.patch;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof NormalVersion)) {
            return false;
        }
        return this.compareTo((NormalVersion)object) == 0;
    }

    public int hashCode() {
        int n = 17;
        n = 31 * n + this.major;
        n = 31 * n + this.minor;
        n = 31 * n + this.patch;
        return n;
    }

    public String toString() {
        return String.format("%d.%d.%d", this.major, this.minor, this.patch);
    }
}

