/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.ObjectBuffer;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@JacksonStdImpl
public class UntypedObjectDeserializer
extends StdDeserializer<Object>
implements ResolvableDeserializer,
ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    protected static final Object[] NO_OBJECTS = new Object[0];
    @Deprecated
    public static final UntypedObjectDeserializer instance = new UntypedObjectDeserializer(null, null);
    protected JsonDeserializer<Object> _mapDeserializer;
    protected JsonDeserializer<Object> _listDeserializer;
    protected JsonDeserializer<Object> _stringDeserializer;
    protected JsonDeserializer<Object> _numberDeserializer;
    protected JavaType _listType;
    protected JavaType _mapType;

    @Deprecated
    public UntypedObjectDeserializer() {
        this(null, null);
    }

    public UntypedObjectDeserializer(JavaType javaType, JavaType javaType2) {
        super(Object.class);
        this._listType = javaType;
        this._mapType = javaType2;
    }

    public UntypedObjectDeserializer(UntypedObjectDeserializer untypedObjectDeserializer, JsonDeserializer<?> jsonDeserializer, JsonDeserializer<?> jsonDeserializer2, JsonDeserializer<?> jsonDeserializer3, JsonDeserializer<?> jsonDeserializer4) {
        super(Object.class);
        this._mapDeserializer = jsonDeserializer;
        this._listDeserializer = jsonDeserializer2;
        this._stringDeserializer = jsonDeserializer3;
        this._numberDeserializer = jsonDeserializer4;
        this._listType = untypedObjectDeserializer._listType;
        this._mapType = untypedObjectDeserializer._mapType;
    }

    @Override
    public void resolve(DeserializationContext deserializationContext) throws JsonMappingException {
        JavaType javaType = deserializationContext.constructType(Object.class);
        JavaType javaType2 = deserializationContext.constructType(String.class);
        TypeFactory typeFactory = deserializationContext.getTypeFactory();
        this._listDeserializer = this._listType == null ? this._clearIfStdImpl(this._findCustomDeser(deserializationContext, typeFactory.constructCollectionType(List.class, javaType))) : this._findCustomDeser(deserializationContext, this._listType);
        this._mapDeserializer = this._mapType == null ? this._clearIfStdImpl(this._findCustomDeser(deserializationContext, typeFactory.constructMapType(Map.class, javaType2, javaType))) : this._findCustomDeser(deserializationContext, this._mapType);
        this._stringDeserializer = this._clearIfStdImpl(this._findCustomDeser(deserializationContext, javaType2));
        this._numberDeserializer = this._clearIfStdImpl(this._findCustomDeser(deserializationContext, typeFactory.constructType((Type)((Object)Number.class))));
        JavaType javaType3 = TypeFactory.unknownType();
        this._mapDeserializer = deserializationContext.handleSecondaryContextualization(this._mapDeserializer, null, javaType3);
        this._listDeserializer = deserializationContext.handleSecondaryContextualization(this._listDeserializer, null, javaType3);
        this._stringDeserializer = deserializationContext.handleSecondaryContextualization(this._stringDeserializer, null, javaType3);
        this._numberDeserializer = deserializationContext.handleSecondaryContextualization(this._numberDeserializer, null, javaType3);
    }

    protected JsonDeserializer<Object> _findCustomDeser(DeserializationContext deserializationContext, JavaType javaType) throws JsonMappingException {
        return deserializationContext.findNonContextualValueDeserializer(javaType);
    }

    protected JsonDeserializer<Object> _clearIfStdImpl(JsonDeserializer<Object> jsonDeserializer) {
        return ClassUtil.isJacksonStdImpl(jsonDeserializer) ? null : jsonDeserializer;
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) throws JsonMappingException {
        if (this._stringDeserializer == null && this._numberDeserializer == null && this._mapDeserializer == null && this._listDeserializer == null && this.getClass() == UntypedObjectDeserializer.class) {
            return Vanilla.std;
        }
        return this;
    }

    protected JsonDeserializer<?> _withResolved(JsonDeserializer<?> jsonDeserializer, JsonDeserializer<?> jsonDeserializer2, JsonDeserializer<?> jsonDeserializer3, JsonDeserializer<?> jsonDeserializer4) {
        return new UntypedObjectDeserializer(this, jsonDeserializer, jsonDeserializer2, jsonDeserializer3, jsonDeserializer4);
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        switch (jsonParser.getCurrentTokenId()) {
            case 1: 
            case 2: 
            case 5: {
                if (this._mapDeserializer != null) {
                    return this._mapDeserializer.deserialize(jsonParser, deserializationContext);
                }
                return this.mapObject(jsonParser, deserializationContext);
            }
            case 3: {
                if (deserializationContext.isEnabled(DeserializationFeature.USE_JAVA_ARRAY_FOR_JSON_ARRAY)) {
                    return this.mapArrayToArray(jsonParser, deserializationContext);
                }
                if (this._listDeserializer != null) {
                    return this._listDeserializer.deserialize(jsonParser, deserializationContext);
                }
                return this.mapArray(jsonParser, deserializationContext);
            }
            case 12: {
                return jsonParser.getEmbeddedObject();
            }
            case 6: {
                if (this._stringDeserializer != null) {
                    return this._stringDeserializer.deserialize(jsonParser, deserializationContext);
                }
                return jsonParser.getText();
            }
            case 7: {
                if (this._numberDeserializer != null) {
                    return this._numberDeserializer.deserialize(jsonParser, deserializationContext);
                }
                if (deserializationContext.hasSomeOfFeatures(F_MASK_INT_COERCIONS)) {
                    return this._coerceIntegral(jsonParser, deserializationContext);
                }
                return jsonParser.getNumberValue();
            }
            case 8: {
                if (this._numberDeserializer != null) {
                    return this._numberDeserializer.deserialize(jsonParser, deserializationContext);
                }
                if (deserializationContext.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
                    return jsonParser.getDecimalValue();
                }
                return jsonParser.getDoubleValue();
            }
            case 9: {
                return Boolean.TRUE;
            }
            case 10: {
                return Boolean.FALSE;
            }
            case 11: {
                return null;
            }
        }
        return deserializationContext.handleUnexpectedToken(Object.class, jsonParser);
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException {
        switch (jsonParser.getCurrentTokenId()) {
            case 1: 
            case 3: 
            case 5: {
                return typeDeserializer.deserializeTypedFromAny(jsonParser, deserializationContext);
            }
            case 12: {
                return jsonParser.getEmbeddedObject();
            }
            case 6: {
                if (this._stringDeserializer != null) {
                    return this._stringDeserializer.deserialize(jsonParser, deserializationContext);
                }
                return jsonParser.getText();
            }
            case 7: {
                if (this._numberDeserializer != null) {
                    return this._numberDeserializer.deserialize(jsonParser, deserializationContext);
                }
                if (deserializationContext.hasSomeOfFeatures(F_MASK_INT_COERCIONS)) {
                    return this._coerceIntegral(jsonParser, deserializationContext);
                }
                return jsonParser.getNumberValue();
            }
            case 8: {
                if (this._numberDeserializer != null) {
                    return this._numberDeserializer.deserialize(jsonParser, deserializationContext);
                }
                if (deserializationContext.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
                    return jsonParser.getDecimalValue();
                }
                return jsonParser.getDoubleValue();
            }
            case 9: {
                return Boolean.TRUE;
            }
            case 10: {
                return Boolean.FALSE;
            }
            case 11: {
                return null;
            }
        }
        return deserializationContext.handleUnexpectedToken(Object.class, jsonParser);
    }

    protected Object mapArray(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
            return new ArrayList(2);
        }
        Object object = this.deserialize(jsonParser, deserializationContext);
        if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
            ArrayList<Object> arrayList = new ArrayList<Object>(2);
            arrayList.add(object);
            return arrayList;
        }
        Object object2 = this.deserialize(jsonParser, deserializationContext);
        if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
            ArrayList<Object> arrayList = new ArrayList<Object>(2);
            arrayList.add(object);
            arrayList.add(object2);
            return arrayList;
        }
        ObjectBuffer objectBuffer = deserializationContext.leaseObjectBuffer();
        Object[] objectArray = objectBuffer.resetAndStart();
        int n = 0;
        objectArray[n++] = object;
        objectArray[n++] = object2;
        int n2 = n;
        do {
            object = this.deserialize(jsonParser, deserializationContext);
            ++n2;
            if (n >= objectArray.length) {
                objectArray = objectBuffer.appendCompletedChunk(objectArray);
                n = 0;
            }
            objectArray[n++] = object;
        } while (jsonParser.nextToken() != JsonToken.END_ARRAY);
        ArrayList<Object> arrayList = new ArrayList<Object>(n2);
        objectBuffer.completeAndClearBuffer(objectArray, n, arrayList);
        return arrayList;
    }

    protected Object mapObject(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        String string;
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.START_OBJECT) {
            string = jsonParser.nextFieldName();
        } else if (jsonToken == JsonToken.FIELD_NAME) {
            string = jsonParser.getCurrentName();
        } else {
            if (jsonToken != JsonToken.END_OBJECT) {
                return deserializationContext.handleUnexpectedToken(this.handledType(), jsonParser);
            }
            string = null;
        }
        if (string == null) {
            return new LinkedHashMap(2);
        }
        jsonParser.nextToken();
        Object object = this.deserialize(jsonParser, deserializationContext);
        String string2 = jsonParser.nextFieldName();
        if (string2 == null) {
            LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>(2);
            linkedHashMap.put(string, object);
            return linkedHashMap;
        }
        jsonParser.nextToken();
        Object object2 = this.deserialize(jsonParser, deserializationContext);
        String string3 = jsonParser.nextFieldName();
        if (string3 == null) {
            LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>(4);
            linkedHashMap.put(string, object);
            linkedHashMap.put(string2, object2);
            return linkedHashMap;
        }
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        linkedHashMap.put(string, object);
        linkedHashMap.put(string2, object2);
        do {
            jsonParser.nextToken();
            linkedHashMap.put(string3, this.deserialize(jsonParser, deserializationContext));
        } while ((string3 = jsonParser.nextFieldName()) != null);
        return linkedHashMap;
    }

    protected Object[] mapArrayToArray(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
            return NO_OBJECTS;
        }
        ObjectBuffer objectBuffer = deserializationContext.leaseObjectBuffer();
        Object[] objectArray = objectBuffer.resetAndStart();
        int n = 0;
        do {
            Object object = this.deserialize(jsonParser, deserializationContext);
            if (n >= objectArray.length) {
                objectArray = objectBuffer.appendCompletedChunk(objectArray);
                n = 0;
            }
            objectArray[n++] = object;
        } while (jsonParser.nextToken() != JsonToken.END_ARRAY);
        return objectBuffer.completeAndClearBuffer(objectArray, n);
    }

    @JacksonStdImpl
    public static class Vanilla
    extends StdDeserializer<Object> {
        private static final long serialVersionUID = 1L;
        public static final Vanilla std = new Vanilla();

        public Vanilla() {
            super(Object.class);
        }

        @Override
        public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            switch (jsonParser.getCurrentTokenId()) {
                case 1: {
                    JsonToken jsonToken = jsonParser.nextToken();
                    if (jsonToken == JsonToken.END_OBJECT) {
                        return new LinkedHashMap(2);
                    }
                }
                case 5: {
                    return this.mapObject(jsonParser, deserializationContext);
                }
                case 3: {
                    JsonToken jsonToken = jsonParser.nextToken();
                    if (jsonToken == JsonToken.END_ARRAY) {
                        if (deserializationContext.isEnabled(DeserializationFeature.USE_JAVA_ARRAY_FOR_JSON_ARRAY)) {
                            return NO_OBJECTS;
                        }
                        return new ArrayList(2);
                    }
                    if (deserializationContext.isEnabled(DeserializationFeature.USE_JAVA_ARRAY_FOR_JSON_ARRAY)) {
                        return this.mapArrayToArray(jsonParser, deserializationContext);
                    }
                    return this.mapArray(jsonParser, deserializationContext);
                }
                case 12: {
                    return jsonParser.getEmbeddedObject();
                }
                case 6: {
                    return jsonParser.getText();
                }
                case 7: {
                    if (deserializationContext.hasSomeOfFeatures(F_MASK_INT_COERCIONS)) {
                        return this._coerceIntegral(jsonParser, deserializationContext);
                    }
                    return jsonParser.getNumberValue();
                }
                case 8: {
                    if (deserializationContext.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
                        return jsonParser.getDecimalValue();
                    }
                    return jsonParser.getDoubleValue();
                }
                case 9: {
                    return Boolean.TRUE;
                }
                case 10: {
                    return Boolean.FALSE;
                }
                case 11: {
                    return null;
                }
                case 2: {
                    return new LinkedHashMap(2);
                }
            }
            return deserializationContext.handleUnexpectedToken(Object.class, jsonParser);
        }

        @Override
        public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException {
            switch (jsonParser.getCurrentTokenId()) {
                case 1: 
                case 3: 
                case 5: {
                    return typeDeserializer.deserializeTypedFromAny(jsonParser, deserializationContext);
                }
                case 6: {
                    return jsonParser.getText();
                }
                case 7: {
                    if (deserializationContext.isEnabled(DeserializationFeature.USE_BIG_INTEGER_FOR_INTS)) {
                        return jsonParser.getBigIntegerValue();
                    }
                    return jsonParser.getNumberValue();
                }
                case 8: {
                    if (deserializationContext.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
                        return jsonParser.getDecimalValue();
                    }
                    return jsonParser.getDoubleValue();
                }
                case 9: {
                    return Boolean.TRUE;
                }
                case 10: {
                    return Boolean.FALSE;
                }
                case 12: {
                    return jsonParser.getEmbeddedObject();
                }
                case 11: {
                    return null;
                }
            }
            return deserializationContext.handleUnexpectedToken(Object.class, jsonParser);
        }

        protected Object mapArray(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            Object object = this.deserialize(jsonParser, deserializationContext);
            if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
                ArrayList<Object> arrayList = new ArrayList<Object>(2);
                arrayList.add(object);
                return arrayList;
            }
            Object object2 = this.deserialize(jsonParser, deserializationContext);
            if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
                ArrayList<Object> arrayList = new ArrayList<Object>(2);
                arrayList.add(object);
                arrayList.add(object2);
                return arrayList;
            }
            ObjectBuffer objectBuffer = deserializationContext.leaseObjectBuffer();
            Object[] objectArray = objectBuffer.resetAndStart();
            int n = 0;
            objectArray[n++] = object;
            objectArray[n++] = object2;
            int n2 = n;
            do {
                object = this.deserialize(jsonParser, deserializationContext);
                ++n2;
                if (n >= objectArray.length) {
                    objectArray = objectBuffer.appendCompletedChunk(objectArray);
                    n = 0;
                }
                objectArray[n++] = object;
            } while (jsonParser.nextToken() != JsonToken.END_ARRAY);
            ArrayList<Object> arrayList = new ArrayList<Object>(n2);
            objectBuffer.completeAndClearBuffer(objectArray, n, arrayList);
            return arrayList;
        }

        protected Object mapObject(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            String string = jsonParser.getText();
            jsonParser.nextToken();
            Object object = this.deserialize(jsonParser, deserializationContext);
            String string2 = jsonParser.nextFieldName();
            if (string2 == null) {
                LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>(2);
                linkedHashMap.put(string, object);
                return linkedHashMap;
            }
            jsonParser.nextToken();
            Object object2 = this.deserialize(jsonParser, deserializationContext);
            String string3 = jsonParser.nextFieldName();
            if (string3 == null) {
                LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>(4);
                linkedHashMap.put(string, object);
                linkedHashMap.put(string2, object2);
                return linkedHashMap;
            }
            LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
            linkedHashMap.put(string, object);
            linkedHashMap.put(string2, object2);
            do {
                jsonParser.nextToken();
                linkedHashMap.put(string3, this.deserialize(jsonParser, deserializationContext));
            } while ((string3 = jsonParser.nextFieldName()) != null);
            return linkedHashMap;
        }

        protected Object[] mapArrayToArray(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            ObjectBuffer objectBuffer = deserializationContext.leaseObjectBuffer();
            Object[] objectArray = objectBuffer.resetAndStart();
            int n = 0;
            do {
                Object object = this.deserialize(jsonParser, deserializationContext);
                if (n >= objectArray.length) {
                    objectArray = objectBuffer.appendCompletedChunk(objectArray);
                    n = 0;
                }
                objectArray[n++] = object;
            } while (jsonParser.nextToken() != JsonToken.END_ARRAY);
            return objectBuffer.completeAndClearBuffer(objectArray, n);
        }
    }
}

