/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

import java.io.Serializable;

public class PropertyMetadata
implements Serializable {
    private static final long serialVersionUID = -1L;
    public static final PropertyMetadata STD_REQUIRED = new PropertyMetadata(Boolean.TRUE, null, null, null);
    public static final PropertyMetadata STD_OPTIONAL = new PropertyMetadata(Boolean.FALSE, null, null, null);
    public static final PropertyMetadata STD_REQUIRED_OR_OPTIONAL = new PropertyMetadata(null, null, null, null);
    protected final Boolean _required;
    protected final String _description;
    protected final Integer _index;
    protected final String _defaultValue;

    @Deprecated
    protected PropertyMetadata(Boolean bl, String string) {
        this(bl, string, null, null);
    }

    protected PropertyMetadata(Boolean bl, String string, Integer n, String string2) {
        this._required = bl;
        this._description = string;
        this._index = n;
        this._defaultValue = string2 == null || string2.isEmpty() ? null : string2;
    }

    @Deprecated
    public static PropertyMetadata construct(boolean bl, String string) {
        return PropertyMetadata.construct(bl, string, null, null);
    }

    public static PropertyMetadata construct(boolean bl, String string, Integer n, String string2) {
        if (string != null || n != null || string2 != null) {
            return new PropertyMetadata(bl, string, n, string2);
        }
        return bl ? STD_REQUIRED : STD_OPTIONAL;
    }

    protected Object readResolve() {
        if (this._description == null && this._index == null && this._defaultValue == null) {
            if (this._required == null) {
                return STD_REQUIRED_OR_OPTIONAL;
            }
            return this._required != false ? STD_REQUIRED : STD_OPTIONAL;
        }
        return this;
    }

    public PropertyMetadata withDescription(String string) {
        return new PropertyMetadata(this._required, string, this._index, this._defaultValue);
    }

    public PropertyMetadata withDefaultValue(String string) {
        if (string == null || string.isEmpty()) {
            if (this._defaultValue == null) {
                return this;
            }
            string = null;
        } else if (this._defaultValue.equals(string)) {
            return this;
        }
        return new PropertyMetadata(this._required, this._description, this._index, string);
    }

    public PropertyMetadata withIndex(Integer n) {
        return new PropertyMetadata(this._required, this._description, n, this._defaultValue);
    }

    public PropertyMetadata withRequired(Boolean bl) {
        if (bl == null ? this._required == null : this._required != null && this._required.booleanValue() == bl.booleanValue()) {
            return this;
        }
        return new PropertyMetadata(bl, this._description, this._index, this._defaultValue);
    }

    public String getDescription() {
        return this._description;
    }

    public String getDefaultValue() {
        return this._defaultValue;
    }

    @Deprecated
    public boolean hasDefuaultValue() {
        return this.hasDefaultValue();
    }

    public boolean hasDefaultValue() {
        return this._defaultValue != null;
    }

    public boolean isRequired() {
        return this._required != null && this._required != false;
    }

    public Boolean getRequired() {
        return this._required;
    }

    public Integer getIndex() {
        return this._index;
    }

    public boolean hasIndex() {
        return this._index != null;
    }
}

