/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.smtp;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class SimpleSMTPHeader {
    private final String __subject;
    private final String __from;
    private final String __to;
    private final StringBuffer __headerFields;
    private boolean hasHeaderDate;
    private StringBuffer __cc;

    public SimpleSMTPHeader(String string, String string2, String string3) {
        if (string == null) {
            throw new IllegalArgumentException("From cannot be null");
        }
        this.__to = string2;
        this.__from = string;
        this.__subject = string3;
        this.__headerFields = new StringBuffer();
        this.__cc = null;
    }

    public void addHeaderField(String string, String string2) {
        if (!this.hasHeaderDate && "Date".equals(string)) {
            this.hasHeaderDate = true;
        }
        this.__headerFields.append(string);
        this.__headerFields.append(": ");
        this.__headerFields.append(string2);
        this.__headerFields.append('\n');
    }

    public void addCC(String string) {
        if (this.__cc == null) {
            this.__cc = new StringBuffer();
        } else {
            this.__cc.append(", ");
        }
        this.__cc.append(string);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.ENGLISH);
        if (!this.hasHeaderDate) {
            this.addHeaderField("Date", simpleDateFormat.format(new Date()));
        }
        if (this.__headerFields.length() > 0) {
            stringBuilder.append(this.__headerFields.toString());
        }
        stringBuilder.append("From: ").append(this.__from).append("\n");
        if (this.__to != null) {
            stringBuilder.append("To: ").append(this.__to).append("\n");
        }
        if (this.__cc != null) {
            stringBuilder.append("Cc: ").append(this.__cc.toString()).append("\n");
        }
        if (this.__subject != null) {
            stringBuilder.append("Subject: ").append(this.__subject).append("\n");
        }
        stringBuilder.append('\n');
        return stringBuilder.toString();
    }
}

