/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.ftp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.net.MalformedServerReplyException;
import org.apache.commons.net.ftp.Configurable;
import org.apache.commons.net.ftp.FTP;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPCmd;
import org.apache.commons.net.ftp.FTPCommand;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPFileEntryParser;
import org.apache.commons.net.ftp.FTPFileFilter;
import org.apache.commons.net.ftp.FTPFileFilters;
import org.apache.commons.net.ftp.FTPListParseEngine;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.ftp.parser.DefaultFTPFileEntryParserFactory;
import org.apache.commons.net.ftp.parser.FTPFileEntryParserFactory;
import org.apache.commons.net.ftp.parser.MLSxEntryParser;
import org.apache.commons.net.io.CRLFLineReader;
import org.apache.commons.net.io.CopyStreamAdapter;
import org.apache.commons.net.io.CopyStreamEvent;
import org.apache.commons.net.io.CopyStreamListener;
import org.apache.commons.net.io.FromNetASCIIInputStream;
import org.apache.commons.net.io.SocketInputStream;
import org.apache.commons.net.io.SocketOutputStream;
import org.apache.commons.net.io.ToNetASCIIOutputStream;
import org.apache.commons.net.io.Util;

public class FTPClient
extends FTP
implements Configurable {
    public static final String FTP_SYSTEM_TYPE = "org.apache.commons.net.ftp.systemType";
    public static final String FTP_SYSTEM_TYPE_DEFAULT = "org.apache.commons.net.ftp.systemType.default";
    public static final String SYSTEM_TYPE_PROPERTIES = "/systemType.properties";
    public static final int ACTIVE_LOCAL_DATA_CONNECTION_MODE = 0;
    public static final int ACTIVE_REMOTE_DATA_CONNECTION_MODE = 1;
    public static final int PASSIVE_LOCAL_DATA_CONNECTION_MODE = 2;
    public static final int PASSIVE_REMOTE_DATA_CONNECTION_MODE = 3;
    private int __dataConnectionMode;
    private int __dataTimeout;
    private int __passivePort;
    private String __passiveHost;
    private final Random __random;
    private int __activeMinPort;
    private int __activeMaxPort;
    private InetAddress __activeExternalHost;
    private InetAddress __reportActiveExternalHost;
    private InetAddress __passiveLocalHost;
    private int __fileType;
    private int __fileFormat;
    private int __fileStructure;
    private int __fileTransferMode;
    private boolean __remoteVerificationEnabled;
    private long __restartOffset;
    private FTPFileEntryParserFactory __parserFactory;
    private int __bufferSize;
    private int __sendDataSocketBufferSize;
    private int __receiveDataSocketBufferSize;
    private boolean __listHiddenFiles;
    private boolean __useEPSVwithIPv4;
    private String __systemName;
    private FTPFileEntryParser __entryParser;
    private String __entryParserKey;
    private FTPClientConfig __configuration;
    private CopyStreamListener __copyStreamListener;
    private long __controlKeepAliveTimeout;
    private int __controlKeepAliveReplyTimeout = 1000;
    private boolean __passiveNatWorkaround = true;
    private static final Pattern __PARMS_PAT = Pattern.compile("(\\d{1,3},\\d{1,3},\\d{1,3},\\d{1,3}),(\\d{1,3}),(\\d{1,3})");
    private boolean __autodetectEncoding = false;
    private HashMap<String, Set<String>> __featuresMap;

    private static Properties getOverrideProperties() {
        return PropertiesSingleton.PROPERTIES;
    }

    public FTPClient() {
        this.__initDefaults();
        this.__dataTimeout = -1;
        this.__remoteVerificationEnabled = true;
        this.__parserFactory = new DefaultFTPFileEntryParserFactory();
        this.__configuration = null;
        this.__listHiddenFiles = false;
        this.__useEPSVwithIPv4 = false;
        this.__random = new Random();
        this.__passiveLocalHost = null;
    }

    private void __initDefaults() {
        this.__dataConnectionMode = 0;
        this.__passiveHost = null;
        this.__passivePort = -1;
        this.__activeExternalHost = null;
        this.__reportActiveExternalHost = null;
        this.__activeMinPort = 0;
        this.__activeMaxPort = 0;
        this.__fileType = 0;
        this.__fileStructure = 7;
        this.__fileFormat = 4;
        this.__fileTransferMode = 10;
        this.__restartOffset = 0L;
        this.__systemName = null;
        this.__entryParser = null;
        this.__entryParserKey = "";
        this.__featuresMap = null;
    }

    static String __parsePathname(String string) {
        String string2 = string.substring(4);
        if (string2.startsWith("\"")) {
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            for (int i = 1; i < string2.length(); ++i) {
                char c = string2.charAt(i);
                if (c == '\"') {
                    if (bl) {
                        stringBuilder.append(c);
                        bl = false;
                        continue;
                    }
                    bl = true;
                    continue;
                }
                if (bl) {
                    return stringBuilder.toString();
                }
                stringBuilder.append(c);
            }
            if (bl) {
                return stringBuilder.toString();
            }
        }
        return string2;
    }

    protected void _parsePassiveModeReply(String string) throws MalformedServerReplyException {
        Matcher matcher = __PARMS_PAT.matcher(string);
        if (!matcher.find()) {
            throw new MalformedServerReplyException("Could not parse passive host information.\nServer Reply: " + string);
        }
        this.__passiveHost = matcher.group(1).replace(',', '.');
        try {
            int n = Integer.parseInt(matcher.group(2));
            int n2 = Integer.parseInt(matcher.group(3));
            this.__passivePort = n << 8 | n2;
        }
        catch (NumberFormatException numberFormatException) {
            throw new MalformedServerReplyException("Could not parse passive port information.\nServer Reply: " + string);
        }
        if (this.__passiveNatWorkaround) {
            try {
                InetAddress inetAddress;
                InetAddress inetAddress2 = InetAddress.getByName(this.__passiveHost);
                if (inetAddress2.isSiteLocalAddress() && !(inetAddress = this.getRemoteAddress()).isSiteLocalAddress()) {
                    String string2 = inetAddress.getHostAddress();
                    this.fireReplyReceived(0, "[Replacing site local address " + this.__passiveHost + " with " + string2 + "]\n");
                    this.__passiveHost = string2;
                }
            }
            catch (UnknownHostException unknownHostException) {
                throw new MalformedServerReplyException("Could not parse passive host information.\nServer Reply: " + string);
            }
        }
    }

    protected void _parseExtendedPassiveModeReply(String string) throws MalformedServerReplyException {
        int n;
        string = string.substring(string.indexOf(40) + 1, string.indexOf(41)).trim();
        char c = string.charAt(0);
        char c2 = string.charAt(1);
        char c3 = string.charAt(2);
        char c4 = string.charAt(string.length() - 1);
        if (c != c2 || c2 != c3 || c3 != c4) {
            throw new MalformedServerReplyException("Could not parse extended passive host information.\nServer Reply: " + string);
        }
        try {
            n = Integer.parseInt(string.substring(3, string.length() - 1));
        }
        catch (NumberFormatException numberFormatException) {
            throw new MalformedServerReplyException("Could not parse extended passive host information.\nServer Reply: " + string);
        }
        this.__passiveHost = this.getRemoteAddress().getHostAddress();
        this.__passivePort = n;
    }

    private boolean __storeFile(FTPCmd fTPCmd, String string, InputStream inputStream) throws IOException {
        return this._storeFile(fTPCmd.getCommand(), string, inputStream);
    }

    protected boolean _storeFile(String string, String string2, InputStream inputStream) throws IOException {
        Socket socket = this._openDataConnection_(string, string2);
        if (socket == null) {
            return false;
        }
        OutputStream outputStream = this.__fileType == 0 ? new ToNetASCIIOutputStream(this.getBufferedOutputStream(socket.getOutputStream())) : this.getBufferedOutputStream(socket.getOutputStream());
        CSL cSL = null;
        if (this.__controlKeepAliveTimeout > 0L) {
            cSL = new CSL(this, this.__controlKeepAliveTimeout, this.__controlKeepAliveReplyTimeout);
        }
        try {
            Util.copyStream(inputStream, outputStream, this.getBufferSize(), -1L, this.__mergeListeners(cSL), false);
        }
        catch (IOException iOException) {
            Util.closeQuietly(socket);
            if (cSL != null) {
                cSL.cleanUp();
            }
            throw iOException;
        }
        outputStream.close();
        socket.close();
        if (cSL != null) {
            cSL.cleanUp();
        }
        boolean bl = this.completePendingCommand();
        return bl;
    }

    private OutputStream __storeFileStream(FTPCmd fTPCmd, String string) throws IOException {
        return this._storeFileStream(fTPCmd.getCommand(), string);
    }

    protected OutputStream _storeFileStream(String string, String string2) throws IOException {
        Socket socket = this._openDataConnection_(string, string2);
        if (socket == null) {
            return null;
        }
        OutputStream outputStream = this.__fileType == 0 ? new ToNetASCIIOutputStream(this.getBufferedOutputStream(socket.getOutputStream())) : socket.getOutputStream();
        return new SocketOutputStream(socket, outputStream);
    }

    @Deprecated
    protected Socket _openDataConnection_(int n, String string) throws IOException {
        return this._openDataConnection_(FTPCommand.getCommand(n), string);
    }

    protected Socket _openDataConnection_(FTPCmd fTPCmd, String string) throws IOException {
        return this._openDataConnection_(fTPCmd.getCommand(), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected Socket _openDataConnection_(String var1_1, String var2_2) throws IOException {
        if (this.__dataConnectionMode != 0 && this.__dataConnectionMode != 2) {
            return null;
        }
        var3_3 = this.getRemoteAddress() instanceof Inet6Address;
        if (this.__dataConnectionMode == 0) {
            var5_4 = this._serverSocketFactory_.createServerSocket(this.getActivePort(), 1, this.getHostAddress());
            try {
                if (var3_3) {
                    if (!FTPReply.isPositiveCompletion(this.eprt(this.getReportHostAddress(), var5_4.getLocalPort()))) {
                        var6_6 = null;
                        return var6_6;
                    }
                } else if (!FTPReply.isPositiveCompletion(this.port(this.getReportHostAddress(), var5_4.getLocalPort()))) {
                    var6_7 = null;
                    return var6_7;
                }
                if (this.__restartOffset > 0L && !this.restart(this.__restartOffset)) {
                    var6_8 = null;
                    return var6_8;
                }
                if (!FTPReply.isPositivePreliminary(this.sendCommand(var1_1, var2_2))) {
                    var6_9 = null;
                    return var6_9;
                }
                if (this.__dataTimeout >= 0) {
                    var5_4.setSoTimeout(this.__dataTimeout);
                }
                var4_10 = var5_4.accept();
                if (this.__dataTimeout >= 0) {
                    var4_10.setSoTimeout(this.__dataTimeout);
                }
                if (this.__receiveDataSocketBufferSize > 0) {
                    var4_10.setReceiveBufferSize(this.__receiveDataSocketBufferSize);
                }
                if (this.__sendDataSocketBufferSize <= 0) ** GOTO lbl59
                var4_10.setSendBufferSize(this.__sendDataSocketBufferSize);
            }
            finally {
                var5_4.close();
            }
        } else {
            v0 = var5_5 = this.isUseEPSVwithIPv4() != false || var3_3 != false;
            if (var5_5 && this.epsv() == 229) {
                this._parseExtendedPassiveModeReply((String)this._replyLines.get(0));
            } else {
                if (var3_3) {
                    return null;
                }
                if (this.pasv() != 227) {
                    return null;
                }
                this._parsePassiveModeReply((String)this._replyLines.get(0));
            }
            var4_10 = this._socketFactory_.createSocket();
            if (this.__receiveDataSocketBufferSize > 0) {
                var4_10.setReceiveBufferSize(this.__receiveDataSocketBufferSize);
            }
            if (this.__sendDataSocketBufferSize > 0) {
                var4_10.setSendBufferSize(this.__sendDataSocketBufferSize);
            }
            if (this.__passiveLocalHost != null) {
                var4_10.bind(new InetSocketAddress(this.__passiveLocalHost, 0));
            }
            if (this.__dataTimeout >= 0) {
                var4_10.setSoTimeout(this.__dataTimeout);
            }
            var4_10.connect(new InetSocketAddress(this.__passiveHost, this.__passivePort), this.connectTimeout);
            if (this.__restartOffset > 0L && !this.restart(this.__restartOffset)) {
                var4_10.close();
                return null;
            }
            if (!FTPReply.isPositivePreliminary(this.sendCommand(var1_1, var2_2))) {
                var4_10.close();
                return null;
            }
        }
lbl59:
        // 4 sources

        if (this.__remoteVerificationEnabled && !this.verifyRemote(var4_10)) {
            var4_10.close();
            throw new IOException("Host attempting data connection " + var4_10.getInetAddress().getHostAddress() + " is not same as server " + this.getRemoteAddress().getHostAddress());
        }
        return var4_10;
    }

    @Override
    protected void _connectAction_() throws IOException {
        this._connectAction_(null);
    }

    @Override
    protected void _connectAction_(Reader reader) throws IOException {
        super._connectAction_(reader);
        this.__initDefaults();
        if (this.__autodetectEncoding) {
            ArrayList arrayList = new ArrayList(this._replyLines);
            int n = this._replyCode;
            if (this.hasFeature("UTF8") || this.hasFeature("UTF-8")) {
                this.setControlEncoding("UTF-8");
                this._controlInput_ = new CRLFLineReader(new InputStreamReader(this._input_, this.getControlEncoding()));
                this._controlOutput_ = new BufferedWriter(new OutputStreamWriter(this._output_, this.getControlEncoding()));
            }
            this._replyLines.clear();
            this._replyLines.addAll(arrayList);
            this._replyCode = n;
        }
    }

    public void setDataTimeout(int n) {
        this.__dataTimeout = n;
    }

    public void setParserFactory(FTPFileEntryParserFactory fTPFileEntryParserFactory) {
        this.__parserFactory = fTPFileEntryParserFactory;
    }

    @Override
    public void disconnect() throws IOException {
        super.disconnect();
        this.__initDefaults();
    }

    public void setRemoteVerificationEnabled(boolean bl) {
        this.__remoteVerificationEnabled = bl;
    }

    public boolean isRemoteVerificationEnabled() {
        return this.__remoteVerificationEnabled;
    }

    public boolean login(String string, String string2) throws IOException {
        this.user(string);
        if (FTPReply.isPositiveCompletion(this._replyCode)) {
            return true;
        }
        if (!FTPReply.isPositiveIntermediate(this._replyCode)) {
            return false;
        }
        return FTPReply.isPositiveCompletion(this.pass(string2));
    }

    public boolean login(String string, String string2, String string3) throws IOException {
        this.user(string);
        if (FTPReply.isPositiveCompletion(this._replyCode)) {
            return true;
        }
        if (!FTPReply.isPositiveIntermediate(this._replyCode)) {
            return false;
        }
        this.pass(string2);
        if (FTPReply.isPositiveCompletion(this._replyCode)) {
            return true;
        }
        if (!FTPReply.isPositiveIntermediate(this._replyCode)) {
            return false;
        }
        return FTPReply.isPositiveCompletion(this.acct(string3));
    }

    public boolean logout() throws IOException {
        return FTPReply.isPositiveCompletion(this.quit());
    }

    public boolean changeWorkingDirectory(String string) throws IOException {
        return FTPReply.isPositiveCompletion(this.cwd(string));
    }

    public boolean changeToParentDirectory() throws IOException {
        return FTPReply.isPositiveCompletion(this.cdup());
    }

    public boolean structureMount(String string) throws IOException {
        return FTPReply.isPositiveCompletion(this.smnt(string));
    }

    public boolean reinitialize() throws IOException {
        this.rein();
        if (FTPReply.isPositiveCompletion(this._replyCode) || FTPReply.isPositivePreliminary(this._replyCode) && FTPReply.isPositiveCompletion(this.getReply())) {
            this.__initDefaults();
            return true;
        }
        return false;
    }

    public void enterLocalActiveMode() {
        this.__dataConnectionMode = 0;
        this.__passiveHost = null;
        this.__passivePort = -1;
    }

    public void enterLocalPassiveMode() {
        this.__dataConnectionMode = 2;
        this.__passiveHost = null;
        this.__passivePort = -1;
    }

    public boolean enterRemoteActiveMode(InetAddress inetAddress, int n) throws IOException {
        if (FTPReply.isPositiveCompletion(this.port(inetAddress, n))) {
            this.__dataConnectionMode = 1;
            this.__passiveHost = null;
            this.__passivePort = -1;
            return true;
        }
        return false;
    }

    public boolean enterRemotePassiveMode() throws IOException {
        if (this.pasv() != 227) {
            return false;
        }
        this.__dataConnectionMode = 3;
        this._parsePassiveModeReply((String)this._replyLines.get(0));
        return true;
    }

    public String getPassiveHost() {
        return this.__passiveHost;
    }

    public int getPassivePort() {
        return this.__passivePort;
    }

    public int getDataConnectionMode() {
        return this.__dataConnectionMode;
    }

    private int getActivePort() {
        if (this.__activeMinPort > 0 && this.__activeMaxPort >= this.__activeMinPort) {
            if (this.__activeMaxPort == this.__activeMinPort) {
                return this.__activeMaxPort;
            }
            return this.__random.nextInt(this.__activeMaxPort - this.__activeMinPort + 1) + this.__activeMinPort;
        }
        return 0;
    }

    private InetAddress getHostAddress() {
        if (this.__activeExternalHost != null) {
            return this.__activeExternalHost;
        }
        return this.getLocalAddress();
    }

    private InetAddress getReportHostAddress() {
        if (this.__reportActiveExternalHost != null) {
            return this.__reportActiveExternalHost;
        }
        return this.getHostAddress();
    }

    public void setActivePortRange(int n, int n2) {
        this.__activeMinPort = n;
        this.__activeMaxPort = n2;
    }

    public void setActiveExternalIPAddress(String string) throws UnknownHostException {
        this.__activeExternalHost = InetAddress.getByName(string);
    }

    public void setPassiveLocalIPAddress(String string) throws UnknownHostException {
        this.__passiveLocalHost = InetAddress.getByName(string);
    }

    public void setPassiveLocalIPAddress(InetAddress inetAddress) {
        this.__passiveLocalHost = inetAddress;
    }

    public InetAddress getPassiveLocalIPAddress() {
        return this.__passiveLocalHost;
    }

    public void setReportActiveExternalIPAddress(String string) throws UnknownHostException {
        this.__reportActiveExternalHost = InetAddress.getByName(string);
    }

    public boolean setFileType(int n) throws IOException {
        if (FTPReply.isPositiveCompletion(this.type(n))) {
            this.__fileType = n;
            this.__fileFormat = 4;
            return true;
        }
        return false;
    }

    public boolean setFileType(int n, int n2) throws IOException {
        if (FTPReply.isPositiveCompletion(this.type(n, n2))) {
            this.__fileType = n;
            this.__fileFormat = n2;
            return true;
        }
        return false;
    }

    public boolean setFileStructure(int n) throws IOException {
        if (FTPReply.isPositiveCompletion(this.stru(n))) {
            this.__fileStructure = n;
            return true;
        }
        return false;
    }

    public boolean setFileTransferMode(int n) throws IOException {
        if (FTPReply.isPositiveCompletion(this.mode(n))) {
            this.__fileTransferMode = n;
            return true;
        }
        return false;
    }

    public boolean remoteRetrieve(String string) throws IOException {
        if (this.__dataConnectionMode == 1 || this.__dataConnectionMode == 3) {
            return FTPReply.isPositivePreliminary(this.retr(string));
        }
        return false;
    }

    public boolean remoteStore(String string) throws IOException {
        if (this.__dataConnectionMode == 1 || this.__dataConnectionMode == 3) {
            return FTPReply.isPositivePreliminary(this.stor(string));
        }
        return false;
    }

    public boolean remoteStoreUnique(String string) throws IOException {
        if (this.__dataConnectionMode == 1 || this.__dataConnectionMode == 3) {
            return FTPReply.isPositivePreliminary(this.stou(string));
        }
        return false;
    }

    public boolean remoteStoreUnique() throws IOException {
        if (this.__dataConnectionMode == 1 || this.__dataConnectionMode == 3) {
            return FTPReply.isPositivePreliminary(this.stou());
        }
        return false;
    }

    public boolean remoteAppend(String string) throws IOException {
        if (this.__dataConnectionMode == 1 || this.__dataConnectionMode == 3) {
            return FTPReply.isPositivePreliminary(this.appe(string));
        }
        return false;
    }

    public boolean completePendingCommand() throws IOException {
        return FTPReply.isPositiveCompletion(this.getReply());
    }

    public boolean retrieveFile(String string, OutputStream outputStream) throws IOException {
        return this._retrieveFile(FTPCmd.RETR.getCommand(), string, outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean _retrieveFile(String string, String string2, OutputStream outputStream) throws IOException {
        Socket socket = this._openDataConnection_(string, string2);
        if (socket == null) {
            return false;
        }
        InputStream inputStream = this.__fileType == 0 ? new FromNetASCIIInputStream(this.getBufferedInputStream(socket.getInputStream())) : this.getBufferedInputStream(socket.getInputStream());
        CSL cSL = null;
        if (this.__controlKeepAliveTimeout > 0L) {
            cSL = new CSL(this, this.__controlKeepAliveTimeout, this.__controlKeepAliveReplyTimeout);
        }
        try {
            Util.copyStream(inputStream, outputStream, this.getBufferSize(), -1L, this.__mergeListeners(cSL), false);
        }
        finally {
            Util.closeQuietly(inputStream);
            Util.closeQuietly(socket);
            if (cSL != null) {
                cSL.cleanUp();
            }
        }
        boolean bl = this.completePendingCommand();
        return bl;
    }

    public InputStream retrieveFileStream(String string) throws IOException {
        return this._retrieveFileStream(FTPCmd.RETR.getCommand(), string);
    }

    protected InputStream _retrieveFileStream(String string, String string2) throws IOException {
        Socket socket = this._openDataConnection_(string, string2);
        if (socket == null) {
            return null;
        }
        InputStream inputStream = this.__fileType == 0 ? new FromNetASCIIInputStream(this.getBufferedInputStream(socket.getInputStream())) : socket.getInputStream();
        return new SocketInputStream(socket, inputStream);
    }

    public boolean storeFile(String string, InputStream inputStream) throws IOException {
        return this.__storeFile(FTPCmd.STOR, string, inputStream);
    }

    public OutputStream storeFileStream(String string) throws IOException {
        return this.__storeFileStream(FTPCmd.STOR, string);
    }

    public boolean appendFile(String string, InputStream inputStream) throws IOException {
        return this.__storeFile(FTPCmd.APPE, string, inputStream);
    }

    public OutputStream appendFileStream(String string) throws IOException {
        return this.__storeFileStream(FTPCmd.APPE, string);
    }

    public boolean storeUniqueFile(String string, InputStream inputStream) throws IOException {
        return this.__storeFile(FTPCmd.STOU, string, inputStream);
    }

    public OutputStream storeUniqueFileStream(String string) throws IOException {
        return this.__storeFileStream(FTPCmd.STOU, string);
    }

    public boolean storeUniqueFile(InputStream inputStream) throws IOException {
        return this.__storeFile(FTPCmd.STOU, null, inputStream);
    }

    public OutputStream storeUniqueFileStream() throws IOException {
        return this.__storeFileStream(FTPCmd.STOU, null);
    }

    public boolean allocate(int n) throws IOException {
        return FTPReply.isPositiveCompletion(this.allo(n));
    }

    public boolean features() throws IOException {
        return FTPReply.isPositiveCompletion(this.feat());
    }

    public String[] featureValues(String string) throws IOException {
        if (!this.initFeatureMap()) {
            return null;
        }
        Set<String> set = this.__featuresMap.get(string.toUpperCase(Locale.ENGLISH));
        if (set != null) {
            return set.toArray(new String[set.size()]);
        }
        return null;
    }

    public String featureValue(String string) throws IOException {
        String[] stringArray = this.featureValues(string);
        if (stringArray != null) {
            return stringArray[0];
        }
        return null;
    }

    public boolean hasFeature(String string) throws IOException {
        if (!this.initFeatureMap()) {
            return false;
        }
        return this.__featuresMap.containsKey(string.toUpperCase(Locale.ENGLISH));
    }

    public boolean hasFeature(String string, String string2) throws IOException {
        if (!this.initFeatureMap()) {
            return false;
        }
        Set<String> set = this.__featuresMap.get(string.toUpperCase(Locale.ENGLISH));
        if (set != null) {
            return set.contains(string2);
        }
        return false;
    }

    private boolean initFeatureMap() throws IOException {
        if (this.__featuresMap == null) {
            int n = this.feat();
            if (n == 530) {
                return false;
            }
            boolean bl = FTPReply.isPositiveCompletion(n);
            this.__featuresMap = new HashMap();
            if (!bl) {
                return false;
            }
            for (String string : this.getReplyStrings()) {
                String string2;
                if (!string.startsWith(" ")) continue;
                String string3 = "";
                int n2 = string.indexOf(32, 1);
                if (n2 > 0) {
                    string2 = string.substring(1, n2);
                    string3 = string.substring(n2 + 1);
                } else {
                    string2 = string.substring(1);
                }
                string2 = string2.toUpperCase(Locale.ENGLISH);
                Set<String> set = this.__featuresMap.get(string2);
                if (set == null) {
                    set = new HashSet<String>();
                    this.__featuresMap.put(string2, set);
                }
                set.add(string3);
            }
        }
        return true;
    }

    public boolean allocate(int n, int n2) throws IOException {
        return FTPReply.isPositiveCompletion(this.allo(n, n2));
    }

    public boolean doCommand(String string, String string2) throws IOException {
        return FTPReply.isPositiveCompletion(this.sendCommand(string, string2));
    }

    public String[] doCommandAsStrings(String string, String string2) throws IOException {
        boolean bl = FTPReply.isPositiveCompletion(this.sendCommand(string, string2));
        if (bl) {
            return this.getReplyStrings();
        }
        return null;
    }

    public FTPFile mlistFile(String string) throws IOException {
        boolean bl = FTPReply.isPositiveCompletion(this.sendCommand(FTPCmd.MLST, string));
        if (bl) {
            String string2 = this.getReplyStrings()[1].substring(1);
            return MLSxEntryParser.parseEntry(string2);
        }
        return null;
    }

    public FTPFile[] mlistDir() throws IOException {
        return this.mlistDir(null);
    }

    public FTPFile[] mlistDir(String string) throws IOException {
        FTPListParseEngine fTPListParseEngine = this.initiateMListParsing(string);
        return fTPListParseEngine.getFiles();
    }

    public FTPFile[] mlistDir(String string, FTPFileFilter fTPFileFilter) throws IOException {
        FTPListParseEngine fTPListParseEngine = this.initiateMListParsing(string);
        return fTPListParseEngine.getFiles(fTPFileFilter);
    }

    protected boolean restart(long l) throws IOException {
        this.__restartOffset = 0L;
        return FTPReply.isPositiveIntermediate(this.rest(Long.toString(l)));
    }

    public void setRestartOffset(long l) {
        if (l >= 0L) {
            this.__restartOffset = l;
        }
    }

    public long getRestartOffset() {
        return this.__restartOffset;
    }

    public boolean rename(String string, String string2) throws IOException {
        if (!FTPReply.isPositiveIntermediate(this.rnfr(string))) {
            return false;
        }
        return FTPReply.isPositiveCompletion(this.rnto(string2));
    }

    public boolean abort() throws IOException {
        return FTPReply.isPositiveCompletion(this.abor());
    }

    public boolean deleteFile(String string) throws IOException {
        return FTPReply.isPositiveCompletion(this.dele(string));
    }

    public boolean removeDirectory(String string) throws IOException {
        return FTPReply.isPositiveCompletion(this.rmd(string));
    }

    public boolean makeDirectory(String string) throws IOException {
        return FTPReply.isPositiveCompletion(this.mkd(string));
    }

    public String printWorkingDirectory() throws IOException {
        if (this.pwd() != 257) {
            return null;
        }
        return FTPClient.__parsePathname((String)this._replyLines.get(this._replyLines.size() - 1));
    }

    public boolean sendSiteCommand(String string) throws IOException {
        return FTPReply.isPositiveCompletion(this.site(string));
    }

    public String getSystemType() throws IOException {
        if (this.__systemName == null) {
            if (FTPReply.isPositiveCompletion(this.syst())) {
                this.__systemName = ((String)this._replyLines.get(this._replyLines.size() - 1)).substring(4);
            } else {
                String string = System.getProperty(FTP_SYSTEM_TYPE_DEFAULT);
                if (string != null) {
                    this.__systemName = string;
                } else {
                    throw new IOException("Unable to determine system type - response: " + this.getReplyString());
                }
            }
        }
        return this.__systemName;
    }

    public String listHelp() throws IOException {
        if (FTPReply.isPositiveCompletion(this.help())) {
            return this.getReplyString();
        }
        return null;
    }

    public String listHelp(String string) throws IOException {
        if (FTPReply.isPositiveCompletion(this.help(string))) {
            return this.getReplyString();
        }
        return null;
    }

    public boolean sendNoOp() throws IOException {
        return FTPReply.isPositiveCompletion(this.noop());
    }

    public String[] listNames(String string) throws IOException {
        String string2;
        Socket socket = this._openDataConnection_(FTPCmd.NLST, this.getListArguments(string));
        if (socket == null) {
            return null;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream(), this.getControlEncoding()));
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((string2 = bufferedReader.readLine()) != null) {
            arrayList.add(string2);
        }
        bufferedReader.close();
        socket.close();
        if (this.completePendingCommand()) {
            String[] stringArray = new String[arrayList.size()];
            return arrayList.toArray(stringArray);
        }
        return null;
    }

    public String[] listNames() throws IOException {
        return this.listNames(null);
    }

    public FTPFile[] listFiles(String string) throws IOException {
        FTPListParseEngine fTPListParseEngine = this.initiateListParsing((String)null, string);
        return fTPListParseEngine.getFiles();
    }

    public FTPFile[] listFiles() throws IOException {
        return this.listFiles(null);
    }

    public FTPFile[] listFiles(String string, FTPFileFilter fTPFileFilter) throws IOException {
        FTPListParseEngine fTPListParseEngine = this.initiateListParsing((String)null, string);
        return fTPListParseEngine.getFiles(fTPFileFilter);
    }

    public FTPFile[] listDirectories() throws IOException {
        return this.listDirectories(null);
    }

    public FTPFile[] listDirectories(String string) throws IOException {
        return this.listFiles(string, FTPFileFilters.DIRECTORIES);
    }

    public FTPListParseEngine initiateListParsing() throws IOException {
        return this.initiateListParsing(null);
    }

    public FTPListParseEngine initiateListParsing(String string) throws IOException {
        return this.initiateListParsing((String)null, string);
    }

    public FTPListParseEngine initiateListParsing(String string, String string2) throws IOException {
        this.__createParser(string);
        return this.initiateListParsing(this.__entryParser, string2);
    }

    void __createParser(String string) throws IOException {
        if (this.__entryParser == null || string != null && !this.__entryParserKey.equals(string)) {
            if (null != string) {
                this.__entryParser = this.__parserFactory.createFileEntryParser(string);
                this.__entryParserKey = string;
            } else if (null != this.__configuration && this.__configuration.getServerSystemKey().length() > 0) {
                this.__entryParser = this.__parserFactory.createFileEntryParser(this.__configuration);
                this.__entryParserKey = this.__configuration.getServerSystemKey();
            } else {
                String string2 = System.getProperty(FTP_SYSTEM_TYPE);
                if (string2 == null) {
                    String string3;
                    string2 = this.getSystemType();
                    Properties properties = FTPClient.getOverrideProperties();
                    if (properties != null && (string3 = properties.getProperty(string2)) != null) {
                        string2 = string3;
                    }
                }
                this.__entryParser = null != this.__configuration ? this.__parserFactory.createFileEntryParser(new FTPClientConfig(string2, this.__configuration)) : this.__parserFactory.createFileEntryParser(string2);
                this.__entryParserKey = string2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FTPListParseEngine initiateListParsing(FTPFileEntryParser fTPFileEntryParser, String string) throws IOException {
        Socket socket = this._openDataConnection_(FTPCmd.LIST, this.getListArguments(string));
        FTPListParseEngine fTPListParseEngine = new FTPListParseEngine(fTPFileEntryParser, this.__configuration);
        if (socket == null) {
            return fTPListParseEngine;
        }
        try {
            fTPListParseEngine.readServerList(socket.getInputStream(), this.getControlEncoding());
        }
        finally {
            Util.closeQuietly(socket);
        }
        this.completePendingCommand();
        return fTPListParseEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FTPListParseEngine initiateMListParsing(String string) throws IOException {
        Socket socket = this._openDataConnection_(FTPCmd.MLSD, string);
        FTPListParseEngine fTPListParseEngine = new FTPListParseEngine(MLSxEntryParser.getInstance(), this.__configuration);
        if (socket == null) {
            return fTPListParseEngine;
        }
        try {
            fTPListParseEngine.readServerList(socket.getInputStream(), this.getControlEncoding());
        }
        finally {
            Util.closeQuietly(socket);
            this.completePendingCommand();
        }
        return fTPListParseEngine;
    }

    protected String getListArguments(String string) {
        if (this.getListHiddenFiles()) {
            if (string != null) {
                StringBuilder stringBuilder = new StringBuilder(string.length() + 3);
                stringBuilder.append("-a ");
                stringBuilder.append(string);
                return stringBuilder.toString();
            }
            return "-a";
        }
        return string;
    }

    public String getStatus() throws IOException {
        if (FTPReply.isPositiveCompletion(this.stat())) {
            return this.getReplyString();
        }
        return null;
    }

    public String getStatus(String string) throws IOException {
        if (FTPReply.isPositiveCompletion(this.stat(string))) {
            return this.getReplyString();
        }
        return null;
    }

    public String getModificationTime(String string) throws IOException {
        if (FTPReply.isPositiveCompletion(this.mdtm(string))) {
            return this.getReplyStrings()[0].substring(4);
        }
        return null;
    }

    public FTPFile mdtmFile(String string) throws IOException {
        if (FTPReply.isPositiveCompletion(this.mdtm(string))) {
            String string2 = this.getReplyStrings()[0].substring(4);
            FTPFile fTPFile = new FTPFile();
            fTPFile.setName(string);
            fTPFile.setRawListing(string2);
            fTPFile.setTimestamp(MLSxEntryParser.parseGMTdateTime(string2));
            return fTPFile;
        }
        return null;
    }

    public boolean setModificationTime(String string, String string2) throws IOException {
        return FTPReply.isPositiveCompletion(this.mfmt(string, string2));
    }

    public void setBufferSize(int n) {
        this.__bufferSize = n;
    }

    public int getBufferSize() {
        return this.__bufferSize;
    }

    public void setSendDataSocketBufferSize(int n) {
        this.__sendDataSocketBufferSize = n;
    }

    public int getSendDataSocketBufferSize() {
        return this.__sendDataSocketBufferSize;
    }

    public void setReceieveDataSocketBufferSize(int n) {
        this.__receiveDataSocketBufferSize = n;
    }

    public int getReceiveDataSocketBufferSize() {
        return this.__receiveDataSocketBufferSize;
    }

    @Override
    public void configure(FTPClientConfig fTPClientConfig) {
        this.__configuration = fTPClientConfig;
    }

    public void setListHiddenFiles(boolean bl) {
        this.__listHiddenFiles = bl;
    }

    public boolean getListHiddenFiles() {
        return this.__listHiddenFiles;
    }

    public boolean isUseEPSVwithIPv4() {
        return this.__useEPSVwithIPv4;
    }

    public void setUseEPSVwithIPv4(boolean bl) {
        this.__useEPSVwithIPv4 = bl;
    }

    public void setCopyStreamListener(CopyStreamListener copyStreamListener) {
        this.__copyStreamListener = copyStreamListener;
    }

    public CopyStreamListener getCopyStreamListener() {
        return this.__copyStreamListener;
    }

    public void setControlKeepAliveTimeout(long l) {
        this.__controlKeepAliveTimeout = l * 1000L;
    }

    public long getControlKeepAliveTimeout() {
        return this.__controlKeepAliveTimeout / 1000L;
    }

    public void setControlKeepAliveReplyTimeout(int n) {
        this.__controlKeepAliveReplyTimeout = n;
    }

    public int getControlKeepAliveReplyTimeout() {
        return this.__controlKeepAliveReplyTimeout;
    }

    public void setPassiveNatWorkaround(boolean bl) {
        this.__passiveNatWorkaround = bl;
    }

    private OutputStream getBufferedOutputStream(OutputStream outputStream) {
        if (this.__bufferSize > 0) {
            return new BufferedOutputStream(outputStream, this.__bufferSize);
        }
        return new BufferedOutputStream(outputStream);
    }

    private InputStream getBufferedInputStream(InputStream inputStream) {
        if (this.__bufferSize > 0) {
            return new BufferedInputStream(inputStream, this.__bufferSize);
        }
        return new BufferedInputStream(inputStream);
    }

    private CopyStreamListener __mergeListeners(CopyStreamListener copyStreamListener) {
        if (copyStreamListener == null) {
            return this.__copyStreamListener;
        }
        if (this.__copyStreamListener == null) {
            return copyStreamListener;
        }
        CopyStreamAdapter copyStreamAdapter = new CopyStreamAdapter();
        copyStreamAdapter.addCopyStreamListener(copyStreamListener);
        copyStreamAdapter.addCopyStreamListener(this.__copyStreamListener);
        return copyStreamAdapter;
    }

    public void setAutodetectUTF8(boolean bl) {
        this.__autodetectEncoding = bl;
    }

    public boolean getAutodetectUTF8() {
        return this.__autodetectEncoding;
    }

    FTPFileEntryParser getEntryParser() {
        return this.__entryParser;
    }

    @Deprecated
    public String getSystemName() throws IOException {
        if (this.__systemName == null && FTPReply.isPositiveCompletion(this.syst())) {
            this.__systemName = ((String)this._replyLines.get(this._replyLines.size() - 1)).substring(4);
        }
        return this.__systemName;
    }

    private static class CSL
    implements CopyStreamListener {
        private final FTPClient parent;
        private final long idle;
        private final int currentSoTimeout;
        private long time = System.currentTimeMillis();
        private int notAcked;

        CSL(FTPClient fTPClient, long l, int n) throws SocketException {
            this.idle = l;
            this.parent = fTPClient;
            this.currentSoTimeout = fTPClient.getSoTimeout();
            fTPClient.setSoTimeout(n);
        }

        @Override
        public void bytesTransferred(CopyStreamEvent copyStreamEvent) {
            this.bytesTransferred(copyStreamEvent.getTotalBytesTransferred(), copyStreamEvent.getBytesTransferred(), copyStreamEvent.getStreamSize());
        }

        @Override
        public void bytesTransferred(long l, int n, long l2) {
            long l3 = System.currentTimeMillis();
            if (l3 - this.time > this.idle) {
                try {
                    this.parent.__noop();
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    ++this.notAcked;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.time = l3;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cleanUp() throws IOException {
            try {
                while (this.notAcked-- > 0) {
                    this.parent.__getReplyNoReport();
                }
            }
            finally {
                this.parent.setSoTimeout(this.currentSoTimeout);
            }
        }
    }

    private static class PropertiesSingleton {
        static final Properties PROPERTIES;

        private PropertiesSingleton() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static {
            InputStream inputStream = FTPClient.class.getResourceAsStream(FTPClient.SYSTEM_TYPE_PROPERTIES);
            Properties properties = null;
            if (inputStream != null) {
                properties = new Properties();
                try {
                    properties.load(inputStream);
                }
                catch (IOException iOException) {
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            PROPERTIES = properties;
        }
    }
}

