/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.node.Location;
import freenet.support.Logger;
import java.util.Arrays;
import java.util.Set;

public class PeerLocation {
    private double currentLocation;
    private double[] currentPeersLocation;
    private long locSetTime;

    PeerLocation(String locationString) {
        this.currentLocation = Location.getLocation(locationString);
        this.locSetTime = System.currentTimeMillis();
    }

    public synchronized String toString() {
        return Double.toString(this.currentLocation);
    }

    public void setPeerLocations(String[] peerLocationsString) {
        if (peerLocationsString != null) {
            double[] peerLocations = new double[peerLocationsString.length];
            for (int i = 0; i < peerLocationsString.length; ++i) {
                peerLocations[i] = Location.getLocation(peerLocationsString[i]);
            }
            this.updateLocation(this.currentLocation, peerLocations);
        }
    }

    public synchronized double getLocation() {
        return this.currentLocation;
    }

    public synchronized double[] getPeersLocationArray() {
        if (this.currentPeersLocation == null) {
            return null;
        }
        return Arrays.copyOf(this.currentPeersLocation, this.currentPeersLocation.length);
    }

    public synchronized long getLocationSetTime() {
        return this.locSetTime;
    }

    public synchronized boolean isValidLocation() {
        return Location.isValid(this.currentLocation);
    }

    public synchronized int getDegree() {
        if (this.currentPeersLocation == null) {
            return 0;
        }
        return this.currentPeersLocation.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updateLocation(double newLoc, double[] newLocs) {
        if (!Location.isValid(newLoc)) {
            Logger.error(this, "Invalid location update for " + this + " (" + newLoc + ')', (Throwable)new Exception("error"));
            return false;
        }
        double[] newPeersLocation = new double[newLocs.length];
        for (int i = 0; i < newLocs.length; ++i) {
            double loc = newLocs[i];
            if (!Location.isValid(loc)) {
                Logger.error(this, "Invalid location update for " + this + " (" + loc + ")", (Throwable)new Exception("error"));
                return false;
            }
            newPeersLocation[i] = loc;
        }
        Arrays.sort(newPeersLocation);
        boolean anythingChanged = false;
        PeerLocation peerLocation = this;
        synchronized (peerLocation) {
            if (!Location.equals(this.currentLocation, newLoc) || this.currentPeersLocation == null) {
                anythingChanged = true;
            }
            if (!anythingChanged) {
                boolean bl = anythingChanged = this.currentPeersLocation.length != newPeersLocation.length;
            }
            if (!anythingChanged) {
                for (int i = 0; i < this.currentPeersLocation.length; ++i) {
                    if (Location.equals(this.currentPeersLocation[i], newPeersLocation[i])) continue;
                    anythingChanged = true;
                    break;
                }
            }
            this.currentLocation = newLoc;
            this.currentPeersLocation = newPeersLocation;
            this.locSetTime = System.currentTimeMillis();
        }
        return anythingChanged;
    }

    synchronized double setLocation(double newLoc) {
        double oldLoc = this.currentLocation;
        if (!Location.equals(newLoc, this.currentLocation)) {
            this.currentLocation = newLoc;
            this.locSetTime = System.currentTimeMillis();
        }
        return oldLoc;
    }

    private static int findFirstGreater(double[] elems, double x) {
        int low = 0;
        int high = elems.length;
        if (elems[high - 1] <= x) {
            return -1;
        }
        while (low != high) {
            int mid = low + (high - low) / 2;
            if (elems[mid] > x) {
                high = mid;
                continue;
            }
            low = mid + 1;
        }
        return low;
    }

    static int findClosestLocation(double[] locs, double l) {
        int right;
        int left;
        assert (locs.length > 0);
        if (locs.length == 1) {
            return 0;
        }
        int firstGreater = PeerLocation.findFirstGreater(locs, l);
        if (firstGreater == -1 || firstGreater == 0) {
            left = locs.length - 1;
            right = 0;
        } else {
            left = firstGreater - 1;
            right = firstGreater;
        }
        if (Location.distance(l, locs[left]) <= Location.distance(l, locs[right])) {
            return left;
        }
        return right;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getClosestPeerLocation(double l, Set<Double> exclude) {
        double loc;
        double[] locs;
        PeerLocation peerLocation = this;
        synchronized (peerLocation) {
            locs = this.currentPeersLocation;
        }
        if (locs == null || locs.length == 0) {
            return Double.NaN;
        }
        int closest = PeerLocation.findClosestLocation(locs, l);
        if (exclude == null || !exclude.contains(locs[closest])) {
            return locs[closest];
        }
        int left = closest == 0 ? locs.length - 1 : closest - 1;
        int right = closest == locs.length - 1 ? 0 : closest + 1;
        double leftDist = Location.distance(l, locs[left]);
        double rightDist = Location.distance(l, locs[right]);
        while (left != right) {
            if (leftDist <= rightDist) {
                loc = locs[left];
                if (!exclude.contains(loc)) {
                    return loc;
                }
                left = left == 0 ? locs.length - 1 : left - 1;
                leftDist = Location.distance(l, locs[left]);
                continue;
            }
            loc = locs[right];
            if (!exclude.contains(loc)) {
                return loc;
            }
            right = right == locs.length - 1 ? 0 : right + 1;
            rightDist = Location.distance(l, locs[right]);
        }
        loc = locs[left];
        if (!exclude.contains(loc)) {
            return loc;
        }
        return Double.NaN;
    }
}

