/*
 * Decompiled with CFR 0.152.
 */
package com.onionnetworks.util;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class TimedSoftHashMap
extends HashMap {
    public static final int DEFAULT_TTL = 120000;
    TreeSet timings = new TreeSet();

    public TimedSoftHashMap() {
    }

    public TimedSoftHashMap(Map t) {
        throw new UnsupportedOperationException("this(Map t)");
    }

    public TimedSoftHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public TimedSoftHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    @Override
    public boolean containsValue(Object value) {
        return super.containsValue(new HashableSoftReference(value, 0));
    }

    @Override
    public Set entrySet() {
        throw new UnsupportedOperationException("entrySet()");
    }

    @Override
    public Object get(Object key) {
        HashableSoftReference ref = (HashableSoftReference)super.get(key);
        if (ref != null) {
            ref.renew();
        }
        this.checkTimings();
        return ref == null ? null : ref.get();
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException("isEmpty()");
    }

    @Override
    public Set keySet() {
        throw new UnsupportedOperationException("entrySet()");
    }

    @Override
    public Object put(Object key, Object value) {
        return this.put(key, value, 120000);
    }

    public Object put(Object key, Object value, int ttl) {
        this.checkTimings();
        HashableSoftReference hsr = new HashableSoftReference(value, ttl);
        HashableSoftReference hsr2 = super.put(key, hsr);
        this.timings.add(hsr);
        if (hsr2 == null) {
            return null;
        }
        this.timings.remove(hsr2);
        return hsr2.get();
    }

    @Override
    public void putAll(Map t) {
        throw new UnsupportedOperationException("putAll(Map t)");
    }

    @Override
    public Object remove(Object key) {
        this.checkTimings();
        Reference ref = (Reference)super.remove(key);
        this.timings.remove(ref);
        return ref == null ? null : ref.get();
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("size()");
    }

    @Override
    public Collection values() {
        throw new UnsupportedOperationException("values()");
    }

    @Override
    public Object clone() {
        throw new UnsupportedOperationException("clone()");
    }

    protected void checkTimings() {
        long time = System.currentTimeMillis();
        Iterator it = this.timings.iterator();
        block0: while (it.hasNext()) {
            HashableSoftReference hsr = (HashableSoftReference)it.next();
            if (hsr.deathTime >= time) break;
            Iterator it2 = super.keySet().iterator();
            while (it2.hasNext()) {
                Object key = it2.next();
                if (super.get(key) != hsr) continue;
                it2.remove();
                it.remove();
                continue block0;
            }
        }
    }

    public class HashableSoftReference
    extends SoftReference
    implements Comparable {
        public long deathTime;
        public int ttl;

        public HashableSoftReference(Object ref, int ttl) {
            super(ref);
            this.ttl = ttl;
            this.renew();
        }

        public void renew() {
            this.deathTime = System.currentTimeMillis() + (long)this.ttl;
        }

        public int compareTo(Object obj) {
            HashableSoftReference hsr = (HashableSoftReference)obj;
            if (hsr.deathTime == this.deathTime) {
                return 0;
            }
            return hsr.deathTime < this.deathTime ? 1 : -1;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                throw new NullPointerException();
            }
            Object thisObj = this.get();
            if (thisObj == null) {
                return false;
            }
            return thisObj.equals(obj);
        }

        public int hashCode() {
            Object thisObj = this.get();
            if (thisObj == null) {
                return 0;
            }
            return thisObj.hashCode();
        }
    }
}

