/*
 * Decompiled with CFR 0.152.
 */
package com.onionnetworks.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;

public class NetUtil {
    public static final URL[] getIpUrlsByName(URL url) throws IOException {
        String userInfo = url.getUserInfo();
        String protocol = url.getProtocol();
        String host = url.getHost();
        String file = url.getFile();
        String ref = url.getRef();
        int port = url.getPort();
        if (host == null || "".equals(host)) {
            return new URL[]{url};
        }
        InetAddress[] addrs = InetAddress.getAllByName(host);
        URL[] retval = new URL[addrs.length];
        for (int i = 0; i < addrs.length; ++i) {
            retval[i] = new URL(protocol, userInfo == null ? addrs[i].getHostAddress() : userInfo + "@" + addrs[i].getHostAddress(), port, ref == null ? file : file + "#" + ref);
        }
        return retval;
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            args = new String[]{"http://user:pass@cnn.com:14234/dir/foobar?param&adsf=2312#anc", "http://user:pass@cnn.com:14234/dir/foobar?param&adsf=2312", "http://user@cnn.com:14234/dir/foobar?param&adsf=2312#anc", "http://cnn.com:14234/dir/foobar?param&adsf=2312#anc", "http:/dir/foobar?param&adsf=2312#anc", "http://cnn.com/", "http://64.236.24.4:14234/dir/foobar"};
        }
        for (int j = 0; j < args.length; ++j) {
            System.out.println("----------[ Matches for: " + args[j]);
            URL[] urls = NetUtil.getIpUrlsByName(new URL(args[j]));
            for (int i = 0; i < urls.length; ++i) {
                System.out.println(urls[i].toExternalForm());
            }
        }
    }
}

