/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.fontbox.util.Charsets;

abstract class TTFDataStream
implements Closeable {
    TTFDataStream() {
    }

    public float read32Fixed() throws IOException {
        float f = 0.0f;
        f = this.readSignedShort();
        f = (float)((double)f + (double)this.readUnsignedShort() / 65536.0);
        return f;
    }

    public String readString(int n) throws IOException {
        return this.readString(n, Charsets.ISO_8859_1);
    }

    public String readString(int n, String string) throws IOException {
        byte[] byArray = this.read(n);
        return new String(byArray, string);
    }

    public String readString(int n, Charset charset) throws IOException {
        byte[] byArray = this.read(n);
        return new String(byArray, charset);
    }

    public abstract int read() throws IOException;

    public abstract long readLong() throws IOException;

    public int readSignedByte() throws IOException {
        int n = this.read();
        return n < 127 ? n : n - 256;
    }

    public int readUnsignedByte() throws IOException {
        int n = this.read();
        if (n == -1) {
            throw new EOFException("premature EOF");
        }
        return n;
    }

    public long readUnsignedInt() throws IOException {
        long l = this.read();
        long l2 = this.read();
        long l3 = this.read();
        long l4 = this.read();
        if (l4 < 0L) {
            throw new EOFException();
        }
        return (l << 24) + (l2 << 16) + (l3 << 8) + (l4 << 0);
    }

    public abstract int readUnsignedShort() throws IOException;

    public int[] readUnsignedByteArray(int n) throws IOException {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.read();
        }
        return nArray;
    }

    public int[] readUnsignedShortArray(int n) throws IOException {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.readUnsignedShort();
        }
        return nArray;
    }

    public abstract short readSignedShort() throws IOException;

    public Calendar readInternationalDate() throws IOException {
        long l = this.readLong();
        Calendar calendar = GregorianCalendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.set(1904, 0, 1, 0, 0, 0);
        calendar.set(14, 0);
        long l2 = calendar.getTimeInMillis();
        calendar.setTimeInMillis(l2 += l * 1000L);
        return calendar;
    }

    public String readTag() throws IOException {
        return new String(this.read(4), Charsets.US_ASCII);
    }

    @Override
    public abstract void close() throws IOException;

    public abstract void seek(long var1) throws IOException;

    public byte[] read(int n) throws IOException {
        int n2;
        byte[] byArray = new byte[n];
        int n3 = 0;
        for (n2 = 0; n2 < n && (n3 = this.read(byArray, n2, n - n2)) != -1; n2 += n3) {
        }
        if (n2 == n) {
            return byArray;
        }
        throw new IOException("Unexpected end of TTF stream reached");
    }

    public abstract int read(byte[] var1, int var2, int var3) throws IOException;

    public abstract long getCurrentPosition() throws IOException;

    public abstract InputStream getOriginalData() throws IOException;
}

