/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class BufferedRandomAccessFile
extends RandomAccessFile {
    private final byte[] buffer;
    private int bufend = 0;
    private int bufpos = 0;
    private long realpos = 0L;
    private final int BUFSIZE;

    public BufferedRandomAccessFile(String string, String string2, int n) throws FileNotFoundException {
        super(string, string2);
        this.BUFSIZE = n;
        this.buffer = new byte[this.BUFSIZE];
    }

    public BufferedRandomAccessFile(File file, String string, int n) throws FileNotFoundException {
        super(file, string);
        this.BUFSIZE = n;
        this.buffer = new byte[this.BUFSIZE];
    }

    @Override
    public final int read() throws IOException {
        if (this.bufpos >= this.bufend && this.fillBuffer() < 0) {
            return -1;
        }
        if (this.bufend == 0) {
            return -1;
        }
        return this.buffer[this.bufpos++] + 256 & 0xFF;
    }

    private int fillBuffer() throws IOException {
        int n = super.read(this.buffer, 0, this.BUFSIZE);
        if (n >= 0) {
            this.realpos += (long)n;
            this.bufend = n;
            this.bufpos = 0;
        }
        return n;
    }

    private void invalidate() throws IOException {
        this.bufend = 0;
        this.bufpos = 0;
        this.realpos = super.getFilePointer();
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = this.bufend - this.bufpos;
        if (n2 <= n4) {
            System.arraycopy(this.buffer, this.bufpos, byArray, n, n2);
            this.bufpos += n2;
            return n2;
        }
        System.arraycopy(this.buffer, this.bufpos, byArray, n, n4);
        this.bufpos += n4;
        if (this.fillBuffer() > 0 && (n3 = this.read(byArray, n + n4, n2 - n4)) > 0) {
            n4 += n3;
        }
        return n4 > 0 ? n4 : -1;
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.realpos - (long)this.bufend + (long)this.bufpos;
    }

    @Override
    public void seek(long l) throws IOException {
        int n = (int)(this.realpos - l);
        if (n >= 0 && n <= this.bufend) {
            this.bufpos = this.bufend - n;
        } else {
            super.seek(l);
            this.invalidate();
        }
    }
}

