/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cff;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.cff.CharStringCommand;
import org.apache.fontbox.cff.DataInput;

public class Type1CharStringParser {
    private static final Log LOG = LogFactory.getLog(Type1CharStringParser.class);
    static final int RETURN = 11;
    static final int CALLSUBR = 10;
    static final int TWO_BYTE = 12;
    static final int CALLOTHERSUBR = 16;
    static final int POP = 17;
    private final String fontName;
    private final String glyphName;

    public Type1CharStringParser(String string, String string2) {
        this.fontName = string;
        this.glyphName = string2;
    }

    public List<Object> parse(byte[] byArray, List<byte[]> list) throws IOException {
        return this.parse(byArray, list, new ArrayList<Object>());
    }

    private List<Object> parse(byte[] byArray, List<byte[]> list, List<Object> list2) throws IOException {
        DataInput dataInput = new DataInput(byArray);
        while (dataInput.hasRemaining()) {
            Object object;
            Integer n;
            Object object2;
            int n2 = dataInput.readUnsignedByte();
            if (n2 == 10) {
                object2 = list2.remove(list2.size() - 1);
                if (!(object2 instanceof Integer)) {
                    LOG.warn((Object)("Parameter " + object2 + " for CALLSUBR is ignored, integer expected in glyph '" + this.glyphName + "' of font " + this.fontName));
                    continue;
                }
                n = (Integer)object2;
                if (n >= 0 && n < list.size()) {
                    object = list.get(n);
                    this.parse((byte[])object, list, list2);
                    Object object3 = list2.get(list2.size() - 1);
                    if (!(object3 instanceof CharStringCommand) || ((CharStringCommand)object3).getKey().getValue()[0] != 11) continue;
                    list2.remove(list2.size() - 1);
                    continue;
                }
                LOG.warn((Object)("CALLSUBR is ignored, operand: " + n + ", subrs.size(): " + list.size() + " in glyph '" + this.glyphName + "' of font " + this.fontName));
                while (list2.get(list2.size() - 1) instanceof Integer) {
                    list2.remove(list2.size() - 1);
                }
                continue;
            }
            if (n2 == 12 && dataInput.peekUnsignedByte(0) == 16) {
                dataInput.readByte();
                object2 = (Integer)list2.remove(list2.size() - 1);
                n = (Integer)list2.remove(list2.size() - 1);
                object = new Stack();
                switch ((Integer)object2) {
                    case 0: {
                        ((Stack)object).push(Type1CharStringParser.removeInteger(list2));
                        ((Stack)object).push(Type1CharStringParser.removeInteger(list2));
                        list2.remove(list2.size() - 1);
                        list2.add(0);
                        list2.add(new CharStringCommand(12, 16));
                        break;
                    }
                    case 1: {
                        list2.add(1);
                        list2.add(new CharStringCommand(12, 16));
                        break;
                    }
                    case 3: {
                        ((Stack)object).push(Type1CharStringParser.removeInteger(list2));
                        break;
                    }
                    default: {
                        for (int i = 0; i < n; ++i) {
                            ((Stack)object).push(Type1CharStringParser.removeInteger(list2));
                        }
                    }
                }
                while (dataInput.peekUnsignedByte(0) == 12 && dataInput.peekUnsignedByte(1) == 17) {
                    dataInput.readByte();
                    dataInput.readByte();
                    list2.add(((Stack)object).pop());
                }
                if (((Vector)object).size() <= 0) continue;
                LOG.warn((Object)("Value left on the PostScript stack in glyph " + this.glyphName + " of font " + this.fontName));
                continue;
            }
            if (n2 >= 0 && n2 <= 31) {
                list2.add(this.readCommand(dataInput, n2));
                continue;
            }
            if (n2 >= 32 && n2 <= 255) {
                list2.add(this.readNumber(dataInput, n2));
                continue;
            }
            throw new IllegalArgumentException();
        }
        return list2;
    }

    private static Integer removeInteger(List<Object> list) throws IOException {
        Object object = list.remove(list.size() - 1);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        CharStringCommand charStringCommand = (CharStringCommand)object;
        if (charStringCommand.getKey().getValue()[0] == 12 && charStringCommand.getKey().getValue()[1] == 12) {
            int n = (Integer)list.remove(list.size() - 1);
            int n2 = (Integer)list.remove(list.size() - 1);
            return n2 / n;
        }
        throw new IOException("Unexpected char string command: " + charStringCommand.getKey());
    }

    private CharStringCommand readCommand(DataInput dataInput, int n) throws IOException {
        if (n == 12) {
            int n2 = dataInput.readUnsignedByte();
            return new CharStringCommand(n, n2);
        }
        return new CharStringCommand(n);
    }

    private Integer readNumber(DataInput dataInput, int n) throws IOException {
        if (n >= 32 && n <= 246) {
            return n - 139;
        }
        if (n >= 247 && n <= 250) {
            int n2 = dataInput.readUnsignedByte();
            return (n - 247) * 256 + n2 + 108;
        }
        if (n >= 251 && n <= 254) {
            int n3 = dataInput.readUnsignedByte();
            return -(n - 251) * 256 - n3 - 108;
        }
        if (n == 255) {
            return dataInput.readInt();
        }
        throw new IllegalArgumentException();
    }
}

