/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cff;

import java.io.EOFException;
import java.io.IOException;
import org.apache.fontbox.util.Charsets;

public class DataInput {
    private byte[] inputBuffer = null;
    private int bufferPosition = 0;

    public DataInput(byte[] byArray) {
        this.inputBuffer = byArray;
    }

    public boolean hasRemaining() {
        return this.bufferPosition < this.inputBuffer.length;
    }

    public int getPosition() {
        return this.bufferPosition;
    }

    public void setPosition(int n) {
        this.bufferPosition = n;
    }

    public String getString() throws IOException {
        return new String(this.inputBuffer, Charsets.ISO_8859_1);
    }

    public byte readByte() throws IOException {
        try {
            byte by = this.inputBuffer[this.bufferPosition];
            ++this.bufferPosition;
            return by;
        }
        catch (RuntimeException runtimeException) {
            return -1;
        }
    }

    public int readUnsignedByte() throws IOException {
        int n = this.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    public int peekUnsignedByte(int n) throws IOException {
        int n2 = this.peek(n);
        if (n2 < 0) {
            throw new EOFException();
        }
        return n2;
    }

    public short readShort() throws IOException {
        return (short)this.readUnsignedShort();
    }

    public int readUnsignedShort() throws IOException {
        int n;
        int n2 = this.read();
        if ((n2 | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return n2 << 8 | n;
    }

    public int readInt() throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = this.read();
        if ((n4 | (n3 = this.read()) | (n2 = this.read()) | (n = this.read())) < 0) {
            throw new EOFException();
        }
        return n4 << 24 | n3 << 16 | n2 << 8 | n;
    }

    public byte[] readBytes(int n) throws IOException {
        if (this.inputBuffer.length - this.bufferPosition < n) {
            throw new EOFException();
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this.inputBuffer, this.bufferPosition, byArray, 0, n);
        this.bufferPosition += n;
        return byArray;
    }

    private int read() {
        try {
            int n = this.inputBuffer[this.bufferPosition] & 0xFF;
            ++this.bufferPosition;
            return n;
        }
        catch (RuntimeException runtimeException) {
            return -1;
        }
    }

    private int peek(int n) {
        try {
            int n2 = this.inputBuffer[this.bufferPosition + n] & 0xFF;
            return n2;
        }
        catch (RuntimeException runtimeException) {
            return -1;
        }
    }

    public int length() {
        return this.inputBuffer.length;
    }
}

