/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor.pattern;

import blue.soundObject.PatternObject;
import blue.soundObject.editor.pattern.PatternCanvas;
import blue.soundObject.editor.pattern.PatternsConstants;
import blue.soundObject.pattern.Pattern;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

class PatternCanvasMouseListener
implements MouseListener,
MouseMotionListener {
    PatternCanvas canvas;
    boolean isWrite = false;
    private PatternObject patternObj = null;

    public PatternCanvasMouseListener(PatternCanvas canvas) {
        this.canvas = canvas;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.processMousePressed(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.processMouseReleased(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.processMouseDragged(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    void processMousePressed(MouseEvent e) {
        int y;
        this.patternObj = this.canvas.getPatternObject();
        if (this.patternObj == null) {
            return;
        }
        int x = e.getX();
        this.isWrite = !this.getPatternValue(x, y = e.getY());
        this.setPatternValue(x, y, this.isWrite);
        this.canvas.repaint();
    }

    void processMouseDragged(MouseEvent e) {
        if (this.patternObj == null) {
            return;
        }
        this.setPatternValue(e.getX(), e.getY(), this.isWrite);
        this.canvas.repaint();
    }

    void processMouseReleased(MouseEvent e) {
    }

    public boolean getPatternValue(int x, int y) {
        if (this.patternObj == null) {
            return false;
        }
        int patternNum = y / PatternsConstants.patternViewHeight;
        if (patternNum >= this.patternObj.size() || patternNum < 0) {
            return false;
        }
        Pattern p = this.patternObj.getPattern(patternNum);
        int measureNum = x / PatternsConstants.patternViewHeight;
        if (measureNum >= p.values.length || measureNum < 0) {
            return false;
        }
        return p.values[measureNum];
    }

    public void setPatternValue(int x, int y, boolean val) {
        if (this.patternObj == null) {
            return;
        }
        int patternNum = y / PatternsConstants.patternViewHeight;
        if (patternNum >= this.patternObj.size() || patternNum < 0) {
            return;
        }
        Pattern p = this.patternObj.getPattern(patternNum);
        int measureNum = x / PatternsConstants.patternViewHeight;
        if (measureNum >= p.values.length || measureNum < 0) {
            return;
        }
        p.values[measureNum] = val;
    }
}

