/*
 * Decompiled with CFR 0.152.
 */
package blue.gui;

import blue.gui.LabelledRangeLabelFilter;
import blue.utility.GUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeListener;

public class LabelledRangeBar
extends JComponent {
    JLabel label = new JLabel();
    JSlider slider = new JSlider(0);
    JLabel display = new JLabel();
    LabelledRangeLabelFilter filter;

    public LabelledRangeBar(String labelText, int rangeStart, int rangeEnd) {
        this.setLayout(new BorderLayout());
        this.label.setText(labelText);
        this.label.setVerticalAlignment(1);
        this.slider.setMinimum(rangeStart);
        this.slider.setMaximum(rangeEnd);
        this.slider.setValue(rangeEnd);
        this.slider.addChangeListener(e -> {
            if (this.filter != null) {
                this.display.setText(this.filter.filter(this.slider.getValue()));
            } else {
                this.display.setText(Integer.toString(this.slider.getValue()));
            }
        });
        this.slider.setValue(0);
        this.display.setPreferredSize(new Dimension(50, 27));
        this.display.setVerticalAlignment(1);
        this.add((Component)this.label, "West");
        this.add((Component)this.slider, "Center");
        this.add((Component)this.display, "East");
        this.setBorder(BorderFactory.createEmptyBorder(3, 0, 3, 0));
    }

    public void addChangeListener(ChangeListener cListener) {
        this.slider.addChangeListener(cListener);
    }

    public int getValue() {
        return this.slider.getValue();
    }

    public void setValue(int val) {
        this.slider.setValue(val);
    }

    public void setFilter(LabelledRangeLabelFilter filter) {
        this.filter = filter;
    }

    public static void main(String[] args) {
        LabelledRangeBar labelledRangeBar1 = new LabelledRangeBar("Test: ", 0, 127);
        GUI.showComponentAsStandalone((Component)labelledRangeBar1, (String)"Labelled Range Bar Test", (boolean)true);
    }
}

