/*
 * Decompiled with CFR 0.152.
 */
package blue.score.layers.patterns.ui;

import blue.score.layers.LayerGroupDataEvent;
import blue.score.layers.LayerGroupListener;
import blue.score.layers.patterns.core.PatternLayer;
import blue.score.layers.patterns.core.PatternsLayerGroup;
import blue.score.layers.patterns.ui.PatternLayerPanel;
import blue.soundObject.SoundObject;
import blue.ui.utilities.LinearLayout;
import blue.ui.utilities.SelectionModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.lookup.InstanceContent;
import skt.swing.SwingUtil;

public class PatternsHeaderListPanel
extends JPanel
implements LayerGroupListener,
LookupListener {
    private final PatternsLayerGroup layerGroup;
    private SelectionModel selection = new SelectionModel();
    JPopupMenu menu;
    private InstanceContent content;
    Lookup.Result<SoundObject> result = null;

    public PatternsHeaderListPanel(PatternsLayerGroup patternsLayerGroup, InstanceContent ic) {
        this.content = ic;
        this.layerGroup = patternsLayerGroup;
        this.layerGroup.addLayerGroupListener((LayerGroupListener)this);
        this.setLayout((LayoutManager)new LinearLayout());
        this.setPreferredSize(new Dimension(30, 22 * patternsLayerGroup.size()));
        for (PatternLayer layer : patternsLayerGroup) {
            this.add(new PatternLayerPanel(layer, ic));
        }
        this.selection.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PatternsHeaderListPanel.this.updateSelection();
            }
        });
        LayerAddAction layerAddAction = new LayerAddAction();
        final LayerRemoveAction layerRemoveAction = new LayerRemoveAction();
        final PushUpAction pushUpAction = new PushUpAction();
        final PushDownAction pushDownAction = new PushDownAction();
        this.menu = new JPopupMenu("Layer Operations"){

            @Override
            public void show(Component invoker, int x, int y) {
                if (PatternsHeaderListPanel.this.layerGroup == null) {
                    return;
                }
                layerRemoveAction.setEnabled(PatternsHeaderListPanel.this.layerGroup.size() >= 2);
                pushUpAction.setEnabled(PatternsHeaderListPanel.this.selection.getStartIndex() >= 1);
                pushDownAction.setEnabled(PatternsHeaderListPanel.this.selection.getEndIndex() < PatternsHeaderListPanel.this.layerGroup.size() - 1);
                super.show(invoker, x, y);
            }
        };
        this.menu.add(layerAddAction);
        this.menu.add(layerRemoveAction);
        this.menu.add(pushUpAction);
        this.menu.add(pushDownAction);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                PatternsHeaderListPanel.this.requestFocus();
                if (me.isPopupTrigger()) {
                    Component c = PatternsHeaderListPanel.this.getComponentAt(me.getPoint());
                    int index = PatternsHeaderListPanel.this.getIndexOfComponent(c);
                    if (index > PatternsHeaderListPanel.this.selection.getEndIndex() || index < PatternsHeaderListPanel.this.selection.getStartIndex()) {
                        PatternsHeaderListPanel.this.selection.setAnchor(index);
                    }
                    PatternsHeaderListPanel.this.menu.show(me.getComponent(), me.getX(), me.getY());
                } else if (SwingUtilities.isLeftMouseButton(me)) {
                    Component c;
                    if (me.getClickCount() == 1) {
                        Component c2 = PatternsHeaderListPanel.this.getComponentAt(me.getPoint());
                        int index = PatternsHeaderListPanel.this.getIndexOfComponent(c2);
                        if (index < 0) {
                            return;
                        }
                        if (me.isShiftDown()) {
                            PatternsHeaderListPanel.this.selection.setEnd(index);
                            PatternsHeaderListPanel.this.content.set(Collections.emptyList(), null);
                        } else {
                            PatternsHeaderListPanel.this.selection.setAnchor(index);
                            ((PatternLayerPanel)c2).editSoundObject();
                            ((PatternLayerPanel)c2).setSelected(true);
                        }
                    } else if (me.getClickCount() == 2 && (c = SwingUtilities.getDeepestComponentAt(PatternsHeaderListPanel.this, me.getX(), me.getY())) != null && c instanceof JLabel) {
                        Component panel = PatternsHeaderListPanel.this.getComponentAt(me.getPoint());
                        ((PatternLayerPanel)panel).editName();
                    }
                }
            }
        });
        this.selection.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PatternsHeaderListPanel.this.updateSelection();
            }
        });
        this.initActions();
    }

    private void initActions() {
        SwingUtil.installActions((JComponent)this, (Action[])new Action[]{new ShiftUpAction(), new UpAction(), new ShiftDownAction(), new DownAction()}, (int)1);
    }

    private int getIndexOfComponent(Component c) {
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (comps[i] != c) continue;
            return i;
        }
        return -1;
    }

    private void updateSelection() {
        int start = this.selection.getStartIndex();
        int end = this.selection.getEndIndex();
        Component[] comps = this.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            PatternLayerPanel panel = (PatternLayerPanel)comps[i];
            panel.setSelected(i >= start && i <= end);
        }
    }

    public void checkSize() {
        if (this.layerGroup == null || this.getParent() == null) {
            this.setSize(0, 0);
            return;
        }
        int w = this.getParent().getWidth();
        int h = this.layerGroup.size() * 22;
        this.setSize(w, h);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.result = Utilities.actionsGlobalContext().lookupResult(SoundObject.class);
        this.result.addLookupListener((LookupListener)this);
        this.resultChanged(null);
    }

    @Override
    public void removeNotify() {
        if (this.layerGroup != null) {
            this.layerGroup.addLayerGroupListener((LayerGroupListener)this);
        }
        this.result.removeLookupListener((LookupListener)this);
    }

    public void layerGroupChanged(LayerGroupDataEvent event) {
        switch (event.getType()) {
            case 0: {
                this.layersAdded(event);
                break;
            }
            case 1: {
                this.layersRemoved(event);
                break;
            }
            case 2: {
                this.contentsChanged(event);
            }
        }
    }

    public void layersAdded(LayerGroupDataEvent e) {
        int index = e.getStartIndex();
        PatternLayer sLayer = (PatternLayer)this.layerGroup.get(index);
        PatternLayerPanel panel = new PatternLayerPanel(sLayer, this.content);
        this.add((Component)panel, index);
        this.checkSize();
    }

    public void layersRemoved(LayerGroupDataEvent e) {
        int end;
        int start = e.getStartIndex();
        for (int i = end = e.getEndIndex(); i >= start; --i) {
            this.remove(i);
        }
        this.checkSize();
        this.selection.setAnchor(-1);
    }

    public void contentsChanged(LayerGroupDataEvent e) {
        boolean isUp;
        int start = e.getStartIndex();
        int end = e.getEndIndex();
        boolean bl = isUp = start >= 0 && end >= 0;
        if (isUp) {
            Component c = this.getComponent(start);
            PatternLayerPanel panel = (PatternLayerPanel)c;
            this.remove(start);
            this.add(c, end);
            int i1 = this.selection.getStartIndex() - 1;
            int i2 = this.selection.getEndIndex() - 1;
            this.selection.setAnchor(i1);
            this.selection.setEnd(i2);
        } else {
            Component c = this.getComponent(-start);
            PatternLayerPanel panel = (PatternLayerPanel)c;
            this.remove(-start);
            this.add(c, -end);
            int i1 = this.selection.getStartIndex() + 1;
            int i2 = this.selection.getEndIndex() + 1;
            this.selection.setAnchor(i1);
            this.selection.setEnd(i2);
        }
        this.revalidate();
    }

    public void resultChanged(LookupEvent ev) {
        Collection allEvents = this.result.allInstances();
        boolean found = false;
        if (!allEvents.isEmpty()) {
            for (PatternLayer pLayer : this.layerGroup) {
                if (!allEvents.contains(pLayer.getSoundObject())) continue;
                found = true;
                break;
            }
        }
        if (!found) {
            this.selection.clear();
        }
    }

    class LayerRemoveAction
    extends AbstractAction {
        public LayerRemoveAction() {
            super("Remove Layers");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int start = PatternsHeaderListPanel.this.selection.getStartIndex();
            int end = PatternsHeaderListPanel.this.selection.getEndIndex();
            if (end < 0 || PatternsHeaderListPanel.this.layerGroup.size() < 2) {
                return;
            }
            int len = end - start + 1;
            String message = "Please confirm deleting these " + len + " layers.";
            if (JOptionPane.showConfirmDialog(null, message) == 0) {
                PatternsHeaderListPanel.this.layerGroup.removeLayers(start, end);
                PatternsHeaderListPanel.this.selection.setAnchor(-1);
            }
        }
    }

    class LayerAddAction
    extends AbstractAction {
        public LayerAddAction() {
            super("Add Layer");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int end = PatternsHeaderListPanel.this.selection.getEndIndex();
            if (end < 0) {
                return;
            }
            PatternsHeaderListPanel.this.layerGroup.newLayerAt(++end);
        }
    }

    class PushDownAction
    extends AbstractAction {
        public PushDownAction() {
            super("Push Down Layers");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int start = PatternsHeaderListPanel.this.selection.getStartIndex();
            int end = PatternsHeaderListPanel.this.selection.getEndIndex();
            if (end < 0 || end >= PatternsHeaderListPanel.this.layerGroup.size() - 1) {
                return;
            }
            PatternsHeaderListPanel.this.layerGroup.pushDownLayers(start, end);
            PatternsHeaderListPanel.this.selection.setAnchor(start + 1);
        }
    }

    class PushUpAction
    extends AbstractAction {
        public PushUpAction() {
            super("Push Up Layers");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int start = PatternsHeaderListPanel.this.selection.getStartIndex();
            int end = PatternsHeaderListPanel.this.selection.getEndIndex();
            if (end < 0 || start == 0) {
                return;
            }
            PatternsHeaderListPanel.this.layerGroup.pushUpLayers(start, end);
            PatternsHeaderListPanel.this.selection.setAnchor(start - 1);
        }
    }

    class ShiftDownAction
    extends AbstractAction {
        public ShiftDownAction() {
            super("shift-Down");
            this.putValue("ShortDescription", "Shift-Down Action");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(40, 64));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int length;
            int index = PatternsHeaderListPanel.this.selection.getLastIndexSet() + 1;
            index = index >= (length = PatternsHeaderListPanel.this.getComponents().length) ? length - 1 : index;
            PatternsHeaderListPanel.this.selection.setEnd(index);
            PatternsHeaderListPanel.this.content.set(Collections.emptyList(), null);
        }
    }

    class DownAction
    extends AbstractAction {
        public DownAction() {
            super("down");
            this.putValue("ShortDescription", "Down Action");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(40, 0));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int length;
            int index = PatternsHeaderListPanel.this.selection.getLastIndexSet() + 1;
            index = index >= (length = PatternsHeaderListPanel.this.getComponents().length) ? length - 1 : index;
            PatternsHeaderListPanel.this.selection.setAnchor(index);
            ((PatternLayerPanel)PatternsHeaderListPanel.this.getComponent(index)).editSoundObject();
        }
    }

    class ShiftUpAction
    extends AbstractAction {
        public ShiftUpAction() {
            super("shift-up");
            this.putValue("ShortDescription", "Shift-Up Action");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(38, 64));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int index = PatternsHeaderListPanel.this.selection.getLastIndexSet() - 1;
            index = index < 0 ? 0 : index;
            PatternsHeaderListPanel.this.selection.setEnd(index);
            PatternsHeaderListPanel.this.content.set(Collections.emptyList(), null);
        }
    }

    class UpAction
    extends AbstractAction {
        public UpAction() {
            super("up");
            this.putValue("ShortDescription", "Up Action");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(38, 0));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int index = PatternsHeaderListPanel.this.selection.getLastIndexSet() - 1;
            index = index < 0 ? 0 : index;
            PatternsHeaderListPanel.this.selection.setAnchor(index);
            ((PatternLayerPanel)PatternsHeaderListPanel.this.getComponent(index)).editSoundObject();
        }
    }
}

