/*
 * Decompiled with CFR 0.152.
 */
package blue.clojure.project;

import blue.BlueDataObject;
import electric.xml.Element;
import electric.xml.Elements;
import javafx.beans.property.SimpleStringProperty;

public class ClojureLibraryEntry
implements BlueDataObject {
    private SimpleStringProperty dependencyCoordinates = new SimpleStringProperty((Object)this, "coordinates", "org/library-name");
    private SimpleStringProperty version = new SimpleStringProperty((Object)this, "version", "1.0.0");

    public ClojureLibraryEntry() {
    }

    public ClojureLibraryEntry(ClojureLibraryEntry cle) {
        this.setDependencyCoordinates(cle.getDependencyCoordinates());
        this.setVersion(cle.getVersion());
    }

    public String getDependencyCoordinates() {
        return this.dependencyCoordinates.get();
    }

    public void setDependencyCoordinates(String coordinates) {
        this.dependencyCoordinates.set(coordinates);
    }

    public SimpleStringProperty dependencyCoordinates() {
        return this.dependencyCoordinates;
    }

    public String getVersion() {
        return this.version.get();
    }

    public void setVersion(String versionString) {
        this.version.set(versionString);
    }

    public SimpleStringProperty version() {
        return this.version;
    }

    public static ClojureLibraryEntry loadFromXML(Element data) {
        ClojureLibraryEntry lib = new ClojureLibraryEntry();
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            Element node = nodes.next();
            String nodeText = node.getTextString();
            switch (node.getName()) {
                case "coordinates": {
                    lib.setDependencyCoordinates(nodeText);
                    break;
                }
                case "version": {
                    lib.setVersion(nodeText);
                }
            }
        }
        return lib;
    }

    public Element saveAsXML() {
        Element elem = new Element("clojureLibraryEntry");
        elem.addElement("coordinates").setText(this.getDependencyCoordinates());
        elem.addElement("version").setText(this.getVersion());
        return elem;
    }

    public ClojureLibraryEntry deepCopy() {
        return new ClojureLibraryEntry(this);
    }
}

