/*
 * Decompiled with CFR 0.152.
 */
package jam.panels;

import jam.panels.RuleModel;
import jam.util.IconUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class RulesPanel
extends JPanel {
    private Icon addIcon = null;
    private Icon addRolloverIcon = null;
    private Icon addPressedIcon = null;
    private Icon removeIcon = null;
    private Icon removeRolloverIcon = null;
    private Icon removePressedIcon = null;
    AbstractAction removeAction = new AbstractAction("-"){

        @Override
        public void actionPerformed(ActionEvent ae) {
        }
    };
    private RuleModel ruleModel;
    private ArrayList rules = new ArrayList();

    public RulesPanel(RuleModel ruleModel) {
        this.ruleModel = ruleModel;
        try {
            this.addIcon = IconUtils.getIcon(RulesPanel.class, "images/plusminus/plus.png");
            this.addRolloverIcon = IconUtils.getIcon(RulesPanel.class, "images/plusminus/plusRollover.png");
            this.addPressedIcon = IconUtils.getIcon(RulesPanel.class, "images/plusminus/plusPressed.png");
            this.removeIcon = IconUtils.getIcon(RulesPanel.class, "images/plusminus/minus.png");
            this.removeRolloverIcon = IconUtils.getIcon(RulesPanel.class, "images/plusminus/minusRollover.png");
            this.removePressedIcon = IconUtils.getIcon(RulesPanel.class, "images/plusminus/minusPressed.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        BoxLayout layout = new BoxLayout(this, 3);
        this.setLayout(layout);
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.setOpaque(false);
        this.addRule(null);
        Dimension dim = super.getPreferredSize();
        dim.height = (int)((double)dim.height + this.getComponent(0).getPreferredSize().getHeight());
        this.setMinimumSize(dim);
        this.setPreferredSize(dim);
    }

    public List getRules() {
        return Collections.unmodifiableList(this.rules);
    }

    private void addRule(Rule previousRule) {
        DefaultRule rule = new DefaultRule();
        RulePanel rulePanel = new RulePanel(rule);
        if (previousRule != null) {
            int index = this.rules.indexOf(previousRule);
            this.add((Component)rulePanel, index + 1);
            this.rules.add(index + 1, rule);
        } else {
            this.add((Component)rulePanel, 0);
            this.rules.add(0, rule);
        }
        this.removeAction.setEnabled(this.rules.size() > 1);
        this.validate();
        this.repaint();
    }

    private void removeRule(Rule rule) {
        int index = this.rules.indexOf(rule);
        this.remove(index);
        this.rules.remove(index);
        this.removeAction.setEnabled(this.rules.size() > 1);
        this.validate();
        this.repaint();
    }

    class DefaultRule
    implements Rule {
        JComboBox fieldCombo;
        JComboBox conditionCombo;
        JTextField valueText;

        DefaultRule() {
        }

        @Override
        public Object getField() {
            return this.fieldCombo.getSelectedItem();
        }

        @Override
        public Object getCondition() {
            return this.conditionCombo.getSelectedItem();
        }

        @Override
        public Object getValue() {
            return this.valueText.getText();
        }
    }

    public static interface Rule {
        public Object getField();

        public Object getCondition();

        public Object getValue();
    }

    class RulePanel
    extends JPanel {
        RulePanel(final DefaultRule rule) {
            this.setLayout(new GridBagLayout());
            this.setOpaque(true);
            this.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.lightGray));
            this.setBackground(new Color(0.0f, 0.0f, 0.0f, 0.05f));
            rule.fieldCombo = new JComboBox<Object>(RulesPanel.this.ruleModel.getFields());
            rule.conditionCombo = new JComboBox<Object>(RulesPanel.this.ruleModel.getConditions(rule.getField()));
            rule.fieldCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent ie) {
                    rule.conditionCombo.setModel(new DefaultComboBoxModel<Object>(RulesPanel.this.ruleModel.getConditions(rule.getField())));
                }
            });
            rule.valueText = new JTextField("");
            rule.valueText.setColumns(12);
            JButton addButton = new JButton("+");
            addButton.putClientProperty("JButton.buttonType", "toolbar");
            addButton.setOpaque(false);
            if (RulesPanel.this.addIcon != null) {
                addButton.setIcon(RulesPanel.this.addIcon);
                addButton.setPressedIcon(RulesPanel.this.addPressedIcon);
                addButton.setRolloverIcon(RulesPanel.this.addRolloverIcon);
                addButton.setRolloverEnabled(true);
                addButton.setText(null);
            }
            addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    RulesPanel.this.addRule(rule);
                }
            });
            addButton.setEnabled(true);
            JButton removeButton = new JButton(RulesPanel.this.removeAction);
            removeButton.putClientProperty("JButton.buttonType", "toolbar");
            removeButton.setOpaque(false);
            if (RulesPanel.this.removeIcon != null) {
                removeButton.setIcon(RulesPanel.this.removeIcon);
                removeButton.setPressedIcon(RulesPanel.this.removePressedIcon);
                removeButton.setRolloverIcon(RulesPanel.this.removeRolloverIcon);
                removeButton.setRolloverEnabled(true);
                removeButton.setText(null);
            }
            removeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    RulesPanel.this.removeRule(rule);
                }
            });
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 0;
            c.weightx = 0.0;
            c.weighty = 0.0;
            c.anchor = 10;
            c.insets = new Insets(1, 2, 0, 2);
            c.gridx = -1;
            this.add((Component)rule.fieldCombo, c);
            this.add((Component)rule.conditionCombo, c);
            c.weightx = 1.0;
            c.fill = 2;
            this.add((Component)rule.valueText, c);
            c.fill = 0;
            c.weightx = 0.0;
            this.add((Component)addButton, c);
            this.add((Component)removeButton, c);
        }
    }
}

