/*
 * Decompiled with CFR 0.152.
 */
package beast.util;

import beast.math.GammaFunction;
import beast.math.statistic.DiscreteStatistics;
import beast.util.Randomizer;
import java.io.FileNotFoundException;
import java.io.Serializable;

public class MersenneTwisterFast
implements Serializable {
    private static final long serialVersionUID = 6185086957226269797L;
    private static final int N = 624;
    private static final int M = 397;
    private static final int MATRIX_A = -1727483681;
    private static final int UPPER_MASK = Integer.MIN_VALUE;
    private static final int LOWER_MASK = Integer.MAX_VALUE;
    private static final int TEMPERING_MASK_B = -1658038656;
    private static final int TEMPERING_MASK_C = -272236544;
    private int[] mt;
    private int mti;
    private int[] mag01;
    private static final long GOOD_SEED = 4357L;
    private double nextNextGaussian;
    private boolean haveNextNextGaussian;
    public static final MersenneTwisterFast DEFAULT_INSTANCE = new MersenneTwisterFast();
    private static long seedAdditive_ = 0L;
    private long initializationSeed;

    private MersenneTwisterFast() {
        this(System.currentTimeMillis() + seedAdditive_);
        seedAdditive_ += (long)this.nextInt();
    }

    private MersenneTwisterFast(long l) {
        if (l == 0L) {
            this.setSeed(4357L);
        } else {
            this.setSeed(l);
        }
    }

    public final void setSeed(long l) {
        if (l == 0L) {
            throw new IllegalArgumentException("Non zero random seed required.");
        }
        this.initializationSeed = l;
        this.haveNextNextGaussian = false;
        this.mt = new int[624];
        this.mt[0] = (int)l;
        this.mti = 1;
        while (this.mti < 624) {
            this.mt[this.mti] = 69069 * this.mt[this.mti - 1];
            ++this.mti;
        }
        this.mag01 = new int[2];
        this.mag01[0] = 0;
        this.mag01[1] = -1727483681;
    }

    public final long getSeed() {
        return this.initializationSeed;
    }

    private synchronized int next() {
        if (this.mti >= 624) {
            int n;
            int n2;
            for (n2 = 0; n2 < 227; ++n2) {
                n = this.mt[n2] & Integer.MIN_VALUE | this.mt[n2 + 1] & Integer.MAX_VALUE;
                this.mt[n2] = this.mt[n2 + 397] ^ n >>> 1 ^ this.mag01[n & 1];
            }
            while (n2 < 623) {
                n = this.mt[n2] & Integer.MIN_VALUE | this.mt[n2 + 1] & Integer.MAX_VALUE;
                this.mt[n2] = this.mt[n2 + -227] ^ n >>> 1 ^ this.mag01[n & 1];
                ++n2;
            }
            n = this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE;
            this.mt[623] = this.mt[396] ^ n >>> 1 ^ this.mag01[n & 1];
            this.mti = 0;
        }
        return this.mt[this.mti++];
    }

    public final int nextInt() {
        int n = this.next();
        n ^= n >>> 11;
        n ^= n << 7 & 0x9D2C5680;
        n ^= n << 15 & 0xEFC60000;
        n ^= n >>> 18;
        return n;
    }

    public final short nextShort() {
        int n = this.next();
        n ^= n >>> 11;
        n ^= n << 7 & 0x9D2C5680;
        n ^= n << 15 & 0xEFC60000;
        n ^= n >>> 18;
        return (short)(n >>> 16);
    }

    public final char nextChar() {
        int n = this.next();
        n ^= n >>> 11;
        n ^= n << 7 & 0x9D2C5680;
        n ^= n << 15 & 0xEFC60000;
        n ^= n >>> 18;
        return (char)(n >>> 16);
    }

    public final boolean nextBoolean() {
        int n = this.next();
        n ^= n >>> 11;
        n ^= n << 7 & 0x9D2C5680;
        n ^= n << 15 & 0xEFC60000;
        return (n ^= n >>> 18) >>> 31 != 0;
    }

    public final byte nextByte() {
        int n = this.next();
        n ^= n >>> 11;
        n ^= n << 7 & 0x9D2C5680;
        n ^= n << 15 & 0xEFC60000;
        n ^= n >>> 18;
        return (byte)(n >>> 24);
    }

    public final void nextBytes(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            int n = this.next();
            n ^= n >>> 11;
            n ^= n << 7 & 0x9D2C5680;
            n ^= n << 15 & 0xEFC60000;
            n ^= n >>> 18;
            byArray[i] = (byte)(n >>> 24);
        }
    }

    public final long nextLong() {
        int n = this.next();
        n ^= n >>> 11;
        n ^= n << 7 & 0x9D2C5680;
        n ^= n << 15 & 0xEFC60000;
        n ^= n >>> 18;
        int n2 = this.next();
        n2 ^= n2 >>> 11;
        n2 ^= n2 << 7 & 0x9D2C5680;
        n2 ^= n2 << 15 & 0xEFC60000;
        n2 ^= n2 >>> 18;
        return ((long)n << 32) + (long)n2;
    }

    public final double nextDouble() {
        int n = this.next();
        n ^= n >>> 11;
        n ^= n << 7 & 0x9D2C5680;
        n ^= n << 15 & 0xEFC60000;
        n ^= n >>> 18;
        int n2 = this.next();
        n2 ^= n2 >>> 11;
        n2 ^= n2 << 7 & 0x9D2C5680;
        n2 ^= n2 << 15 & 0xEFC60000;
        n2 ^= n2 >>> 18;
        return (double)(((long)(n >>> 6) << 27) + (long)(n2 >>> 5)) / 9.007199254740992E15;
    }

    public final double nextGaussian() {
        int n;
        int n2;
        double d;
        int n3;
        int n4;
        double d2;
        double d3;
        if (this.haveNextNextGaussian) {
            this.haveNextNextGaussian = false;
            return this.nextNextGaussian;
        }
        do {
            n4 = this.next();
            n4 ^= n4 >>> 11;
            n4 ^= n4 << 7 & 0x9D2C5680;
            n4 ^= n4 << 15 & 0xEFC60000;
            n4 ^= n4 >>> 18;
            n3 = this.next();
            n3 ^= n3 >>> 11;
            n3 ^= n3 << 7 & 0x9D2C5680;
            n3 ^= n3 << 15 & 0xEFC60000;
            n3 ^= n3 >>> 18;
            n2 = this.next();
            n2 ^= n2 >>> 11;
            n2 ^= n2 << 7 & 0x9D2C5680;
            n2 ^= n2 << 15 & 0xEFC60000;
            n2 ^= n2 >>> 18;
            n = this.next();
            n ^= n >>> 11;
            n ^= n << 7 & 0x9D2C5680;
            n ^= n << 15 & 0xEFC60000;
        } while ((d3 = (d2 = 2.0 * ((double)(((long)(n4 >>> 6) << 27) + (long)(n3 >>> 5)) / 9.007199254740992E15) - 1.0) * d2 + (d = 2.0 * ((double)(((long)(n2 >>> 6) << 27) + (long)((n ^= n >>> 18) >>> 5)) / 9.007199254740992E15) - 1.0) * d) >= 1.0);
        double d4 = Math.sqrt(-2.0 * Math.log(d3) / d3);
        this.nextNextGaussian = d * d4;
        this.haveNextNextGaussian = true;
        return d2 * d4;
    }

    public final float nextFloat() {
        int n = this.next();
        n ^= n >>> 11;
        n ^= n << 7 & 0x9D2C5680;
        n ^= n << 15 & 0xEFC60000;
        n ^= n >>> 18;
        return (float)(n >>> 8) / 1.6777216E7f;
    }

    public int nextInt(int n) {
        int n2;
        int n3;
        int n4;
        if (n <= 0) {
            throw new IllegalArgumentException("n must be positive");
        }
        if ((n & -n) == n) {
            int n5 = this.next();
            n5 ^= n5 >>> 11;
            n5 ^= n5 << 7 & 0x9D2C5680;
            n5 ^= n5 << 15 & 0xEFC60000;
            n5 ^= n5 >>> 18;
            return (int)((long)n * (long)(n5 >>> 1) >> 31);
        }
        do {
            n3 = this.next();
            n3 ^= n3 >>> 11;
            n3 ^= n3 << 7 & 0x9D2C5680;
            n3 ^= n3 << 15 & 0xEFC60000;
        } while ((n4 = (n3 ^= n3 >>> 18) >>> 1) - (n2 = n4 % n) + (n - 1) < 0);
        return n2;
    }

    public final void permute(int[] nArray) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = this.nextInt(n - i) + i;
            int n3 = nArray[n2];
            nArray[n2] = nArray[i];
            nArray[i] = n3;
        }
    }

    public final void shuffle(int[] nArray) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = this.nextInt(n - i) + i;
            int n3 = nArray[n2];
            nArray[n2] = nArray[i];
            nArray[i] = n3;
        }
    }

    public final void shuffle(int[] nArray, int n) {
        int n2 = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n3;
            int n4;
            while ((n4 = this.nextInt(n2)) != (n3 = this.nextInt(n2))) {
            }
            int n5 = nArray[n3];
            nArray[n3] = nArray[n4];
            nArray[n4] = n5;
        }
    }

    public int[] shuffled(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = i;
        }
        this.shuffle(nArray);
        return nArray;
    }

    public int[] permuted(int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = i;
        }
        this.permute(nArray);
        return nArray;
    }

    public double nextGamma(double d, double d2) {
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        double d10;
        double d11 = d;
        double d12 = -1.0;
        double d13 = -1.0;
        double d14 = 0.0;
        double d15 = 0.0;
        double d16 = 0.0;
        double d17 = 0.0;
        double d18 = 0.0;
        double d19 = 0.0;
        double d20 = 0.0;
        double d21 = 0.0416666664;
        double d22 = 0.0208333723;
        double d23 = 0.0079849875;
        double d24 = 0.0015746717;
        double d25 = -3.349403E-4;
        double d26 = 3.340332E-4;
        double d27 = 6.053049E-4;
        double d28 = -4.701849E-4;
        double d29 = 1.71032E-4;
        double d30 = 0.333333333;
        double d31 = -0.249999949;
        double d32 = 0.199999867;
        double d33 = -0.166677482;
        double d34 = 0.142873973;
        double d35 = -0.124385581;
        double d36 = 0.11036831;
        double d37 = -0.112750886;
        double d38 = 0.104089866;
        double d39 = 1.0;
        double d40 = 0.499999994;
        double d41 = 0.166666848;
        double d42 = 0.041664508;
        double d43 = 0.008345522;
        double d44 = 0.001353826;
        double d45 = 2.47453E-4;
        if (d11 <= 0.0) {
            throw new IllegalArgumentException();
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException();
        }
        if (d11 < 1.0) {
            double d46;
            d14 = 1.0 + 0.36788794412 * d11;
            while (true) {
                double d47;
                if ((d47 = d14 * this.nextDouble()) <= 1.0) {
                    d46 = Math.exp(Math.log(d47) / d11);
                    if (!(Math.log(this.nextDouble()) <= -d46)) continue;
                    return d46 / d2;
                }
                d46 = -Math.log((d14 - d47) / d11);
                if (Math.log(this.nextDouble()) <= (d11 - 1.0) * Math.log(d46)) break;
            }
            return d46 / d2;
        }
        if (d11 != d12) {
            d12 = d11;
            d19 = d11 - 0.5;
            d17 = Math.sqrt(d19);
            d16 = 5.656854249 - 12.0 * d17;
        }
        while ((d10 = (d9 = 2.0 * this.nextDouble() - 1.0) * d9 + (d8 = 2.0 * this.nextDouble() - 1.0) * d8) > 1.0) {
        }
        double d48 = d9 * Math.sqrt(-2.0 * Math.log(d10) / d10);
        double d49 = d17 + 0.5 * d48;
        double d50 = d49 * d49;
        if (d48 >= 0.0) {
            return d50 / d2;
        }
        double d51 = this.nextDouble();
        if (d16 * d51 <= d48 * d48 * d48) {
            return d50 / d2;
        }
        if (d11 != d13) {
            d13 = d11;
            double d52 = 1.0 / d11;
            d20 = ((((((((d29 * d52 + d28) * d52 + d27) * d52 + d26) * d52 + d25) * d52 + d24) * d52 + d23) * d52 + d22) * d52 + d21) * d52;
            if (d11 > 3.686) {
                if (d11 > 13.022) {
                    d14 = 1.77;
                    d18 = 0.75;
                    d15 = 0.1515 / d17;
                } else {
                    d14 = 1.654 + 0.0076 * d19;
                    d18 = 1.68 / d17 + 0.275;
                    d15 = 0.062 / d17 + 0.024;
                }
            } else {
                d14 = 0.463 + d17 - 0.178 * d19;
                d18 = 1.235;
                d15 = 0.195 / d17 - 0.079 + 0.016 * d17;
            }
        }
        if (d49 > 0.0) {
            d7 = d48 / (d17 + d17);
            d6 = Math.abs(d7) > 0.25 ? d20 - d17 * d48 + 0.25 * d48 * d48 + (d19 + d19) * Math.log(1.0 + d7) : d20 + 0.5 * d48 * d48 * ((((((((d38 * d7 + d37) * d7 + d36) * d7 + d35) * d7 + d34) * d7 + d33) * d7 + d32) * d7 + d31) * d7 + d30) * d7;
            if (Math.log(1.0 - d51) <= d6) {
                return d50 / d2;
            }
        }
        do {
            d5 = -Math.log(this.nextDouble());
            d51 = this.nextDouble();
        } while ((d48 = d14 + d5 * d18 * (d4 = (d51 = d51 + d51 - 1.0) > 0.0 ? 1.0 : -1.0)) <= -0.71874483771719 || (d6 = Math.abs(d7 = d48 / (d17 + d17)) > 0.25 ? d20 - d17 * d48 + 0.25 * d48 * d48 + (d19 + d19) * Math.log(1.0 + d7) : d20 + 0.5 * d48 * d48 * ((((((((d38 * d7 + d37) * d7 + d36) * d7 + d35) * d7 + d34) * d7 + d33) * d7 + d32) * d7 + d31) * d7 + d30) * d7) <= 0.0 || !(d15 * d51 * d4 <= (d3 = d6 > 0.5 ? Math.exp(d6) - 1.0 : ((((((d45 * d6 + d44) * d6 + d43) * d6 + d42) * d6 + d41) * d6 + d40) * d6 + d39) * d6) * Math.exp(d5 - 0.5 * d48 * d48)));
        d49 = d17 + 0.5 * d48;
        return d49 * d49 / d2;
    }

    private long poissonian_reject(double d) {
        double d2;
        double d3 = Math.sqrt(2.0 * d);
        double d4 = Math.log(d);
        double d5 = d * d4 - GammaFunction.lnGamma(d + 1.0);
        while (true) {
            double d6;
            if ((d2 = d3 * (d6 = Math.tan(Math.PI * this.nextDouble())) + d) < 0.0) {
                continue;
            }
            d2 = Math.floor(d2);
            double d7 = 0.9 * (1.0 + d6 * d6) * Math.exp(d2 * d4 - GammaFunction.lnGamma(d2 + 1.0) - d5);
            if (!(this.nextDouble() > d7)) break;
        }
        return Math.round(d2);
    }

    private long poissonian_icdf(double d) {
        double d2;
        double d3 = this.nextDouble();
        int n = 0;
        for (double d4 = d2 = Math.exp(-d); d3 > d4 && n < 500; d4 += (d2 *= d / (double)(++n))) {
        }
        return n;
    }

    public long nextPoisson(double d) {
        if (d < 12.0) {
            return this.poissonian_icdf(d);
        }
        return this.poissonian_reject(d);
    }

    public static void main(String[] stringArray) throws FileNotFoundException {
        double d = 1.0E14;
        int n = 100000;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            double d2;
            dArray[i] = d2 = (double)Randomizer.nextPoisson(d);
        }
        System.out.format("E[x]=%g\n", DiscreteStatistics.mean(dArray));
        System.out.format("Var[x]=%g\n", DiscreteStatistics.variance(dArray));
    }
}

