/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.tree.coalescent;

import beast.core.Description;
import beast.core.Input;
import beast.core.parameter.RealParameter;
import beast.evolution.tree.coalescent.PopulationFunction;
import java.util.Collections;
import java.util.List;

@Description(value="Coalescent intervals for a exponentially growing population.")
public class ExponentialGrowth
extends PopulationFunction.Abstract {
    public final Input<RealParameter> popSizeParameterInput = new Input("popSize", "present-day population size (defaults to 1.0). ");
    public final Input<RealParameter> growthRateParameterInput = new Input("growthRate", "Growth rate is the exponent of the exponential growth. A value of zero represents a constant population size, negative values represent decline towards the present, positive numbers represents exponential growth towards the present.");

    @Override
    public void initAndValidate() {
        if (this.popSizeParameterInput.get() != null) {
            this.popSizeParameterInput.get().setBounds(Math.max(0.0, (Double)this.popSizeParameterInput.get().getLower()), this.popSizeParameterInput.get().getUpper());
        }
    }

    public double getN0() {
        return this.popSizeParameterInput.get().getValue();
    }

    public final double getGrowthRate() {
        return this.growthRateParameterInput.get().getValue();
    }

    @Override
    public double getPopSize(double d) {
        double d2 = this.getGrowthRate();
        if (d2 == 0.0) {
            return this.getN0();
        }
        return this.getN0() * Math.exp(-d * d2);
    }

    @Override
    public double getIntegral(double d, double d2) {
        double d3 = this.getGrowthRate();
        if (d3 == 0.0) {
            return (d2 - d) / this.getN0();
        }
        return (Math.exp(d2 * d3) - Math.exp(d * d3)) / this.getN0() / d3;
    }

    @Override
    public double getIntensity(double d) {
        double d2 = this.getGrowthRate();
        if (d2 == 0.0) {
            return d / this.getN0();
        }
        return (Math.exp(d * d2) - 1.0) / this.getN0() / d2;
    }

    @Override
    public double getInverseIntensity(double d) {
        double d2 = this.getGrowthRate();
        if (d2 == 0.0) {
            return this.getN0() * d;
        }
        return Math.log(1.0 + this.getN0() * d * d2) / d2;
    }

    @Override
    public List<String> getParameterIds() {
        return Collections.singletonList(this.popSizeParameterInput.get().getID());
    }
}

