/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.substitutionmodel;

import beast.core.Citation;
import beast.core.Description;
import beast.core.Input;
import beast.core.parameter.RealParameter;
import beast.evolution.datatype.DataType;
import beast.evolution.datatype.Nucleotide;
import beast.evolution.substitutionmodel.EigenDecomposition;
import beast.evolution.substitutionmodel.SubstitutionModel;
import beast.evolution.tree.Node;

@Description(value="TN93 (Tamura and Nei, 1993) substitution model of nucleotide evolution.")
@Citation(value="Tamura, K., & Nei, M. (1993). Estimation of the number of nucleotide substitutions in the control region of mitochondrial DNA in humans and chimpanzees. Molecular Biology and Evolution, 10(3), 512-526.", DOI="", year=1994, firstAuthorSurname="tamura")
public class TN93
extends SubstitutionModel.NucleotideBase {
    public final Input<RealParameter> kappa1Variable = new Input("kappa1", "rate of A<->G transitions", Input.Validate.REQUIRED);
    public final Input<RealParameter> kappa2Variable = new Input("kappa2", "rate of C<->T transitions", Input.Validate.REQUIRED);
    private boolean updateIntermediates = true;
    private double p1a;
    private double p0a;
    private double p3b;
    private double p2b;
    private double a;
    private double b;
    private double p1aa;
    private double p0aa;
    private double p3bb;
    private double p2bb;
    private double p1aIsa;
    private double p0aIsa;
    private double p3bIsb;
    private double p2bIsb;
    private double k1g;
    private double k1a;
    private double k2t;
    private double k2c;
    private double subrateScale;
    public static final int STATE_COUNT = 4;
    private EigenDecomposition eigenDecomposition = null;
    private EigenDecomposition storedEigenDecomposition = null;
    private boolean updateEigen = true;
    protected double beta;

    @Override
    public void initAndValidate() {
        super.initAndValidate();
        this.kappa1Variable.get().setBounds(Math.max(0.0, (Double)this.kappa1Variable.get().getLower()), this.kappa1Variable.get().getUpper());
        this.kappa2Variable.get().setBounds(Math.max(0.0, (Double)this.kappa2Variable.get().getLower()), this.kappa2Variable.get().getUpper());
        this.nrOfStates = 4;
        this.updateIntermediates = true;
    }

    public final double getKappa1() {
        return (Double)this.kappa1Variable.get().getValue(0);
    }

    public final double getKappa2() {
        return (Double)this.kappa2Variable.get().getValue(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getTransitionProbabilities(Node node, double d, double d2, double d3, double[] dArray) {
        double d4 = (d - d2) * d3;
        Object object = this;
        synchronized (object) {
            if (this.updateIntermediates) {
                this.calculateIntermediates();
            }
        }
        d4 /= this.subrateScale;
        object = new double[]{0.0, this.k1g, this.freqC, this.freqT, this.k1a, 0.0, this.freqC, this.freqT, this.freqA, this.freqG, 0.0, this.k2t, this.freqA, this.freqG, this.k2c, 0.0};
        object[0] = -(object[1] + object[2] + object[3]);
        object[5] = -(object[4] + object[6] + object[7]);
        object[10] = -(object[8] + object[9] + object[11]);
        object[15] = -(object[12] + object[13] + object[14]);
        double[] dArray2 = new double[]{1.0 + object[0] - this.p1aa, (double)(object[1] + this.p1aa), (double)object[2], (double)object[3], (double)(object[4] + this.p0aa), 1.0 + object[5] - this.p0aa, (double)object[6], (double)object[7], (double)object[8], (double)object[9], 1.0 + object[10] - this.p3bb, (double)(object[11] + this.p3bb), (double)object[12], (double)object[13], (double)(object[14] + this.p2bb), 1.0 + object[15] - this.p2bb};
        double[] dArray3 = new double[]{(double)(-object[0] + this.p1aIsa), (double)(-object[1] - this.p1aIsa), (double)(-object[2]), (double)(-object[3]), (double)(-object[4] - this.p0aIsa), (double)(-object[5] + this.p0aIsa), (double)(-object[6]), (double)(-object[7]), (double)(-object[8]), (double)(-object[9]), (double)(-object[10] + this.p3bIsb), (double)(-object[11] - this.p3bIsb), (double)(-object[12]), (double)(-object[13]), (double)(-object[14] - this.p2bIsb), (double)(-object[15] + this.p2bIsb)};
        double d5 = Math.exp(-d4);
        for (int i = 0; i < 16; ++i) {
            dArray3[i] = dArray3[i] * d5 + dArray2[i];
        }
        double d6 = Math.exp(d4 * this.a);
        double d7 = Math.exp(d4 * this.b);
        double d8 = d6 / (this.a * (1.0 + this.a));
        double d9 = d7 / (this.b * (1.0 + this.b));
        double d10 = this.p1a * d8;
        double d11 = this.p0a * d8;
        double d12 = this.p3b * d9;
        double d13 = this.p2b * d9;
        dArray3[0] = dArray3[0] + d10;
        dArray3[1] = dArray3[1] - d10;
        dArray3[4] = dArray3[4] - d11;
        dArray3[5] = dArray3[5] + d11;
        dArray3[10] = dArray3[10] + d12;
        dArray3[11] = dArray3[11] - d12;
        dArray3[14] = dArray3[14] - d13;
        dArray3[15] = dArray3[15] + d13;
        dArray[0] = dArray3[0];
        dArray[1] = dArray3[2];
        dArray[2] = dArray3[1];
        dArray[3] = dArray3[3];
        dArray[4] = dArray3[8];
        dArray[5] = dArray3[10];
        dArray[6] = dArray3[9];
        dArray[7] = dArray3[11];
        dArray[8] = dArray3[4];
        dArray[9] = dArray3[6];
        dArray[10] = dArray3[5];
        dArray[11] = dArray3[7];
        dArray[12] = dArray3[12];
        dArray[13] = dArray3[14];
        dArray[14] = dArray3[13];
        dArray[15] = dArray3[15];
    }

    @Override
    public EigenDecomposition getEigenDecomposition(Node node) {
        double[] dArray;
        double[] dArray2;
        double[] dArray3;
        if (this.eigenDecomposition == null) {
            dArray3 = new double[16];
            dArray2 = new double[16];
            dArray = new double[4];
            this.eigenDecomposition = new EigenDecomposition(dArray3, dArray2, dArray);
            dArray2[9] = 1.0;
            dArray2[11] = -1.0;
            dArray2[12] = 1.0;
            dArray2[14] = -1.0;
            dArray3[0] = 1.0;
            dArray3[4] = 1.0;
            dArray3[8] = 1.0;
            dArray3[12] = 1.0;
            this.updateEigen = true;
        }
        if (this.updateEigen) {
            dArray3 = this.eigenDecomposition.getEigenVectors();
            dArray2 = this.eigenDecomposition.getInverseEigenVectors();
            dArray = this.frequencies.getFreqs();
            double d = dArray[0] + dArray[2];
            double d2 = dArray[1] + dArray[3];
            dArray2[0] = dArray[0];
            dArray2[1] = dArray[1];
            dArray2[2] = dArray[2];
            dArray2[3] = dArray[3];
            dArray2[4] = dArray[0] * d2;
            dArray2[5] = -dArray[1] * d;
            dArray2[6] = dArray[2] * d2;
            dArray2[7] = -dArray[3] * d;
            dArray3[1] = 1.0 / d;
            dArray3[5] = -1.0 / d2;
            dArray3[9] = 1.0 / d;
            dArray3[13] = -1.0 / d2;
            dArray3[6] = dArray[3] / d2;
            dArray3[14] = -dArray[1] / d2;
            dArray3[3] = dArray[2] / d;
            dArray3[11] = -dArray[0] / d;
            double[] dArray4 = this.eigenDecomposition.getEigenValues();
            double d3 = this.getKappa1();
            double d4 = this.getKappa2();
            double d5 = -1.0 / (2.0 * (d * d2 + d3 * dArray[0] * dArray[2] + d4 * dArray[1] * dArray[3]));
            double d6 = 1.0 + d * (d3 - 1.0);
            double d7 = 1.0 + d2 * (d4 - 1.0);
            dArray4[1] = d5;
            dArray4[2] = d5 * d7;
            dArray4[3] = d5 * d6;
            this.updateEigen = false;
        }
        return this.eigenDecomposition;
    }

    private void calculateIntermediates() {
        this.calculateFreqRY();
        double d = this.getKappa1();
        double d2 = this.getKappa2();
        if (d == 1.0) {
            d += 1.0E-10;
        }
        if (d2 == 1.0) {
            d2 += 1.0E-10;
        }
        double d3 = d * d * this.freqR + d * (2.0 * this.freqY - 1.0) - this.freqY;
        double d4 = d2 * d2 * this.freqY + d2 * (2.0 * this.freqR - 1.0) - this.freqR;
        this.p1a = this.freqG * d3;
        this.p0a = this.freqA * d3;
        this.p3b = this.freqT * d4;
        this.p2b = this.freqC * d4;
        this.a = -(d * this.freqR + this.freqY);
        this.b = -(d2 * this.freqY + this.freqR);
        this.p1aa = this.p1a / this.a;
        this.p0aa = this.p0a / this.a;
        this.p3bb = this.p3b / this.b;
        this.p2bb = this.p2b / this.b;
        this.p1aIsa = this.p1a / (1.0 + this.a);
        this.p0aIsa = this.p0a / (1.0 + this.a);
        this.p3bIsb = this.p3b / (1.0 + this.b);
        this.p2bIsb = this.p2b / (1.0 + this.b);
        this.k1g = d * this.freqG;
        this.k1a = d * this.freqA;
        this.k2t = d2 * this.freqT;
        this.k2c = d2 * this.freqC;
        this.subrateScale = 2.0 * (d * this.freqA * this.freqG + d2 * this.freqC * this.freqT + this.freqR * this.freqY);
        this.updateIntermediates = false;
    }

    @Override
    protected boolean requiresRecalculation() {
        this.updateEigen = true;
        this.updateIntermediates = true;
        return true;
    }

    @Override
    protected void store() {
        if (this.eigenDecomposition != null) {
            this.storedEigenDecomposition = this.eigenDecomposition.copy();
        }
        super.store();
    }

    @Override
    protected void restore() {
        this.updateEigen = true;
        this.updateIntermediates = true;
        if (this.storedEigenDecomposition != null) {
            this.eigenDecomposition = this.storedEigenDecomposition;
        }
        super.restore();
    }

    @Override
    public boolean canHandleDataType(DataType dataType) {
        return dataType instanceof Nucleotide;
    }
}

