/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.speciation;

public class CalibrationLineagesIterator {
    final int[][] taxaPartialOrder;
    final int[] cladesFreeLins;
    private final boolean rootCalibrated;
    private int curIters;
    private final LinsIterator[] iters;
    private int[][] vals;
    private int freeLineages;
    private final int[] maximalClades;

    /*
     * WARNING - void declaration
     */
    CalibrationLineagesIterator(int[][] nArray, int[][] nArray2, boolean[] blArray, int n) {
        void var6_9;
        int n2;
        this.cladesFreeLins = new int[nArray.length];
        for (n2 = 0; n2 < this.cladesFreeLins.length; ++n2) {
            this.cladesFreeLins[n2] = nArray[n2].length;
            for (int n3 : nArray2[n2]) {
                int n4 = n2;
                this.cladesFreeLins[n4] = this.cladesFreeLins[n4] - nArray[n3].length;
            }
            assert (this.cladesFreeLins[n2] >= 0);
        }
        this.taxaPartialOrder = nArray2;
        this.iters = new LinsIterator[nArray.length + 1];
        this.vals = new int[this.iters.length][];
        n2 = 0;
        for (int n3 : blArray) {
            n2 += n3 != 0 ? 1 : 0;
        }
        this.maximalClades = new int[n2];
        this.freeLineages = n;
        n2 = 0;
        boolean bl = false;
        while (var6_9 < blArray.length) {
            if (blArray[var6_9]) {
                this.maximalClades[n2] = var6_9;
                ++n2;
                this.freeLineages -= nArray[var6_9].length;
            }
            ++var6_9;
        }
        boolean bl2 = this.rootCalibrated = n2 == 1 && nArray[this.maximalClades[0]].length == n;
        assert (!this.rootCalibrated || this.freeLineages <= 0);
        assert (this.freeLineages >= 0);
    }

    boolean isRootCalibrated() {
        return this.rootCalibrated;
    }

    int setup(int[] nArray) {
        int n;
        int n2 = this.cladesFreeLins.length;
        this.curIters = 0;
        for (n = 0; n < n2; ++n) {
            this.setOneIterator(nArray, this.taxaPartialOrder[n], this.cladesFreeLins[n], nArray[n]);
        }
        if (!this.rootCalibrated) {
            this.setOneIterator(nArray, this.maximalClades, this.freeLineages, n2 + 1);
        }
        for (n = 0; n < this.curIters - 1; ++n) {
            this.vals[n] = this.iters[n].next();
        }
        return this.curIters;
    }

    private void setOneIterator(int[] nArray, int[] nArray2, int n, int n2) {
        LinsIterator linsIterator;
        int n3 = nArray2.length;
        if (n3 == 0) {
            linsIterator = new LinsIterator(n, n2, null);
        } else {
            int[] nArray3 = new int[n3];
            for (int i = 0; i < n3; ++i) {
                nArray3[i] = nArray[nArray2[i]];
            }
            linsIterator = new LinsIterator(n, n2, nArray3);
        }
        this.iters[((LinsIterator)linsIterator).rank - 1] = linsIterator;
        linsIterator.startIter();
        ++this.curIters;
    }

    int[][] next() {
        int n;
        int[] nArray = this.iters[this.curIters - 1].next();
        if (nArray != null) {
            this.vals[this.curIters - 1] = nArray;
            return this.vals;
        }
        for (n = this.curIters - 2; n >= 0 && (this.vals[n] = this.iters[n].next()) == null; --n) {
        }
        if (n < 0) {
            return null;
        }
        ++n;
        while (n < this.curIters) {
            this.iters[n].startIter();
            this.vals[n] = this.iters[n].next();
            ++n;
        }
        return this.vals;
    }

    public int[][] allJoiners() {
        int[][] nArrayArray = new int[this.curIters][];
        for (int i = 0; i < this.curIters; ++i) {
            nArrayArray[i] = this.iters[i].ljoins();
        }
        return nArrayArray;
    }

    public int start(int n) {
        return this.iters[n].start;
    }

    class LinsIterator {
        private final int rank;
        private final int start;
        private final int[] joiners;
        private final int[] aStart;
        private final int[] lins;
        private int lastJoinger;
        private boolean stopIter;

        LinsIterator(int n, int n2, int[] nArray) {
            int n3;
            this.rank = n2;
            this.start = n;
            this.joiners = new int[n2];
            this.lastJoinger = -1;
            this.aStart = new int[2 + this.rank - 1];
            this.lins = new int[2 + this.rank - 1];
            for (n3 = 0; n3 < this.rank; ++n3) {
                this.joiners[n3] = 0;
            }
            if (nArray != null) {
                for (int n4 : nArray) {
                    this.joiners[n4] = 1;
                    if (this.lastJoinger >= n4) continue;
                    this.lastJoinger = n4;
                }
            }
            this.aStart[0] = n;
            if (this.lastJoinger <= 0) {
                for (n3 = 1; n3 < this.rank + 1; ++n3) {
                    this.aStart[n3] = 2;
                }
                if (this.rank > 1) {
                    int n5 = this.rank - 1;
                    this.aStart[n5] = this.aStart[n5] - 1;
                }
            } else {
                if (this.start > 0) {
                    for (n3 = 1; n3 < this.lastJoinger + 1; ++n3) {
                        this.aStart[n3] = 1;
                    }
                    while (n3 < this.rank + 1) {
                        this.aStart[n3] = 2;
                        ++n3;
                    }
                } else {
                    int n6;
                    assert (nArray != null);
                    n3 = nArray[0];
                    for (int n7 : nArray) {
                        n3 = Math.min(n3, n7);
                    }
                    for (n6 = 1; n6 < n3 + 1; ++n6) {
                        this.aStart[n6] = 0;
                    }
                    while (n6 < this.lastJoinger + 1) {
                        this.aStart[n6] = 1;
                        ++n6;
                    }
                    while (n6 < this.rank + 1) {
                        this.aStart[n6] = 2;
                        ++n6;
                    }
                }
                int n8 = this.rank - 1;
                this.aStart[n8] = this.aStart[n8] - 1;
            }
        }

        void startIter() {
            for (int i = 0; i < this.rank + 1; ++i) {
                this.lins[i] = this.aStart[i];
            }
            this.stopIter = false;
        }

        final int[] next() {
            int n;
            if (this.lastJoinger <= 0) {
                for (n = this.rank - 1; n >= 1 && this.lins[n] == this.lins[n - 1]; --n) {
                }
                if (n == 0) {
                    if (this.rank == 1 && !this.stopIter) {
                        this.stopIter = true;
                        return this.lins;
                    }
                    return null;
                }
                int n2 = n++;
                this.lins[n2] = this.lins[n2] + 1;
                while (n < this.rank) {
                    this.lins[n] = 2;
                    ++n;
                }
            } else {
                while (n >= 1 && this.lins[n] == this.lins[n - 1] + this.joiners[n - 1]) {
                    --n;
                }
                if (n == 0) {
                    return null;
                }
                int n3 = n++;
                this.lins[n3] = this.lins[n3] + 1;
                while (n < this.rank) {
                    this.lins[n] = n <= this.lastJoinger ? 1 : 2;
                    ++n;
                }
            }
            return this.lins;
        }

        final int[] ljoins() {
            return this.joiners;
        }
    }
}

