/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.sitemodel;

import beast.core.Description;
import beast.core.Input;
import beast.core.parameter.RealParameter;
import beast.core.util.Log;
import beast.evolution.sitemodel.SiteModelInterface;
import beast.evolution.substitutionmodel.SubstitutionModel;
import beast.evolution.tree.Node;
import org.apache.commons.math.distribution.GammaDistributionImpl;

@Description(value="Defines mutation rate and gamma distributed rates across sites (optional) and proportion of the sites invariant (also optional).")
public class SiteModel
extends SiteModelInterface.Base {
    public final Input<RealParameter> muParameterInput = new Input("mutationRate", "mutation rate (defaults to 1.0)");
    public final Input<Integer> gammaCategoryCount = new Input<Integer>("gammaCategoryCount", "gamma category count (default=zero for no gamma)", 0);
    public final Input<RealParameter> shapeParameterInput = new Input("shape", "shape parameter of gamma distribution. Ignored if gammaCategoryCount 1 or less");
    public final Input<RealParameter> invarParameterInput = new Input("proportionInvariant", "proportion of sites that is invariant: should be between 0 (default) and 1");
    RealParameter muParameter;
    RealParameter shapeParameter;
    RealParameter invarParameter;
    boolean useBeast1StyleGamma;
    protected boolean ratesKnown;
    protected int categoryCount;
    protected double[] categoryRates;
    protected double[] categoryProportions;

    @Override
    public void initAndValidate() {
        this.useBeast1StyleGamma = true;
        this.muParameter = this.muParameterInput.get();
        if (this.muParameter == null) {
            this.muParameter = new RealParameter("1.0");
        }
        this.shapeParameter = this.shapeParameterInput.get();
        this.invarParameter = this.invarParameterInput.get();
        if (this.invarParameter == null) {
            this.invarParameter = new RealParameter("0.0");
            this.invarParameter.setBounds(Math.max(0.0, (Double)this.invarParameter.getLower()), Math.min(1.0, (Double)this.invarParameter.getUpper()));
        }
        this.muParameter.setBounds(Math.max((Double)this.muParameter.getLower(), 0.0), Math.min((Double)this.muParameter.getUpper(), Double.POSITIVE_INFINITY));
        if (this.shapeParameter != null) {
            this.shapeParameter.setBounds(Math.max((Double)this.shapeParameter.getLower(), 0.001), Math.min((Double)this.shapeParameter.getUpper(), 1000.0));
        }
        if (this.invarParameter.getValue() < 0.0 || this.invarParameter.getValue() > 1.0) {
            throw new IllegalArgumentException("proportion invariant should be between 0 and 1");
        }
        this.refresh();
        this.addCondition(this.muParameterInput);
        this.addCondition(this.invarParameterInput);
        this.addCondition(this.shapeParameterInput);
    }

    @Override
    protected void refresh() {
        if (this.shapeParameter != null) {
            this.categoryCount = this.gammaCategoryCount.get();
            if (this.categoryCount < 1) {
                if (this.categoryCount < 0) {
                    Log.warning.println("SiteModel: Invalid category count (" + this.categoryCount + ") Setting category count to 1");
                }
                this.categoryCount = 1;
            }
        } else {
            this.categoryCount = 1;
        }
        if (this.invarParameter.getValue() > 0.0) {
            if (this.invarParameter.getValue() >= 1.0) {
                throw new RuntimeException("Wrong value for parameter " + this.invarParameter.getID() + ". Proportion invariant should be in bewteen 0 and 1 (exclusive)");
            }
            if (this.hasPropInvariantCategory) {
                ++this.categoryCount;
            }
        }
        this.categoryRates = new double[this.categoryCount];
        this.categoryProportions = new double[this.categoryCount];
        this.calculateCategoryRates(null);
    }

    @Override
    public boolean integrateAcrossCategories() {
        return true;
    }

    @Override
    public int getCategoryCount() {
        return this.categoryCount;
    }

    @Override
    public int getCategoryOfSite(int n, Node node) {
        throw new IllegalArgumentException("Integrating across categories");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getRateForCategory(int n, Node node) {
        SiteModel siteModel = this;
        synchronized (siteModel) {
            if (!this.ratesKnown) {
                this.calculateCategoryRates(node);
            }
        }
        return this.categoryRates[n] * this.muParameter.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double[] getCategoryRates(Node node) {
        SiteModel siteModel = this;
        synchronized (siteModel) {
            if (!this.ratesKnown) {
                this.calculateCategoryRates(node);
            }
        }
        double d = this.muParameter.getValue();
        double[] dArray = new double[this.categoryRates.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = this.categoryRates[i] * d;
        }
        return dArray;
    }

    @Override
    public SubstitutionModel getSubstitutionModel() {
        return (SubstitutionModel)this.substModelInput.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getProportionForCategory(int n, Node node) {
        SiteModel siteModel = this;
        synchronized (siteModel) {
            if (!this.ratesKnown) {
                this.calculateCategoryRates(node);
            }
        }
        return this.categoryProportions[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double[] getCategoryProportions(Node node) {
        SiteModel siteModel = this;
        synchronized (siteModel) {
            if (!this.ratesKnown) {
                this.calculateCategoryRates(node);
            }
        }
        return this.categoryProportions;
    }

    protected void calculateCategoryRates(Node node) {
        double d = 1.0;
        int n = 0;
        if (this.invarParameter.getValue() > 0.0) {
            if (this.hasPropInvariantCategory) {
                this.categoryRates[0] = 0.0;
                this.categoryProportions[0] = this.invarParameter.getValue();
            }
            d = 1.0 - this.invarParameter.getValue();
            if (this.hasPropInvariantCategory) {
                n = 1;
            }
        }
        if (this.shapeParameter != null) {
            int n2;
            double d2 = this.shapeParameter.getValue();
            double d3 = 0.0;
            int n3 = this.categoryCount - n;
            GammaDistributionImpl gammaDistributionImpl = new GammaDistributionImpl(d2, 1.0 / d2);
            for (n2 = 0; n2 < n3; ++n2) {
                try {
                    this.categoryRates[n2 + n] = this.useBeast1StyleGamma ? this.GammaDistributionQuantile((2.0 * (double)n2 + 1.0) / (2.0 * (double)n3), d2, 1.0 / d2) : gammaDistributionImpl.inverseCumulativeProbability((2.0 * (double)n2 + 1.0) / (2.0 * (double)n3));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    Log.err.println("Something went wrong with the gamma distribution calculation");
                    System.exit(-1);
                }
                d3 += this.categoryRates[n2 + n];
                this.categoryProportions[n2 + n] = d / (double)n3;
            }
            d3 = d * d3 / (double)n3;
            for (n2 = 0; n2 < n3; ++n2) {
                int n4 = n2 + n;
                this.categoryRates[n4] = this.categoryRates[n4] / d3;
            }
        } else {
            this.categoryRates[n] = 1.0 / d;
            this.categoryProportions[n] = d;
        }
        this.ratesKnown = true;
    }

    @Override
    public void store() {
        super.store();
    }

    @Override
    public void restore() {
        super.restore();
        this.ratesKnown = false;
    }

    @Override
    protected boolean requiresRecalculation() {
        if (this.categoryCount > 1) {
            if (this.shapeParameter != null && this.shapeParameter.somethingIsDirty() || this.muParameter.somethingIsDirty() || this.invarParameter.somethingIsDirty()) {
                this.ratesKnown = false;
            }
        } else if (this.muParameter.somethingIsDirty() || !this.hasPropInvariantCategory && this.invarParameter.somethingIsDirty()) {
            this.ratesKnown = false;
        }
        return true;
    }

    protected double GammaDistributionQuantile(double d, double d2, double d3) {
        return 0.5 * d3 * this.pointChi2(d, 2.0 * d2);
    }

    double pointChi2(double d, double d2) {
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        double d10;
        double d11;
        double d12;
        double d13;
        double d14;
        double d15;
        double d16 = 5.0E-7;
        double d17 = 0.6931471805;
        if (d < 2.0E-6 || d > 0.999998 || d2 <= 0.0) {
            throw new IllegalArgumentException("Error SiteModel 102: Arguments out of range");
        }
        double d18 = this.GammaFunctionlnGamma(d2 / 2.0);
        double d19 = d2 / 2.0;
        double d20 = d19 - 1.0;
        if (d2 < -1.24 * Math.log(d)) {
            d15 = Math.pow(d * d19 * Math.exp(d18 + d19 * d17), 1.0 / d19);
            if (d15 - d16 < 0.0) {
                return d15;
            }
        } else if (d2 > 0.32) {
            double d21 = this.NormalDistributionQuantile(d, 0.0, 1.0);
            d15 = d2 * Math.pow(d21 * Math.sqrt(d14 = 0.222222 / d2) + 1.0 - d14, 3.0);
            if (d15 > 2.2 * d2 + 6.0) {
                d15 = -2.0 * (Math.log(1.0 - d) - d20 * Math.log(0.5 * d15) + d18);
            }
        } else {
            d15 = 0.4;
            d13 = Math.log(1.0 - d);
            do {
                d12 = d15;
                d14 = 1.0 + d15 * (4.67 + d15);
                d11 = d15 * (6.73 + d15 * (6.66 + d15));
                d10 = -0.5 + (4.67 + 2.0 * d15) / d14 - (6.73 + d15 * (13.32 + 3.0 * d15)) / d11;
            } while (Math.abs(d12 / (d15 -= (1.0 - Math.exp(d13 + d18 + 0.5 * d15 + d20 * d17) * d11 / d14) / d10) - 1.0) - 0.01 > 0.0);
        }
        do {
            double d22;
            d12 = d15;
            d14 = 0.5 * d15;
            d10 = this.GammaFunctionincompleteGammaP(d19, d14, d18);
            if (!(d22 < 0.0)) continue;
            throw new IllegalArgumentException("Error SiteModel 101: Arguments out of range: t < 0");
        } while (Math.abs(d12 / (d15 += (d10 = (d11 = d - d10) * Math.exp(d19 * d17 + d18 + d14 - d20 * Math.log(d15))) * (1.0 + 0.5 * d10 * (d9 = (210.0 + (d13 = 0.5 * d10 - (d8 = d10 / d15) * d20) * (140.0 + d13 * (105.0 + d13 * (84.0 + d13 * (70.0 + 60.0 * d13))))) / 420.0) - d8 * d20 * (d9 - d8 * ((d7 = (420.0 + d13 * (735.0 + d13 * (966.0 + d13 * (1141.0 + 1278.0 * d13)))) / 2520.0) - d8 * ((d6 = (210.0 + d13 * (462.0 + d13 * (707.0 + 932.0 * d13))) / 2520.0) - d8 * ((d5 = (252.0 + d13 * (672.0 + 1182.0 * d13) + d20 * (294.0 + d13 * (889.0 + 1740.0 * d13))) / 5040.0) - d8 * ((d4 = (84.0 + 264.0 * d13 + d20 * (175.0 + 606.0 * d13)) / 2520.0) - d8 * (d3 = (120.0 + d20 * (346.0 + 127.0 * d20)) / 5040.0)))))))) - 1.0) > d16);
        return d15;
    }

    double GammaFunctionlnGamma(double d) {
        double d2;
        double d3 = d;
        double d4 = 0.0;
        if (d3 < 7.0) {
            d4 = 1.0;
            d2 = d3 - 1.0;
            while (true) {
                double d5;
                d2 += 1.0;
                if (!(d5 < 7.0)) break;
                d4 *= d2;
            }
            d3 = d2;
            d4 = -Math.log(d4);
        }
        d2 = 1.0 / (d3 * d3);
        return d4 + (d3 - 0.5) * Math.log(d3) - d3 + 0.918938533204673 + (((-5.95238095238E-4 * d2 + 7.93650793651E-4) * d2 - 0.002777777777778) * d2 + 0.083333333333333) / d3;
    }

    double GammaFunctionincompleteGammaP(double d, double d2, double d3) {
        return this.incompleteGamma(d2, d, d3);
    }

    double incompleteGamma(double d, double d2, double d3) {
        double d4;
        double d5 = 1.0E-8;
        double d6 = 1.0E30;
        if (d == 0.0) {
            return 0.0;
        }
        if (d < 0.0 || d2 <= 0.0) {
            throw new IllegalArgumentException("Error SiteModel 103: Arguments out of bounds");
        }
        double d7 = Math.exp(d2 * Math.log(d) - d - d3);
        if (d > 1.0 && d >= d2) {
            double d8 = 1.0 - d2;
            double d9 = d8 + d + 1.0;
            double d10 = 0.0;
            double d11 = 1.0;
            double d12 = d;
            double d13 = d + 1.0;
            double d14 = d * d9;
            d4 = d13 / d14;
            while (true) {
                double d15 = (d8 += 1.0) * (d10 += 1.0);
                double d16 = (d9 += 2.0) * d13 - d15 * d11;
                double d17 = d9 * d14 - d15 * d12;
                if (d17 != 0.0) {
                    double d18 = d16 / d17;
                    double d19 = Math.abs(d4 - d18);
                    if (d19 <= d5 && d19 <= d5 * d18) break;
                    d4 = d18;
                }
                d11 = d13;
                d12 = d14;
                d13 = d16;
                d14 = d17;
                if (!(Math.abs(d16) >= d6)) continue;
                d11 /= d6;
                d12 /= d6;
                d13 /= d6;
                d14 /= d6;
            }
            d4 = 1.0 - d7 * d4;
        } else {
            d4 = 1.0;
            double d20 = 1.0;
            double d21 = d2;
            do {
                d4 += (d20 *= d / (d21 += 1.0));
            } while (d20 > d5);
            d4 *= d7 / d2;
        }
        return d4;
    }

    double NormalDistributionQuantile(double d, double d2, double d3) {
        return d2 + Math.sqrt(2.0) * d3 * this.ErrorFunctionInverseErf(2.0 * d - 1.0);
    }

    double ErrorFunctionInverseErf(double d) {
        return this.ErrorFunctionPointNormal(0.5 * d + 0.5) / Math.sqrt(2.0);
    }

    double ErrorFunctionPointNormal(double d) {
        double d2;
        double d3 = -0.322232431088;
        double d4 = -1.0;
        double d5 = -0.342242088547;
        double d6 = -0.0204231210245;
        double d7 = -4.53642210148E-5;
        double d8 = 0.099348462606;
        double d9 = 0.588581570495;
        double d10 = 0.531103462366;
        double d11 = 0.10353775285;
        double d12 = 0.0038560700634;
        double d13 = d2 = d < 0.5 ? d : 1.0 - d;
        if (d2 < 1.0E-20) {
            throw new IllegalArgumentException("Error SiteModel 104: Argument prob out of range");
        }
        double d14 = Math.sqrt(Math.log(1.0 / (d2 * d2)));
        double d15 = d14 + ((((d14 * d7 + d6) * d14 + d5) * d14 + d4) * d14 + d3) / ((((d14 * d12 + d11) * d14 + d10) * d14 + d9) * d14 + d8);
        return d < 0.5 ? -d15 : d15;
    }

    @Override
    public double getProportionInvariant() {
        return this.invarParameter.getValue();
    }
}

