/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.operators;

import beast.core.Description;
import beast.core.Input;
import beast.evolution.operators.TreeOperator;
import beast.evolution.tree.Node;
import beast.evolution.tree.Tree;
import beast.util.Randomizer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

@Description(value="Moves the height of an internal node along the branch. If it moves up, it can exceed the root and become a new root. If it moves down, it may need to make a choice which branch to slide down into.")
public class SubtreeSlide
extends TreeOperator {
    public final Input<Double> sizeInput = new Input<Double>("size", "size of the slide, default 1.0", 1.0);
    public final Input<Boolean> gaussianInput = new Input<Boolean>("gaussian", "Gaussian (=true=default) or uniform delta", true);
    public final Input<Boolean> optimiseInput = new Input<Boolean>("optimise", "flag to indicate that the scale factor is automatically changed in order to achieve a good acceptance rate (default true)", true);
    public final Input<Double> limitInput = new Input<Double>("limit", "limit on step size, default disable, i.e. -1. (when positive, gets multiplied by tree-height/log2(n-taxa).", -1.0);
    double size;
    private double limit;

    @Override
    public void initAndValidate() {
        this.size = this.sizeInput.get();
        this.limit = this.limitInput.get();
    }

    @Override
    public double proposal() {
        double d;
        Node node;
        Tree tree = (Tree)this.treeInput.get(this);
        boolean bl = (Boolean)this.markCladesInput.get();
        int n = tree.getNodeCount();
        while ((node = tree.getNode(Randomizer.nextInt(n))).isRoot()) {
        }
        Node node2 = node.getParent();
        Node node3 = this.getOtherChild(node2, node);
        Node node4 = node2.getParent();
        double d2 = this.getDelta();
        double d3 = node2.getHeight();
        double d4 = d3 + d2;
        if (d2 > 0.0) {
            if (node4 != null && node4.getHeight() < d4) {
                Node node5 = node4;
                Node node6 = node2;
                while (node5.getHeight() < d4) {
                    node6 = node5;
                    if (bl) {
                        node5.makeDirty(2);
                    }
                    if ((node5 = node5.getParent()) != null) continue;
                }
                if (node6.isRoot()) {
                    this.replace(node2, node3, node6);
                    this.replace(node4, node2, node3);
                    node2.setParent(null);
                    tree.setRoot(node2);
                } else {
                    this.replace(node2, node3, node6);
                    this.replace(node4, node2, node3);
                    this.replace(node5, node6, node2);
                }
                node2.setHeight(d4);
                int n2 = this.intersectingEdges(node6, d3, null);
                d = -Math.log(n2);
            } else {
                node2.setHeight(d4);
                d = 0.0;
            }
        } else {
            if (node.getHeight() > d4) {
                return Double.NEGATIVE_INFINITY;
            }
            if (node3.getHeight() > d4) {
                ArrayList<Node> arrayList = new ArrayList<Node>();
                int n3 = this.intersectingEdges(node3, d4, arrayList);
                if (arrayList.size() == 0) {
                    return Double.NEGATIVE_INFINITY;
                }
                int n4 = Randomizer.nextInt(arrayList.size());
                Node node7 = (Node)arrayList.get(n4);
                Node node8 = node7.getParent();
                if (node2.isRoot()) {
                    this.replace(node2, node3, node7);
                    this.replace(node8, node7, node2);
                    node3.setParent(null);
                    tree.setRoot(node3);
                } else {
                    this.replace(node2, node3, node7);
                    this.replace(node4, node2, node3);
                    this.replace(node8, node7, node2);
                }
                node2.setHeight(d4);
                if (bl) {
                    for (Node node9 = node2; node9 != node3; node9 = node9.getParent()) {
                        node9.makeDirty(2);
                    }
                }
                d = Math.log(n3);
            } else {
                node2.setHeight(d4);
                d = 0.0;
            }
        }
        return d;
    }

    private double getDelta() {
        if (!this.gaussianInput.get().booleanValue()) {
            return Randomizer.nextDouble() * this.size - this.size / 2.0;
        }
        return Randomizer.nextGaussian() * this.size;
    }

    private int intersectingEdges(Node node, double d, List<Node> list) {
        Node node2 = node.getParent();
        if (node2.getHeight() < d) {
            return 0;
        }
        if (node.getHeight() < d) {
            if (list != null) {
                list.add(node);
            }
            return 1;
        }
        if (node.isLeaf()) {
            return 0;
        }
        int n = this.intersectingEdges(node.getLeft(), d, list) + this.intersectingEdges(node.getRight(), d, list);
        return n;
    }

    @Override
    public void optimize(double d) {
        if (this.optimiseInput.get().booleanValue()) {
            double d2 = this.calcDelta(d);
            double d3 = Math.exp(d2 += Math.log(this.size));
            if (this.limit > 0.0) {
                double d4;
                Tree tree = (Tree)this.treeInput.get();
                double d5 = tree.getRoot().getHeight();
                double d6 = d5 / (d4 = Math.log(tree.getLeafNodeCount()) / Math.log(2.0)) * this.limit;
                if (d3 <= d6) {
                    this.size = d3;
                }
            } else {
                this.size = d3;
            }
        }
    }

    @Override
    public double getCoercableParameterValue() {
        return this.size;
    }

    @Override
    public void setCoercableParameterValue(double d) {
        this.size = d;
    }

    @Override
    public String getPerformanceSuggestion() {
        double d = (double)this.m_nNrAccepted / ((double)(this.m_nNrAccepted + this.m_nNrRejected) + 0.0);
        double d2 = this.getTargetAcceptanceProbability();
        double d3 = d / d2;
        if (d3 > 2.0) {
            d3 = 2.0;
        }
        if (d3 < 0.5) {
            d3 = 0.5;
        }
        double d4 = this.size * d3;
        DecimalFormat decimalFormat = new DecimalFormat("#.###");
        if (d < 0.1) {
            return "Try decreasing size to about " + decimalFormat.format(d4);
        }
        if (d > 0.4) {
            return "Try increasing size to about " + decimalFormat.format(d4);
        }
        return "";
    }
}

