/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.operators;

import beast.core.Description;
import beast.core.Input;
import beast.core.Operator;
import beast.core.parameter.BooleanParameter;
import beast.core.parameter.RealParameter;
import beast.evolution.tree.Node;
import beast.evolution.tree.Tree;
import beast.util.Randomizer;
import java.text.DecimalFormat;

@Description(value="Scales a parameter or a complete beast.tree (depending on which of the two is specified.")
public class ScaleOperator
extends Operator {
    public final Input<Tree> treeInput = new Input("tree", "if specified, all beast.tree divergence times are scaled");
    public final Input<RealParameter> parameterInput = new Input("parameter", "if specified, this parameter is scaled", Input.Validate.XOR, this.treeInput);
    public final Input<Double> scaleFactorInput = new Input<Double>("scaleFactor", "scaling factor: larger means more bold proposals", 1.0);
    public final Input<Boolean> scaleAllInput = new Input<Boolean>("scaleAll", "if true, all elements of a parameter (not beast.tree) are scaled, otherwise one is randomly selected", false);
    public final Input<Boolean> scaleAllIndependentlyInput = new Input<Boolean>("scaleAllIndependently", "if true, all elements of a parameter (not beast.tree) are scaled with a different factor, otherwise a single factor is used", false);
    public final Input<Integer> degreesOfFreedomInput = new Input<Integer>("degreesOfFreedom", "Degrees of freedom used when scaleAllIndependently=false and scaleAll=true to override default in calculation of Hasting ratio. Ignored when less than 1, default 0.", 0);
    public final Input<BooleanParameter> indicatorInput = new Input("indicator", "indicates which of the dimension of the parameters can be scaled. Only used when scaleAllIndependently=false and scaleAll=false. If not specified it is assumed all dimensions are allowed to be scaled.");
    public final Input<Boolean> rootOnlyInput = new Input<Boolean>("rootOnly", "scale root of a tree only, ignored if tree is not specified (default false)", false);
    public final Input<Boolean> optimiseInput = new Input<Boolean>("optimise", "flag to indicate that the scale factor is automatically changed in order to achieve a good acceptance rate (default true)", true);
    public final Input<Double> scaleUpperLimit = new Input<Double>("upper", "Upper Limit of scale factor", 0.99999999);
    public final Input<Double> scaleLowerLimit = new Input<Double>("lower", "Lower limit of scale factor", 1.0E-8);
    private double m_fScaleFactor;
    private double upper;
    private double lower;
    boolean m_bIsTreeScaler = true;

    @Override
    public void initAndValidate() {
        this.m_fScaleFactor = this.scaleFactorInput.get();
        this.m_bIsTreeScaler = this.treeInput.get() != null;
        this.upper = this.scaleUpperLimit.get();
        this.lower = this.scaleLowerLimit.get();
        BooleanParameter booleanParameter = this.indicatorInput.get();
        if (booleanParameter != null) {
            if (this.m_bIsTreeScaler) {
                throw new IllegalArgumentException("indicator is specified which has no effect for scaling a tree");
            }
            int n = this.parameterInput.get().getDimension();
            int n2 = booleanParameter.getDimension();
            if (n2 != n && n2 + 1 != n) {
                throw new IllegalArgumentException("indicator dimension not compatible from parameter dimension");
            }
        }
    }

    protected boolean outsideBounds(double d, RealParameter realParameter) {
        Double d2 = (Double)realParameter.getLower();
        Double d3 = (Double)realParameter.getUpper();
        return d < d2 || d > d3;
    }

    protected double getScaler() {
        return this.m_fScaleFactor + Randomizer.nextDouble() * (1.0 / this.m_fScaleFactor - this.m_fScaleFactor);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public double proposal() {
        try {
            double d;
            double d2 = this.getScaler();
            if (this.m_bIsTreeScaler) {
                Tree tree = this.treeInput.get(this);
                if (this.rootOnlyInput.get().booleanValue()) {
                    Node node = tree.getRoot();
                    double d3 = node.getHeight() * d2;
                    if (d3 < Math.max(node.getLeft().getHeight(), node.getRight().getHeight())) {
                        return Double.NEGATIVE_INFINITY;
                    }
                    node.setHeight(d3);
                    return -Math.log(d2);
                }
                int n = tree.scale(d2);
                return Math.log(d2) * (double)(n - 2);
            }
            boolean bl = this.scaleAllInput.get();
            int n = this.degreesOfFreedomInput.get();
            boolean bl2 = this.scaleAllIndependentlyInput.get();
            RealParameter realParameter = this.parameterInput.get(this);
            assert (realParameter.getLower() != null && realParameter.getUpper() != null);
            int n2 = realParameter.getDimension();
            if (bl2) {
                d = 0.0;
                BooleanParameter booleanParameter = this.indicatorInput.get();
                if (booleanParameter != null) {
                    int n3 = booleanParameter.getDimension();
                    Boolean[] booleanArray = (Boolean[])booleanParameter.getValues();
                    boolean bl3 = n3 == n2 - 1;
                    for (int i = 0; i < n2; ++i) {
                        if ((!bl3 || i != 0 && !booleanArray[i - 1].booleanValue()) && (bl3 || !booleanArray[i].booleanValue())) continue;
                        double d4 = this.getScaler();
                        double d5 = d4 * (Double)realParameter.getValue(i);
                        d -= Math.log(d4);
                        if (this.outsideBounds(d5, realParameter)) {
                            return Double.NEGATIVE_INFINITY;
                        }
                        realParameter.setValue(i, d5);
                    }
                    return d;
                } else {
                    for (int i = 0; i < n2; ++i) {
                        double d6 = this.getScaler();
                        double d7 = d6 * (Double)realParameter.getValue(i);
                        d -= Math.log(d6);
                        if (this.outsideBounds(d7, realParameter)) {
                            return Double.NEGATIVE_INFINITY;
                        }
                        realParameter.setValue(i, d7);
                    }
                }
                return d;
            } else if (bl) {
                int n4 = n > 0 ? n - 2 : n2 - 2;
                d = (double)n4 * Math.log(d2);
                for (int i = 0; i < n2; ++i) {
                    double d8 = (Double)realParameter.getValue(i) * d2;
                    if (this.outsideBounds(d8, realParameter)) {
                        return Double.NEGATIVE_INFINITY;
                    }
                    realParameter.setValue(i, d8);
                }
                return d;
            } else {
                double d9;
                int n5;
                d = -Math.log(d2);
                BooleanParameter booleanParameter = this.indicatorInput.get();
                if (booleanParameter != null) {
                    int n6;
                    int n7 = booleanParameter.getDimension();
                    Boolean[] booleanArray = (Boolean[])booleanParameter.getValues();
                    boolean bl4 = n7 == n2 - 1;
                    int[] nArray = new int[n7 + 1];
                    int n8 = 0;
                    if (bl4) {
                        nArray[n8] = 0;
                        ++n8;
                    }
                    for (n6 = 0; n6 < n7; ++n6) {
                        if (!booleanArray[n6].booleanValue()) continue;
                        nArray[n8] = n6 + (bl4 ? 1 : 0);
                        ++n8;
                    }
                    if (n8 <= 0) return Double.NEGATIVE_INFINITY;
                    n6 = Randomizer.nextInt(n8);
                    n5 = nArray[n6];
                } else {
                    n5 = Randomizer.nextInt(n2);
                }
                if ((d9 = ((Double)realParameter.getValue(n5)).doubleValue()) == 0.0) {
                    return Double.NEGATIVE_INFINITY;
                }
                double d10 = d2 * d9;
                if (this.outsideBounds(d10, realParameter)) {
                    return Double.NEGATIVE_INFINITY;
                }
                realParameter.setValue(n5, d10);
            }
            return d;
        }
        catch (Exception exception) {
            return Double.NEGATIVE_INFINITY;
        }
    }

    @Override
    public void optimize(double d) {
        if (this.optimiseInput.get().booleanValue()) {
            double d2 = this.calcDelta(d);
            this.setCoercableParameterValue(1.0 / (Math.exp(d2 += Math.log(1.0 / this.m_fScaleFactor - 1.0)) + 1.0));
        }
    }

    @Override
    public double getCoercableParameterValue() {
        return this.m_fScaleFactor;
    }

    @Override
    public void setCoercableParameterValue(double d) {
        this.m_fScaleFactor = Math.max(Math.min(d, this.upper), this.lower);
    }

    @Override
    public String getPerformanceSuggestion() {
        double d = (double)this.m_nNrAccepted / ((double)(this.m_nNrAccepted + this.m_nNrRejected) + 0.0);
        double d2 = this.getTargetAcceptanceProbability();
        double d3 = d / d2;
        if (d3 > 2.0) {
            d3 = 2.0;
        }
        if (d3 < 0.5) {
            d3 = 0.5;
        }
        double d4 = Math.pow(this.m_fScaleFactor, d3);
        DecimalFormat decimalFormat = new DecimalFormat("#.###");
        if (d < 0.1) {
            return "Try setting scaleFactor to about " + decimalFormat.format(d4);
        }
        if (d > 0.4) {
            return "Try setting scaleFactor to about " + decimalFormat.format(d4);
        }
        return "";
    }
}

