/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.operators;

import beast.core.Description;
import beast.core.Input;
import beast.core.Operator;
import beast.core.StateNode;
import beast.core.util.Log;
import java.util.ArrayList;
import java.util.List;

@Description(value="Operator which allows multiple operators to be chained together. This is only correct when each operator acts on a different part of the state.")
public class JointOperator
extends Operator {
    public final Input<List<Operator>> operatorsInput = new Input("operator", "List of operators to combine into one operation.", new ArrayList());

    @Override
    public void initAndValidate() {
    }

    @Override
    public double proposal() {
        double d = 0.0;
        for (Operator operator : this.operatorsInput.get()) {
            if ((d += operator.proposal()) == Double.NEGATIVE_INFINITY) break;
            try {
                if (operator.listStateNodes().isEmpty()) continue;
                operator.listStateNodes().get(0).getState().checkCalculationNodesDirtiness();
            }
            catch (Exception exception) {
                Log.err(exception.getMessage());
            }
        }
        return d;
    }

    @Override
    public List<StateNode> listStateNodes() {
        ArrayList<StateNode> arrayList = new ArrayList<StateNode>();
        for (Operator operator : this.operatorsInput.get()) {
            arrayList.addAll(operator.listStateNodes());
        }
        return arrayList;
    }
}

