/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.operators;

import beast.core.Description;
import beast.core.Input;
import beast.evolution.operators.TreeOperator;
import beast.evolution.tree.Node;
import beast.evolution.tree.Tree;
import beast.util.Randomizer;

@Description(value="Implements branch exchange operations. There is a NARROW and WIDE variety. The narrow exchange is very similar to a rooted-beast.tree nearest-neighbour interchange but with the restriction that node height must remain consistent.")
public class Exchange
extends TreeOperator {
    public final Input<Boolean> isNarrowInput = new Input<Boolean>("isNarrow", "if true (default) a narrow exchange is performed, otherwise a wide exchange", true);

    @Override
    public void initAndValidate() {
    }

    @Override
    public double proposal() {
        Tree tree = (Tree)this.treeInput.get(this);
        double d = 0.0;
        d = this.isNarrowInput.get() != false ? this.narrow(tree) : this.wide(tree);
        return d;
    }

    private int isg(Node node) {
        return node.getLeft().isLeaf() && node.getRight().isLeaf() ? 0 : 1;
    }

    private int sisg(Node node) {
        return node.isLeaf() ? 0 : this.isg(node);
    }

    public double narrow(Tree tree) {
        int n;
        int n2 = tree.getInternalNodeCount();
        if (n2 <= 1) {
            return Double.NEGATIVE_INFINITY;
        }
        Node node = tree.getNode(n2 + 1 + Randomizer.nextInt(n2));
        while (node.getLeft().isLeaf() && node.getRight().isLeaf()) {
            node = tree.getNode(n2 + 1 + Randomizer.nextInt(n2));
        }
        Node node2 = node.getLeft();
        Node node3 = node.getRight();
        if (node2.getHeight() < node3.getHeight()) {
            node2 = node.getRight();
            node3 = node.getLeft();
        }
        if (node2.isLeaf()) {
            return Double.NEGATIVE_INFINITY;
        }
        int n3 = 0;
        for (n = n2 + 1; n < 1 + 2 * n2; ++n) {
            n3 += this.isg(tree.getNode(n));
        }
        n = this.sisg(node2) + this.sisg(node3);
        Node node4 = Randomizer.nextBoolean() ? node2.getLeft() : node2.getRight();
        this.exchangeNodes(node4, node3, node2, node);
        int n4 = n3 - n + this.sisg(node2) + this.sisg(node3);
        return Math.log((float)n3 / (float)n4);
    }

    public double wide(Tree tree) {
        Node node;
        int n = tree.getNodeCount();
        Node node2 = tree.getRoot();
        while (node2.isRoot()) {
            node2 = tree.getNode(Randomizer.nextInt(n));
        }
        Node node3 = node2;
        while (node3.getNr() == node2.getNr() || node3.isRoot()) {
            node3 = tree.getNode(Randomizer.nextInt(n));
        }
        Node node4 = node2.getParent();
        if (node4 != (node = node3.getParent()) && node2 != node && node3 != node4 && node3.getHeight() < node4.getHeight() && node2.getHeight() < node.getHeight()) {
            this.exchangeNodes(node2, node3, node4, node);
            if (((Boolean)this.markCladesInput.get()).booleanValue()) {
                Node node5 = node4;
                Node node6 = node;
                while (node5 != node6) {
                    if (node5.getHeight() < node6.getHeight()) {
                        assert (!node5.isRoot());
                        node5 = node5.getParent();
                        node5.makeDirty(2);
                        continue;
                    }
                    assert (!node6.isRoot());
                    node6 = node6.getParent();
                    node6.makeDirty(2);
                }
            }
            return 0.0;
        }
        return Double.NEGATIVE_INFINITY;
    }

    protected void exchangeNodes(Node node, Node node2, Node node3, Node node4) {
        this.replace(node3, node, node2);
        this.replace(node4, node2, node);
    }
}

