/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.alignment.distance;

import beast.core.Description;
import beast.evolution.alignment.Alignment;
import beast.evolution.alignment.distance.Distance;

@Description(value="compute jukes-cantor corrected distance")
public class JukesCantorDistance
extends Distance.Base {
    private double const1;
    private double const2;

    @Override
    public void setPatterns(Alignment alignment) {
        super.setPatterns(alignment);
        int n = this.dataType.getStateCount();
        this.const1 = ((double)n - 1.0) / (double)n;
        this.const2 = (double)n / (double)(n - 1);
    }

    @Override
    public double pairwiseDistance(int n, int n2) {
        double d = super.pairwiseDistance(n, n2);
        if (d == 0.0) {
            return 0.0;
        }
        if (d >= this.const1) {
            return 5.0;
        }
        double d2 = -this.const1 * Math.log(1.0 - this.const2 * d);
        if (d2 < 5.0) {
            return d2;
        }
        return 5.0;
    }
}

