/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.alignment;

import beast.core.Description;
import beast.core.Input;
import beast.core.util.Log;
import beast.evolution.alignment.Sequence;
import beast.evolution.alignment.TaxonSet;
import beast.evolution.datatype.DataType;
import beast.evolution.datatype.StandardData;
import beast.util.AddOnManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Description(value="Class representing alignment data")
public class Alignment
extends beast.core.parameter.Map<String> {
    protected static final String NUCLEOTIDE = "nucleotide";
    static final String[] IMPLEMENTATION_DIR = new String[]{"beast.evolution.datatype"};
    static List<String> types = new ArrayList<String>();
    public final Input<List<Sequence>> sequenceInput = new Input("sequence", "sequence and meta data for particular taxon", new ArrayList(), Input.Validate.OPTIONAL);
    public final Input<TaxonSet> taxonSetInput = new Input<TaxonSet>("taxa", "An optional taxon-set used only to sort the sequences into the same order as they appear in the taxon-set.", new TaxonSet(), Input.Validate.OPTIONAL);
    public final Input<Integer> stateCountInput = new Input("statecount", "maximum number of states in all sequences");
    public final Input<String> dataTypeInput = new Input<String>("dataType", "data type, one of " + types, "nucleotide", types.toArray(new String[0]));
    public final Input<DataType.Base> userDataTypeInput = new Input("userDataType", "non-standard, user specified data type, if specified 'dataType' is ignored");
    public final Input<Boolean> stripInvariantSitesInput = new Input<Boolean>("strip", "sets weight to zero for sites that are invariant (e.g. all 1, all A or all unkown)", false);
    public final Input<String> siteWeightsInput = new Input("weights", "comma separated list of weights, one for each site in the sequences. If not specified, each site has weight 1");
    public final Input<Boolean> isAscertainedInput = new Input<Boolean>("ascertained", "is true if the alignment allows ascertainment correction, i.e., conditioning the Felsenstein likelihood on excluding constant sites from the alignment", false);
    public final Input<Integer> excludefromInput = new Input<Integer>("excludefrom", "first site to condition on, default 0", 0);
    public final Input<Integer> excludetoInput = new Input<Integer>("excludeto", "last site to condition on (but excluding this site), default 0", 0);
    public final Input<Integer> excludeeveryInput = new Input<Integer>("excludeevery", "interval between sites to condition on (default 1)", 1);
    public Input<Integer> m_includefrom = new Input<Integer>("includefrom", "first site to condition on, default 0", 0);
    public Input<Integer> m_includeto = new Input<Integer>("includeto", "last site to condition on, default 0", 0);
    public Input<Integer> m_includeevery = new Input<Integer>("includeevery", "interval between sites to condition on (default 1)", 1);
    protected List<Sequence> sequences = new ArrayList<Sequence>();
    protected List<String> taxaNames = new ArrayList<String>();
    protected List<Integer> stateCounts = new ArrayList<Integer>();
    protected int maxStateCount;
    protected List<List<Integer>> counts = new ArrayList<List<Integer>>();
    protected DataType m_dataType;
    protected int[] patternWeight;
    protected int[] siteWeights = null;
    public List<double[][]> tipLikelihoods = new ArrayList<double[][]>();
    private boolean usingTipLikelihoods = false;
    protected int[][] sitePatterns;
    protected int[] patternIndex;
    Set<Integer> excludedPatterns;
    List<Integer> m_nIncluded;
    public boolean isAscertained;

    @Override
    protected Class<?> mapType() {
        return String.class;
    }

    public static void findDataTypes() {
        List<String> list = AddOnManager.find(DataType.class, IMPLEMENTATION_DIR);
        for (String string : list) {
            try {
                String string2;
                DataType dataType = (DataType)Class.forName(string).newInstance();
                if (!dataType.isStandard() || types.contains(string2 = dataType.getTypeDescription())) continue;
                types.add(string2);
            }
            catch (Exception exception) {}
        }
    }

    public Alignment() {
    }

    @Deprecated
    public Alignment(List<Sequence> list, Integer n, String string) {
        this(list, string);
    }

    public Alignment(List<Sequence> list, String string) {
        for (Sequence sequence : list) {
            this.sequenceInput.setValue(sequence, this);
        }
        this.dataTypeInput.setValue(string, this);
        this.initAndValidate();
    }

    @Override
    public void initAndValidate() {
        Object object;
        ArrayList arrayList;
        if (this.sequenceInput.get().size() == 0 && ((Map)this.defaultInput.get()).size() == 0) {
            throw new IllegalArgumentException("Either a sequence input must be specified, or a map of strings must be specified");
        }
        if (this.siteWeightsInput.get() != null) {
            arrayList = this.siteWeightsInput.get().trim();
            String[] stringArray = ((String)((Object)arrayList)).split(",");
            this.siteWeights = new int[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.siteWeights[i] = Integer.parseInt(((String)stringArray[i]).trim());
            }
        }
        if (this.userDataTypeInput.get() != null) {
            this.m_dataType = this.userDataTypeInput.get();
        } else {
            if (types.indexOf(this.dataTypeInput.get()) < 0) {
                throw new IllegalArgumentException("data type + '" + this.dataTypeInput.get() + "' cannot be found. " + "Choose one of " + Arrays.toString(types.toArray(new String[0])));
            }
            arrayList = AddOnManager.find(DataType.class, IMPLEMENTATION_DIR);
            for (String string : arrayList) {
                try {
                    object = (DataType)Class.forName(string).newInstance();
                    if (!this.dataTypeInput.get().equals(object.getTypeDescription())) continue;
                    this.m_dataType = object;
                    break;
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
                    throw new IllegalArgumentException(reflectiveOperationException.getMessage());
                }
            }
        }
        if (this.sequenceInput.get().size() > 0) {
            this.sequences = this.sequenceInput.get();
        } else {
            arrayList = new ArrayList();
            arrayList.addAll(this.map.keySet());
            this.sequences.clear();
            for (String string : arrayList) {
                object = (String)this.map.get(string);
                this.sequences.add(new Sequence(string, (String)object));
            }
        }
        this.initializeWithSequenceList(this.sequences, true);
        if (this.taxonSetInput.get() != null && this.taxonSetInput.get().getTaxonCount() > 0) {
            this.sortByTaxonSet(this.taxonSetInput.get());
        }
        Log.info.println(this.toString(false));
    }

    private void initializeWithSequenceList(List<Sequence> list, boolean bl) {
        this.sequences = list;
        this.taxaNames.clear();
        this.stateCounts.clear();
        this.counts.clear();
        try {
            for (Sequence sequence : list) {
                this.counts.add(sequence.getSequence(this.m_dataType));
                if (this.taxaNames.contains(sequence.getTaxon())) {
                    throw new RuntimeException("Duplicate taxon found in alignment: " + sequence.getTaxon());
                }
                this.taxaNames.add(sequence.getTaxon());
                this.tipLikelihoods.add(sequence.getLikelihoods());
                this.usingTipLikelihoods |= sequence.getLikelihoods() != null;
                if (sequence.totalCountInput.get() != null) {
                    this.stateCounts.add(sequence.totalCountInput.get());
                    continue;
                }
                this.stateCounts.add(this.m_dataType.getStateCount());
            }
            if (this.counts.size() == 0) {
                throw new RuntimeException("Sequence data expected, but none found");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception);
        }
        this.sanityCheckCalcPatternsSetUpAscertainment(bl);
    }

    private void sanityCheckCalcPatternsSetUpAscertainment(boolean bl) {
        int n = this.counts.get(0).size();
        if (!(this.m_dataType instanceof StandardData)) {
            for (List<Integer> list : this.counts) {
                if (list.size() == n) continue;
                throw new RuntimeException("Two sequences with different length found: " + n + " != " + list.size());
            }
        }
        if (this.siteWeights != null && this.siteWeights.length != n) {
            throw new RuntimeException("Number of weights (" + this.siteWeights.length + ") does not match sequence length (" + n + ")");
        }
        this.calcPatterns(bl);
        this.setupAscertainment();
    }

    public void sortByTaxonSet(TaxonSet taxonSet) {
        ArrayList<Sequence> arrayList = new ArrayList<Sequence>();
        arrayList.addAll(this.sequences);
        Collections.sort(arrayList, (sequence, sequence2) -> Integer.compare(taxonSet.getTaxonIndex(sequence.getTaxon()), taxonSet.getTaxonIndex(sequence2.getTaxon())));
        this.initializeWithSequenceList(arrayList, false);
    }

    void setupAscertainment() {
        this.isAscertained = this.isAscertainedInput.get();
        if (this.isAscertained) {
            int n;
            int n2;
            int n3 = this.excludefromInput.get();
            int n4 = this.excludetoInput.get();
            int n5 = this.excludeeveryInput.get();
            this.excludedPatterns = new HashSet<Integer>();
            for (n2 = n3; n2 < n4; n2 += n5) {
                n = this.patternIndex[n2];
                this.patternWeight[n] = 0;
                this.excludedPatterns.add(n);
            }
            n3 = this.m_includefrom.get();
            n4 = this.m_includeto.get();
            n5 = this.m_includeevery.get();
            this.m_nIncluded = new ArrayList<Integer>();
            for (n2 = n3; n2 < n4; n2 += n5) {
                n = this.patternIndex[n2];
                this.patternWeight[n] = 0;
                this.m_nIncluded.add(n);
            }
        } else {
            int n = this.excludefromInput.get();
            int n6 = this.excludetoInput.get();
            if (n != (Integer)this.excludefromInput.defaultValue || n6 != (Integer)this.excludetoInput.defaultValue) {
                Log.warning.println("WARNING: excludefrom or excludeto is specified, but 'ascertained' flag is not set to true");
                Log.warning.println("WARNING: to suppress this warning, remove the excludefrom or excludeto attributes (if no astertainment correction is required)");
                Log.warning.println("WARNING: or set the 'ascertained' flag to true on element with id=" + this.getID());
            }
        }
    }

    static String getSequence(Alignment alignment, int n) {
        int[] nArray = new int[alignment.getPatternCount()];
        for (int i = 0; i < alignment.getPatternCount(); ++i) {
            int[] nArray2 = alignment.getPattern(i);
            nArray[i] = nArray2[n];
        }
        try {
            return alignment.getDataType().state2string(nArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
            return null;
        }
    }

    public List<String> getTaxaNames() {
        if (this.taxaNames.size() == 0) {
            try {
                this.initAndValidate();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new RuntimeException(exception);
            }
        }
        return this.taxaNames;
    }

    public List<Integer> getStateCounts() {
        return this.stateCounts;
    }

    public List<List<Integer>> getCounts() {
        return this.counts;
    }

    public DataType getDataType() {
        return this.m_dataType;
    }

    public int getTaxonCount() {
        return this.taxaNames.size();
    }

    @Deprecated
    public int getNrTaxa() {
        return this.getTaxonCount();
    }

    public int getTaxonIndex(String string) {
        return this.taxaNames.indexOf(string);
    }

    public int getPatternCount() {
        return this.sitePatterns.length;
    }

    public int[] getPattern(int n) {
        return this.sitePatterns[n];
    }

    public int getPattern(int n, int n2) {
        return this.sitePatterns[n2][n];
    }

    public int getPatternWeight(int n) {
        return this.patternWeight[n];
    }

    public int getMaxStateCount() {
        return this.maxStateCount;
    }

    public int getPatternIndex(int n) {
        return this.patternIndex[n];
    }

    public int getSiteCount() {
        return this.patternIndex.length;
    }

    public int[] getWeights() {
        return this.patternWeight;
    }

    protected void calcPatterns() {
        this.calcPatterns(true);
    }

    private void calcPatterns(boolean bl) {
        int n;
        int n2 = this.counts.size();
        int n3 = this.counts.get(0).size();
        int[][] nArray = new int[n3][n2];
        for (int i = 0; i < n2; ++i) {
            List<Integer> list = this.counts.get(i);
            for (int j = 0; j < n3; ++j) {
                nArray[j][i] = list.get(j);
            }
        }
        SiteComparator siteComparator = new SiteComparator();
        Arrays.sort(nArray, siteComparator);
        int n4 = 1;
        int[] nArray2 = new int[n3];
        nArray2[0] = 1;
        for (n = 1; n < n3; ++n) {
            if (this.usingTipLikelihoods || siteComparator.compare(nArray[n - 1], nArray[n]) != 0) {
                nArray[++n4 - 1] = nArray[n];
            }
            int n5 = n4 - 1;
            nArray2[n5] = nArray2[n5] + 1;
        }
        this.patternWeight = new int[n4];
        this.sitePatterns = new int[n4][n2];
        for (n = 0; n < n4; ++n) {
            this.patternWeight[n] = nArray2[n];
            this.sitePatterns[n] = nArray[n];
        }
        this.patternIndex = new int[n3];
        for (n = 0; n < n3; ++n) {
            int[] nArray3 = new int[n2];
            for (int i = 0; i < n2; ++i) {
                nArray3[i] = this.counts.get(i).get(n);
            }
            this.patternIndex[n] = Arrays.binarySearch(this.sitePatterns, nArray3, siteComparator);
        }
        if (this.siteWeights != null) {
            Arrays.fill(this.patternWeight, 0);
            for (n = 0; n < n3; ++n) {
                int n6 = this.patternIndex[n];
                this.patternWeight[n6] = this.patternWeight[n6] + this.siteWeights[n];
            }
        }
        this.maxStateCount = 0;
        for (int n7 : this.stateCounts) {
            this.maxStateCount = Math.max(this.maxStateCount, n7);
        }
        if (bl && this.taxaNames.size() < 30) {
            for (int i = 0; i < this.taxaNames.size(); ++i) {
                Log.info.println(this.taxaNames.get(i) + ": " + this.counts.get(i).size() + " " + this.stateCounts.get(i));
            }
        }
        if (this.stripInvariantSitesInput.get().booleanValue()) {
            if (bl) {
                Log.info.println("Stripping invariant sites");
            }
            int n8 = 0;
            for (int i = 0; i < n4; ++i) {
                int[] nArray4 = this.sitePatterns[i];
                int n9 = nArray4[0];
                boolean bl2 = true;
                for (int j = 1; j < nArray4.length; ++j) {
                    if (nArray4[j] == n9) continue;
                    bl2 = false;
                    break;
                }
                if (!bl2) continue;
                n8 += this.patternWeight[i];
                this.patternWeight[i] = 0;
                if (!bl) continue;
                Log.info.print(" <" + n9 + "> ");
            }
            if (bl) {
                Log.info.println(" removed " + n8 + " sites ");
            }
        }
    }

    private long getTotalWeight() {
        long l = 0L;
        for (int n : this.patternWeight) {
            l += (long)n;
        }
        return l;
    }

    public String toString(boolean bl) {
        long l = this.getTotalWeight();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName() + "(" + this.getID() + ")");
        if (bl) {
            stringBuilder.append(": [taxa, patterns, sites] = [" + this.getTaxonCount() + ", " + this.getPatternCount());
            stringBuilder.append(", " + this.getTotalWeight() + "]");
        } else {
            long l2 = this.getSiteCount();
            stringBuilder.append('\n');
            stringBuilder.append("  " + this.getTaxonCount() + " taxa");
            stringBuilder.append('\n');
            stringBuilder.append("  " + l2 + (l2 == 1L ? " site" : " sites") + (l == (long)this.getSiteCount() ? "" : " with weight " + l + ""));
            stringBuilder.append('\n');
            if (l2 > 1L) {
                stringBuilder.append("  " + this.getPatternCount() + " patterns");
                stringBuilder.append('\n');
            }
        }
        return stringBuilder.toString();
    }

    public double[] getTipLikelihoods(int n, int n2) {
        if (n >= this.tipLikelihoods.size() || this.tipLikelihoods.get(n) == null) {
            return null;
        }
        return this.tipLikelihoods.get(n)[n2];
    }

    public boolean[] getStateSet(int n) {
        return this.m_dataType.getStateSet(n);
    }

    boolean isAmbiguousState(int n) {
        return n < 0 || n >= this.maxStateCount;
    }

    public Set<Integer> getExcludedPatternIndices() {
        return this.excludedPatterns;
    }

    public int getExcludedPatternCount() {
        return this.excludedPatterns.size();
    }

    public double getAscertainmentCorrection(double[] dArray) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 1.0;
        for (int i = 0; i < this.m_nIncluded.size(); ++i) {
            d2 += Math.exp(dArray[this.m_nIncluded.get(i)]);
        }
        for (int n : this.excludedPatterns) {
            d += Math.exp(dArray[n]);
        }
        d3 = d2 == 0.0 ? (d3 -= d) : (d == 0.0 ? d2 : 1.0 + d2 - d);
        return Math.log(d3);
    }

    @Deprecated
    public static void sortByTaxonName(List<Sequence> list) {
        Collections.sort(list, (sequence, sequence2) -> sequence.taxonInput.get().compareTo(sequence2.taxonInput.get()));
    }

    public String getSequenceAsString(String string) {
        int n = this.getTaxonIndex(string);
        int[] nArray = new int[this.getSiteCount()];
        for (int i = 0; i < this.getSiteCount(); ++i) {
            int n2;
            nArray[i] = n2 = this.sitePatterns[this.patternIndex[i]][n];
        }
        String string2 = null;
        try {
            string2 = this.m_dataType.state2string(nArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    static {
        Alignment.findDataTypes();
    }

    class SiteComparator
    implements Comparator<int[]> {
        SiteComparator() {
        }

        @Override
        public int compare(int[] nArray, int[] nArray2) {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] > nArray2[i]) {
                    return 1;
                }
                if (nArray[i] >= nArray2[i]) continue;
                return -1;
            }
            return 0;
        }
    }
}

