/*
 * Decompiled with CFR 0.152.
 */
package beast.app.treeannotator;

import beast.app.BEASTVersion;
import beast.app.beauti.BeautiDoc;
import beast.app.tools.LogCombiner;
import beast.app.treeannotator.CladeSystem;
import beast.app.treeannotator.ContourPath;
import beast.app.treeannotator.ContourWithSynder;
import beast.app.treeannotator.TreeAnnotatorDialog;
import beast.app.util.Arguments;
import beast.app.util.Utils;
import beast.core.util.Log;
import beast.evolution.alignment.TaxonSet;
import beast.evolution.tree.Node;
import beast.evolution.tree.Tree;
import beast.evolution.tree.TreeUtils;
import beast.math.statistic.DiscreteStatistics;
import beast.util.CollectionUtils;
import beast.util.HeapSort;
import beast.util.NexusParser;
import beast.util.TreeParser;
import jam.console.ConsoleApplication;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class TreeAnnotator {
    private static final BEASTVersion version = new BEASTVersion();
    private static final boolean USE_R = false;
    private static boolean forceIntegerToDiscrete = false;
    static boolean processSA = true;
    private boolean SAmode = false;
    TreeSet treeSet;
    static PrintStream progressStream = Log.err;
    public static final String CORDINATE = "cordinates";
    int totalTrees = 0;
    int totalTreesUsed = 0;
    double posteriorLimit = 0.0;
    double hpd2D = 0.8;
    private final List<TreeAnnotationPlugin> beastObjects = new ArrayList<TreeAnnotationPlugin>();
    Set<String> attributeNames = new HashSet<String>();
    TaxonSet taxa = null;
    static boolean processBivariateAttributes = true;

    public TreeAnnotator() {
    }

    public TreeAnnotator(int n, boolean bl, HeightsSummary heightsSummary, double d, double d2, Target target, String string, String string2, String string3) throws IOException {
        Object object;
        Object object2;
        this.posteriorLimit = d;
        this.hpd2D = d2;
        this.attributeNames.add("height");
        this.attributeNames.add("length");
        CladeSystem cladeSystem = new CladeSystem();
        this.totalTrees = 10000;
        this.totalTreesUsed = 0;
        try {
            this.treeSet = bl ? new MemoryFriendlyTreeSet(string2, n) : new FastTreeSet(string2, n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Log.err.println("Error Parsing Input Tree: " + exception.getMessage());
            return;
        }
        if (target != Target.USER_TARGET_TREE) {
            try {
                this.treeSet.reset();
                while (this.treeSet.hasNext()) {
                    object2 = this.treeSet.next();
                    ((Tree)object2).getLeafNodeCount();
                    if (((Tree)object2).getDirectAncestorNodeCount() > 0 && !this.SAmode && processSA) {
                        this.SAmode = true;
                        Log.err.println("A tree with a sampled ancestor is found. Turning on\n the sampled ancestor summary analysis.");
                        if (heightsSummary == HeightsSummary.CA_HEIGHTS) {
                            throw new RuntimeException("The common ancestor height is not \n available for trees with sampled ancestors. Please choose \n another height summary option");
                        }
                    }
                    cladeSystem.add((Tree)object2, false);
                    ++this.totalTreesUsed;
                }
                this.totalTrees = this.totalTreesUsed * 100 / (100 - Math.max(n, 0));
            }
            catch (Exception exception) {
                Log.err.println(exception.getMessage());
                return;
            }
            progressStream.println();
            progressStream.println();
            if (this.totalTrees < 1) {
                Log.err.println("No trees");
                return;
            }
            if (this.totalTreesUsed <= 1 && n > 0) {
                Log.err.println("No trees to use: burnin too high");
                return;
            }
            cladeSystem.calculateCladeCredibilities(this.totalTreesUsed);
            progressStream.println("Total trees have " + this.totalTrees + ", where " + this.totalTreesUsed + " are used.");
            progressStream.println("Total unique clades: " + cladeSystem.getCladeMap().keySet().size());
            progressStream.println();
        } else {
            this.treeSet.reset();
            while (this.treeSet.hasNext()) {
                object2 = this.treeSet.next();
                ((Tree)object2).getLeafNodeCount();
                if (((Tree)object2).getDirectAncestorNodeCount() > 0 && !this.SAmode && processSA) {
                    this.SAmode = true;
                    Log.err.println("A tree with a sampled ancestor is found. Turning on\n the sampled ancestor summary analysis.");
                    if (heightsSummary == HeightsSummary.CA_HEIGHTS) {
                        throw new RuntimeException("The common ancestor height is not \n available for trees with sampled ancestors. Please choose \n another height summary option");
                    }
                }
                ++this.totalTreesUsed;
            }
        }
        object2 = null;
        switch (target) {
            case USER_TARGET_TREE: {
                if (string != null) {
                    Object object3;
                    progressStream.println("Reading user specified target tree, " + string);
                    String string4 = BeautiDoc.load(string);
                    if (string4.startsWith("#NEXUS")) {
                        object3 = new NexusParser();
                        ((NexusParser)object3).parseFile(new File(string));
                        object2 = ((NexusParser)object3).trees.get(0);
                        break;
                    }
                    try {
                        object3 = new TreeParser();
                        object3.initByName("IsLabelledNewick", true, "newick", string4);
                        object2 = object3;
                        break;
                    }
                    catch (Exception exception) {
                        Log.err.println("Error Parsing Target Tree: " + exception.getMessage());
                        return;
                    }
                }
                Log.err.println("No user target tree specified.");
                return;
            }
            case MAX_CLADE_CREDIBILITY: {
                progressStream.println("Finding maximum credibility tree...");
                object2 = this.summarizeTrees(cladeSystem, false).copy();
                break;
            }
            case MAX_SUM_CLADE_CREDIBILITY: {
                progressStream.println("Finding maximum sum clade credibility tree...");
                object2 = this.summarizeTrees(cladeSystem, true).copy();
            }
        }
        progressStream.println("Collecting node information...");
        progressStream.println("0              25             50             75            100");
        progressStream.println("|--------------|--------------|--------------|--------------|");
        int n2 = Math.max(this.totalTreesUsed / 60, 1);
        int n3 = 0;
        cladeSystem = new CladeSystem((Tree)object2);
        int n4 = 0;
        try {
            int n5 = 0;
            this.treeSet.reset();
            while (this.treeSet.hasNext()) {
                object = this.treeSet.next();
                if (n5 == 0) {
                    this.setupAttributes((Tree)object);
                }
                cladeSystem.collectAttributes((Tree)object, this.attributeNames);
                if (n5 > 0 && n5 % n2 == 0 && n3 < 61) {
                    while (1000 * n3 < 61000 * (n5 + 1) / this.totalTreesUsed) {
                        progressStream.print("*");
                        ++n3;
                    }
                    progressStream.flush();
                }
                ++n4;
                ++n5;
            }
            cladeSystem.removeClades(((Tree)object2).getRoot(), true);
            this.totalTreesUsed = n4;
            cladeSystem.calculateCladeCredibilities(n4);
        }
        catch (Exception exception) {
            Log.err.println("Error Parsing Input Tree: " + exception.getMessage());
            return;
        }
        progressStream.println();
        progressStream.println();
        progressStream.println("Annotating target tree...");
        try {
            this.annotateTree(cladeSystem, ((Tree)object2).getRoot(), null, heightsSummary);
            if (heightsSummary == HeightsSummary.CA_HEIGHTS) {
                this.setTreeHeightsByCA((Tree)object2, target);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Log.err.println("Error to annotate tree: " + exception.getMessage() + "\nPlease check the tree log file format.");
            return;
        }
        progressStream.println("Writing annotated tree....");
        this.processMetaData(((Tree)object2).getRoot());
        try {
            PrintStream printStream = string3 != null ? new PrintStream(new FileOutputStream(string3)) : System.out;
            ((Tree)object2).init(printStream);
            printStream.println();
            printStream.print("tree TREE1 = ");
            object = new int[1];
            String string5 = ((Tree)object2).getRoot().toSortedNewick((int[])object, true);
            printStream.print(string5);
            printStream.println(";");
            ((Tree)object2).close(printStream);
            printStream.println();
        }
        catch (Exception exception) {
            Log.err.println("Error to write annotated tree file: " + exception.getMessage());
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void processMetaData(Node node) {
        for (Node object : node.getChildren()) {
            this.processMetaData(object);
        }
        Set<String> set = node.getMetaDataNames();
        if (set != null && !set.isEmpty()) {
            String string;
            void var3_5;
            String string2 = "";
            for (String string3 : set) {
                void var3_14;
                Object object = node.getMetaData(string3);
                String string4 = (String)var3_5 + string3 + "=";
                if (object instanceof Object[]) {
                    void var3_8;
                    Object[] objectArray = (Object[])object;
                    String string5 = string4 + "{";
                    for (int i = 0; i < objectArray.length; ++i) {
                        String string6 = (String)var3_8 + objectArray[i].toString();
                        if (i >= objectArray.length - 1) continue;
                        String string7 = string6 + ",";
                    }
                    String string8 = (String)var3_8 + "}";
                } else {
                    String string9 = string4 + object.toString();
                }
                String string10 = (String)var3_14 + ",";
            }
            node.metaDataString = string = var3_5.substring(0, var3_5.length() - 1);
        }
    }

    private void setupAttributes(Tree tree) {
        Set<String> set;
        for (int i = 0; i < tree.getNodeCount(); ++i) {
            Node object = tree.getNode(i);
            set = object.getMetaDataNames();
            if (set == null) continue;
            for (String string : set) {
                this.attributeNames.add(string);
            }
        }
        for (TreeAnnotationPlugin treeAnnotationPlugin : this.beastObjects) {
            set = treeAnnotationPlugin.setAttributeNames(this.attributeNames);
            this.attributeNames.removeAll(set);
        }
    }

    private Tree summarizeTrees(CladeSystem cladeSystem, boolean bl) throws IOException {
        Tree tree = null;
        double d = Double.NEGATIVE_INFINITY;
        progressStream.println("Analyzing " + this.totalTreesUsed + " trees...");
        progressStream.println("0              25             50             75            100");
        progressStream.println("|--------------|--------------|--------------|--------------|");
        int n = Math.max(this.totalTreesUsed / 60, 1);
        int n2 = 0;
        int n3 = 0;
        this.treeSet.reset();
        while (this.treeSet.hasNext()) {
            Tree tree2 = this.treeSet.next();
            double d2 = this.scoreTree(tree2, cladeSystem, bl);
            if (d2 > d) {
                tree = tree2;
                d = d2;
            }
            if (n3 % n == 0 && n2 < 61) {
                while (1000 * n2 < 61000 * (n3 + 1) / this.totalTreesUsed) {
                    progressStream.print("*");
                    ++n2;
                }
                progressStream.flush();
            }
            ++n3;
        }
        progressStream.println();
        progressStream.println();
        if (bl) {
            progressStream.println("Highest Sum Clade Credibility: " + d);
        } else {
            progressStream.println("Highest Log Clade Credibility: " + d);
        }
        return tree;
    }

    public double scoreTree(Tree tree, CladeSystem cladeSystem, boolean bl) {
        if (bl) {
            return cladeSystem.getSumCladeCredibility(tree.getRoot(), null);
        }
        return cladeSystem.getLogCladeCredibility(tree.getRoot(), null);
    }

    private void annotateTree(CladeSystem cladeSystem, Node node, BitSet bitSet, HeightsSummary heightsSummary) {
        BitSet bitSet2 = new BitSet();
        if (node.isLeaf()) {
            int n = cladeSystem.getTaxonIndex(node);
            bitSet2.set(2 * n);
            this.annotateNode(cladeSystem, node, bitSet2, true, heightsSummary);
        } else {
            int n;
            for (n = 0; n < node.getChildCount(); ++n) {
                Node node2 = node.getChild(n);
                this.annotateTree(cladeSystem, node2, bitSet2, heightsSummary);
            }
            for (n = 1; n < bitSet2.length(); n += 2) {
                bitSet2.set(n, false);
            }
            if (node.isFake()) {
                n = cladeSystem.getTaxonIndex(node.getDirectAncestorChild());
                bitSet2.set(2 * n + 1);
            }
            this.annotateNode(cladeSystem, node, bitSet2, false, heightsSummary);
        }
        if (bitSet != null) {
            bitSet.or(bitSet2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void annotateNode(CladeSystem cladeSystem, Node node, BitSet bitSet, boolean bl, HeightsSummary heightsSummary) {
        CladeSystem.Clade clade = cladeSystem.cladeMap.get(bitSet);
        assert (clade != null) : "Clade missing?";
        boolean bl2 = false;
        if (!bl) {
            double d = clade.getCredibility();
            node.setMetaData("posterior", d);
            if (d < this.posteriorLimit) {
                bl2 = true;
            }
        }
        int n = 0;
        for (String string : this.attributeNames) {
            if (clade.attributeValues != null && clade.attributeValues.size() > 0) {
                double[] dArray = new double[clade.attributeValues.size()];
                HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
                Object[] objectArray = clade.attributeValues.get(0);
                if (objectArray[n] != null) {
                    void object;
                    int n2;
                    int n3;
                    boolean bl3;
                    boolean bl4 = string.equals("height");
                    boolean bl5 = objectArray[n] instanceof Boolean;
                    boolean bl6 = objectArray[n] instanceof String;
                    if (forceIntegerToDiscrete && objectArray[n] instanceof Integer) {
                        bl6 = true;
                    }
                    double d = Double.MAX_VALUE;
                    double d2 = -1.7976931348623157E308;
                    boolean bl7 = objectArray[n] instanceof Object[];
                    boolean bl8 = bl3 = bl7 && ((Object[])objectArray[n])[0] instanceof Double;
                    if (bl3) {
                        for (Object object2 : (Object[])objectArray[n]) {
                            if (object2 instanceof Double) continue;
                            bl3 = false;
                            break;
                        }
                    }
                    double[][] dArray2 = null;
                    double[] dArray3 = null;
                    double[] dArray4 = null;
                    int n4 = 0;
                    if (bl3) {
                        n4 = ((Object[])objectArray[n]).length;
                        double[][] dArray5 = new double[n4][clade.attributeValues.size()];
                        dArray3 = new double[n4];
                        dArray4 = new double[n4];
                        for (n3 = 0; n3 < n4; ++n3) {
                            dArray3[n3] = Double.MAX_VALUE;
                            dArray4[n3] = -1.7976931348623157E308;
                        }
                    }
                    for (n3 = 0; n3 < clade.attributeValues.size(); ++n3) {
                        Iterator<TreeAnnotationPlugin> iterator = clade.attributeValues.get(n3)[n];
                        if (bl6) {
                            Iterator<TreeAnnotationPlugin> iterator2 = iterator;
                            if (hashMap.containsKey(iterator2)) {
                                hashMap.put(iterator2, (Integer)hashMap.get(iterator2) + 1);
                                continue;
                            }
                            hashMap.put(iterator2, 1);
                            continue;
                        }
                        if (bl5) {
                            dArray[n3] = (Boolean)((Object)iterator) != false ? 1.0 : 0.0;
                            continue;
                        }
                        if (bl3) {
                            try {
                                Object[] objectArray2 = (Object[])iterator;
                                for (n2 = 0; n2 < n4; ++n2) {
                                    object[n2][n3] = (Double)objectArray2[n2];
                                    if (object[n2][n3] < dArray3[n2]) {
                                        dArray3[n2] = object[n2][n3];
                                    }
                                    if (!(object[n2][n3] > dArray4[n2])) continue;
                                    dArray4[n2] = object[n2][n3];
                                }
                                continue;
                            }
                            catch (Exception exception) {
                                continue;
                            }
                        }
                        if (!(iterator instanceof Number)) continue;
                        dArray[n3] = ((Number)((Object)iterator)).doubleValue();
                        if (dArray[n3] < d) {
                            d = dArray[n3];
                        }
                        if (!(dArray[n3] > d2)) continue;
                        d2 = dArray[n3];
                    }
                    if (bl4) {
                        if (heightsSummary == HeightsSummary.MEAN_HEIGHTS) {
                            double d3 = DiscreteStatistics.mean(dArray);
                            if (node.isDirectAncestor()) {
                                node.getParent().setHeight(d3);
                            }
                            if (node.isFake()) {
                                node.getDirectAncestorChild().setHeight(d3);
                            }
                            node.setHeight(d3);
                        } else if (heightsSummary == HeightsSummary.MEDIAN_HEIGHTS) {
                            double d4 = DiscreteStatistics.median(dArray);
                            if (node.isDirectAncestor()) {
                                node.getParent().setHeight(d4);
                            }
                            if (node.isFake()) {
                                node.getDirectAncestorChild().setHeight(d4);
                            }
                            node.setHeight(d4);
                        }
                    }
                    if (!bl2) {
                        boolean bl9 = false;
                        for (TreeAnnotationPlugin treeAnnotationPlugin : this.beastObjects) {
                            if (!treeAnnotationPlugin.handleAttribute(node, string, dArray)) continue;
                            bl9 = true;
                        }
                        if (!bl9) {
                            if (!bl6) {
                                if (!bl3) {
                                    this.annotateMeanAttribute(node, string, dArray);
                                } else {
                                    for (int i = 0; i < n4; ++i) {
                                        this.annotateMeanAttribute(node, string + (i + 1), (double[])object[i]);
                                    }
                                }
                            } else {
                                this.annotateModeAttribute(node, string, hashMap);
                                this.annotateFrequencyAttribute(node, string, hashMap);
                            }
                            if (!bl5 && d < d2 && !bl6 && !bl3) {
                                this.annotateMedianAttribute(node, string + "_median", dArray);
                                this.annotateHPDAttribute(node, string + "_95%_HPD", 0.95, dArray);
                                this.annotateRangeAttribute(node, string + "_range", dArray);
                            }
                            if (bl3) {
                                boolean bl10;
                                boolean bl11;
                                String string2 = string;
                                boolean bl12 = bl11 = processBivariateAttributes && n4 == 2;
                                if (string2.equals("dmv")) {
                                    bl10 = false;
                                }
                                for (n2 = 0; n2 < n4; ++n2) {
                                    if (!(dArray3[n2] < dArray4[n2])) continue;
                                    this.annotateMedianAttribute(node, string2 + (n2 + 1) + "_median", (double[])object[n2]);
                                    this.annotateRangeAttribute(node, string2 + (n2 + 1) + "_range", (double[])object[n2]);
                                    if (bl10) continue;
                                    this.annotateHPDAttribute(node, string2 + (n2 + 1) + "_95%_HPD", 0.95, (double[])object[n2]);
                                }
                                if (bl10) {
                                    boolean bl13;
                                    n2 = dArray3[0] < dArray4[0] ? 1 : 0;
                                    boolean bl14 = bl13 = dArray3[1] < dArray4[1];
                                    if (n2 != 0 && !bl13) {
                                        this.annotateHPDAttribute(node, string2 + "1" + "_95%_HPD", 0.95, (double[])object[0]);
                                    }
                                    if (bl13 && n2 == 0) {
                                        this.annotateHPDAttribute(node, string2 + "2" + "_95%_HPD", 0.95, (double[])object[1]);
                                    }
                                    if (n2 != 0 && bl13) {
                                        this.annotate2DHPDAttribute(node, string2, "_" + (int)(100.0 * this.hpd2D) + "%HPD", this.hpd2D, (double[][])object);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            ++n;
        }
    }

    private void annotateMeanAttribute(Node node, String string, double[] dArray) {
        double d = DiscreteStatistics.mean(dArray);
        node.setMetaData(string, d);
    }

    private void annotateMedianAttribute(Node node, String string, double[] dArray) {
        double d = DiscreteStatistics.median(dArray);
        node.setMetaData(string, d);
    }

    private void annotateModeAttribute(Node node, String string, HashMap<Object, Integer> hashMap) {
        Object object = null;
        int n = 0;
        int n2 = 0;
        int n3 = 1;
        for (Object object2 : hashMap.keySet()) {
            int n4 = hashMap.get(object2);
            if (n4 == n) {
                object = object.toString().concat("+" + object2);
                ++n3;
            } else if (n4 > n) {
                object = object2;
                n = n4;
                n3 = 1;
            }
            n2 += n4;
        }
        double d = (double)n / (double)n2 * (double)n3;
        node.setMetaData(string, object);
        node.setMetaData(string + ".prob", d);
    }

    private void annotateFrequencyAttribute(Node node, String string, HashMap<Object, Integer> hashMap) {
        double d = 0.0;
        Set<Object> set = hashMap.keySet();
        int n = set.size();
        String[] stringArray = new String[n];
        Double[] doubleArray = new Double[n];
        int n2 = 0;
        for (Object doubleArray2 : hashMap.keySet()) {
            stringArray[n2] = doubleArray2.toString();
            doubleArray[n2] = new Double(hashMap.get(doubleArray2).intValue());
            d += doubleArray[n2].doubleValue();
            ++n2;
        }
        int n3 = 0;
        while (n3 < n) {
            Double[] doubleArray2 = doubleArray;
            int n4 = n3++;
            Double.valueOf(doubleArray2[n4] / d);
        }
        node.setMetaData(string + ".set", stringArray);
        node.setMetaData(string + ".set.prob", doubleArray);
    }

    private void annotateRangeAttribute(Node node, String string, double[] dArray) {
        double d = DiscreteStatistics.min(dArray);
        double d2 = DiscreteStatistics.max(dArray);
        node.setMetaData(string, new Object[]{d, d2});
    }

    private void annotateHPDAttribute(Node node, String string, double d, double[] dArray) {
        int[] nArray = new int[dArray.length];
        HeapSort.sort(dArray, nArray);
        double d2 = Double.MAX_VALUE;
        int n = 0;
        int n2 = (int)Math.round(d * (double)dArray.length);
        for (int i = 0; i <= dArray.length - n2; ++i) {
            double d3 = dArray[nArray[i + n2 - 1]];
            double d4 = dArray[nArray[i]];
            double d5 = Math.abs(d3 - d4);
            if (!(d5 < d2)) continue;
            d2 = d5;
            n = i;
        }
        double d6 = dArray[nArray[n]];
        double d7 = dArray[nArray[n + n2 - 1]];
        node.setMetaData(string, new Object[]{d6, d7});
    }

    private String formattedLocation(double d) {
        return String.format("%5.2f", d);
    }

    private void annotate2DHPDAttribute(Node node, String string, String string2, double d, double[][] dArray) {
        boolean bl = false;
        ContourWithSynder contourWithSynder = new ContourWithSynder(dArray[0], dArray[1], bl);
        ContourPath[] contourPathArray = contourWithSynder.getContourPaths(d);
        node.setMetaData(string + string2 + "_modality", contourPathArray.length);
        if (contourPathArray.length > 1) {
            Log.err.println("Warning: a node has a disjoint " + 100.0 * d + "% HPD region.  This may be an artifact!");
            Log.err.println("Try decreasing the enclosed mass or increasing the number of samples.");
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        for (ContourPath contourPath : contourPathArray) {
            stringBuffer.append("\n<cordinates>\n");
            double[] dArray2 = contourPath.getAllX();
            double[] dArray3 = contourPath.getAllY();
            StringBuffer stringBuffer2 = new StringBuffer("{");
            StringBuffer stringBuffer3 = new StringBuffer("{");
            for (int i = 0; i < dArray2.length; ++i) {
                stringBuffer2.append(this.formattedLocation(dArray2[i])).append(",");
                stringBuffer3.append(this.formattedLocation(dArray3[i])).append(",");
            }
            stringBuffer2.append(this.formattedLocation(dArray2[0])).append("}");
            stringBuffer3.append(this.formattedLocation(dArray3[0])).append("}");
            node.setMetaData(string + "1" + string2 + "_" + (n + 1), stringBuffer2);
            node.setMetaData(string + "2" + string2 + "_" + (n + 1), stringBuffer3);
            ++n;
        }
    }

    public static void printTitle() {
        progressStream.println();
        TreeAnnotator.centreLine("TreeAnnotator " + version.getVersionString() + ", " + version.getDateString(), 60);
        TreeAnnotator.centreLine("MCMC Output analysis", 60);
        TreeAnnotator.centreLine("by", 60);
        TreeAnnotator.centreLine("Andrew Rambaut and Alexei J. Drummond", 60);
        progressStream.println();
        TreeAnnotator.centreLine("Institute of Evolutionary Biology", 60);
        TreeAnnotator.centreLine("University of Edinburgh", 60);
        TreeAnnotator.centreLine("a.rambaut@ed.ac.uk", 60);
        progressStream.println();
        TreeAnnotator.centreLine("Department of Computer Science", 60);
        TreeAnnotator.centreLine("University of Auckland", 60);
        TreeAnnotator.centreLine("alexei@cs.auckland.ac.nz", 60);
        progressStream.println();
        progressStream.println();
    }

    public static void centreLine(String string, int n) {
        int n2 = n - string.length();
        int n3 = n2 / 2;
        for (int i = 0; i < n3; ++i) {
            progressStream.print(" ");
        }
        progressStream.println(string);
    }

    public static void printUsage(Arguments arguments) {
        arguments.printUsage("treeannotator", "<input-file-name> [<output-file-name>]");
        progressStream.println();
        progressStream.println("  Example: treeannotator test.trees out.txt");
        progressStream.println("  Example: treeannotator -burnin 10 -heights mean test.trees out.txt");
        progressStream.println("  Example: treeannotator -burnin 20 -target map.tree test.trees out.txt");
        progressStream.println();
    }

    public static void main(String[] stringArray) throws IOException {
        Locale.setDefault(Locale.US);
        String string = null;
        String string2 = null;
        String string3 = null;
        if (stringArray.length == 0) {
            Utils.loadUIManager();
            System.setProperty("com.apple.macos.useScreenMenuBar", "true");
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("apple.awt.showGrowBox", "true");
            URL uRL = LogCombiner.class.getResource("/images/utility.png");
            ImageIcon imageIcon = null;
            if (uRL != null) {
                imageIcon = new ImageIcon(uRL);
            }
            String string4 = version.getVersionString();
            String string5 = "TreeAnnotator " + string4;
            String string6 = "<html><center><p>" + string4 + ", " + version.getDateString() + "</p>" + "<p>by<br>" + "Andrew Rambaut and Alexei J. Drummond</p>" + "<p>Institute of Evolutionary Biology, University of Edinburgh<br>" + "<a href=\"mailto:a.rambaut@ed.ac.uk\">a.rambaut@ed.ac.uk</a></p>" + "<p>Department of Computer Science, University of Auckland<br>" + "<a href=\"mailto:alexei@cs.auckland.ac.nz\">alexei@cs.auckland.ac.nz</a></p>" + "<p>Part of the BEAST package:<br>" + "<a href=\"http://beast.bio.ed.ac.uk/\">http://beast.bio.ed.ac.uk/</a></p>" + "</center></html>";
            new ConsoleApplication(string5, string6, imageIcon, true);
            Log.info = System.out;
            Log.err = System.err;
            progressStream = System.out;
            TreeAnnotator.printTitle();
            TreeAnnotatorDialog treeAnnotatorDialog = new TreeAnnotatorDialog(new JFrame());
            if (!treeAnnotatorDialog.showDialog("TreeAnnotator " + string4)) {
                return;
            }
            int n = treeAnnotatorDialog.getBurninPercentage();
            if (n < 0) {
                Log.warning.println("burnin percentage is " + n + " but should be non-negative. Setting it to zero");
                n = 0;
            }
            if (n >= 100) {
                Log.err.println("burnin percentage is " + n + " but should be less than 100.");
                return;
            }
            double d = treeAnnotatorDialog.getPosteriorLimit();
            double d2 = 0.8;
            Target target = treeAnnotatorDialog.getTargetOption();
            HeightsSummary heightsSummary = treeAnnotatorDialog.getHeightsOption();
            string = treeAnnotatorDialog.getTargetFileName();
            if (target == Target.USER_TARGET_TREE && string == null) {
                Log.err.println("No target file specified");
                return;
            }
            string2 = treeAnnotatorDialog.getInputFileName();
            if (string2 == null) {
                Log.err.println("No input file specified");
                return;
            }
            string3 = treeAnnotatorDialog.getOutputFileName();
            if (string3 == null) {
                Log.err.println("No output file specified");
                return;
            }
            boolean bl = treeAnnotatorDialog.useLowMem();
            try {
                new TreeAnnotator(n, bl, heightsSummary, d, d2, target, string, string2, string3);
            }
            catch (Exception exception) {
                Log.err.println("Exception: " + exception.getMessage());
            }
            progressStream.println("Finished - Quit program to exit.");
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(1000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                    continue;
                }
                break;
            }
        }
        TreeAnnotator.printTitle();
        Arguments arguments = new Arguments(new Arguments.Option[]{new Arguments.StringOption("heights", new String[]{"keep", "median", "mean", "ca"}, false, "an option of 'keep' (default), 'median', 'mean' or 'ca'"), new Arguments.IntegerOption("burnin", 0, 99, "the percentage of states to be considered as 'burn-in'"), new Arguments.IntegerOption("b", 0, 99, "the percentage of states to be considered as 'burn-in'"), new Arguments.RealOption("limit", "the minimum posterior probability for a node to be annotated"), new Arguments.StringOption("target", "target_file_name", "specifies a user target tree to be annotated"), new Arguments.Option("help", "option to print this message"), new Arguments.Option("forceDiscrete", "forces integer traits to be treated as discrete traits."), new Arguments.Option("lowMem", "use less memory, which is a bit slower."), new Arguments.RealOption("hpd2D", "the HPD interval to be used for the bivariate traits"), new Arguments.Option("nohpd2D", "suppress calculation of HPD intervals for the bivariate traits"), new Arguments.Option("noSA", "interpret the tree set as begin from a not being from a sampled ancestor analysis, even if there are zero branch lengths in the tree set")});
        try {
            arguments.parseArguments(stringArray);
        }
        catch (Arguments.ArgumentException argumentException) {
            progressStream.println(argumentException);
            TreeAnnotator.printUsage(arguments);
            System.exit(1);
        }
        if (arguments.hasOption("nohpd2D")) {
            processBivariateAttributes = false;
        }
        if (arguments.hasOption("noSA")) {
            processSA = false;
        }
        if (arguments.hasOption("forceDiscrete")) {
            Log.info.println("  Forcing integer traits to be treated as discrete traits.");
            forceIntegerToDiscrete = true;
        }
        if (arguments.hasOption("help")) {
            TreeAnnotator.printUsage(arguments);
            System.exit(0);
        }
        boolean bl = false;
        if (arguments.hasOption("lowMem")) {
            bl = true;
        }
        HeightsSummary heightsSummary = HeightsSummary.CA_HEIGHTS;
        if (arguments.hasOption("heights")) {
            String string7 = arguments.getStringOption("heights");
            if (string7.equalsIgnoreCase("mean")) {
                heightsSummary = HeightsSummary.MEAN_HEIGHTS;
            } else if (string7.equalsIgnoreCase("median")) {
                heightsSummary = HeightsSummary.MEDIAN_HEIGHTS;
            } else if (string7.equalsIgnoreCase("ca")) {
                heightsSummary = HeightsSummary.CA_HEIGHTS;
                Log.info.println("Please cite: Heled and Bouckaert: Looking for trees in the forest:\nsummary tree from posterior samples. BMC Evolutionary Biology 2013 13:221.");
            }
        }
        int n = -1;
        if (arguments.hasOption("burnin")) {
            n = arguments.getIntegerOption("burnin");
        } else if (arguments.hasOption("b")) {
            n = arguments.getIntegerOption("b");
        }
        if (n >= 100) {
            Log.err.println("burnin percentage is " + n + " but should be less than 100.");
            System.exit(1);
        }
        double d = 0.0;
        if (arguments.hasOption("limit")) {
            d = arguments.getRealOption("limit");
        }
        double d3 = 0.8;
        if (arguments.hasOption("hpd2D")) {
            d3 = arguments.getRealOption("hpd2D");
            if (d3 <= 0.0 || d3 >= 1.0) {
                Log.err.println("hpd2D is a fraction and should be in between 0.0 and 1.0.");
                System.exit(1);
            }
            processBivariateAttributes = true;
        }
        Target target = Target.MAX_CLADE_CREDIBILITY;
        if (arguments.hasOption("target")) {
            target = Target.USER_TARGET_TREE;
            string = arguments.getStringOption("target");
        }
        String[] stringArray2 = arguments.getLeftoverArguments();
        switch (stringArray2.length) {
            case 2: {
                string3 = stringArray2[1];
            }
            case 1: {
                string2 = stringArray2[0];
                break;
            }
            default: {
                Log.err.println("Unknown option: " + stringArray2[2]);
                Log.err.println();
                TreeAnnotator.printUsage(arguments);
                System.exit(1);
            }
        }
        try {
            new TreeAnnotator(n, bl, heightsSummary, d, d3, target, string, string2, string3);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (stringArray.length == 0) {
            System.exit(0);
        }
    }

    boolean setTreeHeightsByCA(Tree tree, Target target) throws IOException {
        progressStream.println("Setting node heights...");
        progressStream.println("0              25             50             75            100");
        progressStream.println("|--------------|--------------|--------------|--------------|");
        int n = this.totalTreesUsed / 60;
        if (n < 1) {
            n = 1;
        }
        int n2 = 0;
        CladeSystem cladeSystem = new CladeSystem(tree);
        int n3 = cladeSystem.getCladeMap().size();
        int[] nArray = new int[n3];
        BitSet[] bitSetArray = new BitSet[n3];
        BitSet[] bitSetArray2 = new BitSet[n3];
        for (int i = 0; i < n3; ++i) {
            bitSetArray[i] = new BitSet();
            bitSetArray2[i] = new BitSet();
        }
        cladeSystem.getTreeCladeCodes(tree, bitSetArray);
        double[][] dArray = new double[n3][this.treeSet.totalTrees];
        double[] dArray2 = new double[n3];
        int n4 = 0;
        int n5 = 0;
        this.treeSet.reset();
        while (this.treeSet.hasNext()) {
            int n6;
            Tree tree2 = this.treeSet.next();
            TreeUtils.preOrderTraversalList(tree2, nArray);
            cladeSystem.getTreeCladeCodes(tree2, bitSetArray2);
            for (n6 = 0; n6 < n3; ++n6) {
                int n7 = nArray[n6];
                for (int i = 0; i < n3; ++i) {
                    if (!CollectionUtils.isSubSet(bitSetArray[i], bitSetArray2[n7])) continue;
                    dArray[i][n5] = tree2.getNode(n7).getHeight();
                }
            }
            for (n6 = 0; n6 < n3; ++n6) {
                int n8 = n6;
                dArray2[n8] = dArray2[n8] + dArray[n6][n5];
            }
            ++n4;
            if (n5 > 0 && n5 % n == 0 && n2 < 61) {
                while (1000 * n2 < 61000 * (n5 + 1) / this.totalTreesUsed) {
                    progressStream.print("*");
                    ++n2;
                }
                progressStream.flush();
            }
            ++n5;
        }
        if (target != Target.USER_TARGET_TREE) {
            tree.initAndValidate();
        }
        cladeSystem.removeClades(tree.getRoot(), true);
        for (int i = 0; i < n3; ++i) {
            int n9 = i;
            dArray2[n9] = dArray2[n9] / (double)n4;
            Node node = tree.getNode(i);
            node.setHeight(dArray2[i]);
            String string = "CAheight";
            double[] dArray3 = dArray[i];
            double d = dArray3[0];
            double d2 = dArray3[0];
            for (double d3 : dArray3) {
                d = Math.min(d3, d);
                d2 = Math.max(d3, d2);
            }
            if (!(Math.abs(d - d2) > 1.0E-10)) continue;
            this.annotateMeanAttribute(node, string + "_mean", dArray3);
            this.annotateMedianAttribute(node, string + "_median", dArray3);
            this.annotateHPDAttribute(node, string + "_95%_HPD", 0.95, dArray3);
            this.annotateRangeAttribute(node, string + "_range", dArray3);
        }
        assert (n4 == this.totalTreesUsed);
        this.totalTreesUsed = n4;
        progressStream.println();
        progressStream.println();
        return true;
    }

    public static interface TreeAnnotationPlugin {
        public Set<String> setAttributeNames(Set<String> var1);

        public boolean handleAttribute(Node var1, String var2, double[] var3);
    }

    static enum HeightsSummary {
        CA_HEIGHTS("Common Ancestor heights"),
        MEDIAN_HEIGHTS("Median heights"),
        MEAN_HEIGHTS("Mean heights"),
        KEEP_HEIGHTS("Keep target heights");

        String desc;

        private HeightsSummary(String string2) {
            this.desc = string2;
        }

        public String toString() {
            return this.desc;
        }
    }

    static enum Target {
        MAX_CLADE_CREDIBILITY("Maximum clade credibility tree"),
        MAX_SUM_CLADE_CREDIBILITY("Maximum sum of clade credibilities"),
        USER_TARGET_TREE("User target tree");

        String desc;

        private Target(String string2) {
            this.desc = string2;
        }

        public String toString() {
            return this.desc;
        }
    }

    public class MemoryFriendlyTreeSet
    extends TreeSet {
        int current;
        int lineNr;
        public Map<String, String> translationMap;
        public List<String> taxa;
        int origin;
        BufferedReader fin;

        public MemoryFriendlyTreeSet(String string, int n) throws IOException {
            this.current = 0;
            this.translationMap = null;
            this.origin = -1;
            this.inputFileName = string;
            this.countTrees(n);
            this.fin = new BufferedReader(new FileReader(string));
        }

        @Override
        public void reset() throws FileNotFoundException {
            this.current = 0;
            this.fin = new BufferedReader(new FileReader(new File(this.inputFileName)));
            this.lineNr = 0;
            try {
                while (this.fin.ready()) {
                    String string = this.nextLine();
                    if (string == null) {
                        return;
                    }
                    String string2 = string.toLowerCase();
                    if (!string2.matches("^\\s*begin\\s+trees;\\s*$")) continue;
                    this.parseTreesBlock();
                    return;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new RuntimeException("Around line " + this.lineNr + "\n" + exception.getMessage());
            }
        }

        String nextLine() throws IOException {
            String string = this.readLine();
            if (string == null) {
                return null;
            }
            if (string.matches("^\\s*\\[.*")) {
                int n = string.indexOf(91);
                int n2 = string.indexOf(93, n);
                while (n2 < 0) {
                    string = string + this.readLine();
                    n2 = string.indexOf(93, n);
                }
                if ((string = string.substring(0, n) + string.substring(n2 + 1)).matches("^\\s*$")) {
                    return this.nextLine();
                }
            }
            if (string.matches("^\\s*$")) {
                return this.nextLine();
            }
            return string;
        }

        String readLine() throws IOException {
            if (!this.fin.ready()) {
                return null;
            }
            ++this.lineNr;
            return this.fin.readLine();
        }

        private void parseTreesBlock() throws IOException {
            String string = this.readLine().trim();
            while (string.equals("")) {
                string = this.readLine().trim();
            }
            if (string.toLowerCase().contains("translate")) {
                this.translationMap = this.parseTranslateBlock();
                this.origin = this.getIndexedTranslationMapOrigin(this.translationMap);
                if (this.origin != -1) {
                    this.taxa = this.getIndexedTranslationMap(this.translationMap, this.origin);
                }
            }
            this.current = 0;
            while (this.current < this.burninCount && this.fin.ready()) {
                string = this.nextLine();
                if (!string.toLowerCase().startsWith("tree ")) continue;
                ++this.current;
            }
        }

        private List<String> getIndexedTranslationMap(Map<String, String> map, int n) {
            String[] stringArray = new String[map.size()];
            for (String string : map.keySet()) {
                stringArray[Integer.parseInt((String)string) - n] = map.get(string);
            }
            return Arrays.asList(stringArray);
        }

        private int getIndexedTranslationMapOrigin(Map<String, String> map) {
            java.util.TreeSet<Integer> treeSet = new java.util.TreeSet<Integer>();
            int n = 0;
            for (String string : map.keySet()) {
                int n2 = Integer.parseInt(string);
                treeSet.add(n2);
                ++n;
            }
            if ((Integer)treeSet.last() - (Integer)treeSet.first() == n - 1 && ((Integer)treeSet.first() == 0 || (Integer)treeSet.first() == 1)) {
                return (Integer)treeSet.first();
            }
            return -1;
        }

        private Map<String, String> parseTranslateBlock() throws IOException {
            String[] stringArray;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String string = this.readLine();
            StringBuilder stringBuilder = new StringBuilder();
            while (string != null && !string.trim().toLowerCase().equals(";")) {
                stringBuilder.append(string.trim());
                string = this.readLine();
            }
            for (String string2 : stringArray = stringBuilder.toString().split(",")) {
                Object[] objectArray = string2.split("[\t ]+");
                if (objectArray.length == 2) {
                    hashMap.put(objectArray[0], objectArray[1]);
                    continue;
                }
                Log.err.println("Ignoring translation:" + Arrays.toString(objectArray));
            }
            return hashMap;
        }

        @Override
        public boolean hasNext() {
            return this.current < this.totalTrees;
        }

        @Override
        public Tree next() throws IOException {
            String string = this.nextLine();
            if (!this.isNexus) {
                TreeParser treeParser;
                if (this.origin != -1) {
                    treeParser = new TreeParser(this.taxa, string, this.origin, false);
                } else {
                    try {
                        treeParser = new TreeParser(this.taxa, string, 0, false);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        treeParser = new TreeParser(this.taxa, string, 1, false);
                    }
                }
                return treeParser;
            }
            if (string.toLowerCase().startsWith("tree ")) {
                TreeParser treeParser;
                ++this.current;
                int n = string.indexOf(40);
                if (n > 0) {
                    string = string.substring(n);
                }
                if (this.origin != -1) {
                    treeParser = new TreeParser(this.taxa, string, this.origin, false);
                } else {
                    try {
                        treeParser = new TreeParser(this.taxa, string, 0, false);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        treeParser = new TreeParser(this.taxa, string, 1, false);
                    }
                }
                if (this.translationMap != null) {
                    treeParser.translateLeafIds(this.translationMap);
                }
                return treeParser;
            }
            return null;
        }
    }

    public class FastTreeSet
    extends TreeSet {
        int current;
        Tree[] trees;

        public FastTreeSet(String string, int n) throws IOException {
            List<Object> list;
            Object object;
            this.current = 0;
            this.inputFileName = string;
            this.countTrees(n);
            if (this.isNexus) {
                object = new NexusParser();
                ((NexusParser)object).parseFile(new File(string));
                list = ((NexusParser)object).trees;
            } else {
                object = new BufferedReader(new FileReader(string));
                list = new ArrayList();
                while (((BufferedReader)object).ready()) {
                    TreeParser treeParser;
                    String string2 = ((BufferedReader)object).readLine().trim();
                    try {
                        treeParser = new TreeParser(null, string2, 0, false);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        treeParser = new TreeParser(null, string2, 1, false);
                    }
                    list.add(treeParser);
                }
                ((BufferedReader)object).close();
            }
            int n2 = list.size() - this.burninCount;
            this.trees = new Tree[n2];
            for (int i = this.burninCount; i < list.size(); ++i) {
                this.trees[i - this.burninCount] = (Tree)list.get(i);
            }
        }

        @Override
        public boolean hasNext() {
            return this.current < this.trees.length;
        }

        @Override
        public Tree next() {
            return this.trees[this.current++];
        }

        @Override
        public void reset() {
            this.current = 0;
        }
    }

    public abstract class TreeSet {
        String inputFileName;
        int burninCount = 0;
        int totalTrees = 0;
        boolean isNexus = true;

        public abstract boolean hasNext();

        public abstract Tree next() throws IOException;

        public abstract void reset() throws IOException;

        void countTrees(int n) throws IOException {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(this.inputFileName)));
            if (!bufferedReader.ready()) {
                throw new IOException("File appears empty");
            }
            String string = bufferedReader.readLine();
            if (!string.toUpperCase().trim().startsWith("#NEXUS")) {
                this.isNexus = false;
                if (string.trim().length() > 0) {
                    this.totalTrees = 1;
                }
            }
            while (bufferedReader.ready()) {
                string = bufferedReader.readLine();
                if (this.isNexus) {
                    if (!string.trim().toLowerCase().startsWith("tree ")) continue;
                    ++this.totalTrees;
                    continue;
                }
                if (string.trim().length() <= 0) continue;
                ++this.totalTrees;
            }
            bufferedReader.close();
            this.burninCount = Math.max(0, n * this.totalTrees / 100);
            progressStream.println("Processing " + (this.totalTrees - this.burninCount) + " trees from file" + (n > 0 ? " after ignoring first " + n + "% = " + this.burninCount + " trees." : "."));
        }
    }
}

