/*
 * Decompiled with CFR 0.152.
 */
package beast.app.draw;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JButton;

public class SmallButtonOld
extends JButton {
    private static final long serialVersionUID = 1L;
    protected boolean m_bPressed = false;
    Image image = null;

    public void setImg(Image image) {
        this.image = image;
    }

    public SmallButtonOld(String string, boolean bl) {
        super(string);
        this.enableEvents(16L);
        this.setBackground(new Color(128, 128, 255));
        this.setPreferredSize(new Dimension(15, 15));
        this.setSize(15, 15);
        this.setMinimumSize(new Dimension(15, 15));
        this.setMaximumSize(new Dimension(15, 15));
        this.setEnabled(bl);
    }

    @Override
    public void paint(Graphics graphics) {
        Object object;
        if (this.image != null) {
            graphics.drawImage(this.image, 0, 0, null);
            return;
        }
        int n = 14;
        if (this.isEnabled()) {
            if (this.m_bPressed) {
                object = new GradientPaint(new Point(5, 5), Color.WHITE, new Point(this.getWidth(), this.getHeight()), this.getBackground().darker().darker());
                ((Graphics2D)graphics).setPaint((Paint)object);
            } else {
                object = new GradientPaint(new Point(0, 0), Color.WHITE, new Point(this.getWidth(), this.getHeight()), this.getBackground());
                ((Graphics2D)graphics).setPaint((Paint)object);
            }
        } else {
            graphics.setColor(new Color(240, 240, 240));
        }
        graphics.fillArc(0, 0, n, n, 0, 360);
        graphics.setColor(this.getBackground().darker().darker().darker());
        graphics.drawArc(0, 0, n, n, 0, 360);
        this.getBorder().paintBorder(this, graphics, 0, 0, 15, 15);
        object = this.getFont();
        if (object != null) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            graphics.setColor(this.getForeground());
            graphics.drawString(this.getText(), n / 2 - fontMetrics.stringWidth(this.getText()) / 2 + 0, n / 2 + fontMetrics.getMaxDescent() + 1);
        }
    }

    @Override
    public void processMouseEvent(MouseEvent mouseEvent) {
        switch (mouseEvent.getID()) {
            case 501: {
                this.m_bPressed = true;
                break;
            }
            case 502: {
                if (!this.m_bPressed) break;
                this.m_bPressed = false;
                break;
            }
            case 505: {
                if (!this.m_bPressed) break;
                this.m_bPressed = false;
            }
        }
        super.processMouseEvent(mouseEvent);
        this.repaint();
    }
}

