/*
 * Decompiled with CFR 0.152.
 */
package beast.app.draw;

import beast.app.draw.Arrow;
import beast.app.draw.BEASTObjectPanel;
import beast.app.draw.BEASTObjectSet;
import beast.app.draw.BEASTObjectShape;
import beast.app.draw.InputShape;
import beast.app.draw.Selection;
import beast.app.draw.Shape;
import beast.core.BEASTInterface;
import beast.core.Input;
import beast.core.Runnable;
import beast.core.util.Log;
import beast.util.AddOnManager;
import beast.util.XMLParser;
import beast.util.XMLProducer;
import java.awt.Color;
import java.io.File;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.Scanner;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class Document {
    public List<Shape> m_objects = new ArrayList<Shape>();
    public List<Shape> m_tmpobjects;
    List<UndoAction> m_undoStack = new ArrayList<UndoAction>();
    int m_nCurrentEditAction = -1;
    public boolean m_bIsSaved = true;
    Set<String> tabulist;
    String[] m_sPlugInNames;
    boolean m_bShowALlInputs = false;
    boolean m_bSanitiseIDs = true;
    static final int DX = 120;
    static final int DY = 80;
    static final String PLUGIN_SHAPE_ELEMENT = "pluginshape";
    static final String INPUT_SHAPE_ELEMENT = "inputshape";
    static final String ARROW_ELEMENT = "arrow";
    static final int STATUS_OK = 0;
    static final int STATUS_CYCLE = 1;
    static final int STATUS_NOT_RUNNABLE = 2;
    static final int STATUS_EMPTY_MODEL = 3;
    static final int STATUS_ORPHANS_IN_MODEL = 4;

    public void isSaved() {
        this.m_bIsSaved = true;
    }

    void sChanged() {
        this.m_bIsSaved = false;
    }

    boolean showAllInputs() {
        return this.m_bShowALlInputs;
    }

    boolean sanitiseIDs() {
        return this.m_bSanitiseIDs;
    }

    public Document() {
        List<String> list = AddOnManager.find(BEASTInterface.class, AddOnManager.IMPLEMENTATION_DIR);
        this.m_sPlugInNames = list.toArray(new String[0]);
        this.tabulist = new HashSet<String>();
        Properties properties = new Properties();
        try {
            properties.load(this.getClass().getResourceAsStream("/beast/app/draw/tabulist.properties"));
            String string = properties.getProperty("tabulist");
            for (String string2 : string.split("\\s+")) {
                this.tabulist.add(string2.trim());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void adjustInputs() {
        for (Shape shape : this.m_objects) {
            if (!(shape instanceof BEASTObjectShape)) continue;
            ((BEASTObjectShape)shape).adjustInputs();
        }
    }

    void adjustArrows() {
        for (Shape shape : this.m_objects) {
            if (!(shape instanceof Arrow)) continue;
            Arrow arrow = (Arrow)shape;
            arrow.adjustCoordinates();
        }
    }

    void readjustArrows(List<Shape> list) {
        for (Shape shape : this.m_objects) {
            if (!(shape instanceof Arrow)) continue;
            Arrow arrow = (Arrow)shape;
            arrow.m_sHeadID = arrow.m_headShape.getID();
            arrow.m_sTailID = arrow.m_tailShape.getID();
        }
    }

    public void moveShape(int n, int n2, int n3, int n4, int n5) {
        Object object;
        boolean bl = true;
        if (this.m_nCurrentEditAction == this.m_undoStack.size() - 1 && this.m_nCurrentEditAction >= 0) {
            object = this.m_undoStack.get(this.m_nCurrentEditAction);
            if (((UndoAction)object).m_nActionType == 1 && ((UndoAction)object).isSingleSelection(n5)) {
                bl = false;
            }
        }
        if (bl) {
            this.addUndoAction(new UndoAction(n5, 1));
        }
        object = this.m_objects.get(n5);
        ((Shape)object).movePosition(n, n2, n3, n4);
        this.adjustArrows();
    }

    public void moveShapes(int n, int n2, List<Integer> list) {
        boolean bl = true;
        if (this.m_nCurrentEditAction == this.m_undoStack.size() - 1 && this.m_nCurrentEditAction >= 0) {
            UndoAction undoAction = this.m_undoStack.get(this.m_nCurrentEditAction);
            if (undoAction.m_nActionType == 1 && undoAction.isSelection(list)) {
                bl = false;
            }
        }
        if (bl) {
            this.addUndoAction(new UndoAction(list, 1));
        }
    }

    public void movePoint(int n, int n2, int n3, int n4, int n5, int n6) {
        Object object;
        boolean bl = true;
        if (this.m_nCurrentEditAction == this.m_undoStack.size() - 1 && this.m_nCurrentEditAction >= 0) {
            object = this.m_undoStack.get(this.m_nCurrentEditAction);
            if (((UndoAction)object).m_nActionType == 2 && ((UndoAction)object).isSingleSelection(n6)) {
                bl = false;
            }
        }
        if (bl) {
            this.addUndoAction(new UndoAction(n6, 2));
        }
        object = this.m_objects.get(n6);
        ((Shape)object).movePoint(n, n2, n3, n4, n5);
        this.adjustArrows();
    }

    boolean containsID(String string, List<Shape> list, List<String> list2) {
        for (Shape object : this.m_objects) {
            if (!object.getID().equals(string)) continue;
            return true;
        }
        if (list2 == null) {
            return false;
        }
        for (String string2 : list2) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    String getNewID(List<String> list) {
        int n = this.m_objects.size();
        String string = "id" + n;
        while (this.containsID(string, this.m_objects, list)) {
            string = "id" + ++n;
        }
        return string;
    }

    void setPluginID(BEASTObjectShape bEASTObjectShape) {
        if (bEASTObjectShape.m_beastObject.getID() != null && bEASTObjectShape.m_beastObject.getID().length() > 0) {
            return;
        }
        BEASTInterface bEASTInterface = bEASTObjectShape.m_beastObject;
        String string = bEASTInterface.getClass().getName().replaceAll(".*\\.", "");
        int n = 0;
        while (this.containsID(string + n, this.m_objects, null)) {
            ++n;
        }
        bEASTInterface.setID(string + n);
    }

    Shape getShapeByID(String string) {
        for (Shape shape : this.m_objects) {
            if (!shape.getID().equals(string)) continue;
            return shape;
        }
        return null;
    }

    public void addNewShape(Shape shape) {
        if (shape.getID() == null || shape.getID().equals("") || this.containsID(shape.getID(), this.m_objects, null)) {
            if (shape instanceof Arrow) {
                ((Arrow)shape).setID(this.getNewID(null));
            }
            if (shape instanceof BEASTObjectShape) {
                this.setPluginID((BEASTObjectShape)shape);
            }
        }
        this.m_objects.add(shape);
        if (shape instanceof BEASTObjectShape) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            arrayList.add(this.m_objects.size() - 1);
            this.checkForOtherPluginShapes(arrayList, (BEASTObjectShape)shape);
            if (arrayList.size() == 1) {
                this.addUndoAction(new PluginAction(this.m_objects.size() - 1, 3));
            } else {
                this.addUndoAction(new MultiObjectAction(arrayList, 20));
            }
        } else if (shape instanceof Arrow) {
            this.addUndoAction(new ArrowAction(this.m_objects.size() - 1, 5));
        }
    }

    void checkForOtherPluginShapes(List<Integer> list, BEASTObjectShape bEASTObjectShape) {
        try {
            List<Input<?>> list2 = bEASTObjectShape.m_beastObject.listInputs();
            for (Input<?> input : list2) {
                if (!(input.get() instanceof BEASTInterface)) continue;
                BEASTInterface bEASTInterface = (BEASTInterface)input.get();
                BEASTObjectShape bEASTObjectShape2 = new BEASTObjectShape(bEASTInterface, this);
                bEASTObjectShape2.m_x = Math.max(bEASTObjectShape.m_x - 120, 0);
                bEASTObjectShape2.m_y = bEASTObjectShape.m_y;
                bEASTObjectShape2.m_w = 100;
                bEASTObjectShape2.m_h = 80;
                this.setPluginID(bEASTObjectShape2);
                this.m_objects.add(bEASTObjectShape2);
                list.add(this.m_objects.size() - 1);
                Arrow arrow = new Arrow(bEASTObjectShape2, bEASTObjectShape, input.getName());
                this.m_objects.add(arrow);
                list.add(this.m_objects.size() - 1);
                this.checkForOtherPluginShapes(list, bEASTObjectShape2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    List<Integer> getConnectedArrows(List<String> list, List<Integer> list2) {
        for (int i = 0; i < this.m_objects.size(); ++i) {
            Shape shape = this.m_objects.get(i);
            if (!(shape instanceof Arrow)) continue;
            Arrow arrow = (Arrow)shape;
            for (int j = 0; j < list.size(); ++j) {
                if (!arrow.m_sHeadID.startsWith(list.get(j)) && !arrow.m_sTailID.equals(list.get(j)) || list2.contains(new Integer(i))) continue;
                list2.add(new Integer(i));
            }
        }
        return list2;
    }

    List<String> getIncomingArrows(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.m_objects.size(); ++i) {
            Shape shape = this.m_objects.get(i);
            if (!(shape instanceof Arrow)) continue;
            Arrow arrow = (Arrow)shape;
            for (int j = 0; j < list.size(); ++j) {
                if (!arrow.m_sHeadID.equals(list.get(j)) || arrayList.contains(arrow.m_sTailID)) continue;
                arrayList.add(arrow.m_sTailID);
            }
        }
        return arrayList;
    }

    List<String> getOutgoingArrows(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.m_objects.size(); ++i) {
            Shape shape = this.m_objects.get(i);
            if (!(shape instanceof Arrow)) continue;
            Arrow arrow = (Arrow)shape;
            for (int j = 0; j < list.size(); ++j) {
                if (!arrow.m_sTailID.equals(list.get(j)) || arrayList.contains(arrow.m_sTailID)) continue;
                arrayList.add(arrow.m_sTailID);
            }
        }
        return arrayList;
    }

    public void deleteShapes(List<Integer> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(this.m_objects.get(list.get(i)).getID());
        }
        list = this.getConnectedArrows(arrayList, list);
        MultiObjectAction multiObjectAction = new MultiObjectAction(list, 21);
        this.addUndoAction(multiObjectAction);
        ((UndoAction)multiObjectAction).redo();
    }

    void ensureUniqueID(Shape shape, List<String> list) {
        if (shape.getID() == null || shape.getID().equals("") || this.containsID(shape.getID(), this.m_objects, list)) {
            if (shape instanceof Arrow) {
                ((Arrow)shape).setID(this.getNewID(list));
            }
            if (shape instanceof BEASTObjectShape) {
                this.setPluginID((BEASTObjectShape)shape);
            }
        }
        list.add(shape.getID());
    }

    public void pasteShape(String string) {
        List<Shape> list = this.XML2Shapes(string, true);
        if (list.size() == 0) {
            return;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (Shape shape : list) {
            if (shape instanceof Arrow) {
                ((Arrow)shape).setID(this.getNewID(null));
            }
            if (shape instanceof BEASTObjectShape) {
                ((BEASTObjectShape)shape).m_beastObject.setID(null);
                this.setPluginID((BEASTObjectShape)shape);
                int n = 0;
                boolean bl = false;
                do {
                    bl = false;
                    for (Shape shape2 : this.m_objects) {
                        if (shape2.m_x != shape.m_x + n || shape2.m_y != shape.m_y + n || shape2.m_w != shape.m_w || shape2.m_h != shape.m_h) continue;
                        bl = true;
                        n += 10;
                    }
                } while (bl);
                shape.m_x += n;
                shape.m_y += n;
            }
            this.m_objects.add(shape);
            arrayList.add(this.m_objects.size() - 1);
        }
        this.addUndoAction(new MultiObjectAction(arrayList, 20));
    }

    public void collapse(Selection selection) {
    }

    void findAffectedShapes(Shape shape, List<Integer> list) {
        if (shape instanceof InputShape) {
            this.findInputs((InputShape)shape, list);
        } else {
            for (InputShape inputShape : ((BEASTObjectShape)shape).m_inputs) {
                this.findInputs(inputShape, list);
            }
        }
    }

    void findInputs(InputShape inputShape, List<Integer> list) {
        for (Shape shape : this.m_objects) {
            if (!(shape instanceof Arrow)) continue;
            Arrow arrow = (Arrow)shape;
            if (!arrow.m_sHeadID.equals(inputShape.getID())) continue;
            String string = arrow.m_sTailID;
            for (int i = 0; i < this.m_objects.size(); ++i) {
                if (!this.m_objects.get(i).getID().equals(string)) continue;
                list.add(i);
            }
        }
    }

    public void setFillColor(Color color, Selection selection) {
        if (selection.isSingleSelection()) {
            this.addUndoAction(new UndoAction(selection.getSingleSelection(), 5));
        } else {
            this.addUndoAction(new UndoAction(selection.m_Selection, 1));
        }
        for (int i = 0; i < selection.m_Selection.size(); ++i) {
            int n = selection.m_Selection.get(i);
            Shape shape = this.m_objects.get(n);
            shape.setFillColor(color);
        }
    }

    public void setPenColor(Color color, Selection selection) {
        if (selection.isSingleSelection()) {
            this.addUndoAction(new UndoAction(selection.getSingleSelection(), 6));
        } else {
            this.addUndoAction(new UndoAction(selection.m_Selection, 1));
        }
        for (int i = 0; i < selection.m_Selection.size(); ++i) {
            int n = selection.m_Selection.get(i);
            Shape shape = this.m_objects.get(n);
            shape.setPenColor(color);
        }
    }

    int getPositionX(int n) {
        Shape shape = this.m_objects.get(n);
        return shape.getX();
    }

    int getPositionY(int n) {
        Shape shape = this.m_objects.get(n);
        return shape.getY();
    }

    int getPositionX2(int n) {
        Shape shape = this.m_objects.get(n);
        return shape.getX2();
    }

    int getPositionY2(int n) {
        Shape shape = this.m_objects.get(n);
        return shape.getY2();
    }

    void setPositionX(int n, int n2) {
        Shape shape = this.m_objects.get(n2);
        shape.setX(n);
    }

    void setPositionY(int n, int n2) {
        Shape shape = this.m_objects.get(n2);
        shape.setY(n);
    }

    void setPositionX2(int n, int n2) {
        Shape shape = this.m_objects.get(n2);
        shape.setX2(n);
    }

    void setPositionY2(int n, int n2) {
        Shape shape = this.m_objects.get(n2);
        shape.setY2(n);
    }

    public void setID(String string, int n) {
        this.addUndoAction(new UndoAction(n, 7));
        Shape shape = this.m_objects.get(n);
        ((BEASTObjectShape)shape).m_beastObject.setID(string);
    }

    public void toggleFilled(int n) {
        this.addUndoAction(new UndoAction(n, 10));
        Shape shape = this.m_objects.get(n);
        shape.toggleFilled();
    }

    void setInputValue(BEASTObjectShape bEASTObjectShape, String string, String string2) {
        this.addUndoAction(new SetInputAction(bEASTObjectShape, string, string2));
    }

    public void toFront(Selection selection) {
        if (selection.m_Selection.size() == 0) {
            return;
        }
        int[] nArray = new int[selection.m_Selection.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.m_objects.size() - 1 - i;
        }
        int[] nArray2 = new int[selection.m_Selection.size()];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = selection.m_Selection.get(i);
        }
        Arrays.sort(nArray2);
        int[] nArray3 = new int[selection.m_Selection.size()];
        for (int i = 0; i < nArray3.length; ++i) {
            nArray3[i] = nArray2[nArray3.length - 1 - i];
        }
        ReorderAction reorderAction = new ReorderAction(nArray3, nArray);
        this.addUndoAction(reorderAction);
        reorderAction.reorder(nArray3, nArray);
        selection.setSelection(nArray);
    }

    public void toBack(Selection selection) {
        if (selection.m_Selection.size() == 0) {
            return;
        }
        int[] nArray = new int[selection.m_Selection.size()];
        for (int i = 0; i < selection.m_Selection.size(); ++i) {
            nArray[i] = i;
        }
        int[] nArray2 = new int[selection.m_Selection.size()];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = selection.m_Selection.get(i);
        }
        Arrays.sort(nArray2);
        ReorderAction reorderAction = new ReorderAction(nArray2, nArray);
        this.addUndoAction(reorderAction);
        reorderAction.reorder(nArray2, nArray);
        selection.setSelection(nArray);
    }

    public void forward(Selection selection) {
        if (selection.m_Selection.size() == 0) {
            return;
        }
        int[] nArray = new int[selection.m_Selection.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = selection.m_Selection.get(i);
        }
        Arrays.sort(nArray);
        int[] nArray2 = new int[selection.m_Selection.size()];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = nArray[nArray2.length - 1 - i];
        }
        int[] nArray3 = new int[selection.m_Selection.size()];
        for (int i = 0; i < nArray3.length; ++i) {
            nArray3[i] = nArray2[i] < this.m_objects.size() - 1 ? nArray2[i] + 1 : this.m_objects.size() - 1;
        }
        ReorderAction reorderAction = new ReorderAction(nArray2, nArray3);
        this.addUndoAction(reorderAction);
        reorderAction.reorder(nArray2, nArray3);
        selection.setSelection(nArray3);
    }

    public void backward(Selection selection) {
        if (selection.m_Selection.size() == 0) {
            return;
        }
        int[] nArray = new int[selection.m_Selection.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = selection.m_Selection.get(i);
        }
        Arrays.sort(nArray);
        int[] nArray2 = new int[selection.m_Selection.size()];
        for (int i = 0; i < selection.m_Selection.size(); ++i) {
            if (nArray[i] <= 0) continue;
            nArray2[i] = nArray[i] - 1;
        }
        ReorderAction reorderAction = new ReorderAction(nArray, nArray2);
        this.addUndoAction(reorderAction);
        reorderAction.reorder(nArray, nArray2);
        selection.setSelection(nArray2);
    }

    public void alignLeft(Selection selection) {
        int n;
        int n2;
        this.addUndoAction(new UndoAction(selection.m_Selection, 1));
        List<Integer> list = selection.m_Selection;
        int n3 = -1;
        for (n2 = 0; n2 < list.size(); ++n2) {
            n = this.getPositionX(list.get(n2));
            if (n >= n3 && n2 != 0) continue;
            n3 = n;
        }
        for (n2 = 0; n2 < list.size(); ++n2) {
            n = list.get(n2);
            this.setPositionX(n3, n);
        }
        this.adjustArrows();
    }

    public void alignRight(Selection selection) {
        int n;
        int n2;
        this.addUndoAction(new UndoAction(selection.m_Selection, 1));
        List<Integer> list = selection.m_Selection;
        int n3 = -1;
        for (n2 = 0; n2 < list.size(); ++n2) {
            n = this.getPositionX2(list.get(n2));
            if (n <= n3 && n2 != 0) continue;
            n3 = n;
        }
        for (n2 = 0; n2 < list.size(); ++n2) {
            n = list.get(n2);
            int n4 = this.getPositionX2(n) - this.getPositionX(n);
            this.setPositionX(n3 - n4, n);
        }
        this.adjustArrows();
    }

    public void alignTop(Selection selection) {
        int n;
        int n2;
        this.addUndoAction(new UndoAction(selection.m_Selection, 1));
        List<Integer> list = selection.m_Selection;
        int n3 = -1;
        for (n2 = 0; n2 < list.size(); ++n2) {
            n = this.getPositionY(list.get(n2));
            if (n >= n3 && n2 != 0) continue;
            n3 = n;
        }
        for (n2 = 0; n2 < list.size(); ++n2) {
            n = list.get(n2);
            this.setPositionY(n3, n);
        }
        this.adjustArrows();
    }

    public void alignBottom(Selection selection) {
        int n;
        int n2;
        this.addUndoAction(new UndoAction(selection.m_Selection, 1));
        List<Integer> list = selection.m_Selection;
        int n3 = -1;
        for (n2 = 0; n2 < list.size(); ++n2) {
            n = this.getPositionY2(list.get(n2));
            if (n <= n3 && n2 != 0) continue;
            n3 = n;
        }
        for (n2 = 0; n2 < list.size(); ++n2) {
            n = list.get(n2);
            int n4 = this.getPositionY2(n) - this.getPositionY(n);
            this.setPositionY(n3 - n4, n);
        }
        this.adjustArrows();
    }

    public void centreHorizontal(Selection selection) {
        int n;
        int n2;
        this.addUndoAction(new UndoAction(selection.m_Selection, 1));
        List<Integer> list = selection.m_Selection;
        int n3 = -1;
        int n4 = -1;
        for (n2 = 0; n2 < list.size(); ++n2) {
            n = (this.getPositionY(list.get(n2)) + this.getPositionY2(list.get(n2))) / 2;
            if (n < n3 || n2 == 0) {
                n3 = n;
            }
            if (n <= n4 && n2 != 0) continue;
            n4 = n;
        }
        for (n2 = 0; n2 < list.size(); ++n2) {
            n = list.get(n2);
            int n5 = (this.getPositionY2(n) - this.getPositionY(n)) / 2;
            this.setPositionY((n3 + n4) / 2 - n5, n);
        }
        this.adjustArrows();
    }

    public void centreVertical(Selection selection) {
        int n;
        int n2;
        this.addUndoAction(new UndoAction(selection.m_Selection, 1));
        List<Integer> list = selection.m_Selection;
        int n3 = -1;
        int n4 = -1;
        for (n2 = 0; n2 < list.size(); ++n2) {
            n = (this.getPositionX(list.get(n2)) + this.getPositionX2(list.get(n2))) / 2;
            if (n < n3 || n2 == 0) {
                n3 = n;
            }
            if (n <= n4 && n2 != 0) continue;
            n4 = n;
        }
        for (n2 = 0; n2 < list.size(); ++n2) {
            n = list.get(n2);
            int n5 = (this.getPositionX2(n) - this.getPositionX(n)) / 2;
            this.setPositionX((n3 + n4) / 2 - n5, n);
        }
        this.adjustArrows();
    }

    public void spaceHorizontal(Selection selection) {
        int n;
        int n2;
        this.addUndoAction(new UndoAction(selection.m_Selection, 1));
        List<Integer> list = selection.m_Selection;
        int n3 = -1;
        int n4 = -1;
        for (n2 = 0; n2 < list.size(); ++n2) {
            n = this.getPositionX(list.get(n2));
            if (n < n3 || n2 == 0) {
                n3 = n;
            }
            if (n <= n4 && n2 != 0) continue;
            n4 = n;
        }
        for (n2 = 0; n2 < list.size(); ++n2) {
            n = list.get(n2);
            this.setPositionX((int)((double)n3 + (double)(n2 * (n4 - n3)) / ((double)list.size() - 1.0)), n);
        }
        this.adjustArrows();
    }

    public void spaceVertical(Selection selection) {
        int n;
        int n2;
        this.addUndoAction(new UndoAction(selection.m_Selection, 1));
        List<Integer> list = selection.m_Selection;
        int n3 = -1;
        int n4 = -1;
        for (n2 = 0; n2 < list.size(); ++n2) {
            n = this.getPositionY(list.get(n2));
            if (n < n3 || n2 == 0) {
                n3 = n;
            }
            if (n <= n4 && n2 != 0) continue;
            n4 = n;
        }
        for (n2 = 0; n2 < list.size(); ++n2) {
            n = list.get(n2);
            this.setPositionY((int)((double)n3 + (double)(n2 * (n4 - n3)) / ((double)list.size() - 1.0)), n);
        }
        this.adjustArrows();
    }

    void addUndoAction(UndoAction undoAction) {
        int n = this.m_undoStack.size() - 1;
        while (n > this.m_nCurrentEditAction) {
            this.m_undoStack.remove(n--);
        }
        this.m_undoStack.add(undoAction);
        ++this.m_nCurrentEditAction;
    }

    public void clearUndoStack() {
        this.m_undoStack = new ArrayList<UndoAction>();
        this.m_nCurrentEditAction = -1;
    }

    public boolean canUndo() {
        return this.m_nCurrentEditAction > -1;
    }

    public boolean canRedo() {
        return this.m_nCurrentEditAction < this.m_undoStack.size() - 1;
    }

    public void undo() {
        if (!this.canUndo()) {
            return;
        }
        UndoAction undoAction = this.m_undoStack.get(this.m_nCurrentEditAction);
        undoAction.undo();
        this.adjustInputs();
        this.recalcArrows();
        this.adjustArrows();
        --this.m_nCurrentEditAction;
    }

    public void redo() {
        if (!this.canRedo()) {
            return;
        }
        ++this.m_nCurrentEditAction;
        UndoAction undoAction = this.m_undoStack.get(this.m_nCurrentEditAction);
        undoAction.redo();
        this.adjustInputs();
        this.recalcArrows();
        this.adjustArrows();
    }

    BEASTObjectShape getPluginShapeWithLabel(String string) {
        for (Shape shape : this.m_objects) {
            if (!(shape instanceof BEASTObjectShape) || shape.getLabel() == null || !shape.getLabel().equals(string)) continue;
            return (BEASTObjectShape)shape;
        }
        return null;
    }

    InputShape getInputShapeWithID(String string) {
        for (Shape shape : this.m_objects) {
            if (!(shape instanceof InputShape) || shape.getID() == null || !shape.getID().equals(string)) continue;
            return (InputShape)shape;
        }
        return null;
    }

    void addInput(BEASTObjectShape bEASTObjectShape, Object object, int n, String string) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (object instanceof BEASTInterface) {
            BEASTObjectShape bEASTObjectShape2 = this.getPluginShapeWithLabel(((BEASTInterface)object).getID());
            if (bEASTObjectShape2 == null) {
                bEASTObjectShape2 = new BEASTObjectShape((BEASTInterface)object, this);
                bEASTObjectShape2.m_x = n * 120;
                bEASTObjectShape2.m_w = 80;
                bEASTObjectShape2.m_beastObject = (BEASTInterface)object;
                this.setPluginID(bEASTObjectShape2);
                this.m_objects.add(bEASTObjectShape2);
            }
            this.process(bEASTObjectShape2, n);
        }
    }

    void process(BEASTObjectShape bEASTObjectShape, int n) throws IllegalArgumentException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        BEASTInterface bEASTInterface = bEASTObjectShape.m_beastObject;
        List<Input<?>> list = bEASTInterface.listInputs();
        for (Input<?> input : list) {
            Object obj = input.get();
            if (obj == null) continue;
            if (obj instanceof List) {
                for (Object e : (List)obj) {
                    this.addInput(bEASTObjectShape, e, n + 1, input.getName());
                }
                continue;
            }
            if (!(obj instanceof BEASTInterface)) continue;
            this.addInput(bEASTObjectShape, obj, n + 1, input.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFile(String string) {
        this.m_objects.clear();
        XMLParser xMLParser = new XMLParser();
        try {
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = System.getProperty("line.separator");
            try (Scanner scanner = new Scanner(new File(string));){
                while (scanner.hasNextLine()) {
                    stringBuilder.append(scanner.nextLine() + string2);
                }
            }
            BEASTInterface bEASTInterface = xMLParser.parseBareFragment(stringBuilder.toString(), false);
            this.init(bEASTInterface);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void reinit() {
        String string = this.toXML();
        this.m_objects.clear();
        try {
            XMLParser xMLParser = new XMLParser();
            BEASTInterface bEASTInterface = xMLParser.parseBareFragment(string, false);
            this.init(bEASTInterface);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void init(BEASTInterface bEASTInterface) {
        try {
            if (bEASTInterface instanceof BEASTObjectSet) {
                List<BEASTInterface> list = ((BEASTObjectSet)bEASTInterface).m_plugins.get();
                if (list == null) {
                    return;
                }
                for (BEASTInterface bEASTInterface2 : list) {
                    BEASTObjectShape bEASTObjectShape = new BEASTObjectShape(bEASTInterface2, this);
                    bEASTObjectShape.m_beastObject = bEASTInterface2;
                    this.setPluginID(bEASTObjectShape);
                    this.m_objects.add(bEASTObjectShape);
                    this.process(bEASTObjectShape, 1);
                    bEASTObjectShape.m_x = 120;
                    bEASTObjectShape.m_w = 100;
                    Random random = new Random();
                    bEASTObjectShape.m_y = random.nextInt(800);
                    bEASTObjectShape.m_h = 50;
                }
            } else {
                BEASTObjectShape bEASTObjectShape = new BEASTObjectShape(bEASTInterface, this);
                bEASTObjectShape.m_beastObject = bEASTInterface;
                this.setPluginID(bEASTObjectShape);
                this.m_objects.add(bEASTObjectShape);
                this.process(bEASTObjectShape, 1);
                bEASTObjectShape.m_x = 120;
                bEASTObjectShape.m_w = 100;
                Random random = new Random();
                bEASTObjectShape.m_y = random.nextInt(800);
                bEASTObjectShape.m_h = 50;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.clearUndoStack();
        this.recalcArrows();
        this.layout();
        this.adjustArrows();
    }

    List<Shape> XML2Shapes(String string, boolean bl) {
        ArrayList<Shape> arrayList = new ArrayList<Shape>();
        this.m_tmpobjects = arrayList;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(false);
            org.w3c.dom.Document document = documentBuilderFactory.newDocumentBuilder().parse(new InputSource(new StringReader(string)));
            document.normalize();
            NodeList nodeList = document.getDocumentElement().getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                arrayList.add(Document.parseNode(node, this, bl));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.m_tmpobjects = null;
        return arrayList;
    }

    static Shape parseNode(Node node, Document document, boolean bl) {
        Shape shape = null;
        if (node.getNodeName().equals(INPUT_SHAPE_ELEMENT) && bl) {
            shape = new InputShape(node, document, bl);
        } else if (node.getNodeName().equals(ARROW_ELEMENT) && bl) {
            shape = new Arrow(node, document, bl);
        } else if (node.getNodeName().equals(PLUGIN_SHAPE_ELEMENT)) {
            shape = new BEASTObjectShape(node, document, bl);
        }
        return shape;
    }

    public String toXML() {
        XMLProducer xMLProducer = new XMLProducer();
        BEASTObjectSet bEASTObjectSet = this.calcPluginSet();
        if (bEASTObjectSet.m_plugins.get().size() == 1) {
            return xMLProducer.toXML(bEASTObjectSet.m_plugins.get().get(0));
        }
        return xMLProducer.toXML(bEASTObjectSet);
    }

    BEASTObjectSet calcPluginSet() {
        Collection<BEASTInterface> collection = this.getPlugins();
        HashMap<BEASTInterface, List<BEASTInterface>> hashMap = BEASTObjectPanel.getOutputs(collection);
        BEASTObjectSet bEASTObjectSet = new BEASTObjectSet();
        for (BEASTInterface bEASTInterface : hashMap.keySet()) {
            if (hashMap.get(bEASTInterface).size() != 0) continue;
            try {
                bEASTObjectSet.setInputValue("beastObject", bEASTInterface);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return bEASTObjectSet;
    }

    Collection<BEASTInterface> getPlugins() {
        HashSet<BEASTInterface> hashSet = new HashSet<BEASTInterface>();
        for (Shape shape : this.m_objects) {
            if (!(shape instanceof BEASTObjectShape)) continue;
            hashSet.add(((BEASTObjectShape)shape).m_beastObject);
        }
        return hashSet;
    }

    boolean isAscendant(BEASTInterface bEASTInterface, BEASTInterface bEASTInterface2) {
        Collection<BEASTInterface> collection = this.getPlugins();
        List<BEASTInterface> list = BEASTObjectPanel.listAscendants(bEASTInterface2, collection);
        return list.contains(bEASTInterface);
    }

    Shape findObjectWithID(String string) {
        int n;
        if (this.m_tmpobjects != null) {
            for (n = 0; n < this.m_tmpobjects.size(); ++n) {
                if (!this.m_tmpobjects.get(n).getID().equals(string)) continue;
                return this.m_tmpobjects.get(n);
            }
        }
        for (n = 0; n < this.m_objects.size(); ++n) {
            if (!this.m_objects.get(n).getID().equals(string)) continue;
            return this.m_objects.get(n);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    void layout() {
        void var4_15;
        HashMap<BEASTObjectShape, List<BEASTObjectShape>> hashMap = new HashMap<BEASTObjectShape, List<BEASTObjectShape>>();
        HashMap hashMap2 = new HashMap();
        for (Shape object : this.m_objects) {
            if (!(object instanceof BEASTObjectShape) || !object.m_bNeedsDrawing) continue;
            hashMap.put((BEASTObjectShape)object, new ArrayList());
            hashMap2.put((BEASTObjectShape)object, new ArrayList());
        }
        for (Shape shape : this.m_objects) {
            if (!(shape instanceof Arrow) || !shape.m_bNeedsDrawing) continue;
            Shape shape2 = ((Arrow)shape).m_headShape;
            BEASTObjectShape bEASTObjectShape = shape2.m_beastObjectShape;
            Iterator iterator = ((Arrow)shape).m_tailShape;
            hashMap.get(bEASTObjectShape).add((BEASTObjectShape)((Object)iterator));
            ((List)hashMap2.get(iterator)).add(bEASTObjectShape);
        }
        for (Shape shape : hashMap.keySet()) {
            shape.m_x = 120;
        }
        boolean bl = true;
        while (bl) {
            bl = false;
            for (Shape shape2 : hashMap.keySet()) {
                int n = -120;
                for (Shape shape : hashMap.get(shape2)) {
                    n = Math.max(n, shape.m_x);
                }
                if (shape2.m_x >= n + 120) continue;
                shape2.m_x = n + 120;
                bl = true;
            }
        }
        bl = true;
        while (bl) {
            bl = false;
            for (Shape shape2 : hashMap2.keySet()) {
                int n = Integer.MAX_VALUE;
                for (Shape shape : (List)hashMap2.get(shape2)) {
                    n = Math.min(n, shape.m_x);
                }
                if (n >= Integer.MAX_VALUE || shape2.m_x >= n - 120) continue;
                shape2.m_x = n - 120;
                bl = true;
            }
        }
        this.layoutAdjustY(hashMap);
        Log.warning.print("Relax...");
        boolean bl2 = false;
        while (var4_15 < 250) {
            this.relax(false);
            ++var4_15;
        }
        Log.warning.println("Done");
        this.layoutAdjustY(hashMap);
        this.adjustInputs();
    }

    void layoutAdjustY(HashMap<BEASTObjectShape, List<BEASTObjectShape>> hashMap) {
        boolean bl = true;
        int n = 120;
        while (bl) {
            Object object2;
            ArrayList<BEASTObjectShape> arrayList = new ArrayList<BEASTObjectShape>();
            for (BEASTObjectShape bEASTObjectShape : hashMap.keySet()) {
                if (bEASTObjectShape.m_x != n) continue;
                arrayList.add(bEASTObjectShape);
            }
            int n2 = 1;
            HashMap<Integer, Object> object22 = new HashMap<Integer, Object>();
            for (Object object2 : arrayList) {
                List<BEASTObjectShape> list = hashMap.get(object2);
                if (list.size() == 0) {
                    ((BEASTObjectShape)object2).m_y = n2 * 80;
                } else {
                    ((BEASTObjectShape)object2).m_y = 0;
                    for (Shape shape : list) {
                        ((BEASTObjectShape)object2).m_y += shape.m_y;
                    }
                    ((BEASTObjectShape)object2).m_y /= list.size();
                }
                while (object22.containsKey(((BEASTObjectShape)object2).m_y)) {
                    ++((BEASTObjectShape)object2).m_y;
                }
                object22.put(((BEASTObjectShape)object2).m_y, object2);
                ++n2;
            }
            int n3 = 0;
            object2 = new ArrayList();
            ((ArrayList)object2).addAll(object22.keySet());
            Collections.sort(object2);
            int n4 = 0;
            Iterator<BEASTObjectShape> iterator = ((ArrayList)object2).iterator();
            while (iterator.hasNext()) {
                Integer n5 = (Integer)((Object)iterator.next());
                BEASTObjectShape bEASTObjectShape = (BEASTObjectShape)object22.get(n5);
                if (bEASTObjectShape.m_y < n3 + 80) {
                    n4 = n3 + 80 - bEASTObjectShape.m_y;
                    bEASTObjectShape.m_y = n3 + 80;
                }
                n3 = bEASTObjectShape.m_y;
            }
            if (n4 > 0) {
                n4 /= arrayList.size();
                for (BEASTObjectShape bEASTObjectShape : arrayList) {
                    bEASTObjectShape.m_y -= n4;
                }
            }
            bl = arrayList.size() > 0;
            n += 120;
        }
    }

    public void relax(boolean bl) {
        Object object;
        Arrow arrow;
        ArrayList<Shape> arrayList = new ArrayList<Shape>();
        for (Shape iterator : this.m_objects) {
            if (!iterator.m_bNeedsDrawing) continue;
            arrayList.add(iterator);
        }
        HashMap hashMap = new HashMap();
        for (Shape shape : arrayList) {
            if (!(shape instanceof Arrow)) continue;
            arrow = (Arrow)shape;
            object = arrow.m_tailShape.getID();
            if (!(arrow.m_headShape instanceof InputShape)) continue;
            String string = arrow.m_headShape.m_beastObjectShape.getID();
            if (hashMap.containsKey(object)) {
                hashMap.put(object, (Integer)hashMap.get(object) + 1);
            } else {
                hashMap.put(object, 1);
            }
            if (hashMap.containsKey(string)) {
                hashMap.put(string, (Integer)hashMap.get(string) + 1);
                continue;
            }
            hashMap.put(string, 1);
        }
        for (Shape shape : arrayList) {
            if (!(shape instanceof Arrow)) continue;
            arrow = (Arrow)shape;
            object = arrow.m_tailShape;
            int n = ((Shape)object).m_x + ((Shape)object).m_w / 2;
            int n2 = ((Shape)object).m_y + ((Shape)object).m_h / 2;
            if (!(arrow.m_headShape instanceof InputShape)) continue;
            BEASTObjectShape bEASTObjectShape = arrow.m_headShape.m_beastObjectShape;
            int n3 = bEASTObjectShape.m_x + bEASTObjectShape.m_w / 2;
            int n4 = bEASTObjectShape.m_y + bEASTObjectShape.m_h / 2;
            double d = n - n3;
            double d2 = n2 - n4;
            double d3 = Math.sqrt(d * d + d2 * d2);
            double d4 = 150.0;
            d3 = d3 == 0.0 ? 1.0E-4 : d3;
            double d5 = 0.3333333333333333 * (d4 - d3) / d3;
            int n5 = (Integer)hashMap.get(((Shape)object).getID());
            int n6 = (Integer)hashMap.get(((Shape)bEASTObjectShape).getID());
            double d6 = Math.min((d5 *= Math.pow(0.99, n5 + n6 - 2)) * d, 3.0);
            double d7 = Math.min(d5 * d2, 3.0);
            if (d > -200.0 && d < 0.0) {
                d6 = -d6;
            }
            if (bl) {
                ((Shape)object).m_x = (int)Math.max(100.0, (double)((Shape)object).m_x + d6);
            }
            ((Shape)object).m_y = (int)Math.max(10.0, (double)((Shape)object).m_y + d7);
            if (bl) {
                bEASTObjectShape.m_x = (int)Math.max(100.0, (double)bEASTObjectShape.m_x - d6);
            }
            bEASTObjectShape.m_y = (int)Math.max(10.0, (double)bEASTObjectShape.m_y - d7);
        }
        for (Shape shape : arrayList) {
            if (!(shape instanceof BEASTObjectShape)) continue;
            int n = shape.m_x + shape.m_w / 2;
            int n7 = shape.m_y + shape.m_h / 2;
            double d = 0.0;
            double d8 = 0.0;
            for (Shape shape2 : arrayList) {
                if (!(shape2 instanceof BEASTObjectShape)) continue;
                int n8 = shape2.m_x + shape2.m_w / 2;
                double d9 = n - n8;
                int n9 = shape2.m_y + shape2.m_h / 2;
                double d10 = n7 - n9;
                double d11 = Math.sqrt(d9 * d9 + d10 * d10);
                if (d11 == 0.0) {
                    d += Math.random() * 1.0;
                    d8 += Math.random() * 5.0;
                    continue;
                }
                if (!(d11 < 300.0)) continue;
                double d12 = 500.0;
                d += d12 * d9 / d11 / d11;
                d8 += d12 * d10 / d11 / d11;
            }
            if (bl) {
                shape.m_x = (int)Math.min(800.0, Math.max(10.0, (double)shape.m_x + d));
            }
            shape.m_y = (int)Math.min(800.0, Math.max(10.0, (double)shape.m_y + d8));
        }
        for (Shape shape : arrayList) {
            if (!(shape instanceof BEASTObjectShape)) continue;
            ((BEASTObjectShape)shape).adjustInputs();
        }
        this.adjustArrows();
    }

    int isValidModel() {
        BEASTObjectSet bEASTObjectSet = this.calcPluginSet();
        if (bEASTObjectSet.m_plugins.get().size() == 0) {
            return 3;
        }
        if (bEASTObjectSet.m_plugins.get().size() > 1) {
            return 4;
        }
        boolean bl = false;
        for (BEASTInterface bEASTInterface : bEASTObjectSet.m_plugins.get()) {
            if (!(bEASTInterface instanceof Runnable)) continue;
            bl = true;
        }
        if (!bl) {
            return 2;
        }
        return 0;
    }

    void recalcArrows() {
        for (int i = this.m_objects.size() - 1; i >= 0; --i) {
            Shape shape = this.m_objects.get(i);
            if (!(shape instanceof Arrow)) continue;
            this.m_objects.remove(i);
        }
        HashMap<BEASTInterface, BEASTObjectShape> hashMap = new HashMap<BEASTInterface, BEASTObjectShape>();
        for (Shape shape : this.m_objects) {
            if (!(shape instanceof BEASTObjectShape)) continue;
            hashMap.put(((BEASTObjectShape)shape).m_beastObject, (BEASTObjectShape)shape);
        }
        for (int i = this.m_objects.size() - 1; i >= 0; --i) {
            Shape shape;
            shape = this.m_objects.get(i);
            if (!(shape instanceof BEASTObjectShape)) continue;
            BEASTObjectShape bEASTObjectShape = (BEASTObjectShape)shape;
            BEASTInterface bEASTInterface = bEASTObjectShape.m_beastObject;
            try {
                List<Input<?>> list = bEASTInterface.listInputs();
                for (Input<?> input : list) {
                    if (input.get() == null) continue;
                    if (input.get() instanceof BEASTInterface) {
                        BEASTObjectShape bEASTObjectShape2 = (BEASTObjectShape)hashMap.get(input.get());
                        try {
                            Arrow arrow = new Arrow(bEASTObjectShape2, bEASTObjectShape, input.getName());
                            arrow.setID(this.getNewID(null));
                            this.m_objects.add(arrow);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (!(input.get() instanceof List)) continue;
                    for (Arrow arrow : (List)input.get()) {
                        if (arrow == null || !(arrow instanceof BEASTInterface)) continue;
                        BEASTObjectShape bEASTObjectShape3 = (BEASTObjectShape)hashMap.get(arrow);
                        try {
                            Arrow arrow2 = new Arrow(bEASTObjectShape3, bEASTObjectShape, input.getName());
                            arrow2.setID(this.getNewID(null));
                            this.m_objects.add(arrow2);
                        }
                        catch (Exception exception) {}
                    }
                }
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    class ReorderAction
    extends UndoAction {
        int[] m_oldOrder;
        int[] m_newOrder;

        ReorderAction(int[] nArray, int[] nArray2) {
            this.m_oldOrder = nArray;
            this.m_newOrder = nArray2;
        }

        @Override
        void undo() {
            this.reorder(this.m_oldOrder, this.m_newOrder);
        }

        @Override
        void redo() {
            for (int i = this.m_newOrder.length - 1; i >= 0; --i) {
                int n = this.m_newOrder[i];
                Shape shape = Document.this.m_objects.get(n);
                Document.this.m_objects.remove(n);
                Document.this.m_objects.add(this.m_oldOrder[i], shape);
            }
        }

        void reorder(int[] nArray, int[] nArray2) {
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i];
                Shape shape = Document.this.m_objects.get(n);
                Document.this.m_objects.remove(n);
                Document.this.m_objects.add(nArray2[i], shape);
            }
        }
    }

    class MultiObjectAction
    extends UndoAction {
        List<UndoAction> m_actions;

        MultiObjectAction(List<Integer> list, int n3) {
            this.m_nActionType = n3;
            this.m_actions = new ArrayList<UndoAction>();
            Collections.sort(list, (n, n2) -> n2 - n);
            for (int i = 1; i < list.size(); ++i) {
                if (list.get(i) != list.get(i - 1)) continue;
                list.remove(i);
                --i;
            }
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            for (int n4 : list) {
                Shape shape = Document.this.m_objects.get(n4);
                if (shape instanceof BEASTObjectShape) {
                    arrayList2.add(n4);
                    continue;
                }
                if (!(shape instanceof Arrow)) continue;
                arrayList.add(n4);
            }
            switch (n3) {
                case 20: {
                    for (int n4 : arrayList2) {
                        this.m_actions.add(new PluginAction(n4, 3));
                    }
                    for (int n4 : arrayList) {
                        this.m_actions.add(new ArrowAction(n4, 5));
                    }
                    break;
                }
                case 21: {
                    for (int n4 : arrayList) {
                        this.m_actions.add(new ArrowAction(n4, 6));
                    }
                    for (int n4 : arrayList2) {
                        this.m_actions.add(new PluginAction(n4, 4));
                    }
                    break;
                }
                default: {
                    Log.err.println("Error 105: unrecognized action type");
                }
            }
        }

        @Override
        void undo() {
            for (int i = this.m_actions.size() - 1; i >= 0; --i) {
                this.m_actions.get(i).undo();
            }
        }

        @Override
        void redo() {
            for (int i = 0; i < this.m_actions.size(); ++i) {
                this.m_actions.get(i).redo();
            }
        }
    }

    class ArrowAction
    extends UndoAction {
        public ArrowAction(int n, int n2) {
            this.m_nActionType = n2;
            this.m_nPositions = new ArrayList();
            this.m_nPositions.add(n);
            this.init();
        }

        @Override
        void undo() {
            switch (this.m_nActionType) {
                case 5: {
                    this.removeArrow();
                    return;
                }
                case 6: {
                    this.addArrow();
                    return;
                }
            }
            Log.err.println("Error 103: action type not set properly");
        }

        @Override
        void redo() {
            switch (this.m_nActionType) {
                case 5: {
                    this.addArrow();
                    return;
                }
                case 6: {
                    this.removeArrow();
                    return;
                }
            }
            Log.err.println("Error 104: action type not set properly");
        }

        void removeArrow() {
            Arrow arrow = (Arrow)Document.this.m_objects.get((Integer)this.m_nPositions.get(0));
            Document.this.m_objects.remove((Integer)this.m_nPositions.get(0));
            Input<?> input = arrow.m_headShape.m_input;
            if (input instanceof List) {
                ((List)input.get()).remove(arrow.m_tailShape.m_beastObject);
            } else {
                try {
                    input.setValue(null, arrow.m_headShape.getBEASTObject());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }

        void addArrow() {
            List<Shape> list = Document.this.XML2Shapes(this.m_sXML, true);
            Arrow arrow = (Arrow)list.get(0);
            Document.this.m_objects.add((Integer)this.m_nPositions.get(0), arrow);
            arrow.m_tailShape = Document.this.getPluginShapeWithLabel(arrow.m_sTailID);
            arrow.m_headShape = Document.this.getInputShapeWithID(arrow.m_sHeadID);
            try {
                arrow.m_headShape.m_input.setValue(arrow.m_tailShape.m_beastObject, arrow.m_headShape.getBEASTObject());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    class PluginAction
    extends UndoAction {
        public PluginAction(int n, int n2) {
            this.m_nActionType = n2;
            BEASTObjectShape bEASTObjectShape = (BEASTObjectShape)Document.this.m_objects.get(n);
            this.m_nPositions = new ArrayList();
            this.m_nPositions.add(n);
            --n;
            while (n >= 0 && Document.this.m_objects.get(n) instanceof InputShape && ((InputShape)Document.this.m_objects.get(n)).getPluginShape() == bEASTObjectShape) {
                this.m_nPositions.add(0, n--);
            }
            this.init();
        }

        @Override
        void undo() {
            switch (this.m_nActionType) {
                case 3: {
                    this.removePlugin();
                    return;
                }
                case 4: {
                    this.addPlugin();
                    return;
                }
            }
            Log.err.println("Error 101: action type not set properly");
        }

        @Override
        void redo() {
            switch (this.m_nActionType) {
                case 3: {
                    this.addPlugin();
                    return;
                }
                case 4: {
                    this.removePlugin();
                    return;
                }
            }
            Log.err.println("Error 102: action type not set properly");
        }

        void removePlugin() {
            for (int i = this.m_nPositions.size() - 1; i >= 0; --i) {
                Document.this.m_objects.remove((Integer)this.m_nPositions.get(i));
            }
        }

        void addPlugin() {
            List<Shape> list = Document.this.XML2Shapes(this.m_sXML, true);
            for (int i = 0; i < this.m_nPositions.size(); ++i) {
                Document.this.m_objects.add((Integer)this.m_nPositions.get(i), list.get(i));
            }
        }
    }

    public class UndoAction {
        static final int UNDO_ACTION = 0;
        static final int MOVE_ACTION = 1;
        static final int RESHAPE_ACTION = 2;
        static final int ADD_PLUGIN_ACTION = 3;
        static final int DEL_PLUGIN_ACTION = 4;
        static final int ADD_ARROW_ACTION = 5;
        static final int DEL_ARROW_ACTION = 6;
        static final int FILL_COLOR_ACTION = 5;
        static final int PEN_COLOR_ACTION = 6;
        static final int SET_LABEL_ACTION = 7;
        static final int TOGGLE_FILL_ACTION = 10;
        static final int ADD_GROUP_ACTION = 20;
        static final int DEL_GROUP_ACTION = 21;
        int m_nActionType = 0;
        String m_sXML;
        List<Integer> m_nPositions;

        public UndoAction(int n, int n2) {
            if (!(Document.this.m_objects.get(n) instanceof BEASTObjectShape)) {
                return;
            }
            this.m_nActionType = n2;
            this.m_nPositions = new ArrayList<Integer>();
            this.m_nPositions.add(n);
            this.init();
        }

        public UndoAction(List<Integer> list, int n) {
            this.m_nActionType = n;
            this.m_nPositions = new ArrayList<Integer>();
            for (int i = 0; i < list.size(); ++i) {
                if (!(Document.this.m_objects.get(list.get(i)) instanceof BEASTObjectShape)) continue;
                this.m_nPositions.add(new Integer(list.get(i)));
            }
            this.init();
        }

        public UndoAction() {
        }

        boolean isSingleSelection(int n) {
            return this.m_nPositions.size() == 1 && this.m_nPositions.get(0) == n;
        }

        boolean isSelection(List<Integer> list) {
            int n = 0;
            for (Integer n2 : list) {
                if (!(Document.this.m_objects.get(n2) instanceof BEASTObjectShape)) continue;
                if (this.m_nPositions.contains(n2)) {
                    ++n;
                    continue;
                }
                return false;
            }
            return n == this.m_nPositions.size();
        }

        void init() {
            this.m_sXML = "<doc>";
            for (int i = 0; i < this.m_nPositions.size(); ++i) {
                int n = this.m_nPositions.get(i);
                Shape shape = Document.this.m_objects.get(n);
                this.m_sXML = this.m_sXML + shape.getXML();
            }
            this.m_sXML = this.m_sXML + "</doc>";
        }

        void undo() {
            this.doit();
        }

        void redo() {
            this.doit();
        }

        void doit() {
            int n;
            String string = "<doc>";
            for (int i = 0; i < this.m_nPositions.size(); ++i) {
                n = this.m_nPositions.get(i);
                Shape shape = Document.this.m_objects.get(n);
                string = string + shape.getXML();
            }
            string = string + "</doc>";
            List<Shape> list = Document.this.XML2Shapes(this.m_sXML, false);
            for (n = 0; n < this.m_nPositions.size(); ++n) {
                int n2 = this.m_nPositions.get(n);
                Shape shape = Document.this.m_objects.get(n2);
                Shape shape2 = list.get(n);
                ((BEASTObjectShape)shape2).m_beastObject = ((BEASTObjectShape)shape).m_beastObject;
                shape.assignFrom(shape2);
            }
            this.m_sXML = string;
        }
    }

    class SetInputAction
    extends UndoAction {
        BEASTObjectShape m_beastObjectShape;
        String m_sInput;
        String m_sValue;

        SetInputAction(BEASTObjectShape bEASTObjectShape, String string, String string2) {
            this.m_beastObjectShape = bEASTObjectShape;
            this.m_sInput = string;
            this.m_sValue = string2;
            this.doit();
        }

        @Override
        void redo() {
            this.doit();
        }

        @Override
        void undo() {
            this.doit();
        }

        @Override
        void doit() {
            try {
                String string = this.m_beastObjectShape.m_beastObject.getInput(this.m_sInput).get().toString();
                this.m_beastObjectShape.m_beastObject.setInputValue(this.m_sInput, this.m_sValue);
                this.m_sValue = string;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

