/*
 * Decompiled with CFR 0.152.
 */
package viz.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import viz.DensiTree;
import viz.GridDrawer;
import viz.graphics.JFontChooser;
import viz.panel.RoundedButton;
import viz.util.Util;

public class GridPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final String HELP_GRID = "Show lines indicating timescale. Options are to show none, short lines at the side of the panel, or full lines over the complete tree set.";
    public static final String HELP_DIGITS = "Set number of significant digits for the grid labels.";
    public static final String HELP_REVERSE = "By setting reverse, the time scale will be drawn forward in time. By default, time scale is drawn backward in time, so that the height of a tree is a positive number. Also, set 'origin' to the date of the youngest tip.";
    public static final String HELP_FONT = "Set font of the grid labels.";
    public static final String HELP_COLOR = "Set colour of the grid labels.";
    public static final String HELP_ORIGIN = "Set date of the youngest tip.";
    public static final String HELP_AUTOMATIC = "Automatically determine the number of ticks.";
    public static final String HELP_TICKS = "Interval between two ticks.";
    public static final String HELP_OFFSET = "Time added to the ticks. This can be usefull when the youngest tip of the tree is on a number that is not quite a round number, for example 2003.4. Setting the offset to -3.4 ensures the grid lines will be drawn on 2000 instead of through 2003.4.";
    public static final String HELP_SCALE = "Scale time, which can be handy when the tree is in substitutions and a clock rate is available from the literature. A negative scale has the same effect as selecting 'reverse' with a positive scale.";
    DensiTree m_dt;
    ButtonGroup m_modeGroup = new ButtonGroup();
    private JTextField m_originTextField;
    private JTextField m_ticksTextField;
    private JTextField m_offsetTextField;
    SpinnerNumberModel significantDigitsModel;
    private JTextField txtScale;

    public GridPanel(DensiTree dt) {
        this.m_dt = dt;
        GridBagLayout gridBagLayout = new GridBagLayout();
        int[] nArray = new int[5];
        nArray[0] = 10;
        nArray[2] = 20;
        gridBagLayout.columnWidths = nArray;
        gridBagLayout.rowWeights = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        gridBagLayout.columnWeights = new double[]{1.0, 1.0, 1.0, 0.0, 0.0};
        this.setLayout(gridBagLayout);
        JPanel panel = new JPanel();
        panel.setBorder(new LineBorder(Color.gray));
        GridBagConstraints gbc_panel = new GridBagConstraints();
        gbc_panel.weightx = 0.95;
        gbc_panel.gridwidth = 3;
        gbc_panel.gridheight = 3;
        gbc_panel.insets = new Insets(0, 0, 5, 5);
        gbc_panel.fill = 1;
        gbc_panel.gridx = 0;
        gbc_panel.gridy = 1;
        this.add((Component)panel, gbc_panel);
        panel.setLayout(new BoxLayout(panel, 1));
        JRadioButton rdbtnNewRadioButton_1 = new JRadioButton("No grid");
        panel.add(rdbtnNewRadioButton_1);
        rdbtnNewRadioButton_1.addActionListener(e -> {
            this.m_dt.m_gridDrawer.m_nGridMode = GridDrawer.GridMode.NONE;
            this.m_dt.makeDirty();
        });
        this.m_modeGroup.add(rdbtnNewRadioButton_1);
        JRadioButton rdbtnNewRadioButton = new JRadioButton("Short grid");
        panel.add(rdbtnNewRadioButton);
        rdbtnNewRadioButton.addActionListener(e -> {
            this.m_dt.m_gridDrawer.m_nGridMode = GridDrawer.GridMode.SHORT;
            this.m_dt.makeDirty();
        });
        this.m_modeGroup.add(rdbtnNewRadioButton);
        JRadioButton radioButton_2 = new JRadioButton("Full grid");
        panel.add(radioButton_2);
        radioButton_2.addActionListener(e -> {
            this.m_dt.m_gridDrawer.m_nGridMode = GridDrawer.GridMode.FULL;
            this.m_dt.makeDirty();
        });
        this.m_modeGroup.add(radioButton_2);
        this.m_modeGroup.setSelected(rdbtnNewRadioButton_1.getModel(), true);
        rdbtnNewRadioButton.setToolTipText(Util.formatToolTipAsHtml(HELP_GRID));
        rdbtnNewRadioButton_1.setToolTipText(Util.formatToolTipAsHtml(HELP_GRID));
        radioButton_2.setToolTipText(Util.formatToolTipAsHtml(HELP_GRID));
        JLabel lblDigits = new JLabel("Digits");
        lblDigits.setToolTipText(Util.formatToolTipAsHtml(HELP_DIGITS));
        GridBagConstraints gbc_lblDigits = new GridBagConstraints();
        gbc_lblDigits.anchor = 16;
        gbc_lblDigits.insets = new Insets(0, 0, 5, 5);
        gbc_lblDigits.gridx = 0;
        gbc_lblDigits.gridy = 4;
        this.add((Component)lblDigits, gbc_lblDigits);
        this.significantDigitsModel = new SpinnerNumberModel(this.m_dt.m_gridDrawer.m_nGridDigits, 0, 5, 1);
        JSpinner spinner = new JSpinner(this.significantDigitsModel);
        spinner.setToolTipText(Util.formatToolTipAsHtml(HELP_DIGITS));
        this.significantDigitsModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GridPanel.this.m_dt.m_gridDrawer.m_nGridDigits = (Integer)GridPanel.this.significantDigitsModel.getValue();
                GridPanel.this.m_dt.makeDirty();
            }
        });
        GridBagConstraints gbc_spinner = new GridBagConstraints();
        gbc_spinner.anchor = 17;
        gbc_spinner.gridwidth = 2;
        gbc_spinner.insets = new Insets(0, 0, 5, 5);
        gbc_spinner.gridx = 1;
        gbc_spinner.gridy = 4;
        this.add((Component)spinner, gbc_spinner);
        JCheckBox reverseGrid = new JCheckBox("Reverse");
        reverseGrid.setToolTipText(Util.formatToolTipAsHtml(HELP_REVERSE));
        GridBagConstraints c5 = new GridBagConstraints();
        c5.insets = new Insets(0, 0, 5, 5);
        c5.gridx = 0;
        c5.gridy = 5;
        c5.weightx = 0.5;
        c5.gridwidth = 3;
        c5.fill = 2;
        this.add((Component)reverseGrid, c5);
        reverseGrid.addActionListener(e -> {
            JCheckBox button = (JCheckBox)e.getSource();
            this.m_dt.m_gridDrawer.m_bReverseGrid = button.isSelected();
            this.m_dt.m_Panel.clearImage();
            this.m_dt.repaint();
        });
        RoundedButton btnGridFont = new RoundedButton("Font");
        btnGridFont.setToolTipText(Util.formatToolTipAsHtml(HELP_FONT));
        GridBagConstraints c7 = new GridBagConstraints();
        c7.insets = new Insets(0, 0, 5, 5);
        c7.gridwidth = 2;
        c7.gridx = 0;
        c7.gridy = 6;
        c7.weightx = 0.5;
        c7.fill = 2;
        this.add((Component)btnGridFont, c7);
        btnGridFont.addActionListener(ae -> {
            int result;
            JFontChooser fontChooser = new JFontChooser();
            if (this.m_dt.m_gridDrawer.m_gridfont != null) {
                fontChooser.setSelectedFont(this.m_dt.m_gridDrawer.m_gridfont);
            }
            if ((result = fontChooser.showDialog(null)) == 0) {
                this.m_dt.m_gridDrawer.m_gridfont = fontChooser.getSelectedFont();
                this.m_dt.makeDirty();
                this.m_dt.repaint();
            }
        });
        RoundedButton btnGridColor = new RoundedButton("Color");
        btnGridColor.setToolTipText(Util.formatToolTipAsHtml(HELP_COLOR));
        GridBagConstraints c6 = new GridBagConstraints();
        c6.insets = new Insets(0, 0, 5, 5);
        c6.gridwidth = 2;
        c6.gridx = 2;
        c6.gridy = 6;
        c6.weightx = 0.5;
        c6.fill = 2;
        this.add((Component)btnGridColor, c6);
        btnGridColor.addActionListener(ae -> {
            Color newColor = JColorChooser.showDialog(this.m_dt.m_Panel, this.getName(), this.m_dt.m_color[DensiTree.HEIGHTCOLOR]);
            if (newColor != null) {
                this.m_dt.m_color[DensiTree.HEIGHTCOLOR] = newColor;
                this.m_dt.makeDirty();
            }
            this.m_dt.repaint();
        });
        JLabel lblOffset = new JLabel("Origin");
        lblOffset.setToolTipText(Util.formatToolTipAsHtml(HELP_ORIGIN));
        GridBagConstraints c4 = new GridBagConstraints();
        c4.insets = new Insets(0, 0, 5, 5);
        c4.gridx = 0;
        c4.gridy = 7;
        c4.weightx = 0.5;
        c4.gridwidth = 1;
        c4.fill = 2;
        this.add((Component)lblOffset, c4);
        this.m_originTextField = new JTextField();
        this.m_originTextField.setToolTipText(Util.formatToolTipAsHtml(HELP_ORIGIN));
        this.m_originTextField.setText(String.valueOf(this.m_dt.m_gridDrawer.m_fGridOrigin));
        GridBagConstraints c8 = new GridBagConstraints();
        c8.gridwidth = 2;
        c8.fill = 2;
        c8.insets = new Insets(0, 0, 5, 5);
        c8.gridx = 1;
        c8.gridy = 7;
        this.add((Component)this.m_originTextField, c8);
        this.m_originTextField.setColumns(4);
        JCheckBox chckbxAutomatic = new JCheckBox("Automatic");
        chckbxAutomatic.setToolTipText(Util.formatToolTipAsHtml(HELP_AUTOMATIC));
        chckbxAutomatic.setSelected(this.m_dt.m_gridDrawer.m_bAutoGrid);
        chckbxAutomatic.addActionListener(e -> {
            boolean bPrev = this.m_dt.m_gridDrawer.m_bAutoGrid;
            this.m_dt.m_gridDrawer.m_bAutoGrid = ((JCheckBox)e.getSource()).isSelected();
            this.m_ticksTextField.setEnabled(!this.m_dt.m_gridDrawer.m_bAutoGrid);
            this.m_offsetTextField.setEnabled(!this.m_dt.m_gridDrawer.m_bAutoGrid);
            if (bPrev != this.m_dt.m_gridDrawer.m_bAutoGrid) {
                this.m_dt.makeDirty();
                this.m_dt.repaint();
            }
        });
        GridBagConstraints gbc_chckbxAutomatic = new GridBagConstraints();
        gbc_chckbxAutomatic.gridwidth = 3;
        gbc_chckbxAutomatic.anchor = 17;
        gbc_chckbxAutomatic.insets = new Insets(0, 0, 5, 5);
        gbc_chckbxAutomatic.gridx = 0;
        gbc_chckbxAutomatic.gridy = 8;
        this.add((Component)chckbxAutomatic, gbc_chckbxAutomatic);
        JLabel lblTicks = new JLabel("Ticks");
        lblTicks.setToolTipText(Util.formatToolTipAsHtml(HELP_TICKS));
        GridBagConstraints gbc_lblTicks = new GridBagConstraints();
        gbc_lblTicks.anchor = 17;
        gbc_lblTicks.insets = new Insets(0, 0, 5, 5);
        gbc_lblTicks.gridx = 0;
        gbc_lblTicks.gridy = 9;
        this.add((Component)lblTicks, gbc_lblTicks);
        this.m_ticksTextField = new JTextField();
        this.m_ticksTextField.setToolTipText(Util.formatToolTipAsHtml(HELP_TICKS));
        this.m_ticksTextField.setText(String.valueOf(this.m_dt.m_gridDrawer.m_fGridTicks));
        this.m_ticksTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateOffset();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateOffset();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateOffset();
            }

            private void updateOffset() {
                try {
                    float fGridTicks = Float.parseFloat(GridPanel.this.m_ticksTextField.getText());
                    if (fGridTicks > 0.0f) {
                        GridPanel.this.m_dt.m_gridDrawer.m_fGridTicks = fGridTicks;
                        GridPanel.this.m_dt.makeDirty();
                        GridPanel.this.m_dt.repaint();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        GridBagConstraints gbc_txtScale = new GridBagConstraints();
        gbc_txtScale.gridwidth = 2;
        gbc_txtScale.insets = new Insets(0, 0, 5, 5);
        gbc_txtScale.fill = 2;
        gbc_txtScale.gridx = 1;
        gbc_txtScale.gridy = 9;
        this.add((Component)this.m_ticksTextField, gbc_txtScale);
        this.m_ticksTextField.setColumns(4);
        JLabel lblOrigin = new JLabel("Offset");
        lblOrigin.setToolTipText(Util.formatToolTipAsHtml(HELP_OFFSET));
        GridBagConstraints gbc_lblOrigin = new GridBagConstraints();
        gbc_lblOrigin.anchor = 17;
        gbc_lblOrigin.insets = new Insets(0, 0, 5, 5);
        gbc_lblOrigin.gridx = 0;
        gbc_lblOrigin.gridy = 10;
        this.add((Component)lblOrigin, gbc_lblOrigin);
        this.m_offsetTextField = new JTextField();
        this.m_offsetTextField.setToolTipText(Util.formatToolTipAsHtml(HELP_OFFSET));
        this.m_offsetTextField.setText(String.valueOf(this.m_dt.m_gridDrawer.m_fGridOffset));
        this.m_offsetTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateOffset();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateOffset();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateOffset();
            }

            private void updateOffset() {
                try {
                    GridPanel.this.m_dt.m_gridDrawer.m_fGridOffset = Float.parseFloat(GridPanel.this.m_offsetTextField.getText());
                    GridPanel.this.m_dt.makeDirty();
                    GridPanel.this.m_dt.repaint();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        GridBagConstraints gbc_textField_1 = new GridBagConstraints();
        gbc_textField_1.gridwidth = 2;
        gbc_textField_1.insets = new Insets(0, 0, 5, 5);
        gbc_textField_1.fill = 2;
        gbc_textField_1.gridx = 1;
        gbc_textField_1.gridy = 10;
        this.add((Component)this.m_offsetTextField, gbc_textField_1);
        this.m_offsetTextField.setColumns(4);
        this.m_originTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateOffset();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateOffset();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updateOffset();
            }

            private void updateOffset() {
                try {
                    GridPanel.this.m_dt.m_gridDrawer.m_fGridOrigin = Float.parseFloat(GridPanel.this.m_originTextField.getText());
                    GridPanel.this.m_dt.m_Panel.clearImage();
                    GridPanel.this.m_dt.repaint();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        this.m_ticksTextField.setEnabled(!this.m_dt.m_gridDrawer.m_bAutoGrid);
        this.m_offsetTextField.setEnabled(!this.m_dt.m_gridDrawer.m_bAutoGrid);
        JSeparator separator = new JSeparator();
        GridBagConstraints gbc_separator = new GridBagConstraints();
        gbc_separator.fill = 2;
        gbc_separator.gridwidth = 3;
        gbc_separator.insets = new Insets(0, 0, 5, 5);
        gbc_separator.gridx = 0;
        gbc_separator.gridy = 11;
        this.add((Component)separator, gbc_separator);
        JLabel lblS = new JLabel("Scale");
        lblS.setToolTipText(Util.formatToolTipAsHtml(HELP_SCALE));
        GridBagConstraints gbc_lblS = new GridBagConstraints();
        gbc_lblS.anchor = 17;
        gbc_lblS.insets = new Insets(0, 0, 0, 5);
        gbc_lblS.gridx = 0;
        gbc_lblS.gridy = 12;
        this.add((Component)lblS, gbc_lblS);
        this.txtScale = new JTextField();
        this.txtScale.addActionListener(e -> {
            try {
                this.m_dt.m_fUserScale = Float.parseFloat(this.txtScale.getText());
                this.m_dt.updateCladeModel();
                this.m_dt.makeDirty();
                this.m_dt.repaint();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.txtScale.setText(String.valueOf(this.m_dt.m_fUserScale));
        this.txtScale.setToolTipText(Util.formatToolTipAsHtml(HELP_SCALE));
        GridBagConstraints gbc_txtScale2 = new GridBagConstraints();
        gbc_txtScale2.gridwidth = 2;
        gbc_txtScale2.insets = new Insets(0, 0, 0, 5);
        gbc_txtScale2.fill = 2;
        gbc_txtScale2.gridx = 1;
        gbc_txtScale2.gridy = 12;
        this.add((Component)this.txtScale, gbc_txtScale2);
        this.txtScale.setColumns(4);
    }
}

