/*
 * Decompiled with CFR 0.152.
 */
package viz.graphics;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class BufferedImageF {
    int m_nWidth;
    int m_nHeight;
    public BufferedImage m_localImage;
    int[] m_nR;
    int[] m_nG;
    int[] m_nB;
    boolean m_bIsHorizontal = true;
    int m_nRed;
    int m_nGreen;
    int m_nBlue;
    float m_fAlpha;

    public BufferedImageF(int nWidth, int nHeight) {
        this.m_nWidth = nWidth;
        this.m_nHeight = nHeight;
        this.m_localImage = new BufferedImage(nWidth, nHeight, 6);
        this.m_nR = new int[nHeight * nWidth];
        this.m_nG = new int[nHeight * nWidth];
        this.m_nB = new int[nHeight * nWidth];
    }

    public int getWidth() {
        return this.m_localImage.getWidth();
    }

    public int getHeight() {
        return this.m_localImage.getHeight();
    }

    public int getRGB(int i, int j) {
        return this.m_localImage.getRGB(i, j);
    }

    public void init(Graphics2D g, Color bgColor, BufferedImage bgImage, double[] fBGImageBox, int nLabelWidth, double fMinLong, double fMaxLong, double fMinLat, double fMaxLat) {
        g.setBackground(bgColor);
        g.clearRect(0, 0, this.m_localImage.getWidth(), this.m_localImage.getHeight());
        if (bgImage != null) {
            if (fMaxLong == 180.0) {
                g.drawImage(bgImage, 0, 0, this.m_localImage.getWidth() - nLabelWidth - 20, this.m_localImage.getHeight(), 0, 0, bgImage.getWidth(), bgImage.getHeight(), null);
            } else {
                int nW = bgImage.getWidth();
                int nH = bgImage.getHeight();
                int x0 = (int)((double)nW * (fMinLong - fBGImageBox[0]) / (fBGImageBox[2] - fBGImageBox[0]));
                int x1 = (int)((double)nW * (fMaxLong - fBGImageBox[0]) / (fBGImageBox[2] - fBGImageBox[0]));
                int y0 = (int)((double)nH * (fMaxLat - fBGImageBox[3]) / (fBGImageBox[1] - fBGImageBox[3]));
                int y1 = (int)((double)nH * (fMinLat - fBGImageBox[3]) / (fBGImageBox[1] - fBGImageBox[3]));
                g.drawImage(bgImage, 0, 0, this.m_localImage.getWidth() - nLabelWidth - 20, this.m_localImage.getHeight(), x0, y0, x1, y1, null);
                if (x1 > nW) {
                    g.drawImage(bgImage, 0, 0, this.m_localImage.getWidth() - nLabelWidth - 20, this.m_localImage.getHeight(), x0 - nW, y0, x1 - nW, y1, null);
                }
            }
        }
    }

    public void SyncIntToRGBImage() {
        int p = 0;
        int y = 0;
        while (y < this.m_nHeight) {
            int x = 0;
            while (x < this.m_nWidth) {
                int nRGB = this.m_localImage.getRGB(x, y);
                this.m_nR[p] = nRGB & 0xFF0000;
                this.m_nG[p] = (nRGB & 0xFF00) << 8;
                this.m_nB[p] = (nRGB & 0xFF) << 16;
                ++p;
                ++x;
            }
            ++y;
        }
    }

    public Graphics2D createGraphics() {
        return this.m_localImage.createGraphics();
    }

    public void drawImage(Graphics g, Component component) {
        int[] rgbArray = new int[this.m_nWidth * this.m_nHeight];
        int k = 0;
        int y = 0;
        while (y < this.m_nHeight) {
            int x = 0;
            while (x < this.m_nWidth) {
                int nRGB = this.m_nR[k] & 0xFF0000;
                nRGB += (this.m_nG[k] & 0xFF0000) >> 8;
                rgbArray[k++] = (nRGB += (this.m_nB[k] & 0xFF0000) >> 16) | 0xFF000000;
                ++x;
            }
            ++y;
        }
        this.m_localImage.setRGB(0, 0, this.m_nWidth, this.m_nHeight, rgbArray, 0, this.m_nWidth);
        g.drawImage(this.m_localImage, 0, 0, component);
    }

    public void setColor(Graphics2D g, Color color) {
        g.setColor(color);
    }

    public void setOrientation(boolean bIsHorizontal) {
        this.m_bIsHorizontal = bIsHorizontal;
    }

    public void scale(Graphics2D g, double fScaleX, double fScaleY) {
        g.scale(fScaleX, fScaleY);
    }

    float fpart(float x) {
        return x - (float)((int)x);
    }

    float rfpart(float x) {
        return 1.0f - this.fpart(x);
    }

    int round(double x) {
        return (int)(x + 0.5);
    }

    void plot(int x, int y, float fAlpha, int nRed, int nGreen, int nBlue) {
        if (y >= this.m_nHeight || x >= this.m_nWidth || x < 0 || y < 0) {
            return;
        }
        int p = y * this.m_nWidth + x;
        this.m_nR[p] = (int)((float)this.m_nR[p] * (1.0f - fAlpha) + (float)nRed * fAlpha);
        this.m_nG[p] = (int)((float)this.m_nG[p] * (1.0f - fAlpha) + (float)nGreen * fAlpha);
        this.m_nB[p] = (int)((float)this.m_nB[p] * (1.0f - fAlpha) + (float)nBlue * fAlpha);
    }

    void line(int x1, int y1, int x2, int y2, float fAlpha, int nRed, int nGreen, int nBlue, float fLineWidth) {
        int length = Math.abs(x2 - x1) >= Math.abs(y2 - y1) ? Math.abs(x2 - x1) : Math.abs(y2 - y1);
        int w = (int)fLineWidth;
        int wx = (int)((double)((w - 1) / 2) * (Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1)) / (double)Math.abs(y2 - y1)));
        int wy = (int)((double)((w - 1) / 2) * (Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1)) / (double)Math.abs(x2 - x1)));
        int dy = (y2 - y1) / length;
        int dx = (x2 - x1) / length;
        if (dy > dx) {
            wy = wx;
        }
        int x = (int)((double)x1 + (dx > 0 ? 0.5 : -0.5));
        int y = (int)((double)y1 + (dy > 0 ? 0.5 : -0.5));
        int i = 1;
        while (i <= length) {
            int j = -wy;
            while (j < wy) {
                this.plot(x, y + j, fAlpha, nRed, nGreen, nBlue);
                ++j;
            }
            if (wy == 0) {
                this.plot(x, y, fAlpha, nRed, nGreen, nBlue);
            }
            x += dx;
            y += dy;
            ++i;
        }
    }

    void line2(int x0, int y0, int x1, int y1, float fAlpha, int nRed, int nGreen, int nBlue, float fLineWidth) {
        int h;
        boolean steep;
        boolean bl = steep = Math.abs(y1 - y0) > Math.abs(x1 - x0);
        if (steep) {
            h = x0;
            x0 = y0;
            y0 = h;
            h = x1;
            x1 = y1;
            y1 = h;
        }
        if (x0 > x1) {
            h = x0;
            x0 = x1;
            x1 = h;
            h = y0;
            y0 = y1;
            y1 = h;
        }
        int deltax = x1 - x0;
        int deltay = Math.abs(y1 - y0);
        int error = deltax / 2;
        int y = y0;
        int ystep = y0 < y1 ? 1 : -1;
        int x = x0;
        while (x < x1) {
            int i;
            if (steep) {
                i = 0;
                while (i <= (int)fLineWidth) {
                    this.plot(y + i, x, fAlpha, nRed, nGreen, nBlue);
                    ++i;
                }
            } else {
                i = 0;
                while (i <= (int)fLineWidth) {
                    this.plot(x, y + i, fAlpha, nRed, nGreen, nBlue);
                    ++i;
                }
            }
            if ((error -= deltay) < 0) {
                y += ystep;
                error += deltax;
            }
            ++x;
        }
    }
}

