/*
 * Decompiled with CFR 0.152.
 */
package viz.graphics;

import java.util.Random;
import viz.graphics.BranchDrawer;
import viz.graphics.BufferedImageF;

public class BrownianBridgeBranchDrawer
extends BranchDrawer {
    Random m_random = new Random();
    static final int NR_OF_POINTS = 32;
    static final double NOISE = 1.5;

    @Override
    void lineAA(BufferedImageF image, int x1, int y1, int x2, int y2, float fAlpha, int nRed, int nGreen, int nBlue, float fLineWidth) {
        int[] nX = new int[32];
        int[] nY = new int[32];
        nX[0] = x1;
        nY[0] = y1;
        nX[31] = x2;
        nY[31] = y2;
        this.determinePoints(nX, nY, 0, 31);
        int i = 0;
        while (i < 30) {
            super.lineAA(image, nX[i], nY[i], nX[i + 1], nY[i + 1], fAlpha, nRed, nGreen, nBlue, fLineWidth);
            ++i;
        }
    }

    void determinePoints(int[] nX, int[] nY, int iStart, int iEnd) {
        int iMid = (iStart + iEnd) / 2;
        double xMid = (double)(nX[iStart] + nX[iEnd]) / 2.0;
        double yMid = (double)(nY[iStart] + nY[iEnd]) / 2.0;
        nX[iMid] = (int)(xMid + 1.5 * (this.m_random.nextDouble() - 0.5) * Math.exp(-this.m_random.nextDouble()) * (double)Math.abs(nX[iStart] - nX[iEnd]));
        nY[iMid] = (int)(yMid + 1.5 * (this.m_random.nextDouble() - 0.5) * Math.exp(-this.m_random.nextDouble()) * (double)Math.abs(nY[iStart] - nY[iEnd]));
        if (iMid > iStart + 1) {
            this.determinePoints(nX, nY, iStart, iMid);
        }
        if (iMid < iEnd - 1) {
            this.determinePoints(nX, nY, iMid, iEnd);
        }
    }
}

