/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update.processor;

import java.util.Locale;
import org.apache.commons.lang.LocaleUtils;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.update.processor.FieldMutatingUpdateProcessor;
import org.apache.solr.update.processor.FieldMutatingUpdateProcessorFactory;

public abstract class ParseNumericFieldUpdateProcessorFactory
extends FieldMutatingUpdateProcessorFactory {
    private static final String LOCALE_PARAM = "locale";
    protected Locale locale = Locale.ROOT;

    @Override
    public void init(NamedList args) {
        String localeParam = (String)args.remove(LOCALE_PARAM);
        if (null != localeParam) {
            this.locale = LocaleUtils.toLocale((String)localeParam);
        }
        super.init(args);
    }

    protected abstract boolean isSchemaFieldTypeCompatible(FieldType var1);

    @Override
    public FieldMutatingUpdateProcessor.FieldNameSelector getDefaultSelector(SolrCore core) {
        return fieldName -> {
            IndexSchema schema = core.getLatestSchema();
            FieldType type = schema.getFieldTypeNoEx(fieldName);
            return null == type || this.isSchemaFieldTypeCompatible(type);
        };
    }
}

