/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic.web;

import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.JSONException;
import net.arnx.jsonic.JSONHint;
import net.arnx.jsonic.util.ClassUtil;
import net.arnx.jsonic.web.Container;
import net.arnx.jsonic.web.ExternalContext;

public class RPCServlet
extends HttpServlet {
    protected Container container;
    Config config;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        String configText = servletConfig.getInitParameter("config");
        JSON json = new JSON();
        if (configText == null) {
            HashMap map = new HashMap();
            Enumeration e = (Enumeration)Container.cast(servletConfig.getInitParameterNames());
            while (e.hasMoreElements()) {
                map.put(e.nextElement(), servletConfig.getInitParameter((String)e.nextElement()));
            }
            configText = json.format(map);
        }
        try {
            this.config = json.parse((CharSequence)configText, Config.class);
            if (this.config.container == null) {
                this.config.container = Container.class;
            }
            this.container = json.parse((CharSequence)configText, this.config.container);
            this.container.init(this);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        if (this.config.definitions == null) {
            this.config.definitions = new HashMap<String, Pattern>();
        }
        if (!this.config.definitions.containsKey("package")) {
            this.config.definitions.put("package", Pattern.compile(".+"));
        }
        if (this.config.errors == null) {
            this.config.errors = Collections.emptyMap();
        }
        if (this.config.mappings == null) {
            this.config.mappings = Collections.emptyMap();
        }
        for (Map.Entry<String, RouteMapping> entry : this.config.mappings.entrySet()) {
            entry.getValue().init(entry.getKey(), this.config);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doRPC(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRPC(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        JSON json = null;
        boolean isBatch = false;
        ArrayList responseList = new ArrayList();
        try {
            ExternalContext.start(this.getServletConfig(), this.getServletContext(), request, response);
            this.container.start(request, response);
            String uri = request.getContextPath().equals("/") ? request.getRequestURI() : request.getRequestURI().substring(request.getContextPath().length());
            Route route = null;
            for (RouteMapping m : this.config.mappings.values()) {
                route = m.matches(request, uri);
                if (route == null) continue;
                if (!this.container.isDebugMode()) break;
                this.container.debug("Route found: " + request.getMethod() + " " + uri + " -> " + route);
                break;
            }
            if (route == null || !Container.isJSONType(request.getContentType())) {
                response.sendError(404, "Not Found");
                return;
            }
            json = this.container.createJSON(request.getLocale());
            List<Object> requestList = new ArrayList(0);
            Object value = json.parse(request.getReader());
            if (value instanceof List && !((List)value).isEmpty()) {
                requestList = (List)Container.cast(value);
                isBatch = true;
            } else if (value instanceof Map && !((Map)value).isEmpty()) {
                requestList = Arrays.asList(value);
            } else {
                throw new IllegalArgumentException("Request is empty.");
            }
            for (int i = 0; i < requestList.size(); ++i) {
                Map req = (Map)requestList.get(i);
                String rjsonrpc = null;
                String rmethod = null;
                ArrayList rparams = null;
                Object rid = null;
                Object result = null;
                LinkedHashMap<String, Object> error = null;
                try {
                    Object component;
                    if (req.get("jsonrpc") != null && !"2.0".equals(req.get("jsonrpc"))) {
                        throw new IllegalArgumentException("jsonrpc is unrecognized version: " + req.get("jsonrpc"));
                    }
                    rjsonrpc = (String)req.get("jsonrpc");
                    if (req.get("method") instanceof String) {
                        rmethod = (String)req.get("method");
                        if (rjsonrpc != null && rmethod.startsWith("rpc.")) {
                            this.container.warn("Method names that begin with 'rpc.' are reserved for system extensions.");
                        }
                    } else {
                        throw new IllegalArgumentException("method must " + (req.get("method") == null ? "not be null." : "be string."));
                    }
                    if (req.get("params") instanceof List || rjsonrpc != null && req.get("params") instanceof Map) {
                        rparams = (ArrayList)req.get("params");
                    } else if (rjsonrpc != null && req.get("params") == null) {
                        rparams = new ArrayList(0);
                    } else {
                        throw new IllegalArgumentException("params must be array" + (rjsonrpc != null ? " or object." : "."));
                    }
                    if (rjsonrpc != null && req.get("id") != null && !(req.get("id") instanceof String) && !(req.get("id") instanceof Number)) {
                        throw new IllegalArgumentException("id must be string, number or null.");
                    }
                    rid = req.get("id");
                    String subcompName = null;
                    String methodName = rmethod;
                    if (route.getParameter("class") == null) {
                        int sep = rmethod.lastIndexOf(46);
                        subcompName = sep != -1 ? rmethod.substring(0, sep) : null;
                        String string = methodName = sep != -1 ? rmethod.substring(sep + 1) : rmethod;
                    }
                    if ((component = this.container.getComponent(route.getComponentClass(this.container, subcompName))) == null) {
                        throw new NoSuchMethodException("Method not found: " + rmethod);
                    }
                    List<Object> params = rparams instanceof List ? (List<Object>)rparams : Arrays.asList(rparams);
                    Method method = this.container.getMethod(component, methodName, params);
                    if (method == null) {
                        throw new NoSuchMethodException("Method not found: " + rmethod);
                    }
                    json.setContext(component);
                    result = this.container.execute(json, component, method, params);
                }
                catch (Exception e) {
                    error = new LinkedHashMap<String, Object>();
                    if (e instanceof IllegalArgumentException) {
                        this.container.debug("Invalid Request.", e);
                        this.container.exception(e, request, response);
                        error.put("code", -32600);
                        error.put("message", "Invalid Request.");
                    }
                    if (e instanceof ClassNotFoundException) {
                        this.container.debug("Class Not Found.", e);
                        this.container.exception(e, request, response);
                        error.put("code", -32601);
                        error.put("message", "Method not found.");
                    }
                    if (e instanceof NoSuchMethodException) {
                        this.container.debug("Method Not Found.", e);
                        this.container.exception(e, request, response);
                        error.put("code", -32601);
                        error.put("message", "Method not found.");
                    }
                    if (e instanceof JSONException) {
                        this.container.debug("Invalid params.", e);
                        this.container.exception(e, request, response);
                        error.put("code", -32602);
                        error.put("message", "Invalid params.");
                    }
                    if (e instanceof InvocationTargetException) {
                        Throwable cause = e.getCause();
                        if (cause instanceof Error) {
                            throw (Error)cause;
                        }
                        this.container.debug("Fails to invoke method.", cause);
                        this.container.exception((Exception)cause, request, response);
                        if (cause instanceof IllegalStateException || cause instanceof UnsupportedOperationException) {
                            error.put("code", -32601);
                            error.put("message", "Method not found.");
                        } else if (cause instanceof IllegalArgumentException) {
                            error.put("code", -32602);
                            error.put("message", "Invalid params.");
                        } else {
                            Integer errorCode = null;
                            for (Map.Entry<String, Integer> entry : this.config.errors.entrySet()) {
                                Class<?> cls = ClassUtil.findClass(entry.getKey());
                                if (cls == null || !cls.isAssignableFrom(cause.getClass()) || entry.getValue() == null) continue;
                                errorCode = entry.getValue();
                                break;
                            }
                            if (errorCode != null) {
                                error.put("code", errorCode);
                                error.put("message", cause.getClass().getSimpleName() + ": " + cause.getMessage());
                                error.put("data", this.container.getErrorData(cause));
                            } else {
                                this.container.error("Internal error occurred.", cause);
                                error.put("code", -32603);
                                error.put("message", "Internal error.");
                            }
                        }
                    }
                    this.container.error("Internal error occurred.", e);
                    this.container.exception(e, request, response);
                    error.put("code", -32603);
                    error.put("message", "Internal error.");
                }
                if (rmethod != null && rjsonrpc == null && rid == null || rjsonrpc != null && req != null && !req.containsKey("id")) continue;
                LinkedHashMap<String, Object> responseData = new LinkedHashMap<String, Object>();
                if (rjsonrpc != null) {
                    responseData.put("jsonrpc", rjsonrpc);
                    if (result != null) {
                        responseData.put("result", result);
                    }
                    if (error != null) {
                        responseData.put("error", error);
                    }
                } else {
                    responseData.put("result", result);
                    responseData.put("error", error);
                }
                responseData.put("id", rid);
                responseList.add(responseData);
            }
        }
        catch (Exception e) {
            LinkedHashMap<String, Object> error = new LinkedHashMap<String, Object>();
            if (e instanceof JSONException) {
                this.container.debug("Fails to parse JSON.", e);
                error.put("code", -32700);
                error.put("message", "Parse error.");
                error.put("data", this.container.getErrorData(e));
            } else {
                this.container.debug("Invalid Request.", e);
                error.put("code", -32600);
                error.put("message", "Invalid Request.");
            }
            LinkedHashMap<String, Object> responseData = new LinkedHashMap<String, Object>();
            responseData.put("jsonrpc", "2.0");
            responseData.put("error", error);
            responseData.put("id", null);
            responseList.add(responseData);
        }
        finally {
            try {
                this.container.end(request, response);
            }
            finally {
                ExternalContext.end();
            }
        }
        if (response.isCommitted()) {
            return;
        }
        if (responseList.isEmpty()) {
            response.setStatus(202);
            return;
        }
        response.setContentType("application/json");
        PrintWriter writer = response.getWriter();
        ArrayList target = isBatch ? responseList : responseList.get(0);
        json.setContext(target);
        json.format(target, writer);
    }

    public void destroy() {
        this.container.destory();
        super.destroy();
    }

    static class Route {
        static final Pattern REPLACE_PATTERN = Pattern.compile("\\$\\{(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)\\}");
        private String target;
        private Map<Object, Object> params;

        public Route(String target, Map<String, Object> params) throws IOException {
            this.target = target;
            this.params = (Map)Container.cast(params);
        }

        public String getParameter(String name) {
            List list;
            Map map;
            Object o = this.params.get(name);
            if (o instanceof Map && (map = (Map)o).containsKey(null)) {
                o = map.get(null);
            }
            if (o instanceof List && !(list = (List)o).isEmpty()) {
                o = list.get(0);
            }
            return o instanceof String ? (String)o : null;
        }

        public Map<?, ?> getParameterMap() {
            return this.params;
        }

        public String getComponentClass(Container container, String sub) {
            Matcher m = REPLACE_PATTERN.matcher(this.target);
            StringBuffer sb = new StringBuffer();
            while (m.find()) {
                String key = m.group(1);
                String value = this.getParameter(key);
                if (key.equals("class") && container.namingConversion) {
                    value = ClassUtil.toUpperCamel(value != null ? value : (sub != null ? sub : "?"));
                } else if (key.equals("package")) {
                    value = value.replace('/', '.');
                }
                m.appendReplacement(sb, value != null ? value : "");
            }
            m.appendTail(sb);
            return sb.toString();
        }

        public Map<?, ?> mergeParameterMap(Map<?, ?> newParams) {
            for (Map.Entry<?, ?> entry : newParams.entrySet()) {
                if (this.params.containsKey(entry.getKey())) {
                    Object target = this.params.get(entry.getKey());
                    if (target instanceof Map) {
                        Map map = (Map)target;
                        if (map.containsKey(null)) {
                            target = map.get(null);
                            if (target instanceof List) {
                                ((List)target).add(entry.getValue());
                                continue;
                            }
                            ArrayList<Object> list = new ArrayList<Object>();
                            list.add(target);
                            list.add(entry.getValue());
                            map.put(null, list);
                            continue;
                        }
                        map.put(null, entry.getValue());
                        continue;
                    }
                    if (target instanceof List) {
                        ((List)target).add(entry.getValue());
                        continue;
                    }
                    ArrayList<Object> list = new ArrayList<Object>();
                    list.add(target);
                    list.add(entry.getValue());
                    this.params.put(entry.getKey(), list);
                    continue;
                }
                this.params.put(entry.getKey(), entry.getValue());
            }
            return this.params;
        }

        public String toString() {
            return "Route [target=" + this.target + ", params=" + this.params + "]";
        }
    }

    static class RouteMapping {
        static final Pattern PLACE_PATTERN = Pattern.compile("\\{\\s*(\\p{javaJavaIdentifierStart}[\\p{javaJavaIdentifierPart}\\.-]*)\\s*(?::\\s*((?:[^{}]|\\{[^{}]*\\})*)\\s*)?\\}");
        static final Pattern DEFAULT_PATTERN = Pattern.compile("[^/().]+");
        public String target;
        Config config;
        Pattern pattern;
        List<String> names;

        public void init(String path, Config config) {
            this.config = config;
            this.names = new ArrayList<String>();
            StringBuffer sb = new StringBuffer("^\\Q");
            Matcher m = PLACE_PATTERN.matcher(path);
            while (m.find()) {
                Pattern p;
                String name = m.group(1);
                this.names.add(name);
                Pattern pattern = p = m.group(2) != null ? Pattern.compile(m.group(2)) : null;
                if (p == null && config.definitions.containsKey(name)) {
                    p = config.definitions.get(name);
                }
                if (p == null) {
                    p = DEFAULT_PATTERN;
                }
                m.appendReplacement(sb, "\\\\E(" + p.pattern().replaceAll("\\((?!\\?)", "(?:").replace("\\", "\\\\") + ")\\\\Q");
            }
            m.appendTail(sb);
            sb.append("\\E$");
            this.pattern = Pattern.compile(sb.toString());
        }

        public Route matches(HttpServletRequest request, String path) throws IOException {
            Matcher m = this.pattern.matcher(path);
            if (m.matches()) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                for (int i = 0; i < this.names.size(); ++i) {
                    String key = this.names.get(i);
                    String value = m.group(i + 1);
                    if (params.containsKey(key)) {
                        Object target = params.get(key);
                        if (target instanceof List) {
                            ((List)target).add(value);
                            continue;
                        }
                        ArrayList<Object> list = new ArrayList<Object>(2);
                        list.add(target);
                        list.add(value);
                        continue;
                    }
                    params.put(key, value);
                }
                return new Route(this.target, params);
            }
            return null;
        }
    }

    static class Config {
        public Class<? extends Container> container;
        @JSONHint(anonym="target")
        public Map<String, RouteMapping> mappings;
        public Map<String, Pattern> definitions;
        public Map<String, Integer> errors;

        Config() {
        }
    }
}

