/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.eval.BooleanEvaluator;
import org.apache.solr.client.solrj.io.eval.ConditionalEvaluator;
import org.apache.solr.client.solrj.io.eval.StreamEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class IfThenElseEvaluator
extends ConditionalEvaluator {
    protected static final long serialVersionUID = 1L;

    public IfThenElseEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (3 != this.subEvaluators.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting three values but found %d", expression, this.subEvaluators.size()));
        }
        if (!(this.subEvaluators.get(0) instanceof BooleanEvaluator)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting a boolean as the first parameter but found %s", expression, ((StreamEvaluator)this.subEvaluators.get(0)).getClass().getSimpleName()));
        }
    }

    @Override
    public Object evaluate(Tuple tuple) throws IOException {
        List<Object> results = this.evaluateAll(tuple);
        if (3 != results.size()) {
            String message = String.format(Locale.ROOT, "%s(...) only works with 3 values but %s were provided", this.constructingFactory.getFunctionName(this.getClass()), results.size());
            throw new IOException(message);
        }
        if (!(results.get(0) instanceof Boolean)) {
            throw new IOException(String.format(Locale.ROOT, "$s(...) only works with a boolean as the first parameter but found %s", results.get(0).getClass().getSimpleName()));
        }
        return (Boolean)results.get(0) != false ? results.get(1) : results.get(2);
    }
}

