/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function;

import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FilterScorer;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

public final class FunctionScoreQuery
extends Query {
    private final Query in;
    private final DoubleValuesSource source;

    public FunctionScoreQuery(Query in, DoubleValuesSource source) {
        this.in = in;
        this.source = source;
    }

    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        Weight inner = this.in.createWeight(searcher, needsScores && this.source.needsScores());
        if (!needsScores) {
            return inner;
        }
        return new FunctionScoreWeight(this, inner, this.source);
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query rewritten = this.in.rewrite(reader);
        if (rewritten == this.in) {
            return this;
        }
        return new FunctionScoreQuery(rewritten, this.source);
    }

    public String toString(String field) {
        return "FunctionScoreQuery(" + this.in.toString(field) + ", scored by " + this.source.toString() + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        FunctionScoreQuery that = (FunctionScoreQuery)((Object)o);
        return Objects.equals(this.in, that.in) && Objects.equals(this.source, that.source);
    }

    public int hashCode() {
        return Objects.hash(this.in, this.source);
    }

    private static class FunctionScoreWeight
    extends Weight {
        final Weight inner;
        final DoubleValuesSource valueSource;
        float boost = 1.0f;

        FunctionScoreWeight(Query query, Weight inner, DoubleValuesSource valueSource) {
            super(query);
            this.inner = inner;
            this.valueSource = valueSource;
        }

        public void extractTerms(Set<Term> terms) {
            this.inner.extractTerms(terms);
        }

        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            Scorer scorer = this.inner.scorer(context);
            if (scorer.iterator().advance(doc) != doc) {
                return Explanation.noMatch((String)"No match", (Explanation[])new Explanation[0]);
            }
            DoubleValues scores = this.valueSource.getValues(context, DoubleValuesSource.fromScorer((Scorer)scorer));
            scores.advanceExact(doc);
            Explanation scoreExpl = this.scoreExplanation(context, doc, scores);
            if (this.boost == 1.0f) {
                return scoreExpl;
            }
            return Explanation.match((float)(scoreExpl.getValue() * this.boost), (String)"product of:", (Explanation[])new Explanation[]{Explanation.match((float)this.boost, (String)"boost", (Explanation[])new Explanation[0]), scoreExpl});
        }

        public float getValueForNormalization() throws IOException {
            return this.inner.getValueForNormalization();
        }

        public void normalize(float norm, float boost) {
            this.inner.normalize(norm, 1.0f);
            this.boost = boost;
        }

        private Explanation scoreExplanation(LeafReaderContext context, int doc, DoubleValues scores) throws IOException {
            if (!this.valueSource.needsScores()) {
                return Explanation.match((float)((float)scores.doubleValue()), (String)this.valueSource.toString(), (Explanation[])new Explanation[0]);
            }
            float score = (float)scores.doubleValue();
            return Explanation.match((float)score, (String)"computed from:", (Explanation[])new Explanation[]{Explanation.match((float)score, (String)this.valueSource.toString(), (Explanation[])new Explanation[0]), this.inner.explain(context, doc)});
        }

        public Scorer scorer(LeafReaderContext context) throws IOException {
            Scorer in = this.inner.scorer(context);
            if (in == null) {
                return null;
            }
            final DoubleValues scores = this.valueSource.getValues(context, DoubleValuesSource.fromScorer((Scorer)in));
            return new FilterScorer(in){

                public float score() throws IOException {
                    if (scores.advanceExact(this.docID())) {
                        return (float)(scores.doubleValue() * (double)boost);
                    }
                    return 0.0f;
                }
            };
        }
    }
}

