/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.aiff.chunk;

import java.util.HashMap;
import java.util.Map;

public enum ChunkType {
    FORMAT_VERSION("FVER"),
    APPLICATION("APPL"),
    SOUND("SSND"),
    COMMON("COMM"),
    COMMENTS("COMT"),
    NAME("NAME"),
    AUTHOR("AUTH"),
    COPYRIGHT("(c) "),
    ANNOTATION("ANNO"),
    TAG("ID3 ");

    private static final Map<String, ChunkType> CODE_TYPE_MAP;
    private String code;

    private ChunkType(String code) {
        this.code = code;
    }

    public static synchronized ChunkType get(String code) {
        if (CODE_TYPE_MAP.isEmpty()) {
            for (ChunkType type : ChunkType.values()) {
                CODE_TYPE_MAP.put(type.getCode(), type);
            }
        }
        return CODE_TYPE_MAP.get(code);
    }

    public String getCode() {
        return this.code;
    }

    static {
        CODE_TYPE_MAP = new HashMap<String, ChunkType>();
    }
}

