/*
 * Decompiled with CFR 0.152.
 */
package com.cybozu.labs.langdetect;

import com.cybozu.labs.langdetect.Detector;
import com.cybozu.labs.langdetect.ErrorCode;
import com.cybozu.labs.langdetect.LangDetectException;
import com.cybozu.labs.langdetect.util.LangProfile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.JSONException;

public class DetectorFactory {
    public HashMap<String, double[]> wordLangProbMap = new HashMap();
    public ArrayList<String> langlist = new ArrayList();
    public Long seed = null;
    private static DetectorFactory instance_ = new DetectorFactory();

    private DetectorFactory() {
    }

    public static void loadProfile(String profileDirectory) throws LangDetectException {
        DetectorFactory.loadProfile(new File(profileDirectory));
    }

    public static void loadProfile(File profileDirectory) throws LangDetectException {
        File[] listFiles = profileDirectory.listFiles();
        if (listFiles == null) {
            throw new LangDetectException(ErrorCode.NeedLoadProfileError, "Not found profile: " + profileDirectory);
        }
        int langsize = listFiles.length;
        int index = 0;
        File[] fileArray = listFiles;
        int n = listFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (!file.getName().startsWith(".") && file.isFile()) {
                FileInputStream is = null;
                try {
                    try {
                        is = new FileInputStream(file);
                        LangProfile profile = JSON.decode((InputStream)is, LangProfile.class);
                        DetectorFactory.addProfile(profile, index, langsize);
                        ++index;
                    }
                    catch (JSONException e) {
                        throw new LangDetectException(ErrorCode.FormatError, "profile format error in '" + file.getName() + "'");
                    }
                    catch (IOException e) {
                        throw new LangDetectException(ErrorCode.FileLoadError, "can't open '" + file.getName() + "'");
                    }
                }
                finally {
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            ++n2;
        }
    }

    public static void loadProfile(List<String> json_profiles) throws LangDetectException {
        int index = 0;
        int langsize = json_profiles.size();
        if (langsize < 2) {
            throw new LangDetectException(ErrorCode.NeedLoadProfileError, "Need more than 2 profiles");
        }
        for (String json : json_profiles) {
            try {
                LangProfile profile = JSON.decode(json, LangProfile.class);
                DetectorFactory.addProfile(profile, index, langsize);
                ++index;
            }
            catch (JSONException e) {
                throw new LangDetectException(ErrorCode.FormatError, "profile format error");
            }
        }
    }

    static void addProfile(LangProfile profile, int index, int langsize) throws LangDetectException {
        String lang = profile.name;
        if (DetectorFactory.instance_.langlist.contains(lang)) {
            throw new LangDetectException(ErrorCode.DuplicateLangError, "duplicate the same language profile");
        }
        DetectorFactory.instance_.langlist.add(lang);
        for (String word : profile.freq.keySet()) {
            double prob;
            int length;
            if (!DetectorFactory.instance_.wordLangProbMap.containsKey(word)) {
                DetectorFactory.instance_.wordLangProbMap.put(word, new double[langsize]);
            }
            if ((length = word.length()) < 1 || length > 3) continue;
            DetectorFactory.instance_.wordLangProbMap.get((Object)word)[index] = prob = profile.freq.get(word).doubleValue() / (double)profile.n_words[length - 1];
        }
    }

    public static void clear() {
        DetectorFactory.instance_.langlist.clear();
        DetectorFactory.instance_.wordLangProbMap.clear();
    }

    public static Detector create() throws LangDetectException {
        return DetectorFactory.createDetector();
    }

    public static Detector create(double alpha) throws LangDetectException {
        Detector detector = DetectorFactory.createDetector();
        detector.setAlpha(alpha);
        return detector;
    }

    private static Detector createDetector() throws LangDetectException {
        if (DetectorFactory.instance_.langlist.size() == 0) {
            throw new LangDetectException(ErrorCode.NeedLoadProfileError, "need to load profiles");
        }
        Detector detector = new Detector(instance_);
        return detector;
    }

    public static void setSeed(long seed) {
        DetectorFactory.instance_.seed = seed;
    }

    public static final List<String> getLangList() {
        return Collections.unmodifiableList(DetectorFactory.instance_.langlist);
    }
}

